/*
 * Decompiled with CFR 0.152.
 */
package com.hisagisoft.eclipse.gadgetholder.views;

import com.hisagisoft.eclipse.gadgetholder.Activator;
import com.hisagisoft.eclipse.gadgetholder.Constants;
import com.hisagisoft.eclipse.gadgetholder.GadgetHolderManager;
import com.hisagisoft.eclipse.gadgetholder.StructTitle;
import com.hisagisoft.eclipse.gadgetholder.dialogs.NewGadgetDialog;
import com.hisagisoft.eclipse.gadgetholder.model.Gadget;
import com.hisagisoft.eclipse.gadgetholder.model.GadgetList;
import java.io.File;
import java.util.logging.Logger;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.part.ViewPart;

public class GadgetView
extends ViewPart {
    private Logger logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());
    private CTabFolder folder;
    private GadgetHolderManager manager;
    private GadgetList gadgets;
    private Action refreshAction;
    private Action newAction;
    private Action removeAction;
    private Action saveAction;
    private Action rollbackAction;
    private Action importAction;
    private Action exportAction;
    private StructTitle title;
    private ImageRegistry imageRegistry;

    public void createPartControl(Composite parent) {
        this.imageRegistry = Activator.getDefault().getImageRegistry();
        this.title = new StructTitle();
        this.title.put(StructTitle.Key.TITLE, this.getPartName());
        this.title.put(StructTitle.Key.UNSAVED, "");
        this.logger.fine("title = " + this.title);
        this.setPartName(this.title.toString());
        this.folder = new CTabFolder(parent, 0);
        this.manager = GadgetHolderManager.getInstance();
        this.gadgets = this.manager.getGadgets();
        for (Gadget gadget : this.gadgets) {
            this.addBrowser(gadget);
        }
        this.makeActions();
        this.setEnabledActions();
    }

    private void addBrowser(Gadget gadget) {
        assert (gadget != null && this.folder != null);
        CTabItem item = new CTabItem(this.folder, 0);
        if (gadget.isNew()) {
            item.setImage(this.imageRegistry.get("IMG_NEW"));
        } else {
            item.setImage(this.imageRegistry.get("IMG_ITEM"));
        }
        this.folder.setSelection(item);
        Browser browser = new Browser((Composite)this.folder, 0);
        browser.setUrl(gadget.getFile().getAbsolutePath());
        item.setControl((Control)browser);
        item.setData(Gadget.class.getName(), (Object)gadget);
    }

    private void makeActions() {
        IToolBarManager bars = this.getViewSite().getActionBars().getToolBarManager();
        this.refreshAction = new Action(){

            public void run() {
                try {
                    GadgetView.this.logger.fine("REFRESH Action");
                    Browser b = (Browser)GadgetView.this.folder.getSelection().getControl();
                    b.refresh();
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        };
        this.refreshAction.setToolTipText("\u8b56\uff74\u8b41\uff70");
        this.refreshAction.setImageDescriptor(this.imageRegistry.getDescriptor("IMG_REFRESH"));
        this.newAction = new Action(){

            public void run() {
                try {
                    GadgetView.this.logger.fine("NEW Action");
                    NewGadgetDialog ngd = new NewGadgetDialog(GadgetView.this.folder.getShell());
                    if (ngd.open() == 0) {
                        GadgetView.this.addBrowser(ngd.getNewGadget());
                        GadgetView.this.setEnabledActions();
                    }
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        };
        this.newAction.setToolTipText("\u8b41\uff70\u9695\ufffd");
        this.newAction.setImageDescriptor(this.imageRegistry.getDescriptor("IMG_NEW"));
        this.removeAction = new Action(){

            public void run() {
                try {
                    GadgetView.this.logger.fine("REMOVE Action");
                    CTabItem item = GadgetView.this.folder.getSelection();
                    Gadget gadget = (Gadget)item.getData(Gadget.class.getName());
                    GadgetView.this.logger.info("remove gadget.id = " + gadget.getId());
                    gadget.setRemoved(true);
                    item.setImage(GadgetView.this.imageRegistry.get("IMG_TRASH"));
                    GadgetView.this.setEnabledActions();
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        };
        this.removeAction.setToolTipText("\u8711\u4f01\u52c1");
        this.removeAction.setImageDescriptor(this.imageRegistry.getDescriptor("IMG_REMOVE"));
        this.removeAction.setDisabledImageDescriptor(this.imageRegistry.getDescriptor("IMG_REMOVE_DISABLED"));
        this.saveAction = new Action(){

            public void run() {
                try {
                    GadgetView.this.logger.fine("SAVE Action");
                    GadgetView.this.gadgets.commit();
                    GadgetView.this.manager.saveProperties();
                    GadgetView.this.updateView();
                    GadgetView.this.setEnabledActions();
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        };
        this.saveAction.setToolTipText("\u7e67\uff73\u7e5d\u6e98\u30e3\u7e5d\ufffd");
        this.saveAction.setImageDescriptor(this.imageRegistry.getDescriptor("IMG_SAVE"));
        this.saveAction.setDisabledImageDescriptor(this.imageRegistry.getDescriptor("IMG_SAVE_DISABLED"));
        this.rollbackAction = new Action(){

            public void run() {
                try {
                    GadgetView.this.logger.fine("ROLLBACK Action");
                    boolean ok = MessageDialog.openConfirm((Shell)GadgetView.this.folder.getShell(), (String)"Confirm", (String)"Are you sure you want to rollback changes?");
                    if (!ok) {
                        GadgetView.this.logger.fine("CANCEL");
                        return;
                    }
                    GadgetView.this.logger.fine("OK");
                    GadgetView.this.gadgets.rollback();
                    GadgetView.this.updateView();
                    GadgetView.this.setEnabledActions();
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        };
        this.rollbackAction.setToolTipText("\u7e5d\uff6d\u7e5d\uff7c\u7e5d\uff6b\u7e5d\u820c\u30e3\u7e67\uff6f");
        this.rollbackAction.setImageDescriptor(this.imageRegistry.getDescriptor("IMG_ROLLBACK"));
        this.rollbackAction.setDisabledImageDescriptor(this.imageRegistry.getDescriptor("IMG_ROLLBACK_DISABLED"));
        this.importAction = new Action(){

            public void run() {
                try {
                    GadgetView.this.logger.fine("IMPORT Action");
                    FileDialog fd = new FileDialog(GadgetView.this.folder.getShell());
                    fd.setFilterExtensions(new String[]{"*.html"});
                    fd.setFilterPath(Constants.PATH_MY_DOCUMENTS);
                    String filePath = fd.open();
                    if (filePath == null) {
                        return;
                    }
                    GadgetList newGadgets = null;
                    newGadgets = GadgetView.this.manager.importGadget(new File(filePath));
                    for (Gadget g : newGadgets) {
                        GadgetView.this.addBrowser(g);
                    }
                    GadgetView.this.setEnabledActions();
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        };
        this.importAction.setToolTipText("\u7e67\uff64\u7e5d\uff73\u7e5d\u6634\ufffd\uff7c\u7e5d\ufffd");
        this.importAction.setImageDescriptor(this.imageRegistry.getDescriptor("IMG_IMPORT"));
        this.importAction.setDisabledImageDescriptor(this.imageRegistry.getDescriptor("IMG_IMPORT_DISABLED"));
        this.exportAction = new Action(){

            public void run() {
                try {
                    boolean ok;
                    GadgetView.this.logger.fine("EXPORT Action");
                    FileDialog fd = new FileDialog(GadgetView.this.folder.getShell());
                    fd.setFileName("export.html");
                    fd.setFilterExtensions(new String[]{"*.html"});
                    fd.setFilterPath(Constants.PATH_MY_DOCUMENTS);
                    String filePath = fd.open();
                    if (filePath == null) {
                        return;
                    }
                    File file = new File(filePath);
                    if (file.exists() && !(ok = MessageDialog.openConfirm((Shell)GadgetView.this.folder.getShell(), (String)"Confirm", (String)"File already exists. Overwrite?"))) {
                        GadgetView.this.logger.fine("CANCEL");
                        return;
                    }
                    GadgetView.this.manager.exportGadget(file);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        };
        this.exportAction.setToolTipText("\u7e67\uff68\u7e67\uff6f\u7e67\uff79\u7e5d\u6634\ufffd\uff7c\u7e5d\ufffd");
        this.exportAction.setImageDescriptor(this.imageRegistry.getDescriptor("IMG_EXPORT"));
        this.exportAction.setDisabledImageDescriptor(this.imageRegistry.getDescriptor("IMG_EXPORT_DISABLED"));
        bars.add((IAction)this.newAction);
        bars.add((IAction)this.removeAction);
        bars.add((IAction)this.saveAction);
        bars.add((IAction)this.rollbackAction);
        bars.add((IAction)this.importAction);
        bars.add((IAction)this.exportAction);
        bars.add((IAction)this.refreshAction);
    }

    private void setEnabledActions() {
        assert (this.newAction != null && this.removeAction != null && this.saveAction != null && this.rollbackAction != null && this.importAction != null && this.exportAction != null);
        this.newAction.setEnabled(true);
        if (this.gadgets.size() > 0) {
            this.refreshAction.setEnabled(true);
            this.removeAction.setEnabled(true);
            this.exportAction.setEnabled(true);
        } else {
            this.refreshAction.setEnabled(false);
            this.removeAction.setEnabled(false);
            this.exportAction.setEnabled(false);
        }
        if (this.gadgets.isModified()) {
            this.saveAction.setEnabled(true);
            this.rollbackAction.setEnabled(true);
            this.title.put(StructTitle.Key.UNSAVED, "*");
        } else {
            this.saveAction.setEnabled(false);
            this.rollbackAction.setEnabled(false);
            this.title.put(StructTitle.Key.UNSAVED, "");
        }
        this.setPartName(this.title.toString());
        this.importAction.setEnabled(true);
    }

    private void updateView() {
        CTabItem[] cTabItemArray = this.folder.getItems();
        int n = cTabItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            CTabItem item = cTabItemArray[n2];
            Gadget gadget = (Gadget)item.getData(Gadget.class.getName());
            if (gadget.isRemoved()) {
                item.getControl().dispose();
                item.dispose();
            } else if (gadget.isNew()) {
                item.dispose();
            } else {
                item.setText("");
                item.setImage(this.imageRegistry.get("IMG_ITEM"));
            }
            ++n2;
        }
    }

    public void setFocus() {
    }
}

