/*
 * Decompiled with CFR 0.152.
 */
package com.hisagisoft.eclipse.gadgetholder.views;

import com.hisagisoft.eclipse.gadgetholder.GadgetManager;
import com.hisagisoft.eclipse.gadgetholder.model.Gadget;
import com.hisagisoft.eclipse.gadgetholder.model.GadgetList;
import com.hisagisoft.eclipse.gadgetholder.views.GadgetView;
import java.io.File;
import java.util.Observable;
import java.util.Observer;
import java.util.logging.Logger;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.part.ViewPart;

public class GadgetBrowser
extends ViewPart
implements Observer {
    private static Logger logger = Logger.getLogger(GadgetView.class.getName());
    private GadgetManager manager = GadgetManager.getInstance();
    ScrolledComposite scrollComposite;
    Browser browser;

    public GadgetBrowser() {
        this.manager.getGadgets().addObserver(this);
    }

    public void createPartControl(Composite parent) {
        logger.fine("createPartControl - start");
        File file = this.manager.createUnifiedHtmlFile();
        this.browser = new Browser(parent, 0);
        this.browser.setUrl(file.getAbsolutePath());
        logger.fine("createPartControl - end");
    }

    public void createPartControlOld(Composite parent) {
        logger.fine("createPartControl - start");
        this.scrollComposite = new ScrolledComposite(parent, 512);
        Composite composite = new Composite((Composite)this.scrollComposite, 0);
        composite.setLayout((Layout)new GridLayout(1, true));
        composite.setBackground(Display.getDefault().getSystemColor(1));
        for (Gadget gadget : this.manager.getGadgets()) {
            Browser browser = new Browser(composite, 0);
            browser.setUrl(gadget.getFile().getAbsolutePath());
            browser.setSize(250, 350);
            browser.setLayoutData((Object)new GridData(768));
        }
        this.scrollComposite.setExpandHorizontal(true);
        this.scrollComposite.setExpandVertical(true);
        this.scrollComposite.setContent((Control)composite);
        this.scrollComposite.setMinSize(composite.computeSize(-1, -1));
        logger.fine("createPartControl - end");
    }

    public void dispose() {
        super.dispose();
        logger.fine("delete observer");
        this.manager.getGadgets().deleteObserver(this);
    }

    public void setFocus() {
    }

    public void update(Observable o, Object arg) {
        logger.fine("observable = " + o.getClass());
        if (o instanceof GadgetList) {
            this.manager.createUnifiedHtmlFile();
            this.browser.refresh();
        }
    }
}

