/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.dom;

import junit.framework.TestCase;
import org.jdom.Element;
import org.jopendocument.dom.ChildCreator;
import org.jopendocument.dom.NS;

public class ChildCreatorTest
extends TestCase {
    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testCreate() throws Exception {
        NS nS = NS.getOD();
        Element element = new Element("p", nS.getTEXT());
        ChildCreator childCreator = new ChildCreator(element, new Element("un", nS.getTEXT()), new Element("deux", nS.getTEXT()), new Element("trois", nS.getSTYLE()), new Element("quatre", nS.getOFFICE()));
        try {
            childCreator.getChild(nS.getOFFICE(), "un", true);
            ChildCreatorTest.fail((String)"un is not in office namespace");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Element element2 = childCreator.getChild(nS.getSTYLE(), "trois", true);
        ChildCreatorTest.assertEquals((Object)nS.getSTYLE(), (Object)element2.getNamespace());
        ChildCreatorTest.assertEquals((String)"trois", (String)element2.getName());
        ChildCreatorTest.assertSame((Object)element2, element.getChildren().get(0));
        ChildCreatorTest.assertSame((Object)element2, (Object)childCreator.getChild(nS.getSTYLE(), "trois", true));
        ChildCreatorTest.assertEquals((int)1, (int)element.getContentSize());
        Element element3 = childCreator.addChild(nS.getSTYLE(), "trois");
        ChildCreatorTest.assertNotSame((Object)element2, (Object)element3);
        ChildCreatorTest.assertSame((Object)element3, element.getChildren().get(1));
        ChildCreatorTest.assertEquals((int)2, (int)element.getContentSize());
        element.getChildren().remove(1);
        childCreator.getChild(nS.getTEXT(), "deux", true);
        ChildCreatorTest.assertSame((Object)element2, element.getChildren().get(1));
        ChildCreatorTest.assertEquals((int)2, (int)element.getContentSize());
        ChildCreatorTest.assertSame((Object)childCreator.getChild(nS.getOFFICE(), "quatre", true), element.getChildren().get(2));
        ChildCreatorTest.assertEquals((int)3, (int)element.getContentSize());
        ChildCreatorTest.assertSame((Object)element2, element.getChildren().get(1));
        ChildCreatorTest.assertSame((Object)childCreator.getChild(nS.getTEXT(), "un", true), element.getChildren().get(0));
        ChildCreatorTest.assertEquals((int)4, (int)element.getContentSize());
    }
}

