/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.dom;

import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import java.util.TimeZone;
import junit.framework.TestCase;
import org.jdom.Element;
import org.jopendocument.dom.ODMeta;
import org.jopendocument.dom.ODPackage;
import org.jopendocument.dom.ODSingleXMLDocument;
import org.jopendocument.dom.ODUserDefinedMeta;
import org.jopendocument.dom.ODValueType;
import org.jopendocument.dom.spreadsheet.Table;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ODSingleXMLDocumentTest
extends TestCase {
    protected void setUp() throws Exception {
        super.setUp();
    }

    public void testCreate() throws Exception {
        ODSingleXMLDocument oDSingleXMLDocument = new ODPackage(((Object)((Object)this)).getClass().getResourceAsStream("test.odt")).toSingle();
        ODSingleXMLDocumentTest.assertNull((Object)oDSingleXMLDocument.isValid());
        ODSingleXMLDocumentTest.assertNull((Object)oDSingleXMLDocument.checkStyles());
    }

    public void testAdd() throws Exception {
        ODSingleXMLDocument oDSingleXMLDocument = new ODPackage(((Object)((Object)this)).getClass().getResourceAsStream("empty.odt")).toSingle();
        oDSingleXMLDocument.getBody().removeContent();
        ODSingleXMLDocument oDSingleXMLDocument2 = new ODPackage(((Object)((Object)this)).getClass().getResourceAsStream("styles.odt")).toSingle();
        oDSingleXMLDocument.add(oDSingleXMLDocument2);
        ODSingleXMLDocumentTest.assertNull((Object)oDSingleXMLDocument.isValid());
        ODSingleXMLDocumentTest.assertNull((Object)oDSingleXMLDocument.checkStyles());
    }

    public void testTable() throws Exception {
        ODSingleXMLDocument oDSingleXMLDocument = new ODPackage(((Object)((Object)this)).getClass().getResourceAsStream("test.odt")).toSingle();
        ODSingleXMLDocumentTest.assertNull((Object)oDSingleXMLDocument.getDescendantByName("draw:text-box", "inexistant"));
        Element element = oDSingleXMLDocument.getDescendantByName("table:table", "JODTestTable");
        ODSingleXMLDocumentTest.assertNotNull((Object)element);
        Table<ODSingleXMLDocument> table = new Table<ODSingleXMLDocument>(oDSingleXMLDocument, element);
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.set(2005, 0, 12, 12, 35);
        ODSingleXMLDocumentTest.assertEquals((Object)calendar.getTime(), (Object)table.getValueAt(2, 1));
        ODSingleXMLDocumentTest.assertEquals((Object)Float.valueOf(119.06f), (Object)table.getWidth());
        table.setColumnCount(6, -1, true);
        table.setValueAt(3.14, 5, 0);
        this.assertTableWidth(table, 119.06f);
        float f = table.getColumn(0).getWidth() / table.getColumn(1).getWidth();
        table.setColumnCount(2, 1, true);
        ODSingleXMLDocumentTest.assertEquals((Object)Float.valueOf(f), (Object)Float.valueOf(table.getColumn(0).getWidth() / table.getColumn(1).getWidth()));
        this.assertTableWidth(table, 119.06f);
        float f2 = table.getColumn(0).getWidth();
        table.setColumnCount(4, 0, false);
        this.assertTableWidth(table, 119.06f + 2.0f * f2);
        table.setColumnCount(1, 123, false);
        ODSingleXMLDocumentTest.assertEquals((int)1, (int)table.getColumnCount());
        this.assertTableWidth(table, f2);
        ODSingleXMLDocumentTest.assertNull((Object)oDSingleXMLDocument.isValid());
        ODSingleXMLDocumentTest.assertNull((Object)oDSingleXMLDocument.checkStyles());
    }

    private void assertTableWidth(Table<?> table, float f) {
        ODSingleXMLDocumentTest.assertEquals((Object)Float.valueOf(f), (Object)table.getWidth());
        float f2 = 0.0f;
        for (int i = 0; i < table.getColumnCount(); ++i) {
            f2 += table.getColumn(i).getWidth();
        }
        ODSingleXMLDocumentTest.assertEquals((long)this.round(f), (long)this.round(f2));
    }

    private long round(float f) {
        return Math.round((double)f * 100.0) / 100L;
    }

    public void testStyle() throws Exception {
        ODPackage oDPackage = new ODPackage(((Object)((Object)this)).getClass().getResourceAsStream("test.odt"));
        Element element = (Element)oDPackage.getContent().getXPath("//text:h[string() = 'Titre 2']").selectSingleNode(oDPackage.getContent().getDocument());
        String string = element.getAttributeValue("style-name", element.getNamespace());
        ODSingleXMLDocumentTest.assertNull((Object)oDPackage.getContent().getStyle("paragraph", string));
        this.testStyleElem(oDPackage.getStyle("paragraph", string));
        oDPackage.toSingle();
        this.testStyleElem(oDPackage.getContent().getStyle("paragraph", string));
    }

    private void testStyleElem(Element element) {
        ODSingleXMLDocumentTest.assertNotNull((Object)element);
        ODSingleXMLDocumentTest.assertEquals((String)"2", (String)element.getAttributeValue("default-outline-level", element.getNamespace()));
        ODSingleXMLDocumentTest.assertEquals((String)"Heading", (String)element.getAttributeValue("parent-style-name", element.getNamespace()));
    }

    public void testMeta() throws Exception {
        ODPackage oDPackage = new ODPackage(((Object)((Object)this)).getClass().getResourceAsStream("test.odt"));
        ODMeta oDMeta = oDPackage.getMeta();
        ODSingleXMLDocumentTest.assertEquals((Object)"firstInfo", (Object)oDMeta.getUserMeta("Info 1").getValue());
        ODSingleXMLDocumentTest.assertEquals((Object)"", (Object)oDMeta.getUserMeta("secondName").getValue());
        List<String> list = Arrays.asList("Info 1", "secondName", "Info 3", "Info 4");
        ODSingleXMLDocumentTest.assertEquals(list, oDMeta.getUserMetaNames());
        ODSingleXMLDocumentTest.assertNull((Object)oDMeta.getUserMeta("toto"));
        ODSingleXMLDocumentTest.assertNotNull((Object)oDMeta.getUserMeta("toto", true));
        oDMeta.removeUserMeta("toto");
        ODSingleXMLDocumentTest.assertNull((Object)oDMeta.getUserMeta("toto"));
        ODUserDefinedMeta oDUserDefinedMeta = oDMeta.getUserMeta("toto", true);
        oDUserDefinedMeta.setValue(3.5);
        ODSingleXMLDocumentTest.assertEquals((Object)((Object)ODValueType.FLOAT), (Object)((Object)oDUserDefinedMeta.getValueType()));
        ODSingleXMLDocumentTest.assertEquals((Object)Float.valueOf(3.5f), (Object)oDUserDefinedMeta.getValue());
        TimeZone timeZone = TimeZone.getTimeZone("Pacific/Marquesas");
        TimeZone timeZone2 = TimeZone.getTimeZone("PST");
        Calendar calendar = Calendar.getInstance(timeZone2);
        int n = calendar.get(11);
        int n2 = calendar.get(12);
        oDUserDefinedMeta.setValue(calendar, ODValueType.TIME);
        Calendar calendar2 = (Calendar)oDUserDefinedMeta.getValue();
        ODSingleXMLDocumentTest.assertEquals((int)n, (int)calendar2.get(11));
        ODSingleXMLDocumentTest.assertEquals((int)n2, (int)calendar2.get(12));
        calendar.setTimeZone(timeZone);
        oDUserDefinedMeta.setValue(calendar, ODValueType.TIME);
        calendar2 = (Calendar)oDUserDefinedMeta.getValue();
        ODSingleXMLDocumentTest.assertFalse((n == calendar2.get(11) ? 1 : 0) != 0);
        ODSingleXMLDocumentTest.assertFalse((n2 == calendar2.get(12) ? 1 : 0) != 0);
        calendar.setTimeZone(timeZone2);
        oDUserDefinedMeta.setValue(calendar, ODValueType.DATE);
        ODSingleXMLDocumentTest.assertEquals((Object)calendar.getTime(), (Object)oDUserDefinedMeta.getValue());
        calendar.setTimeZone(timeZone);
        oDUserDefinedMeta.setValue(calendar, ODValueType.DATE);
        ODSingleXMLDocumentTest.assertEquals((Object)calendar.getTime(), (Object)oDUserDefinedMeta.getValue());
    }
}

