/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.util;

import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ReflectUtils {
    private static Map<Type, Type> resolveTypes(Class<?> clazz, Class<?> clazz2) {
        HashMap<Type, Type> hashMap = new HashMap<Type, Type>();
        if (!clazz2.isAssignableFrom(clazz)) {
            return hashMap;
        }
        ArrayList<Type> arrayList = new ArrayList<Type>(Arrays.asList(clazz.getGenericInterfaces()));
        arrayList.add(clazz.getGenericSuperclass());
        for (Type type : arrayList) {
            Type type2;
            if (type instanceof ParameterizedType && clazz2.isAssignableFrom((Class)(type2 = (ParameterizedType)type).getRawType())) {
                Class clazz3 = (Class)type2.getRawType();
                Type[] typeArray = type2.getActualTypeArguments();
                TypeVariable<Class<T>>[] typeVariableArray = clazz3.getTypeParameters();
                for (int i = 0; i < typeArray.length; ++i) {
                    hashMap.put(typeVariableArray[i], typeArray[i]);
                }
            }
            if ((type2 = ReflectUtils.getClass(type)) == null) continue;
            hashMap.putAll(ReflectUtils.resolveTypes(type2, clazz2));
        }
        return hashMap;
    }

    public static <T> Map<TypeVariable<Class<T>>, Class<?>> getTypeArgumentsMap(Class<? extends T> clazz, Class<T> clazz2) {
        TypeVariable<Class<T>>[] typeVariableArray = clazz2.getTypeParameters();
        if (typeVariableArray.length == 0) {
            throw new IllegalArgumentException(clazz2 + " is not generic");
        }
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        Map<Type, Type> map = ReflectUtils.resolveTypes(clazz, clazz2);
        TypeVariable<Class<T>>[] typeVariableArray2 = typeVariableArray;
        int n = typeVariableArray2.length;
        for (int i = 0; i < n; ++i) {
            TypeVariable<Class<T>> typeVariable;
            Type type = typeVariable = typeVariableArray2[i];
            while (map.containsKey(type)) {
                type = map.get(type);
            }
            linkedHashMap.put(typeVariable, ReflectUtils.getClass(type));
        }
        return linkedHashMap;
    }

    public static <T> List<Class<?>> getTypeArguments(Class<? extends T> clazz, Class<T> clazz2) {
        ArrayList arrayList = new ArrayList();
        for (Class<?> clazz3 : ReflectUtils.getTypeArgumentsMap(clazz, clazz2).values()) {
            if (clazz3 == null) continue;
            arrayList.add(clazz3);
        }
        return arrayList;
    }

    public static <U> List<Class<?>> getTypeArguments(U u, Class<U> clazz) {
        return ReflectUtils.getTypeArguments(u.getClass().asSubclass(clazz), clazz);
    }

    public static <U> boolean isCastable(U u, Class<U> clazz, Class ... classArray) {
        return ((Object)ReflectUtils.getTypeArguments(u, clazz)).equals(Arrays.asList(classArray));
    }

    private static Class<?> getClass(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return ReflectUtils.getClass(((ParameterizedType)type).getRawType());
        }
        if (type instanceof GenericArrayType) {
            Type type2 = ((GenericArrayType)type).getGenericComponentType();
            Class<?> clazz = ReflectUtils.getClass(type2);
            if (clazz != null) {
                return Array.newInstance(clazz, 0).getClass();
            }
            return null;
        }
        return null;
    }
}

