/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;

public abstract class ZippedFilesProcessor {
    public void process(InputStream inputStream) throws IOException {
        JarEntry jarEntry;
        JarInputStreamWrapper jarInputStreamWrapper = new JarInputStreamWrapper(inputStream);
        while ((jarEntry = jarInputStreamWrapper.getNextJarEntry()) != null) {
            String string = jarEntry.getName();
            this.processEntry(string, jarInputStreamWrapper);
            jarInputStreamWrapper.closeEntry();
        }
        jarInputStreamWrapper.closeForReal();
    }

    protected abstract void processEntry(String var1, InputStream var2) throws IOException;

    private static class JarInputStreamWrapper
    extends JarInputStream {
        public JarInputStreamWrapper(InputStream inputStream) throws IOException {
            super(inputStream);
        }

        public void close() {
        }

        public void closeForReal() throws IOException {
            super.close();
        }
    }
}

