/*
 * Decompiled with CFR 0.152.
 */
package jp.getset.gae.util.servlet;

import com.google.appengine.api.datastore.DatastoreService;
import com.google.appengine.api.datastore.DatastoreServiceFactory;
import com.google.appengine.api.datastore.Entity;
import com.google.appengine.api.datastore.Key;
import com.google.appengine.api.datastore.PreparedQuery;
import com.google.appengine.api.datastore.Query;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.ho.yaml.Yaml;

public class InitServlet
extends HttpServlet {
    private static final long serialVersionUID = -2081009819475504682L;
    private static final String PATH_INF = "/WEB-INF/";
    private static final String DATA_YAML = "data.yaml";
    private Map<String, List<Map<String, String>>> dataMap = null;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        String docbase = config.getServletContext().getRealPath("");
        String yamlPath = String.valueOf(docbase) + PATH_INF + DATA_YAML;
        Object data = null;
        try {
            FileInputStream is = new FileInputStream(yamlPath);
            data = Yaml.load((InputStream)is);
        }
        catch (FileNotFoundException e) {
            throw new ServletException((Throwable)e);
        }
        if (data != null) {
            this.dataMap = (Map)data;
        }
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        boolean result = false;
        String res = "";
        if (this.dataMap != null) {
            switch (Integer.parseInt(request.getParameter("mode"))) {
                case 1: {
                    res = this.clearData();
                    break;
                }
                case 2: {
                    String from = request.getParameter("from");
                    String to = request.getParameter("to");
                    res = this.loadData(from == null ? 0 : Integer.parseInt(from), to == null ? -1 : Integer.parseInt(to));
                    break;
                }
                default: {
                    throw new RuntimeException("\u4e0d\u660e\u306amode\u3067\u3059");
                }
            }
            result = true;
        }
        response.setContentType("text/plain");
        response.getWriter().println(result ? "successed" : "faild");
        if (result) {
            response.getWriter().print(res);
        }
    }

    private String clearData() {
        Set<String> kinds = this.dataMap.keySet();
        StringBuffer sb = new StringBuffer();
        for (String kind : kinds) {
            this.clearKind(kind);
            sb.append("Kind cleared [" + kind + "].");
            sb.append("\n");
        }
        return sb.toString();
    }

    private String loadData(int from, int to) {
        DatastoreService service = DatastoreServiceFactory.getDatastoreService();
        ArrayList<Entity> entities = new ArrayList<Entity>();
        Set<String> kinds = this.dataMap.keySet();
        int i = 0;
        for (String kind : kinds) {
            List<Map<String, String>> yamlEntities = this.dataMap.get(kind);
            for (Map<String, String> yamlEntity : yamlEntities) {
                if (this.isFromValid(i, from) && this.isToValid(i, to)) {
                    Entity entity = new Entity(kind);
                    Set<Map.Entry<String, String>> yamlEntrySet = yamlEntity.entrySet();
                    for (Map.Entry<String, String> yamlEntry : yamlEntrySet) {
                        entity.setProperty(yamlEntry.getKey(), (Object)String.valueOf(yamlEntry.getValue()));
                    }
                    entities.add(entity);
                }
                ++i;
            }
        }
        if (entities.size() == 0) {
            throw new RuntimeException("\u30ed\u30fc\u30c9\u3059\u308b\u30c7\u30fc\u30bf\u304c\u3042\u308a\u307e\u305b\u3093\u3002");
        }
        service.put(entities);
        return "";
    }

    private boolean isFromValid(int count, int from) {
        boolean ret = false;
        ret = from == 0 ? true : count >= from - 1;
        return ret;
    }

    private boolean isToValid(int count, int to) {
        boolean ret = false;
        ret = to == -1 ? true : count <= to - 1;
        return ret;
    }

    private Iterable<Entity> getEntities(String kind) {
        DatastoreService service = DatastoreServiceFactory.getDatastoreService();
        Query query = new Query(kind);
        PreparedQuery pq = service.prepare(query);
        return pq.asIterable();
    }

    private void clearKind(String kind) {
        ArrayList<Key> keys = new ArrayList<Key>();
        Iterable<Entity> entities = this.getEntities(kind);
        for (Entity entity : entities) {
            keys.add(entity.getKey());
        }
        DatastoreService service = DatastoreServiceFactory.getDatastoreService();
        service.delete(keys);
    }
}

