/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.common.action;

import java.io.Serializable;
import java.util.Comparator;

import jp.mosp.common.MosPAction;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.dao.CmComponentDao;
import jp.mosp.common.dto.CmComponentDto;
import jp.mosp.common.utils.VariousUtil;
import jp.mosp.common.vo.MosPMenuArrangeVo;

/**
 * @author yoshida
 *
 */
public abstract class MosPMenuArrangeAction extends MosPAction {
	
	/**
	 * j[\DTO
	 */
	protected CmComponentDto	componentDto;
	

	/**
	 * j[\pDAO̎擾
	 * @return	CmComponentDao
	 * @throws Exception	Oꍇ
	 */
	protected CmComponentDao componentDao() throws Exception {
		return part().component().getCmComponentDao();
	}
	
	/**
	 * 
	 * @param targetCmdArray		ΏۃR}hz
	 * @param division				Ώۃj[
	 * @throws Exception	Oꍇ
	 */
	protected void initCardAction(String[][] targetCmdArray, String division) throws Exception {
		MosPMenuArrangeVo vo = (MosPMenuArrangeVo)getVo();
		vo.setCardParams(request);
		vo.aryPltManage = VariousUtil.getManageArray();
		// ڐݒ
		vo.aryPltCmdItem = targetCmdArray;
		vo.setHidDivision(division);
	}
	
	/**
	 * 
	 * @param targetCmdArray		ΏۃR}hz
	 * @param division				Ώۃj[
	 */
	protected void initListAction(String[][] targetCmdArray, String division) {
		MosPMenuArrangeVo vo = (MosPMenuArrangeVo)getVo();
		vo.aryPltManage = VariousUtil.getManageArray();
		vo.aryPltCmdItem = targetCmdArray;
		vo.setHidDivision(division);
	}
	
	/**
	 * \
	 */
	protected void showCard() {
		MosPMenuArrangeVo vo = (MosPMenuArrangeVo)getVo();
		vo.arySelectedCmdItem = new String[0][2];
		vo.setMode(MosPMenuArrangeVo.MODE_INSERT);
		// ZbVDTOZbg
		setSessionDto(componentDto);
	}
	
	/**
	 * I
	 * @throws Exception	Oꍇ
	 */
	protected void selectCard() throws Exception {
		MosPMenuArrangeVo vo = (MosPMenuArrangeVo)getVo();
		componentDto = part().component().findForDto(key1, vo.getHidDivision());
		chkExist(componentDto);
		vo.setFields(componentDto);
		// [hݒ
		vo.setMode(MosPMenuArrangeVo.MODE_UPDATE);
		// ZbVDTOZbg
		setSessionDto(componentDto);
	}
	
	/**
	 * [hݒ
	 */
	protected void setSearchModeOff() {
		MosPMenuArrangeVo vo = (MosPMenuArrangeVo)getVo();
		vo.setSearchmode(MosPMenuArrangeVo.SEARCH_OFF);
	}
	
	@Override
	protected void search() throws Exception {
		MosPMenuArrangeVo vo = (MosPMenuArrangeVo)getVo();
		vo.setListParams(request);
		searchList();
		vo.setIsAscending(true);
		vo.initListInfo();
		// ɃZbg
		vo.setSearchmode(MosPMenuArrangeVo.SEARCH_ON);
	}
	
	@Override
	protected void research() throws Exception {
		MosPMenuArrangeVo vo = (MosPMenuArrangeVo)getVo();
		if (vo.getSearchmode() == MosPMenuArrangeVo.SEARCH_ON) {
			removeSessionDto();
			searchList();
			vo.setPageButton();
			sortList();
		}
	}
	
	/**
	 * Xg
	 * @throws Exception	Oꍇ
	 */
	private void searchList() throws Exception {
		MosPMenuArrangeVo vo = (MosPMenuArrangeVo)getVo();
		// 
		vo.setFields(componentDao().findForCondition(vo.getTxtCompCode(), vo.getHidDivision(), vo.getTxtCompName(),
				vo.getPltManage(), vo.getPltDelete()));
		// Ώۂꍇ̃bZ[Wݒ
		if (vo.getAryCompCode().length == 0) {
			vo.addErrMessage(getMessage(MospConst.MSG_NO_DATA, ""));
		}
	}
	
	@Override
	protected void sortList(String key) throws MospException {
		MosPMenuArrangeVo vo = (MosPMenuArrangeVo)getVo();
		vo.sortList(key, getComparator(key));
		vo.setFields(vo.getList());
	}
	
	@Override
	protected void sortList() throws MospException {
		MosPMenuArrangeVo vo = (MosPMenuArrangeVo)getVo();
		vo.sortList(getComparator(vo.getFormerKey()));
		vo.setFields(vo.getList());
	}
	
	@Override
	protected Comparator<Object> getComparator(String key) throws MospException {
		MosPMenuArrangeVo vo = (MosPMenuArrangeVo)getVo();
		Comparator<Object> comp = null;
		if (key.equals(vo.KEY_COMP_CODE)) {
			comp = new CmComponentCode();
		} else if (key.equals(vo.KEY_COMP_NAME)) {
			comp = new CmComponentName();
		} else if (key.equals(vo.KEY_MANAGE)) {
			comp = new CmComponentManage();
		} else if (key.equals(vo.KEY_COMPONENT)) {
			comp = new CmComponent();
		} else if (key.equals(vo.KEY_DELETE)) {
			comp = new CompOutPutDelete();
		} else {
			throw new MospException(MospConst.EX_SORTKEY_INVALID);
		}
		return comp;
	}
	

	/**
	 * ΏۃR[hɂrNX
	 */
	protected static class CmComponentCode implements Comparator<Object>, Serializable {
		
		private static final long	serialVersionUID	= -1478623163300375391L;
		

		public int compare(Object obj1, Object obj2) {
			CmComponentDto dto1 = (CmComponentDto)obj1;
			CmComponentDto dto2 = (CmComponentDto)obj2;
			return dto1.getCompCode().compareTo(dto2.getCompCode());
		}
	}
	
	/**
	 * Ώۖ̂ɂrNX
	 */
	protected static class CmComponentName implements Comparator<Object>, Serializable {
		
		private static final long	serialVersionUID	= -2713846748281480319L;
		

		public int compare(Object obj1, Object obj2) {
			CmComponentDto dto1 = (CmComponentDto)obj1;
			CmComponentDto dto2 = (CmComponentDto)obj2;
			return dto1.getCompName().compareTo(dto2.getCompName());
		}
	}
	
	/**
	 * {ɂrNX
	 */
	protected static class CmComponentManage implements Comparator<Object>, Serializable {
		
		private static final long	serialVersionUID	= -1445454210063675079L;
		

		public int compare(Object obj1, Object obj2) {
			CmComponentDto dto1 = (CmComponentDto)obj1;
			CmComponentDto dto2 = (CmComponentDto)obj2;
			return String.valueOf(dto1.getManage()).compareTo(String.valueOf(dto2.getManage()));
		}
	}
	
	/**
	 * {\@\ɂrNX
	 */
	protected static class CmComponent implements Comparator<Object>, Serializable {
		
		private static final long	serialVersionUID	= 4168257683510439452L;
		

		public int compare(Object obj1, Object obj2) {
			CmComponentDto dto1 = (CmComponentDto)obj1;
			CmComponentDto dto2 = (CmComponentDto)obj2;
			return String.valueOf(dto1.getComponent()).compareTo(String.valueOf(dto2.getComponent()));
		}
	}
	
	/**
	 * 폜tOɂrNX
	 */
	protected static class CompOutPutDelete implements Comparator<Object>, Serializable {
		
		private static final long	serialVersionUID	= -1608954783023296757L;
		

		public int compare(Object obj1, Object obj2) {
			CmComponentDto dto1 = (CmComponentDto)obj1;
			CmComponentDto dto2 = (CmComponentDto)obj2;
			return dto2.getDeleteFlag() - dto1.getDeleteFlag();
		}
	}
	

	/**
	 * Io͍ڔz
	 */
	protected void setSelectedItemArray() {
		MosPMenuArrangeVo vo = (MosPMenuArrangeVo)getVo();
		String[] array = vo.getPltSelected();
		String[][] arySelectedItem = new String[1][2];
		arySelectedItem[0][0] = "";
		arySelectedItem[0][1] = "";
		if (chkExistObject(array)) {
			arySelectedItem = new String[array.length][2];
			for (int i = 0; i < arySelectedItem.length; i++) {
				arySelectedItem[i][0] = String.valueOf(i);
				arySelectedItem[i][1] = array[i];
			}
		}
		vo.arySelectedCmdItem = arySelectedItem;
	}
	
	/**
	 * f[^}
	 * @throws Exception	Oꍇ
	 */
	protected void insertCard() throws Exception {
		MosPMenuArrangeVo vo = (MosPMenuArrangeVo)getVo();
		// DTȌ
		CmComponentDto dto = new CmComponentDto();
		vo.setPltDelete(String.valueOf(MospConst.DELETE_FLAG_OFF));
		// p[^̑ÓmF
		vo.validate();
		// dmF
		chkDuplicate(componentDao().findForKey(vo.getEscTxtCompCode()));
		// DTȌ
		vo.setDtoFields(dto);
		// f[^̍XV
		componentDao().insert(dto);
		// DTO̍Ď擾
		CmComponentDto retDto = componentDao().findForDto(dto.getCompCode(), dto.getDivision());
		chkInsert(retDto);
		// R~bg
		commit();
		// [hݒ
		vo.setMode(MosPMenuArrangeVo.MODE_UPDATE);
		// bZ[Wݒ
		vo.setMessage(getMessage(MospConst.MSG_INSERT, ""));
		// ZbVDTOZbg
		setSessionDto(retDto);
	}
	
	/**
	 * f[^XV
	 * @throws Exception	Oꍇ
	 */
	protected void updateCard() throws Exception {
		MosPMenuArrangeVo vo = (MosPMenuArrangeVo)getVo();
		// DTO̎擾
		componentDto = (CmComponentDto)getSessionDto();
		// p[^̑ÓmF
		vo.validate();
		// rmF
		chkExclusive(componentDto, componentDao().findForUpdate(vo.getEscTxtCompCode()));
		// DTȌ
		vo.setDtoFields(componentDto);
		// f[^̍XV
		componentDao().update(componentDto);
		// DTO̍Ď擾
		CmComponentDto retDto = componentDao().findForDto(componentDto.getCompCode(), componentDto.getDivision());
		chkUpdate(retDto);
		// R~bg
		commit();
		// [hݒ
		vo.setMode(MosPMenuArrangeVo.MODE_UPDATE);
		// bZ[Wݒ
		vo.setMessage(getMessage(MospConst.MSG_UPDATE, ""));
		// ZbVDTOZbg
		setSessionDto(retDto);
	}
	
}
