/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.common.common;

import java.io.InputStreamReader;
import java.util.Iterator;
import java.util.List;

import javax.servlet.http.HttpServletRequest;

import org.apache.commons.csv.CSVParser;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;

/**
 * t@CAbv[hɗLpȃ\bh񋟂B<br><br>
 * MultipartNGXgAAbv[ht@Cp[^擾B
 */
public class FileUploadUtility {
	
	/**
	 * MultipartNGXgtB[h擾B<br>
	 * ɂ擾List{@link #getMultipartField(List, String)}
	 * y{@link #getMultipartFile(List, String)}ŗpB<br>
	 * @param request NGXg
	 * @return MultipartFieldList
	 * @throws Exception
	 */
	public static List<?> getMultipartFieldList(HttpServletRequest request) throws Exception {
		List<?> multipartFieldList = null;
		if (ServletFileUpload.isMultipartContent(request)) {
			DiskFileItemFactory factory = new org.apache.commons.fileupload.disk.DiskFileItemFactory();
			ServletFileUpload sfu = new org.apache.commons.fileupload.servlet.ServletFileUpload(factory);
			multipartFieldList = sfu.parseRequest(request);
		}
		return multipartFieldList;
	}
	
	/**
	 * MultipartNGXgtB[h擾B
	 * {@link #getMultipartFieldList(HttpServletRequest)}ɂ擾
	 * ListÃtB[h()擾B<br>
	 * @param list  MultipartNGXgtB[hXg
	 * @param param p[^
	 * @return p[^[l(MultipartłȂꍇAp[^ꍇNULL)
	 * @throws Exception
	 */
	public static String getMultipartField(List<?> list, String param) throws Exception {
		if (list == null) {
			return null;
		}
		Iterator<?> iterator = list.iterator();
		while(iterator.hasNext()){
			FileItem item = (FileItem)iterator.next();
			if (item.isFormField()){
				if (item.getFieldName().equals(param)) {
					return new String(item.getString().getBytes("iso-8859-1"), MospConst.REQUEST_CHAR_ENC);
				}
			}
		}
		return null;
	}
	
	/**
	 * MultipartNGXgtB[h擾B<br>
	 * {@link #getMultipartFieldList(HttpServletRequest)}ɂ擾
	 * ListÃtB[h(t@C)擾B<br>
	 * @param list  MultipartNGXgtB[hXg
	 * @param param p[^
	 * @return p[^[l(MultipartłȂꍇAp[^ꍇNULL)
	 * @throws Exception
	 */
	public static FileItem getMultipartFile(List<?> list, String param) throws Exception {
		if (list == null) {
			return null;
		}
		Iterator<?> iterator = list.iterator();
		while(iterator.hasNext()){
			FileItem item = (FileItem)iterator.next();
			if (!item.isFormField()){
				if (item.getFieldName().equals(param)) {
					return item;
				}
			}
		}
		return null;
	}
	
	/**
	 * CSVf[^p[XB<br>
	 * commons-csvCu[pāACSVf[^p[T[擾B<br>
	 * commons-fileuploadCu[păNGXg擾CSVt@Cp[XB<br>
	 * @param filCsv FileItemIuWFNg
	 * @return CSVt@Ce
	 * @throws Exception
	 */
	public static CSVParser parseCSVData(FileItem filCsv) throws Exception {
		CSVParser csvParseData = new CSVParser(
				new InputStreamReader(filCsv.getInputStream(), MospConst.REQUEST_CHAR_ENC));
		return csvParseData;
	}

}
