/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.common.common;

import javax.servlet.http.HttpServletRequest;

/**
 * gу[U[f[eBeB
 * @version		0.0.1
 * @since		
 * @author yoshida
 *
 */
public class MobileUserUtility {

	public static boolean isMobileUser(HttpServletRequest request) {
		String userAgent = request.getHeader("User-Agent");
		// HTTP_USER_AGENT画fB
		if (
				// Docomȍꍇ
				isDocomo(userAgent)
				// aȕꍇ
				|| isKDDI(userAgent)
				// SoftBankAJ-PHONEAVodafonȅꍇ
				|| isSoftBank(userAgent)
		) {
			return true;
		}
		return false;
	}

	/**
	 * Docomo
	 * @param userAgent		ΏHTTP_USER_AGENT
	 * @return
	 * <p>
	 * HTTP_USER_AGENTDocomȍꍇtrueAłȂꍇfalse
	 * </p>
	 */
	private static boolean isDocomo(String userAgent) {
		return userAgent.indexOf("DoCoMo") != -1;
	}

	/**
	 * au
	 * @param userAgent		ΏHTTP_USER_AGENT
	 * @return
	 * <p>
	 * HTTP_USER_AGENTaȕꍇtrueAłȂꍇfalse
	 * </p>
	 */
	private static boolean isKDDI(String userAgent) {
		return userAgent.indexOf("KDDI") != -1;
	}

	/**
	 * SoftBankAJ-PHONEAVodafone
	 * @param userAgent		ΏHTTP_USER_AGENT
	 * @return
	 * <p>
	 * HTTP_USER_AGENTSoftBankAJ-PHONEAVodafonȅꍇtrueA
	 * łȂꍇfalse
	 * </p>
	 */
	private static boolean isSoftBank(String userAgent) {
		return (userAgent.indexOf("SoftBank") != -1)
		|| (userAgent.indexOf("Vodafone") != -1) 
		|| (userAgent.indexOf("J-PHONE") != -1);
	}

}
