/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.common.utils;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

/**
 * <p>jՓ擾NX</p>
 * j@ɂ鍑̏j̎擾<br>
 * <br>
 * 0.0.2iǉj<br>
 * nbs[}f[<br>
 * t̓AH̓̎擾<br>
 * <br>
 * 0.0.3iǉj<br>
 * U֋xȀj<br>
 * ʏj擾<br>
 * MapIuWFNg擾<br>
 * <br>
 * @author yoshida
 *	@version		0.0.3
 */
public class JapanHolidayUtil {
	
	/**
	 * l̓
	 */
	public static final String	SEIJIN_NAME					= "l̓";
	/**
	 * C̓
	 */
	public static final String	UMI_NAME					= "C̓";
	/**
	 * hV̓
	 */
	public static final String	KEIROU_NAME					= "hV̓";
	/**
	 * ̈̓
	 */
	public static final String	TAIIKU_NAME					= "̈̓";
	/**
	 * t̓
	 */
	public static final String	SYUNBUN_NAME				= "t̓";
	/**
	 * H̓
	 */
	public static final String	SYUUBUN_NAME				= "H̓";
	/**
	 * 
	 */
	public static final String	GANJITSU_NAME				= "";
	/**
	 * LO̓
	 */
	private static final String	KENKOKU_KINEN_NAME			= "LO̓";
	/**
	 * a̓
	 */
	private static final String	SYOUWA_NAME					= "a̓";
	/**
	 * @LO
	 */
	private static final String	KENPOU_KINEN_NAME			= "@LO";
	/**
	 * ݂ǂ̓
	 */
	private static final String	MIDORI_NAME					= "݂ǂ̓";
	/**
	 * ǂ̓
	 */
	private static final String	KODOMO_NAME					= "ǂ̓";
	/**
	 * ̓
	 */
	private static final String	BUNKA_NAME					= "̓";
	/**
	 * ΘJӂ̓
	 */
	private static final String	KINROU_KANSYA_NAME			= "ΘJӂ̓";
	/**
	 * Vca
	 */
	private static final String	TENNOU_TANJOU_NAME			= "Vca";
	/**
	 * ̋x
	 */
	private static final String	KOKUMIN_NO_SYUKUJITU_NAME	= "̏j";
	/**
	 * U֋x
	 */
	private static final String	FURIKAE_NAME				= "U֋x";
	
	private static final int	YEAR_1900					= 1900;
	private static final int	YEAR_2000					= 2000;
	private static final int	YEAR_2003					= 2003;
	private static final int	YEAR_2006					= 2006;
	private static final int	YEAR_2007					= 2007;
	
	/**
	 * jz
	 */
	private String[][]			arySyuku					= new String[15][2];
	
	/**
	 * j}bv
	 */
	private Map<Date, String>	holidayMap;
	
	/**
	 * Ώ۔N
	 */
	private int					year;
	

	/**
	 * RXgN^
	 */
	public JapanHolidayUtil() {
		year = 0;
	}
	
	/**
	 * RXgN^
	 * @param year Ώ۔Nx
	 * <p>jՓz쐬</p>
	 */
	public JapanHolidayUtil(int year) {
		this.year = year;
		createHolidayMap();
	}
	
	/**
	 * CalendarCX^X擾
	 * @return	CalendarCX^X
	 */
	private static Calendar getCalendar() {
		Calendar cal = Calendar.getInstance();
		cal.set(Calendar.HOUR_OF_DAY, 0);
		cal.set(Calendar.MINUTE, 0);
		cal.set(Calendar.SECOND, 0);
		cal.set(Calendar.MILLISECOND, 0);
		return cal;
	}
	
	/**
	 * wjۃ\bh
	 * @param date		Ώ۔N
	 * @param dayOfWeek	Ώۗj
	 * @return
	 * <p>
	 * Ώۂ̗jꍇtrueAłȂꍇfalse
	 * </p>
	 */
	public boolean isDayOfWeek(Date date, int dayOfWeek) {
		Calendar cal = getCalendar();
		cal.setTime(date);
		if (cal.get(Calendar.DAY_OF_WEEK) == dayOfWeek) {
			return true;
		}
		return false;
	}
	
	/**
	 * jz擾
	 * @return jz
	 */
	public String[][] getArySyuku() {
		return arySyuku.clone();
	}
	
	/**
	 * Ώ۔Nݒ
	 * @param year	Ώ۔N
	 */
	public void setYear(int year) {
		this.year = year;
	}
	
	/**
	 * j}bv擾
	 * @return	j}bv
	 */
	public Map<Date, String> getHolidayMap() {
		return holidayMap;
	}
	
	/**
	 * jՓMap
	 */
	public void createHolidayMap() {
		// l̓
		addHolidayMap(getSeijinDate(year), SEIJIN_NAME);
		// C̓
		addHolidayMap(getUmiDate(year), UMI_NAME);
		// hV̓
		addHolidayMap(getKeirouDate(year), KEIROU_NAME);
		// ̈̓
		addHolidayMap(getTaiikuDate(year), TAIIKU_NAME);
		// t̓
		addHolidayMap(getSyunbunDate(year), SYUNBUN_NAME);
		// H̓
		addHolidayMap(getSyuubunDate(year), SYUUBUN_NAME);
		// 
		addHolidayMap(getGanjitsuDate(year), GANJITSU_NAME);
		// LO̓
		addHolidayMap(getKenkokuKinenDate(year), KENKOKU_KINEN_NAME);
		// @LO
		addHolidayMap(getKenpouKinenDate(year), KENPOU_KINEN_NAME);
		// ǂ̓
		addHolidayMap(getKodomoDate(year), KODOMO_NAME);
		// ̓
		addHolidayMap(getBunkaDate(year), BUNKA_NAME);
		// ΘJӂ̓
		addHolidayMap(getKinrouKansyaDate(year), KINROU_KANSYA_NAME);
		// Vca
		addHolidayMap(getTennouTanjouDate(year), TENNOU_TANJOU_NAME);
		// ݂ǂ̓2006N܂429Aa̓2007N瓱
		// ̋x2006N܂54A݂ǂ̓2007N瓱
		String midoriName = MIDORI_NAME;
		String syouwaName = SYOUWA_NAME;
		// ݂ǂ̓
		// ̋x
		if (year < YEAR_2007) {
			midoriName = KOKUMIN_NO_SYUKUJITU_NAME;
			syouwaName = MIDORI_NAME;
		}
		addHolidayMap(getSyouwaDate(year), syouwaName);
		addHolidayMap(getMidoriDate(year), midoriName);
		// U֋xǉ
		addSubstituteDate();
		// zɕϊ
		convertMapToArray();
	}
	
	/**
	 * Mapǉ
	 * @param date		Ώ۔N
	 * @param name		ΏۏjՓ
	 */
	private void addHolidayMap(Date date, String name) {
		if (holidayMap == null) {
			holidayMap = new TreeMap<Date, String>();
		}
		holidayMap.put(date, name);
	}
	
	/**
	 * U֋xǉ
	 */
	private void addSubstituteDate() {
		Calendar cal = getCalendar();
		Set<Date> keySet = holidayMap.keySet();
		TreeMap<Date, String> addMap = new TreeMap<Date, String>();
		Date formerHoliday = null;
		for (Date date : keySet) {
			// O
			// ȕjvjɓƂ́A̓ɂĂ̓ɍł߂ȕjvłȂxƂB 
			// jꍇAł߂ȕjvłȂɁuU֋xvǉB
			if (isDayOfWeek(date, Calendar.SUNDAY)) {
				cal.setTime(date);
				cal.add(Calendar.DAY_OF_MONTH, 1);
				if (year > YEAR_2006) {
					// ɓo^ĂxƏdꍇA炷B
					while (holidayMap.containsKey(cal.getTime())) {
						cal.add(Calendar.DAY_OF_MONTH, 1);
					}
				}
				if (!holidayMap.containsKey(cal.getTime())) {
					addMap.put(cal.getTime(), FURIKAE_NAME);
				}
			}
			// OO
			// ̑OyїȕjvłiȕjvłȂɌBj́AxƂB 
			if (formerHoliday != null) {
				cal.setTime(formerHoliday);
				cal.add(Calendar.DAY_OF_MONTH, 2);
				if (cal.getTime().compareTo(date) == 0) {
					cal.add(Calendar.DAY_OF_MONTH, -1);
					addMap.put(cal.getTime(), KOKUMIN_NO_SYUKUJITU_NAME);
				}
			}
			formerHoliday = date;
		}
		holidayMap.putAll(addMap);
	}
	
	/**
	 * zϊ
	 */
	private void convertMapToArray() {
		if (holidayMap != null) {
			Set<Date> dateSet = holidayMap.keySet();
			arySyuku = new String[dateSet.size()][2];
			int i = 0;
			SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");
			for (Date date : dateSet) {
				arySyuku[i][0] = sdf.format(date);
				arySyuku[i][1] = holidayMap.get(date);
				i++;
			}
		}
	}
	
	/**
	 * l̓
	 * @param year Ώ۔N
	 * @return	l̓(12j)
	 * <p>
	 * 1999NȑO(115)
	 * </p>
	 */
	public static Date getSeijinDate(int year) {
		Calendar cal = getCalendar();
		cal.set(Calendar.YEAR, year);
		cal.set(Calendar.MONTH, 0);
		if (year < YEAR_2000) {
			cal.set(Calendar.DAY_OF_MONTH, 15);
		} else {
			cal.set(Calendar.DAY_OF_WEEK, Calendar.MONDAY);
			cal.set(Calendar.DAY_OF_WEEK_IN_MONTH, 2);
		}
		return cal.getTime();
	}
	
	/**
	 * C̓
	 * @param year  Ώ۔N
	 * @return	C̓(73j)
	 * <p>
	 * 2002NȑO(720)
	 * </p>
	 */
	public static Date getUmiDate(int year) {
		Calendar cal = getCalendar();
		cal.set(Calendar.YEAR, year);
		cal.set(Calendar.MONTH, 7 - 1);
		if (year < YEAR_2003) {
			cal.set(Calendar.DAY_OF_MONTH, 20);
		} else {
			cal.set(Calendar.DAY_OF_WEEK, Calendar.MONDAY);
			cal.set(Calendar.DAY_OF_WEEK_IN_MONTH, 3);
		}
		return cal.getTime();
	}
	
	/**
	 * hV̓
	 * @param year Ώ۔N
	 * @return	hV̓(93j)
	 * <p>
	 * 2002NȑO(915)
	 * </p>
	 */
	public static Date getKeirouDate(int year) {
		Calendar cal = getCalendar();
		cal.set(Calendar.YEAR, year);
		cal.set(Calendar.MONTH, 9 - 1);
		if (year < YEAR_2003) {
			cal.set(Calendar.DAY_OF_MONTH, 15);
		} else {
			cal.set(Calendar.DAY_OF_WEEK, Calendar.MONDAY);
			cal.set(Calendar.DAY_OF_WEEK_IN_MONTH, 3);
		}
		return cal.getTime();
	}
	
	/**
	 * ̈̓
	 * @param year  Ώ۔N
	 * @return	̈̓(102j)
	 * <p>
	 * 1999NȑO(1010)
	 * </p>
	 */
	public static Date getTaiikuDate(int year) {
		Calendar cal = getCalendar();
		cal.set(Calendar.YEAR, year);
		cal.set(Calendar.MONTH, 10 - 1);
		if (year < YEAR_2000) {
			cal.set(Calendar.DAY_OF_MONTH, 10);
		} else {
			cal.set(Calendar.DAY_OF_WEEK, Calendar.MONDAY);
			cal.set(Calendar.DAY_OF_WEEK_IN_MONTH, 2);
		}
		return cal.getTime();
	}
	
	/**
	 * t̓
	 * @param year  Ώ۔N
	 * @return	t̓(3xx)
	 */
	public static Date getSyunbunDate(int year) {
		Calendar cal = getCalendar();
		final double param1 = 21.4471d;
		final double param2 = 0.242377d;
		final double param3 = 4.0d;
		cal.set(Calendar.YEAR, year);
		cal.set(Calendar.MONTH, 3 - 1);
		cal.set(Calendar.DAY_OF_MONTH, Double.valueOf(
				param1 + (param2 * (year - YEAR_1900)) - Math.floor((year - YEAR_1900) / param3)).intValue());
		return cal.getTime();
	}
	
	/**
	 *  H̓
	 * @param year  Ώ۔N
	 *  @return H̓(9xx)
	 */
	public static Date getSyuubunDate(int year) {
		Calendar cal = getCalendar();
		final double param1 = 23.8896d;
		final double param2 = 0.242032d;
		final double param3 = 4.0d;
		cal.set(Calendar.YEAR, year);
		cal.set(Calendar.MONTH, 9 - 1);
		cal.set(Calendar.DAY_OF_MONTH, Double.valueOf(
				param1 + (param2 * (year - YEAR_1900)) - Math.floor((year - YEAR_1900) / param3)).intValue());
		return cal.getTime();
	}
	
	/**
	 * 
	 * @param year  Ώ۔N
	 * @return	(11)
	 */
	public static Date getGanjitsuDate(int year) {
		Calendar cal = getCalendar();
		cal.set(Calendar.YEAR, year);
		cal.set(Calendar.MONTH, 1 - 1);
		cal.set(Calendar.DAY_OF_MONTH, 1);
		return cal.getTime();
	}
	
	/**
	 * LO̓
	 * @param year  Ώ۔N
	 * @return	LO̓(211)
	 */
	public static Date getKenkokuKinenDate(int year) {
		Calendar cal = getCalendar();
		cal.set(Calendar.YEAR, year);
		cal.set(Calendar.MONTH, 2 - 1);
		cal.set(Calendar.DAY_OF_MONTH, 11);
		return cal.getTime();
	}
	
	/**
	 * @LO
	 * @param year  Ώ۔N
	 * @return	@LO(53)
	 */
	public static Date getKenpouKinenDate(int year) {
		Calendar cal = getCalendar();
		cal.set(Calendar.YEAR, year);
		cal.set(Calendar.MONTH, 5 - 1);
		cal.set(Calendar.DAY_OF_MONTH, 3);
		return cal.getTime();
	}
	
	/**
	 * ǂ̓
	 * @param year  Ώ۔N
	 * @return	ǂ̓(55)
	 */
	public static Date getKodomoDate(int year) {
		Calendar cal = getCalendar();
		cal.set(Calendar.YEAR, year);
		cal.set(Calendar.MONTH, 5 - 1);
		cal.set(Calendar.DAY_OF_MONTH, 5);
		return cal.getTime();
	}
	
	/**
	 * ̓
	 * @param year  Ώ۔N
	 * @return	̓(113)
	 */
	public static Date getBunkaDate(int year) {
		Calendar cal = getCalendar();
		cal.set(Calendar.YEAR, year);
		cal.set(Calendar.MONTH, 11 - 1);
		cal.set(Calendar.DAY_OF_MONTH, 3);
		return cal.getTime();
	}
	
	/**
	 * ΘJӂ̓
	 * @param year  Ώ۔N
	 * @return	ΘJӂ̓(1123)
	 */
	public static Date getKinrouKansyaDate(int year) {
		Calendar cal = getCalendar();
		cal.set(Calendar.YEAR, year);
		cal.set(Calendar.MONTH, 11 - 1);
		cal.set(Calendar.DAY_OF_MONTH, 23);
		return cal.getTime();
	}
	
	/**
	 * Vca
	 * @param year  Ώ۔N
	 * @return	Vca(1223)
	 */
	public static Date getTennouTanjouDate(int year) {
		Calendar cal = getCalendar();
		cal.set(Calendar.YEAR, year);
		cal.set(Calendar.MONTH, 12 - 1);
		cal.set(Calendar.DAY_OF_MONTH, 23);
		return cal.getTime();
	}
	
	/**
	 * a̓
	 * @param year  Ώ۔N
	 * @return	a̓(429)
	 */
	public static Date getSyouwaDate(int year) {
		final int day = 29;
		Calendar cal = getCalendar();
		cal.set(Calendar.YEAR, year);
		cal.set(Calendar.MONTH, 4 - 1);
		cal.set(Calendar.DAY_OF_MONTH, day);
		return cal.getTime();
	}
	
	/**
	 * ݂ǂ̓
	 * @param year  Ώ۔N
	 * @return	݂ǂ̓(54)
	 */
	public static Date getMidoriDate(int year) {
		Calendar cal = getCalendar();
		cal.set(Calendar.YEAR, year);
		cal.set(Calendar.MONTH, 5 - 1);
		cal.set(Calendar.DAY_OF_MONTH, 4);
		return cal.getTime();
	}
	
}
