/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.common.vo;

import java.util.Properties;

import javax.servlet.http.HttpServletRequest;

import jp.mosp.common.common.BaseVo;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.dto.CmAspUserDto;
import jp.mosp.common.dto.CmUserDto;

/**
 * OCʏi[B<br><br>
 * OCʂɊւtB[hƂ̃ANZT\bhLB<br>
 */
public class LoginVo extends BaseVo {
	
	private static final long serialVersionUID = 2337805367775252627L;
	
	/**
	 * p[^([U[ID)B
	 */
	public static final String PRM_TXT_USER_ID = "txtUserId";
	
	/**
	 * p[^(pX[h)B
	 */
	public static final String PRM_TXT_PASS = "txtPass";
	
	/**
	 * ڒ([U[ID̍ő包)B
	 */
	public static final int LEN_USER_ID = MospConst.LEN_USER_ID;
	
	/**
	 * ڒ(pX[h̍ő包)B
	 */
	public static final int LEN_PASS = MospConst.LEN_PASSWORD;
	
	/**
	 * ږ([U[ID)B
	 */
	public String NAM_USER_ID;
	
	/**
	 * ږ(pX[h)B
	 */
	public String NAM_PASS;
	
	// tB[h
	private String pass;
	
	/**
	 * VȌݒsB<br>
	 * <ul><li>
	 * {@link BaseVo#BaseVo(Properties, Properties, Properties, String, CmAspUserDto, CmUserDto)}
	 * </li><li>
	 * {@link #needDirectJs}ݒ(true)<br>
	 * </li><li>
	 * {@link #setViewPath(String)}
	 * </li></ul>
	 * @param cfg     ݒt@C
	 * @param msg     bZ[Wt@C
	 * @param nam     t@C
	 * @param cmd     R}h
	 * @param aspUser ASP[U[
	 * @param user    [U[
	 */
	public LoginVo(
			Properties   cfg,
			Properties   msg,
			Properties   nam,
			String       cmd,
			CmAspUserDto aspUser,
			CmUserDto    user
	) {
		super(cfg, msg, nam, cmd, aspUser, user);
		needDirectJs  = true;
		setViewPath(getClassName());
	}
	
	/**
	 * ږ̂ݒ肷B
	 */
	@Override
	protected void setFieldsName() {
		NAM_USER_ID = getName("C_USER") + getName("C_ID");
		NAM_PASS    = getName("C_PASSWORD");
	}
	
	/**
	 * p[^擾Aݒ肷B
	 * @param request NGXg
	 */
	public void setParams(HttpServletRequest request) {
		setUserId(request.getParameter(PRM_TXT_USER_ID));
		pass = request.getParameter(PRM_TXT_PASS);
	}
	
	/**
	 * ڂ̑ÓmFsB
	 * @throws MospException
	 */
	public void validate() throws MospException {
		// ÓmFJn
		startValidation();
		// K{mF
		checkRequired(getUserId(), NAM_USER_ID, PRM_TXT_USER_ID);
		checkRequired(pass,        NAM_PASS   , PRM_TXT_PASS   );
		// ^CvmF
		checkCode    (getUserId(), NAM_USER_ID, PRM_TXT_USER_ID);
		checkCode    (pass,        NAM_PASS   , PRM_TXT_PASS   );
		// 񒷊mF
		checkLength  (getUserId(), LEN_USER_ID, NAM_USER_ID, PRM_TXT_USER_ID);
		checkLength  (pass       , LEN_PASS   , NAM_PASS   , PRM_TXT_PASS   );
		// ÓmFJn
		endValidation();
	}
	
	/**
	 * pX[h擾B
	 * @return pX[h
	 */
	public String getPass() { return pass; }
	
	/**
	 * pX[hݒ肷B
	 * @param pass pX[h
	 */
	public void setPass(String pass) { this.pass = pass; }
	
}
