/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.kintai.common.action;

import java.util.Date;

import jp.mosp.common.CommonConst;
import jp.mosp.common.action.AuthAction;
import jp.mosp.common.bean.AuthBean;
import jp.mosp.common.common.BaseVo;
import jp.mosp.common.common.LogUtility;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.common.MospUtility;
import jp.mosp.common.dto.CmAspUserDto;
import jp.mosp.common.dto.HumanBasisDtoInterface;
import jp.mosp.common.part.MosPCodePart;
import jp.mosp.common.part.MosPMenuPart;
import jp.mosp.common.part.PartInfo;
import jp.mosp.common.part.PartManager;
import jp.mosp.common.utils.DateUtil;
import jp.mosp.common.utils.VariousUtil;
import jp.mosp.common.vo.MosPLoginVo;
import jp.mosp.kintai.common.part.HumanPart;

/**
 * @author yoshida
 *
 */
public class MosPAuthAction extends AuthAction {
	
	/**
	 * RXgN^
	 */
	public MosPAuthAction() {
		super();
	}
	
	@Override
	public void action() throws Exception {
		// p[^̎擾
		MosPLoginVo vo = (MosPLoginVo)getInitVo();
		// VOyёJڐZbg(Fؐɏ㏑)
		setVo(vo);
		setUrl(vo.getRetUrl());
		// ASP[U[擾(ݒt@CASPݒŔf)
		setAspUser(vo);
		// F؏
		login(vo);
		// Г`FbNB
		checkEmployDate();
		// ̃y[W֑Jڏ
		setNextPage(vo);
		// [U[ۑ
		storeUserInfo();
		// Oo
		LogUtility.log(request, 4, MospConst.LOG_MOSPINF, MospConst.LOG_MSG_LOGIN);
	}
	
	/**
	 * F؏
	 * @param vo OCʂVO
	 * @throws Exception 	O
	 */
	public void login(MosPLoginVo vo) throws Exception {
		// p[^̎擾
		vo.setParams(request);
		// p[^̑ÓmF
		vo.validate();
		// DBRlNV̎擾
		getConnection();
		// F؏
		AuthBean auth = new AuthBean(cfg, cmd, aspUser, conn, hasMospSeJar());
		auth.login(vo.getUserId(), vo.getPass());
		// F؂sĂꍇ
		if (auth.isErrMessage()) {
			// G[bZ[W̐ݒ
			addErrMessage(MospUtility.getMessage(msg, auth.getErrMessageCode(), ""));
			throw new MospException(auth.getMosPExceptionCode());
		}
		user = auth.getCmUserDto();
		// R~bg
		commit();
	}
	
	/**
	 * y[WJڏ
	 * @param vo			ΏVO
	 * @throws Exception	Oꍇ
	 */
	protected void setNextPage(MosPLoginVo vo) throws Exception {
		// R}hݒ
		String nextCmd = "C1060";
		// pX[hLmF
		boolean validPassWord = true;
		// PartNX̏
		PartInfo partInfo = PartManager.createPartInfo(cfg, cmd, aspUser, user, conn);
		// pX[hL߂ĂApX[hύXʂɑJڂB
		// [U[IDƃpX[hꍇApX[hύXʂɑJڂB
		MosPCodePart mospcode = (MosPCodePart)PartManager.getPreparedPart(MosPCodePart.class, partInfo);
		if (mospcode.isExpirePassWord(user.getChangePass())
				|| VariousUtil.isDefaultPassWord(user.getUserId(), vo.getPass())) {
			nextCmd = MospConst.CMD_PASS_FORCE;
			validPassWord = false;
		}
		// admin̏ꍇCSSƏR}hύX
		if (user.getAuthority().equals(CommonConst.AUTHORITY_ADMIN) && validPassWord) {
			user.setCommonCss(CommonConst.CSS_ADMIN);
			//nextCmd = vo.CMD_MENU_SYSTEM2;
			nextCmd = "S2910";
		}
		MosPMenuPart menu = (MosPMenuPart)PartManager.getPreparedPart(MosPMenuPart.class, partInfo);
		// ]ƈ݂̂̏ꍇA̋Αӓ͂ֈړ
		if (MosPMenuPart.isEmployeeUser(menu.getUserAuthInfo()) && validPassWord) {
			nextCmd = "K1014";
		}
		// 
		setNextCmd(nextCmd);
		// T[ubg
		setUrl(MospConst.URL_SRV);
	}
	
	/**
	 * Г̃`FbN
	 * <p>	2009/06/18	m.yoshida	mosp-baseΉ	</p>
	 * @throws Exception	Oꍇ
	 */
	protected void checkEmployDate() throws Exception {
		// PartNX̏
		PartInfo partInfo = PartManager.createPartInfo(cfg, cmd, aspUser, user, conn);
		HumanPart human = (HumanPart)PartManager.getPreparedPart(HumanPart.class, partInfo);
		// Гȍ~OCłȂ悤ɂB
		HumanBasisDtoInterface dto = human.getBasisInfo(user.getKCode());
		Date entranceDate = null;
		if (dto != null) {
			entranceDate = DateUtil.convIntegerDateToDate(dto.getNyDate());
		}
		// ǗҌ̏ꍇAl{͖
		if (user.getAuthority().equals(CommonConst.AUTHORITY_ADMIN)) {
			entranceDate = new Date(0);
		}
		// ЃAГȌꍇAOCs
		if (entranceDate == null || DateUtil.getSystemDate().compareTo(entranceDate) < 0) {
			// G[bZ[W̐ݒ
			addErrMessage(MospUtility.getMessage(msg, MospConst.MSG_AUTH_FAILED, ""));
			throw new MospException(MospConst.EX_AUTH_FAILED);
		}
	}
	
	@Override
	protected BaseVo getInitVo() {
		return new MosPLoginVo(cfg, msg, nam, cmd, aspUser, user);
	}
	
	/**
	 * ASP[U[擾(ݒt@CASPݒŔf)
	 * @param vo			ΏVO
	 * @throws Exception	Oꍇ
	 */
	protected void setAspUser(BaseVo vo) throws Exception {
		// ASP[U[擾(ݒt@CASPݒŔf)
		switch (MospUtility.getAspFlag(cfg)) {
			case 0:
				// 0FASP(x[U[:1Av)
			case 1:
				// 1FASP(1[U[:1Av)
				// ASP[U[Zbg(ZbV擾)
				session = request.getSession(false);
				aspUser = (CmAspUserDto)session.getAttribute(MospConst.ATT_ASPUSER);
				BaseVo aspVo = (BaseVo)request.getAttribute(MospConst.ATT_VO);
				// returnUrlݒ
				vo.setRetUrl(aspVo.getRetUrl());
				break;
			case 2:
				// 2FASP
				// ASP[U[Zbg(OCʂł̃ZbVؒf)
				createAspUser();
				break;
			default:
				throw new MospException(MospConst.EX_ASP_PROPERTIES);
		}
	}
	
}
