/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.kintai.common.action;

import jp.mosp.common.CommonConst;
import jp.mosp.common.dao.MCodeDao;
import jp.mosp.common.dto.MCodeDto;
import jp.mosp.common.utils.TimeUtil;

/**
 * @author yoshida
 *
 */
public abstract class MosPCodeAction extends KintaiCommonAction {
	
	/**
	 * L[ɂ̎擾
	 * @param tid		R[h
	 * @param tcode		R[h
	 * @return	(DTO)
	 * @throws Exception	Oꍇ
	 */
	protected MCodeDto findForKey(String tid, String tcode) throws Exception {
		return part().mospcode().findForKey(tid, tcode);
	}
	
	/**
	 * L[ɂ̎擾
	 * @param tid		R[h
	 * @param tcode		R[h
	 * @return ΏۃR[hAΏۃR[h̃R[hϊ
	 * @throws Exception 	Oꍇ
	 */
	protected String findTchange(String tid, String tcode) throws Exception {
		return part().mospcode().findTchange(tid, tcode);
	}
	
	/**
	 * XV
	 * @param tId		R[h
	 * @param tCode		R[h
	 * @param tName		R[h
	 * @param tChange	R[hϊ
	 * @throws Exception	 Oꍇ
	 */
	protected void regist(String tId, String tCode, String tName, String tChange) throws Exception {
		// DAȌ
		MCodeDao dao = part().mospcode().getMCodeDao();
		// DTO̎擾
		MCodeDto dto = dao.findForUpdate(tId, tCode);
		if (chkExistDto(dto)) {
			// DTȌ
			dto.setTName(tName);
			dto.setTChange(tChange);
			// rmF
			chkExclusive(dao.findForKey(dto.getTId(), dto.getTCode()), dto);
			// f[^̍XV		
			dao.update(dto);
		} else {
			// DTȌ
			dto = new MCodeDto();
			dto.setTId(tId);
			dto.setTCode(tCode);
			dto.setTName(tName);
			dto.setTChange(tChange);
			// f[^̓o^		
			dao.insert(dto);
		}
		// Abvf[g̃`FbN
		chkUpdate(dao.findForKey(dto.getTId(), dto.getTCode()));
	}
	
	/**
	 * m_codepR[h\bh
	 * @param h1	
	 * @param m1	
	 * @param h2	
	 * @param m2	
	 * @return	string	
	 */
	protected String convStringToTimeCode(String h1, String m1, String h2, String m2) {
		StringBuffer sb = new StringBuffer();
		sb.append(TimeUtil.convStringTimeFormatted(h1, m1));
		sb.append(CommonConst.STR_SLASH_SEPARATOR);
		sb.append(TimeUtil.convStringTimeFormatted(h2, m2));
		sb.append(CommonConst.STR_SLASH_SEPARATOR);
		return sb.toString();
	}
	
}
