/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.kintai.common.dto;

import jp.mosp.common.common.BaseDto;
import jp.mosp.common.dto.HumanBasisDtoInterface;

/**
 * M_KIHON(Ј}X^[{)DTONXB
 */
public class MKihonDto extends BaseDto implements HumanBasisDtoInterface {
	
	/**
	 * 
	 */
	private static final long	serialVersionUID	= -1199182194566469661L;
	// tB[h
	private String				kcode				= "";
	private String				simei				= "";
	private String				furigana			= "";
	private String				scode				= "";
	private String				ycode				= "";
	private String				tokyu				= "";
	private String				jcode				= "";
	private int					nydate				= 0;
	private int					tsdate				= 0;
	private String				knkubun				= "";
	private String				kykubun				= "";
	private String				txkubun				= "";
	private String				txkubunx			= "";
	private String				kmkubun				= "";
	private String				ptkubun				= "";
	private String				shkubun				= "";
	private String				siwakecd			= "";
	private String				haigusya			= "";
	private int					fuyosu				= 0;
	private double				yukyu				= 0;
	private int					nenrei				= 0;
	private int					kinzoku				= 0;
	private String				kenpono				= "";
	private String				kohono				= "";
	private String				kuser				= "";
	private String				passw				= "";
	private String				email				= "";
	private String				ninsyo				= "";
	private int					datalvl				= 0;
	private int					proglevel			= 0;
	

	/**
	 * RXgN^B
	 */
	public MKihonDto() {
		super();
	}
	
	// ANZT\bh
	/**
	 * @return kcode 	ЈR[hB
	 */
	public String getKCode() {
		return kcode;
	}
	
	/**
	 * @return simei 	B
	 */
	public String getSimei() {
		return simei;
	}
	
	/**
	 * @return furigana 	ӂ肪ȁB
	 */
	public String getFurigana() {
		return furigana;
	}
	
	/**
	 * @return scode 	R[hB
	 */
	public String getSCode() {
		return scode;
	}
	
	/**
	 * @return ycode 	ER[hB
	 */
	public String getYCode() {
		return ycode;
	}
	
	/**
	 * @return tokyu 	B
	 */
	public String getTokyu() {
		return tokyu;
	}
	
	/**
	 * @return jcode 	ƏR[hB
	 */
	public String getJCode() {
		return jcode;
	}
	
	/**
	 * @return nydate 	ГB
	 */
	public int getNyDate() {
		return nydate;
	}
	
	/**
	 * @return tsdate 	ސEB
	 */
	public int getTsDate() {
		return tsdate;
	}
	
	/**
	 * @return knkubun 	xސE敪B
	 */
	public String getKnKubun() {
		return knkubun;
	}
	
	/**
	 * @return kykubun 	^敪B
	 */
	public String getKyKubun() {
		return kykubun;
	}
	
	/**
	 * @return txkubun 	ŋ敪B
	 */
	public String getTxKubun() {
		return txkubun;
	}
	
	/**
	 * @return txkubunx 	̑ŋ敪B
	 */
	public String getTxKubunx() {
		return txkubunx;
	}
	
	/**
	 * @return kmkubun 	g敪B
	 */
	public String getKmKubun() {
		return kmkubun;
	}
	
	/**
	 * @return ptkubun 	p[g敪B
	 */
	public String getPtKubun() {
		return ptkubun;
	}
	
	/**
	 * @return shkubun 	x敪B
	 */
	public String getShKubun() {
		return shkubun;
	}
	
	/**
	 * @return siwakecd 	dWvR[hB
	 */
	public String getSiwakeCd() {
		return siwakecd;
	}
	
	/**
	 * @return haigusya 	}{zҁB
	 */
	public String getHaigusya() {
		return haigusya;
	}
	
	/**
	 * @return fuyosu 	}{ƑB
	 */
	public int getFuyosu() {
		return fuyosu;
	}
	
	/**
	 * @return yukyu 	LcB
	 */
	public double getYukyu() {
		return yukyu;
	}
	
	/**
	 * @return nenrei 	NB
	 */
	public int getNenrei() {
		return nenrei;
	}
	
	/**
	 * @return kinzoku 	ΑNB
	 */
	public int getKinzoku() {
		return kinzoku;
	}
	
	/**
	 * @return kenpono 	۔ԍB
	 */
	public String getKenpoNo() {
		return kenpono;
	}
	
	/**
	 * @return kohono 	۔ԍB
	 */
	public String getKohoNo() {
		return kohono;
	}
	
	/**
	 * @return kuser 	[UB
	 */
	public String getKUser() {
		return kuser;
	}
	
	/**
	 * @return passw 	pX[hB
	 */
	public String getPassw() {
		return passw;
	}
	
	/**
	 * @return email 	emailB
	 */
	public String getEmail() {
		return email;
	}
	
	/**
	 * @return ninsyo 	F؎ҁB
	 */
	public String getNinsyo() {
		return ninsyo;
	}
	
	/**
	 * @return datalvl 	f[^xB
	 */
	public int getDataLvl() {
		return datalvl;
	}
	
	/**
	 * @return proglevel 	vOgpB
	 */
	public int getProgLevel() {
		return proglevel;
	}
	
	/**
	 * @param kcode 	ZbgЈR[hB
	 */
	public void setKCode(String kcode) {
		this.kcode = kcode;
	}
	
	/**
	 * @param simei 	Zbg鎁B
	 */
	public void setSimei(String simei) {
		this.simei = simei;
	}
	
	/**
	 * @param furigana 	Zbgӂ肪ȁB
	 */
	public void setFurigana(String furigana) {
		this.furigana = furigana;
	}
	
	/**
	 * @param scode 	Zbg鏊R[hB
	 */
	public void setSCode(String scode) {
		this.scode = scode;
	}
	
	/**
	 * @param ycode 	ZbgER[hB
	 */
	public void setYCode(String ycode) {
		this.ycode = ycode;
	}
	
	/**
	 * @param tokyu 	Zbg铙B
	 */
	public void setTokyu(String tokyu) {
		this.tokyu = tokyu;
	}
	
	/**
	 * @param jcode 	Zbg鎖ƏR[hB
	 */
	public void setJCode(String jcode) {
		this.jcode = jcode;
	}
	
	/**
	 * @param nydate 	ZbgГB
	 */
	public void setNyDate(int nydate) {
		this.nydate = nydate;
	}
	
	/**
	 * @param tsdate 	ZbgސEB
	 */
	public void setTsDate(int tsdate) {
		this.tsdate = tsdate;
	}
	
	/**
	 * @param knkubun 	ZbgxސE敪B
	 */
	public void setKnKubun(String knkubun) {
		this.knkubun = knkubun;
	}
	
	/**
	 * @param kykubun 	Zbg鋋^敪B
	 */
	public void setKyKubun(String kykubun) {
		this.kykubun = kykubun;
	}
	
	/**
	 * @param txkubun 	Zbgŋ敪B
	 */
	public void setTxKubun(String txkubun) {
		this.txkubun = txkubun;
	}
	
	/**
	 * @param txkubunx 	Zbg邻̑ŋ敪B
	 */
	public void setTxKubunx(String txkubunx) {
		this.txkubunx = txkubunx;
	}
	
	/**
	 * @param kmkubun 	Zbgg敪B
	 */
	public void setKmKubun(String kmkubun) {
		this.kmkubun = kmkubun;
	}
	
	/**
	 * @param ptkubun 	Zbgp[g敪B
	 */
	public void setPtKubun(String ptkubun) {
		this.ptkubun = ptkubun;
	}
	
	/**
	 * @param shkubun 	Zbgx敪B
	 */
	public void setShKubun(String shkubun) {
		this.shkubun = shkubun;
	}
	
	/**
	 * @param siwakecd 	ZbgdWvR[hB
	 */
	public void setSiwakeCd(String siwakecd) {
		this.siwakecd = siwakecd;
	}
	
	/**
	 * @param haigusya 	Zbg}{zҁB
	 */
	public void setHaigusya(String haigusya) {
		this.haigusya = haigusya;
	}
	
	/**
	 * @param fuyosu 	Zbg}{ƑB
	 */
	public void setFuyosu(int fuyosu) {
		this.fuyosu = fuyosu;
	}
	
	/**
	 * @param yukyu 	ZbgLcB
	 */
	public void setYukyu(double yukyu) {
		this.yukyu = yukyu;
	}
	
	/**
	 * @param nenrei 	ZbgNB
	 */
	public void setNenrei(int nenrei) {
		this.nenrei = nenrei;
	}
	
	/**
	 * @param kinzoku 	ZbgΑNB
	 */
	public void setKinzoku(int kinzoku) {
		this.kinzoku = kinzoku;
	}
	
	/**
	 * @param kenpono 	Zbg錒۔ԍB
	 */
	public void setKenpoNo(String kenpono) {
		this.kenpono = kenpono;
	}
	
	/**
	 * @param kohono 	Zbg۔ԍB
	 */
	public void setKohoNo(String kohono) {
		this.kohono = kohono;
	}
	
	/**
	 * @param kuser 	Zbg郆[UB
	 */
	public void setKUser(String kuser) {
		this.kuser = kuser;
	}
	
	/**
	 * @param passw 	ZbgpX[hB
	 */
	public void setPassw(String passw) {
		this.passw = passw;
	}
	
	/**
	 * @param email 	ZbgemailB
	 */
	public void setEmail(String email) {
		this.email = email;
	}
	
	/**
	 * @param ninsyo 	ZbgF؎ҁB
	 */
	public void setNinsyo(String ninsyo) {
		this.ninsyo = ninsyo;
	}
	
	/**
	 * @param datalvl 	Zbgf[^xB
	 */
	public void setDataLvl(int datalvl) {
		this.datalvl = datalvl;
	}
	
	/**
	 * @param proglevel 	ZbgvOgpB
	 */
	public void setProgLevel(int proglevel) {
		this.proglevel = proglevel;
	}
}
