/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.kintai.common.part;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import jp.mosp.common.CommonConst;
import jp.mosp.common.dto.HumanBasisDtoInterface;
import jp.mosp.common.part.PartInfo;
import jp.mosp.common.utils.StringUtil;
import jp.mosp.common.utils.VariousUtil;
import jp.mosp.kintai.common.dao.MYakusyokuDao;
import jp.mosp.kintai.common.dto.MYakusyokuDto;

/**
 * EɊւPartNX
 * @author yoshida
 *	@version	0.0.4
 */
public class PositionPart extends KintaiBasePart {
	
	/**
	 * RXgN^
	 */
	public PositionPart() {
		super();
	}
	
	/**
	 * RXgN^
	 * @param partInfo	Part𗘗pۂɕKvȏ
	 */
	public PositionPart(PartInfo partInfo) {
		super(partInfo);
	}
	

	private MYakusyokuDao	yakusyokuDao;
	

	/**
	 * M_YAKUSYOKUe[upDAO擾
	 * @return	ςMYakusyokuDaoCX^X
	 * @throws Exception Oꍇ
	 */
	public MYakusyokuDao getMYakusyokuDao() throws Exception {
		if (VariousUtil.isNull(yakusyokuDao)) {
			yakusyokuDao = (MYakusyokuDao)getPreparedDao(MYakusyokuDao.class.getCanonicalName());
		}
		return yakusyokuDao;
	}
	
	/**
	 * ER[h擾(M_YAKUSYOKU)
	 * @return ER[hXg
	 * @throws Exception  Oꍇ
	 */
	public String[][] getPositionArrayAll() throws Exception {
		// ̎擾
		List<MYakusyokuDto> listPosition = getMYakusyokuDao().findAll();
		// z̍쐬
		String[][] aryPosition = new String[listPosition.size()][3];
		for (int i = 0; i < aryPosition.length; i++) {
			aryPosition[i][0] = listPosition.get(i).getYcode();
			aryPosition[i][1] = listPosition.get(i).getYname();
			aryPosition[i][2] = listPosition.get(i).getTokyu();
		}
		return aryPosition;
	}
	
	/**
	 * ER[h擾(L̂)(M_YAKUSYOKU)
	 * @return ER[hXg
	 * @throws Exception  Oꍇ
	 */
	public String[][] getPositionArray() throws Exception {
		// ̎擾
		List<MYakusyokuDto> listPosition = getMYakusyokuDao().findAvailable();
		// z̍쐬
		String[][] aryPosition = new String[listPosition.size()][3];
		for (int i = 0; i < aryPosition.length; i++) {
			aryPosition[i][0] = listPosition.get(i).getYcode();
			aryPosition[i][1] = listPosition.get(i).getYname();
			aryPosition[i][2] = listPosition.get(i).getTokyu();
		}
		return aryPosition;
	}
	
	/**
	 * ER[h擾(̂)(M_YAKUSYOKU)
	 * @return ER[hXg
	 * @throws Exception  Oꍇ
	 */
	public String[][] getPositionTitleArray() throws Exception {
		// ̎擾
		List<MYakusyokuDto> listPosition = getMYakusyokuDao().findForTitle();
		// z̍쐬
		String[][] aryPosition = new String[listPosition.size()][3];
		for (int i = 0; i < aryPosition.length; i++) {
			aryPosition[i][0] = listPosition.get(i).getYcode();
			aryPosition[i][1] = listPosition.get(i).getYname();
		}
		return aryPosition;
	}
	
	/**
	 * ER[h擾(v_Ep)(M_YAKUSYOKU)
	 * @return ER[hXg
	 * @throws Exception  Oꍇ
	 */
	public String[][] getPositionPltArray() throws Exception {
		// ̎擾
		List<MYakusyokuDto> listPosition = getMYakusyokuDao().findAvailable();
		// z̍쐬
		String[][] aryPosition = new String[listPosition.size()][2];
		for (int i = 0; i < aryPosition.length; i++) {
			aryPosition[i][0] = listPosition.get(i).getYcode() + CommonConst.STR_TIME_SEPARATOR
					+ listPosition.get(i).getTokyu();
			aryPosition[i][1] = listPosition.get(i).getYname();
		}
		return aryPosition;
	}
	
	/**
	 * EXg擾(M_YAKUSYOKU)
	 * @return EXg
	 * @throws Exception  Oꍇ
	 */
	public Map<String, MYakusyokuDto> getPositionMap() throws Exception {
		// ̎擾
		List<MYakusyokuDto> listPosition = getMYakusyokuDao().findAll();
		// Map̍쐬
		HashMap<String, MYakusyokuDto> map = new HashMap<String, MYakusyokuDto>();
		for (MYakusyokuDto dto : listPosition) {
			map.put(dto.getYcode(), dto);
		}
		return map;
	}
	
	/**
	 * E擾(M_YAKUSYOKU)
	 * @param kCode		ΏێЈR[h
	 * @return 			ΏێЈE
	 * @throws Exception  Oꍇ
	 */
	public MYakusyokuDto getHoldingPositionInfo(String kCode) throws Exception {
		String positionCode = "";
		String grade = "0";
		// l{擾
		HumanBasisDtoInterface dto = part().human().getBasisInfo(kCode);
		if (VariousUtil.isNotNull(dto)) {
			// E擾
			positionCode = dto.getYCode();
			grade = dto.getTokyu();
		}
		return getPositionInfo(positionCode, grade);
	}
	
	/**
	 * E̎擾(t)
	 * @param kCode		ΏێЈR[h
	 * @return	ΏێЈE
	 * @throws Exception  Oꍇ
	 */
	public String getPositionName(String kCode) throws Exception {
		HumanBasisDtoInterface dto = part().human().getBasisInfo(kCode);
		if (VariousUtil.isNotNull(dto)) {
			StringBuffer position = new StringBuffer();
			position.append(dto.getYCode());
			position.append(CommonConst.STR_TIME_SEPARATOR);
			position.append(dto.getTokyu());
			String name = StringUtil.getCodeName(position.toString(), getPositionPltArray());
			if (!name.equals(CommonConst.STR_TIME_SEPARATOR)) {
				return name;
			}
		}
		return "";
	}
	
	/**
	 * FΎ蓖p
	 * @since	0.0.2
	 * @param kCode		ΏێЈR[h
	 * @return
	 * <p>
	 * FΎ蓖L̏ꍇtrueAłȂꍇfalse
	 * </p>
	 * @throws Exception Oꍇ
	 */
	public boolean isApplyAttendanceAllowance(String kCode) throws Exception {
		MYakusyokuDto dto = getHoldingPositionInfo(kCode);
		// FΎ蓖
		return VariousUtil.isNotNull(dto) && StringUtil.isFlagOn(dto.getKaikin());
	}
	
	/**
	 * E擾
	 * @since	0.0.3
	 * @param positionCode	ΏۖER[h
	 * @param grade			ΏۓR[h
	 * @return	EDTO
	 * @throws Exception Oꍇ
	 */
	public MYakusyokuDto getPositionInfo(String positionCode, String grade) throws Exception {
		return getMYakusyokuDao().findForKey(positionCode, grade);
	}
	
	/**
	 * E̎擾
	 * @since 0.0.4
	 * @param positionCode	ΏۖER[h
	 * @param grade			ΏۓR[h
	 * @return 	ΏێЈE
	 * @throws Exception  Oꍇ
	 */
	public String getPositionName(String positionCode, String grade) throws Exception {
		MYakusyokuDto dto = getPositionInfo(positionCode, grade);
		if (VariousUtil.isNotNull(dto)) {
			return dto.getYname();
		}
		return "";
	}
	
}
