/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
/**
 * 
 */
package jp.mosp.kintai.payroll.dto;

import java.util.Date;

import jp.mosp.common.common.BaseDto;

/**
 * @author yoshida
 *
 */
public class ViewPaidHolidayDto extends BaseDto {
	
	/**
	 * 
	 */
	private static final long	serialVersionUID	= -4315055487789119897L;
	
	private String				kcode				= "";
	private String				kname				= "";
	
	private Date				processDate			= null;
	private String				processType			= "";
	
	private double				useDays				= 0;
	private int					useHour				= 0;
	
	private double				supplyDays			= 0;
	private int					supplyHour			= 0;
	
	private double				wasteDays			= 0;
	private int					wasteHour			= 0;
	
	private double				lastRemainDays		= 0;
	private int					lastRemainHour		= 0;
	private double				remainDays			= 0;
	private int					remainHour			= 0;
	

	/**
	 * 
	 */
	public ViewPaidHolidayDto() {
		super();
	}
	
	/**
	 * @return kcode
	 */
	public String getKcode() {
		return kcode;
	}
	
	/**
	 * @return kname
	 */
	public String getKname() {
		return kname;
	}
	
	/**
	 * @return processDate
	 */
	public Date getProcessDate() {
		return (Date)processDate.clone();
	}
	
	/**
	 * @return processType
	 */
	public String getProcessType() {
		return processType;
	}
	
	/**
	 * @return useDays
	 */
	public double getUseDays() {
		return useDays;
	}
	
	/**
	 * @return useHour
	 */
	public int getUseHour() {
		return useHour;
	}
	
	/**
	 * @return supplyDays
	 */
	public double getSupplyDays() {
		return supplyDays;
	}
	
	/**
	 * @return supplyHour
	 */
	public int getSupplyHour() {
		return supplyHour;
	}
	
	/**
	 * @return wasteDays
	 */
	public double getWasteDays() {
		return wasteDays;
	}
	
	/**
	 * @return wasteHour
	 */
	public int getWasteHour() {
		return wasteHour;
	}
	
	/**
	 * @return lastRemainDays
	 */
	public double getLastRemainDays() {
		return lastRemainDays;
	}
	
	/**
	 * @return lastRemainHour
	 */
	public int getLastRemainHour() {
		return lastRemainHour;
	}
	
	/**
	 * @return remainDays
	 */
	public double getRemainDays() {
		return remainDays;
	}
	
	/**
	 * @return remainHour
	 */
	public int getRemainHour() {
		return remainHour;
	}
	
	/**
	 * @param kcode Zbg kcode
	 */
	public void setKcode(String kcode) {
		this.kcode = kcode;
	}
	
	/**
	 * @param kname Zbg kname
	 */
	public void setKname(String kname) {
		this.kname = kname;
	}
	
	/**
	 * @param processDate Zbg processDate
	 */
	public void setProcessDate(Date processDate) {
		this.processDate = (Date)processDate.clone();
	}
	
	/**
	 * @param processType Zbg processType
	 */
	public void setProcessType(String processType) {
		this.processType = processType;
	}
	
	/**
	 * @param useDays Zbg useDays
	 */
	public void setUseDays(double useDays) {
		this.useDays = useDays;
	}
	
	/**
	 * @param useHour Zbg useHour
	 */
	public void setUseHour(int useHour) {
		this.useHour = useHour;
	}
	
	/**
	 * @param supplyDays Zbg supplyDays
	 */
	public void setSupplyDays(double supplyDays) {
		this.supplyDays = supplyDays;
	}
	
	/**
	 * @param supplyHour Zbg supplyHour
	 */
	public void setSupplyHour(int supplyHour) {
		this.supplyHour = supplyHour;
	}
	
	/**
	 * @param wasteDays Zbg wasteDays
	 */
	public void setWasteDays(double wasteDays) {
		this.wasteDays = wasteDays;
	}
	
	/**
	 * @param wasteHour Zbg wasteHour
	 */
	public void setWasteHour(int wasteHour) {
		this.wasteHour = wasteHour;
	}
	
	/**
	 * @param lastRemainDays Zbg lastRemainDays
	 */
	public void setLastRemainDays(double lastRemainDays) {
		this.lastRemainDays = lastRemainDays;
	}
	
	/**
	 * @param lastRemainHour Zbg lastRemainHour
	 */
	public void setLastRemainHour(int lastRemainHour) {
		this.lastRemainHour = lastRemainHour;
	}
	
	/**
	 * @param remainDays Zbg remainDays
	 */
	public void setRemainDays(double remainDays) {
		this.remainDays = remainDays;
	}
	
	/**
	 * @param remainHour Zbg remainHour
	 */
	public void setRemainHour(int remainHour) {
		this.remainHour = remainHour;
	}
	
}
