/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
/**
 * 
 */
package jp.mosp.kintai.payroll.vo;

import javax.servlet.http.HttpServletRequest;

import jp.mosp.common.CommonConst;
import jp.mosp.common.MosPMenuConst;
import jp.mosp.common.MosPVo;
import jp.mosp.common.utils.DateUtil;
import jp.mosp.common.utils.TimeUtil;
import jp.mosp.kintai.payroll.dto.KdSubstituteHolidayDto;

/**
 * @author saitou
 *
 */
public class SubHolidayCardVo extends MosPVo {
	
	/**
	 * 
	 */
	private static final long	serialVersionUID	= -7228282138078823959L;
	
	// p[^
	/**
	 * pltDelete
	 */
	public static final String	PRM_PLT_DELETE		= "pltDelete";
	
	// tB[h
	/**
	 * N
	 */
	private String				lblOccurYear;
	/**
	 * 
	 */
	private String				lblOccurMonth;
	/**
	 * ؓ
	 */
	private String				lblCloseDate;
	/**
	 * Jn
	 */
	private String				lblLimitStartDate;
	/**
	 * I
	 */
	private String				lblLimitEndDate;
	/**
	 * ӌ
	 */
	private String				lblAttitudeStatus;
	/**
	 * ֋xɎ擾ԊO
	 */
	private String				lblPaymentAcquireTime;
	/**
	 * ֋xɎ擾xԊO
	 */
	private String				lblPaymentAcquireHoliday;
	/**
	 * ֋xɕԊO
	 */
	private String				lblPaymentQuitTime;
	/**
	 * p
	 */
	private String				lblUseHoliday;
	/**
	 * 擾
	 */
	private String				lblAcquisitionStatus;
	/**
	 * xςɂ鎞ԊOZ
	 */
	private String				lblLiquidationOverTime;
	/**
	 * xςɂxԊOZ
	 */
	private String				lblLiquidationWeekHoliday;
	/**
	 * Ϗ
	 */
	private String				lblDecisionStatus;
	/**
	 * 폜tO
	 */
	private String				pltDelete;
	
	// tB[hyѐ
	/**
	 * ЈR[h
	 */
	public String				NAM_K_CODE;
	/**
	 * Ј
	 */
	public String				NAM_K_NAME;
	/**
	 * N
	 */
	public String				NAM_OCCUR_YEARMONTH;
	/**
	 * ؓ
	 */
	public String				NAM_CLOSE_DATE;
	/**
	 * Jn
	 */
	public String				NAM_LIMIT_START_DATE;
	/**
	 * I
	 */
	public String				NAM_LIMIT_END_DATE;
	/**
	 * ӌ
	 */
	public String				NAM_ATTITUDE_STATUS;
	/**
	 * ֋xɎ擾ԊO
	 */
	public String				NAM_PAYMENT_ACQUIRE_TIME;
	/**
	 * ֋xɎ擾xԊO
	 */
	public String				NAM_PAYMENT_ACQUIRE_HOLIDAY;
	/**
	 * ֋xɕԊO
	 */
	public String				NAM_PAYMENT_QUIT_TIME;
	/**
	 * p
	 */
	public String				NAM_USE_HOLICAY;
	/**
	 * 擾
	 */
	public String				NAM_ACQUISITION_STATUS;
	/**
	 * xςɂ鎞ԊOZ
	 */
	public String				NAM_LIQUIDATION_OVER_TIME;
	/**
	 * xςɂxԊOZ
	 */
	public String				NAM_LIQUIDATION_WEEK_HOLIDAY;
	/**
	 * Ϗ
	 */
	public String				NAM_DECISION_STATUS;
	/**
	 * 폜tO
	 */
	public String				NAM_DELETE_FLAG;
	

	/**
	 * RXgN^
	 */
	public SubHolidayCardVo() {
		super();
		setViewPath(getClassName());
		pltDelete = "";
	}
	
	@Override
	protected void setSubTitle() {
		subTitle = "xǗ";
		createAryMenu(CMD_MENU_PAYROLL, MosPMenuConst.getMenuSubHolidayManagement());
	}
	
	@Override
	protected void setFieldsName() {
		NAM_K_CODE = CommonConst.NAM_K_CODE;
		NAM_K_NAME = CommonConst.NAM_K_NAME;
		NAM_OCCUR_YEARMONTH = "N";
		NAM_CLOSE_DATE = "ؓ";
		NAM_LIMIT_START_DATE = "Jn";
		NAM_LIMIT_END_DATE = "I";
		NAM_ATTITUDE_STATUS = "ӌ";
		NAM_PAYMENT_ACQUIRE_TIME = "x擾()";
		NAM_PAYMENT_ACQUIRE_HOLIDAY = "x擾(x)";
		NAM_PAYMENT_QUIT_TIME = "x";
		NAM_USE_HOLICAY = "p";
		NAM_ACQUISITION_STATUS = "擾";
		NAM_LIQUIDATION_OVER_TIME = "ԊOZ()";
		NAM_LIQUIDATION_WEEK_HOLIDAY = "ԊOZ(x)";
		NAM_DECISION_STATUS = "Ϗ";
		NAM_DELETE_FLAG = CommonConst.NAM_DELETE_FLAG;
	}
	
	@Override
	public void setParams(HttpServletRequest request) {
		pltDelete = request.getParameter(PRM_PLT_DELETE);
	}
	
	/**
	 * tB[hݒ
	 * @param dto ΏDTO
	 */
	public void setFields(KdSubstituteHolidayDto dto) {
		lblOccurYear = String.valueOf(dto.getOccurYear());
		lblOccurMonth = String.valueOf(dto.getOccurMonth());
		lblCloseDate = DateUtil.convDateToFormatDateJP(dto.getCloseDate());
		lblLimitStartDate = DateUtil.convDateToFormatDateJP(dto.getLimitStartDate());
		lblLimitEndDate = DateUtil.convDateToFormatDateJP(dto.getLimitEndDate());
		lblAttitudeStatus = dto.getAttitudeStatus();
		lblPaymentAcquireTime = TimeUtil.convIntegerTimeToJPHours(dto.getPaymentAcquireTime());
		lblPaymentAcquireHoliday = TimeUtil.convIntegerTimeToJPHours(dto.getPaymentAcquireHoliday());
		lblPaymentQuitTime = TimeUtil.convIntegerTimeToJPHours(dto.getPaymentQuitTime());
		lblUseHoliday = TimeUtil.convIntegerTimeToJPHours(dto.getUseHolidayTime());
		lblAcquisitionStatus = dto.getAcquisitionStatus();
		lblLiquidationOverTime = TimeUtil.convIntegerTimeToJPHours(dto.getLiquidationOverTime());
		lblLiquidationWeekHoliday = TimeUtil.convIntegerTimeToJPHours(dto.getLiquidationWeekHoliday());
		lblDecisionStatus = dto.getDecisionStatus();
		pltDelete = String.valueOf(dto.getDeleteFlag());
	}
	
	/**
	 * @return lblOccurYear
	 */
	public String getLblOccurYear() {
		return lblOccurYear;
	}
	
	/**
	 * @return lblOccurMonth
	 */
	public String getLblOccurMonth() {
		return lblOccurMonth;
	}
	
	/**
	 * @return lblCloseDate
	 */
	public String getLblCloseDate() {
		return lblCloseDate;
	}
	
	/**
	 * @return lblLimitStartDate
	 */
	public String getLblLimitStartDate() {
		return lblLimitStartDate;
	}
	
	/**
	 * @return lblLimitEndDate
	 */
	public String getLblLimitEndDate() {
		return lblLimitEndDate;
	}
	
	/**
	 * @return lblAttitudeStatus
	 */
	public String getLblAttitudeStatus() {
		return lblAttitudeStatus;
	}
	
	/**
	 * @return lblPaymentAcquireTime
	 */
	public String getLblPaymentAcquireTime() {
		return lblPaymentAcquireTime;
	}
	
	/**
	 * @return lblPaymentAcquireHoliday
	 */
	public String getLblPaymentAcquireHoliday() {
		return lblPaymentAcquireHoliday;
	}
	
	/**
	 * @return lblPaymentQuitTime
	 */
	public String getLblPaymentQuitTime() {
		return lblPaymentQuitTime;
	}
	
	/**
	 * @return lblUseHoliday
	 */
	public String getLblUseHoliday() {
		return lblUseHoliday;
	}
	
	/**
	 * @return lblAcquisitionStatus
	 */
	public String getLblAcquisitionStatus() {
		return lblAcquisitionStatus;
	}
	
	/**
	 * @return lblLiquidationOverTime
	 */
	public String getLblLiquidationOverTime() {
		return lblLiquidationOverTime;
	}
	
	/**
	 * @return lblLiquidationWeekHoliday
	 */
	public String getLblLiquidationWeekHoliday() {
		return lblLiquidationWeekHoliday;
	}
	
	/**
	 * @return lblDecisionStatus
	 */
	public String getLblDecisionStatus() {
		return lblDecisionStatus;
	}
	
	/**
	 * @param lblOccurYear Zbg lblOccurYear
	 */
	public void setLblOccurYear(String lblOccurYear) {
		this.lblOccurYear = lblOccurYear;
	}
	
	/**
	 * @param lblOccurMonth Zbg lblOccurMonth
	 */
	public void setLblOccurMonth(String lblOccurMonth) {
		this.lblOccurMonth = lblOccurMonth;
	}
	
	/**
	 * @param lblCloseDate Zbg lblCloseDate
	 */
	public void setLblCloseDate(String lblCloseDate) {
		this.lblCloseDate = lblCloseDate;
	}
	
	/**
	 * @param lblLimitStartDate Zbg lblLimitStartDate
	 */
	public void setLblLimitStartDate(String lblLimitStartDate) {
		this.lblLimitStartDate = lblLimitStartDate;
	}
	
	/**
	 * @param lblLimitEndDate Zbg lblLimitEndDate
	 */
	public void setLblLimitEndDate(String lblLimitEndDate) {
		this.lblLimitEndDate = lblLimitEndDate;
	}
	
	/**
	 * @param lblAttitudeStatus Zbg lblAttitudeStatus
	 */
	public void setLblAttitudeStatus(String lblAttitudeStatus) {
		this.lblAttitudeStatus = lblAttitudeStatus;
	}
	
	/**
	 * @param lblPaymentAcquireTime Zbg lblPaymentAcquireTime
	 */
	public void setLblPaymentAcquireTime(String lblPaymentAcquireTime) {
		this.lblPaymentAcquireTime = lblPaymentAcquireTime;
	}
	
	/**
	 * @param lblPaymentAcquireHoliday Zbg lblPaymentAcquireHoliday
	 */
	public void setLblPaymentAcquireHoliday(String lblPaymentAcquireHoliday) {
		this.lblPaymentAcquireHoliday = lblPaymentAcquireHoliday;
	}
	
	/**
	 * @param lblPaymentQuitTime Zbg lblPaymentQuitTime
	 */
	public void setLblPaymentQuitTime(String lblPaymentQuitTime) {
		this.lblPaymentQuitTime = lblPaymentQuitTime;
	}
	
	/**
	 * @param lblUseHoliday Zbg lblUseHoliday
	 */
	public void setLblUseHoliday(String lblUseHoliday) {
		this.lblUseHoliday = lblUseHoliday;
	}
	
	/**
	 * @param lblAcquisitionStatus Zbg lblAcquisitionStatus
	 */
	public void setLblAcquisitionStatus(String lblAcquisitionStatus) {
		this.lblAcquisitionStatus = lblAcquisitionStatus;
	}
	
	/**
	 * @param lblLiquidationOverTime Zbg lblLiquidationOverTime
	 */
	public void setLblLiquidationOverTime(String lblLiquidationOverTime) {
		this.lblLiquidationOverTime = lblLiquidationOverTime;
	}
	
	/**
	 * @param lblLiquidationWeekHoliday Zbg lblLiquidationWeekHoliday
	 */
	public void setLblLiquidationWeekHoliday(String lblLiquidationWeekHoliday) {
		this.lblLiquidationWeekHoliday = lblLiquidationWeekHoliday;
	}
	
	/**
	 * @param lblDecisionStatus Zbg lblDecisionStatus
	 */
	public void setLblDecisionStatus(String lblDecisionStatus) {
		this.lblDecisionStatus = lblDecisionStatus;
	}
	
	/**
	 * @return pltDelete
	 */
	public String getPltDelete() {
		return pltDelete;
	}
	
	/**
	 * @param pltDelete Zbg pltDelete
	 */
	public void setPltDelete(String pltDelete) {
		this.pltDelete = pltDelete;
	}
	
}
