/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.kintai.report.action;

import java.io.Serializable;
import java.sql.ResultSet;
import java.util.Comparator;
import java.util.Date;
import java.util.List;

import jp.mosp.common.CommonConst;
import jp.mosp.common.common.BaseVo;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.common.MospUtility;
import jp.mosp.common.utils.DateUtil;
import jp.mosp.common.utils.StringUtil;
import jp.mosp.kintai.common.action.KintaiCommonAction;
import jp.mosp.kintai.report.dao.ExportDataDao;
import jp.mosp.kintai.report.dto.MExportDto;
import jp.mosp.kintai.report.vo.ExportCardVo;

/**
 * @author yoshida
 *
 */
public class ExportCardAction extends KintaiCommonAction {
	
	// R}h
	private static final String	CMD_EXPORT_SHOW	= "S1200";
	private static final String	CMD_EXPORT_DATA	= "S1206";
	

	/**
	 * RXgN^
	 */
	public ExportCardAction() {
		super();
	}
	
	/**
	 * ANV
	 */
	public void action() throws Exception {
		// VO̎擾
		prepareVo();
		// ݒ
		init();
		// R}h̏
		if (cmd.equals(CMD_EXPORT_SHOW)) {
			// \
			show();
		} else if (cmd.equals(CMD_EXPORT_DATA)) {
			// GNX|[g
			export();
		} else {
			throw new MospException(MospConst.EX_CMD_INVALID);
		}
	}
	
	@Override
	protected BaseVo getSpecificVo() {
		return new ExportCardVo();
	}
	
	@Override
	protected void init() throws Exception {
		// DBRlNV擾
		getConnection();
		// vZǗmF
		confirmCalculateAuth();
		ExportCardVo vo = (ExportCardVo)getVo();
		// v_EXg
		vo.aryPltYear = StringUtil.getYearArray(MospUtility.getYear(DateUtil.getSystemDate()), 4, 1);
		vo.aryPltMonth = StringUtil.getMonthArray();
	}
	
	@Override
	protected void show() throws Exception {
		ExportCardVo vo = (ExportCardVo)getVo();
		Date date = DateUtil.getSystemDate();
		vo.setPltYear(String.valueOf(MospUtility.getYear(date)));
		vo.setPltMonth(String.valueOf(MospUtility.getMonth(date)));
		// 
		removeSessionDto();
		vo.setFields(part().export().getMExportDao().findForCondition());
		// ΏۂȂꍇ̃bZ[Wݒ
		if (vo.getEscAryEName().length == 0) {
			vo.addErrMessage(getMessage(MospConst.MSG_NO_DATA, ""));
		}
		vo.setPageButton();
		sortList();
	}
	
	/**
	 * GNX|[g
	 * @throws Exception 	Oꍇ
	 */
	protected void export() throws Exception {
		ExportCardVo vo = (ExportCardVo)getVo();
		// p[^擾
		vo.setParams(request);
		// VOɏZbg
		// Export
		vo.setTxtEName(key1);
		// Ώۃt@CID
		vo.setTxtEFile(key2);
		// o̓t@C
		StringBuffer fileName = new StringBuffer();
		fileName.append(vo.getPltYear());
		fileName.append(CommonConst.FILE_NAME_SEPARATOR);
		fileName.append(vo.getPltMonth());
		fileName.append(CommonConst.FILE_NAME_SEPARATOR);
		fileName.append(vo.getTxtEFile());
		fileName.append(CommonConst.FILE_COMMON_CSV);
		// Iڎ擾
		List<MExportDto> listSelected = part().export().getMExportDao().findForCondition(vo.getTxtEName(),
				vo.getTxtEFile());
		request.setAttribute(MospConst.ATT_FILE_NAME, fileName.toString());
		request.setAttribute(MospConst.ATT_FILE_OBJECT, makeHumanData(listSelected, vo.getTxtEFile(), vo.getPltYear(),
				vo.getPltMonth()));
		// V[PX𔭍sȂB
		setNeedProcSeq(false);
	}
	
	/**
	 * l쐬
	 * @param listSelected		ΏۑI}X^
	 * @param txtEFile			Ώۃe[u
	 * @param pltYear			Ώ۔N
	 * @param pltMonth			Ώی
	 * @return l񕶎
	 * @throws Exception 	Oꍇ
	 */
	protected StringBuffer makeHumanData(List<MExportDto> listSelected, String txtEFile, String pltYear, String pltMonth)
			throws Exception {
		// [쐬
		StringBuffer sb = new StringBuffer();
		// wb_[ݒ
		sb.append(appendHeader(listSelected));
		// f[^ǋL
		sb.append(appendData(listSelected, txtEFile, pltYear, pltMonth));
		return sb;
	}
	
	/**
	 * wb_[ݒ
	 * @param listSelected		ΏۑI}X^
	 * @return
	 * <p>
	 * I}X^̃wb_[
	 * <p>
	 * @throws Exception 	Oꍇ
	 */
	private StringBuffer appendHeader(List<MExportDto> listSelected) throws Exception {
		StringBuffer sb = new StringBuffer();
		int i = 0;
		int listSize = listSelected.size();
		// wb_[ݒ
		for (MExportDto dto : listSelected) {
			// wb_[ݒ
			sb.append(getCsvData(getEFnameItem(dto.getEFName(), 3)));
			// Zp[^ݒ
			if (i == listSize - 1) {
				sb.append(CommonConst.STR_CSV_NEW_LINE);
			} else {
				sb.append(CommonConst.STR_CSV_SEPARATOR);
			}
			i++;
		}
		return sb;
	}
	
	/**
	 * f[^擾
	 * @param listSelected	ΏۑI}X^
	 * @param txtEFile		Ώۃe[u
	 * @param pltYear		Ώ۔N
	 * @param pltMonth		Ώی
	 * @return
	 * <p>
	 * ɂe[uf[^
	 * </p>
	 * @throws Exception 	Oꍇ
	 */
	protected StringBuffer appendData(List<MExportDto> listSelected, String txtEFile, String pltYear, String pltMonth)
			throws Exception {
		StringBuffer sb = new StringBuffer();
		// ͈͎擾
		Date startDate = DateUtil.getFirstDateOfMonth(pltYear, pltMonth);
		Date endDate = DateUtil.getLastDateOfMonth(pltYear, pltMonth);
		// {AΑӏ擾
		ExportDataDao dao = part().export().getExportDataDao();
		ResultSet rs = null;
		if (txtEFile.equals(CommonConst.CODE_TABLE_M_KIHON)) {
			// l{̏ꍇ
			rs = dao.findForConditionKihon();
		} else if (txtEFile.equals(CommonConst.CODE_TABLE_M_KINTAI)) {
			// Αӏ̏ꍇ
			rs = dao.findForConditionKintai(DateUtil.convDateToStringYearMonthShort(startDate));
		} else if (txtEFile.equals(CommonConst.CODE_TABLE_M_SYUKKINBO)) {
			// oΕ̏ꍇ
			rs = dao.findForConditionSyukkinbo(DateUtil.convDateFormatted(startDate), DateUtil
				.convDateFormatted(endDate));
		} else if (txtEFile.equals(CommonConst.CODE_TABLE_M_YUKYU)) {
			// Lx̏ꍇ
			rs = dao.findForConditionYukyu(DateUtil.convDateToInteger(startDate), DateUtil.convDateToInteger(endDate));
		}
		// LȊO
		if (rs == null) {
			addErrMessage(getMessage(CommonConst.MSG_NO_TARGET_CODE, ""));
			return sb;
		}
		sb.append(appendData(rs, listSelected));
		// I
		dao.closers();
		return sb;
	}
	
	/**
	 * f[^ǋL
	 * @param rs			ΏResultSet
	 * @param listSelected	ΏۑI}X^
	 * @return 			f[^
	 * @throws Exception 	Oꍇ
	 */
	protected StringBuffer appendData(ResultSet rs, List<MExportDto> listSelected) throws Exception {
		StringBuffer sb = new StringBuffer();
		int listSize = listSelected.size();
		while (rs.next()) {
			int i = 0;
			for (MExportDto dto : listSelected) {
				sb.append(getCsvData(rs.getString(getEFnameItem(dto.getEFName(), 2))));
				// Zp[^ݒ
				if (i == listSize - 1) {
					sb.append(CommonConst.STR_CSV_NEW_LINE);
				} else {
					sb.append(CommonConst.STR_CSV_SEPARATOR);
				}
				i++;
			}
		}
		return sb;
	}
	
	@Override
	protected void sortList() throws MospException {
		ExportCardVo vo = (ExportCardVo)getVo();
		vo.sortList(getComparator(vo.getFormerKey()));
		vo.setFields(vo.getList());
	}
	
	@Override
	protected Comparator<Object> getComparator(String key) throws MospException {
		ExportCardVo vo = (ExportCardVo)getVo();
		Comparator<Object> comp = null;
		if (key.equals(vo.KEY_E_NAME)) {
			comp = new CompExportName();
		} else {
			throw new MospException(MospConst.EX_SORTKEY_INVALID);
		}
		return comp;
	}
	

	/**
	 * ̂ɂrNX
	 */
	protected static class CompExportName implements Comparator<Object>, Serializable {
		
		private static final long	serialVersionUID	= -5375772027347639889L;
		

		public int compare(Object obj1, Object obj2) {
			MExportDto dto1 = (MExportDto)obj1;
			MExportDto dto2 = (MExportDto)obj2;
			return dto1.getEName().compareTo(dto2.getEName());
		}
	}
	
}
