/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.kintai.vo;

import jp.mosp.common.CommonConst;
import jp.mosp.common.MosPMenuConst;
import jp.mosp.kintai.schedule.vo.MosPScheduleVo;

/**
 * @author yoshida
 *
 */
public class ScheduleConfirmListVo extends MosPScheduleVo {
	
	private static final long	serialVersionUID	= -3930861402120064453L;
	
	// tB[h
	private String				workTimes;
	private String				breakTimes;
	
	private String				presence;
	private String				paidHoliday;
	private String				particularHoliday;
	private String				absence;
	private String				sick;
	private String				compensationLeave;
	private String				transfer;
	private String				other;
	
	private String[][]			arySchedule;
	private String[]			aryLabel;
	
	// v_EXg
	/**
	 * 
	 */
	public String[][]			aryPltYear;
	/**
	 * 
	 */
	public String[][]			aryPltMonth;
	

	/**
	 * RXgN^
	 */
	public ScheduleConfirmListVo() {
		super();
		setViewPath(getClassName());
		arySchedule = new String[0][0];
		aryLabel = new String[0];
	}
	
	@Override
	protected void setSubTitle() {
		subTitle = CommonConst.TTL_SCHEDULE_CONFIRM;
		aryMenu = new String[][]{ { CMD_MENU_INPUT, CommonConst.NAM_TO_MENU }, MosPMenuConst.getMenuSchedule() };
	}
	
	/**
	 * tB[hݒ
	 * @param arySchedule \ꗗz
	 * @param aryCompile Wvf[^z
	 * @param aryLabel Wvxz
	 */
	public void setFields(String[][] arySchedule, String[] aryCompile, String[] aryLabel) {
		this.arySchedule = escapeArray(arySchedule.clone());
		this.aryLabel = escapeArray(aryLabel.clone());
		workTimes = aryCompile[0];
		breakTimes = aryCompile[1];
		presence = aryCompile[2];
		paidHoliday = aryCompile[3];
		particularHoliday = aryCompile[4];
		absence = aryCompile[5];
		sick = aryCompile[6];
		compensationLeave = aryCompile[7];
		transfer = aryCompile[8];
		other = aryCompile[9];
	}
	
	// ANZT\bh
	public String[][] getEscArySchedule() {
		return arySchedule.clone();
	}
	
	public String[] getEscAryLabel() {
		return aryLabel.clone();
	}
	
	public String getEscWorkTimes() {
		return escapeHTML(workTimes);
	}
	
	public String getEscBreakTimes() {
		return escapeHTML(breakTimes);
	}
	
	public String getEscPresence() {
		return escapeHTML(presence);
	}
	
	public String getEscPaidHoliday() {
		return escapeHTML(paidHoliday);
	}
	
	public String getEscParticularHoliday() {
		return escapeHTML(particularHoliday);
	}
	
	public String getEscAbsence() {
		return escapeHTML(absence);
	}
	
	public String getEscSick() {
		return escapeHTML(sick);
	}
	
	public String getEscCompensationLeave() {
		return escapeHTML(compensationLeave);
	}
	
	public String getEscTransfer() {
		return escapeHTML(transfer);
	}
	
	public String getEscOther() {
		return escapeHTML(other);
	}
	
}
