/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.kintai.workflow.action;

import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

import jp.mosp.common.CommonConst;
import jp.mosp.common.common.BaseVo;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.common.MospUtility;
import jp.mosp.common.utils.DateUtil;
import jp.mosp.common.utils.NumberUtil;
import jp.mosp.common.utils.StringUtil;
import jp.mosp.common.utils.TimeUtil;
import jp.mosp.kintai.common.action.MosPWorkflowAction;
import jp.mosp.kintai.common.part.KintaiApprovalPart;
import jp.mosp.kintai.common.part.KintaiCommonPart;
import jp.mosp.kintai.dto.MSyukkinboDto;
import jp.mosp.kintai.workflow.vo.ApprovalListVo;

/**
 * @author yoshida
 *
 */
public class ApprovalListAction extends MosPWorkflowAction {
	
	// R}h
	private static final String	CMD_APPROVAL_LIST_SELECT	= "K2121";
	private static final String	CMD_APPROVAL_LIST_SEARCH	= "K2122";
	private static final String	CMD_LUMP_SUM_1ST_APPROVAL	= "K2123";
	private static final String	CMD_LUMP_SUM_2ND_APPROVAL	= "K2124";
	
	// LFtO
	private boolean				is1stApproval				= false;
	private boolean				is2ndApproval				= false;
	
	// FctO
	private boolean				is1stRemain					= false;
	private boolean				is2ndRemain					= false;
	

	/**
	 * RXgN^
	 */
	public ApprovalListAction() {
		super();
	}
	
	/**
	 * ANV
	 */
	public void action() throws Exception {
		// VO̎擾
		prepareVo();
		// 
		init();
		// R}h̏
		if (cmd.equals(CMD_APPROVAL_LIST_SELECT)) {
			// I
			select();
		} else if (cmd.equals(CMD_APPROVAL_LIST_SEARCH)) {
			// 
			search();
		} else if (cmd.equals(CMD_LUMP_SUM_1ST_APPROVAL)) {
			// ꗗꎟF
			runApprovalProcess();
		} else if (cmd.equals(CMD_LUMP_SUM_2ND_APPROVAL)) {
			// ꗗ񎟏F
			runApprovalProcess();
		} else {
			throw new MospException(MospConst.EX_CMD_INVALID);
		}
	}
	
	@Override
	protected BaseVo getSpecificVo() {
		return new ApprovalListVo();
	}
	
	@Override
	protected void init() throws Exception {
		// MANAGERmF
		confirmManagerAuth();
		ApprovalListVo vo = (ApprovalListVo)getVo();
		// [U[擾
		getInfo(user.getUserId());
		// v_E擾
		vo.aryPltYear = StringUtil.getYearArray(MospUtility.getYear(getCalcMonth()), 3, 1);
		vo.aryPltMonth = StringUtil.getMonthArray();
	}
	
	@Override
	protected void select() throws Exception {
		ApprovalListVo vo = (ApprovalListVo)getVo();
		// ΏێЈݒ
		vo.setSelectKCode(key1);
		// Ώ۔Nݒ
		String[] aryDate = StringUtil.divideByHyphen(key2, 1);
		vo.setPltYear(aryDate[0]);
		vo.setPltMonth(aryDate[1]);
		// 
		searchApprovalList();
	}
	
	@Override
	protected void search() throws Exception {
		ApprovalListVo vo = (ApprovalListVo)getVo();
		// Ώ۔Nݒ
		vo.setParams(request);
		// 
		searchApprovalList();
	}
	
	/**
	 * Αӈꗗ
	 * @throws Exception	Oꍇ
	 */
	private void searchApprovalList() throws Exception {
		ApprovalListVo vo = (ApprovalListVo)getVo();
		// Ώ۔N擾
		Date targetDate = DateUtil.getYearMonth(vo.getPltYear(), vo.getPltMonth());
		// ЈR[h
		String kCode = vo.getSelectKCode();
		// F[gݒ
		String[] aryRouteInfo = getTargetRouteInfo(kCode, targetDate);
		// ꎟF
		if (isApprover(aryRouteInfo[0], targetDate)) {
			is1stApproval = true;
		}
		// 񎟏F
		if (isApprover(aryRouteInfo[1], targetDate)) {
			is2ndApproval = true;
		}
		// ΑӃf[^擾
		/*						
		 *  	2009/01/20	m.yoshida	ߓΉ
		 */
		getAttendanceListForView(kCode, targetDate);
		// Αӏݒ
		setCalcParam();
		// IЈJg擾
		setLaborAgreementInfo(kCode, targetDate);
		// Wvf[^z쐬
		makeApprovalArray(kCode, attendanceList);
		// Wv
		totalAttendanceDaily(kCode, attendanceList);
		// F̃Zbg
		setApprovalInfo();
		// I̐ݒ
		setLabelBasisInfo(part().human().getBasisInfo(kCode));
		// Wvf[^ƃx𕪗
		String[] aryLabel = new String[aryAttendanceCompile.length];
		String[] aryCompile = new String[aryAttendanceCompile.length];
		for (int i = 0; i < aryAttendanceCompile.length; i++) {
			aryLabel[i] = aryAttendanceCompile[i][0];
			aryCompile[i] = aryAttendanceCompile[i][1];
		}
		// VOݒ
		vo.setFields(aryAttendance, aryCompile, aryLabel);
		// [hݒ
		setMode();
	}
	
	/**
	 * Wvf[^z쐬
	 * @param kCode ЈR[h
	 * @param attendanceList attendanceList
	 * @throws Exception	Oꍇ
	 */
	private void makeApprovalArray(String kCode, List<MSyukkinboDto> attendanceList) throws Exception {
		// f[^擾
		Calendar cal = Calendar.getInstance();
		cal.setTime(MospUtility.getDate(startDate));
		int count = 0;
		while (MospUtility.getDate(endDate).compareTo(cal.getTime()) >= 0) {
			cal.add(Calendar.DAY_OF_MONTH, 1);
			count++;
		}
		// z񏉊
		final int size = 40;
		aryAttendance = StringUtil.getBlankArray(count, size);
		// tݒ
		cal.setTime(MospUtility.getDate(startDate));
		for (int i = 0; i < aryAttendance.length; i++) {
			// tipj
			aryAttendance[i][0] = MospUtility.getDateString(cal.getTime(), CommonConst.FORMAT_DATE);
			// t
			aryAttendance[i][1] = DateUtil.convDateToMonthDayShort(cal.getTime());
			// j
			aryAttendance[i][2] = getDayOfWeek(cal.get(Calendar.DAY_OF_WEEK));
			aryAttendance[i][17] = getDayOfWeekColorClass(cal.getTime());
			// lijՓAxj
			StringBuffer remark = new StringBuffer();
			// jՓ
			String holidayName = getPublicHolidayName(cal.getTime());
			if (StringUtil.isNotNull(holidayName)) {
				remark.append(holidayName);
				remark.append(CommonConst.NAM_COMMON_HALF_KANA_SPACE);
			}
			aryAttendance[i][16] = remark.toString();
			// cƐ\
			if (part().overtime().isOverTimeRequest(kCode, cal.getTime())) {
				aryAttendance[i][16] += CommonConst.NAM_OVERTIME;
				aryAttendance[i][16] += CommonConst.NAM_COMMON_HALF_KANA_SPACE;
			}
			// xɐ\
			if (part().holidayRequest().existHolidayRequest(kCode, cal.getTime())) {
				aryAttendance[i][16] += CommonConst.NAM_VACATION_LEAVE;
				aryAttendance[i][16] += CommonConst.NAM_COMMON_HALF_KANA_SPACE;
			}
			cal.add(Calendar.DAY_OF_MONTH, 1);
		}
		// 1̎ԊO
		int overTimeMonthly = 0;
		// f[^̐ݒ
		Iterator<MSyukkinboDto> it = attendanceList.iterator();
		while (it.hasNext()) {
			cal.setTime(MospUtility.getDate(startDate));
			MSyukkinboDto dto = it.next();
			Date attendanceDate = MospUtility.getDate(dto.getHizuke());
			for (int i = 0; i < aryAttendance.length; i++) {
				if (attendanceDate.compareTo(cal.getTime()) == 0) {
					// ̏ꍇA\ȂB
					if (!KintaiApprovalPart.isDraft(dto)) {
						// Ζ`
						String kinmuName = "";
						// o΂̏ꍇ
						if (KintaiCommonPart.isAvailableWorkType(dto)) {
							kinmuName = part().worktype().getWorkTypeName(dto.getKinmu());
							// oΎ
							aryAttendance[i][4] = dto.getSyJikoku();
							// ދΎ
							aryAttendance[i][5] = dto.getTaJikoku();
							// Ζ
							aryAttendance[i][6] = getHourString(TimeUtil.convIntegerTimeToDoubleTime(dto.getKinmuJi()));
							// xe
							aryAttendance[i][7] = getHourString(TimeUtil.convIntegerTimeToDoubleTime(dto.getKyukeiJi()));
							// x
							aryAttendance[i][8] = getHourString(TimeUtil.convIntegerTimeToDoubleTime(dto.getTiJikan()));
							// ގ
							aryAttendance[i][9] = getHourString(TimeUtil.convIntegerTimeToDoubleTime(dto.getSoJikan()));
							// cƎ
							aryAttendance[i][10] = getHourString(TimeUtil.convIntegerTimeToDoubleTime(dto.getZaJikan()));
							// ԊOxΉ
							overTimeMonthly += dto.getZaJikan();
							String cssClass = "TimeTd";
							// 60ԎԊO
							if (checkCautionOverTime(overTimeMonthly, 0)) {
								cssClass = CommonConst.CSS_CLASS_CAUTION_TD;
							}
							if (checkWarningOverTime(overTimeMonthly, 0)) {
								cssClass = CommonConst.CSS_CLASS_WARNING_TD;
							}
							aryAttendance[i][18] = cssClass;
							// xo
							aryAttendance[i][11] = getHourString(TimeUtil.convIntegerTimeToDoubleTime(dto.getKsJikan()));
							// [鎞
							aryAttendance[i][12] = getHourString(TimeUtil.convIntegerTimeToDoubleTime(dto.getSnJikan()));
						} else if (KintaiCommonPart.isWeekHoliday(dto)) {
							// Txx\
							//kinmu = CommonConst.ATTENDANCE_TYPE_WEEK_HOLIDAY;
							kinmuName = CommonConst.NAM_STANDARD_WEEK_HOLIDAY;
						} else if (KintaiCommonPart.isOfficialHoliday(dto)) {
							kinmuName = part().worktype().getWorkTypeName(dto.getKinmu());
						} else if (KintaiCommonPart.isSubstituteAll(dto)) {
							kinmuName = CommonConst.NAM_SUB_HOLIDAY;
						} else {
							// xɗR
							kinmuName = part().mospcode().getHolidayName(dto.getKKRiyuu());
						}
						aryAttendance[i][3] = kinmuName;
						// ꎟFA񎟏F
						aryAttendance[i][13] = part().kintaiApproval().getApprovalName(dto);
						String result = dto.getSnRiyuu();
						if (KintaiApprovalPart.isRequest(dto)) {
							is1stRemain = true;
							// ꎟFۗL̏ꍇ
							if (is1stApproval) {
								aryAttendance[i][14] = result;
							}
						} else if (KintaiApprovalPart.is1stApproved(dto)) {
							// 񎟏FۗL̏ꍇ
							is2ndRemain = true;
							if (is2ndApproval) {
								aryAttendance[i][14] = result;
							}
						}
						// F
						aryAttendance[i][15] = getKName(dto.getNinsyo());
						// x
						if (KintaiCommonPart.isHalfHoliday(dto)) {
							aryAttendance[i][16] += CommonConst.NAM_VACATION_LEAVE_HALF;
							aryAttendance[i][16] += CommonConst.NAM_COMMON_HALF_KANA_SPACE;
						}
						// xo
						if (KintaiCommonPart.isWorkOnHoliday(dto)) {
							aryAttendance[i][16] += CommonConst.NAM_WORK_ON_HOLIDAY;
							aryAttendance[i][16] += CommonConst.NAM_COMMON_HALF_KANA_SPACE;
						}
						// ԊOx(x)
						if (KintaiCommonPart.isOverTimeSubHolidayHalf(dto)) {
							aryAttendance[i][16] += CommonConst.NAM_SUB_HOLIDAY_HALF;
							aryAttendance[i][16] += CommonConst.NAM_COMMON_HALF_KANA_SPACE;
						}
						break;
					}
				}
				cal.add(Calendar.DAY_OF_MONTH, 1);
			}
		}
	}
	
	/**
	 * ΑӏF
	 * @throws Exception	Oꍇ
	 */
	private void setApprovalInfo() throws Exception {
		ApprovalListVo vo = (ApprovalListVo)getVo();
		// Ώ۔N擾
		Date targetDate = DateUtil.getFirstDateOfMonth(vo.getPltYear(), vo.getPltMonth());
		// F[gݒ
		String[] aryRouteInfo = getTargetRouteInfo(vo.getSelectKCode(), targetDate);
		if (StringUtil.isNull(aryRouteInfo[0]) || StringUtil.isNull(aryRouteInfo[1])) {
			// ΑӏNA
			for (int i = 0; i < aryAttendance.length; i++) {
				aryAttendance[i][3] = "";
				aryAttendance[i][4] = "";
				aryAttendance[i][5] = "";
				aryAttendance[i][6] = "";
				aryAttendance[i][7] = "";
				aryAttendance[i][8] = "";
				aryAttendance[i][9] = "";
				aryAttendance[i][10] = "";
				aryAttendance[i][11] = "";
				aryAttendance[i][12] = "";
				aryAttendance[i][13] = "";
				aryAttendance[i][14] = "";
			}
			for (int i = 0; i < aryAttendanceCompile.length; i++) {
				aryAttendanceCompile[i][1] = "0";
			}
		}
		// ̏FۗLĂꍇ̐\c̏
		for (int i = 0; i < aryAttendance.length; i++) {
			if (is1stRemain && is1stApproval && is2ndApproval && KintaiApprovalPart.is1stApproved(aryAttendance[i][14])) {
				aryAttendance[i][14] = "";
			}
		}
	}
	
	/**
	 * ꗗF
	 * @throws Exception	Oꍇ
	 */
	private void runApprovalProcess() throws Exception {
		ApprovalListVo vo = (ApprovalListVo)getVo();
		// FRg
		String comment = "";
		// ꎟF
		if (cmd.equals(CMD_LUMP_SUM_1ST_APPROVAL)) {
			comment = getMessage(CommonConst.MSG_NUMBER_OF_APPROVED, NumberUtil.NAM_ONE);
		}
		// 񎟏F
		if (cmd.equals(CMD_LUMP_SUM_2ND_APPROVAL)) {
			comment = getMessage(CommonConst.MSG_NUMBER_OF_APPROVED, NumberUtil.NAM_TWO);
		}
		// Ώ۔N
		String[] aryTargetDate = request.getParameterValues(ApprovalListVo.PRM_CKB_DATE);
		for (String element : aryTargetDate) {
			// F
			runDailyApprovalProcess(vo.getSelectKCode(), DateUtil.convStringDateToDate(element), comment, true);
		}
		// R~bg
		commit();
		// bZ[Wݒ
		setMessage(getMessage(MospConst.MSG_UPDATE, ""));
		// 
		searchApprovalList();
	}
	
	/**
	 * F[hݒ
	 */
	private void setMode() {
		ApprovalListVo vo = (ApprovalListVo)getVo();
		// o΃tOiLxxɂ܂߂j
		boolean isAttendance = false;
		int count = 0;
		for (int i = 0; i < vo.getEscAryAttendance().length; i++) {
			if (StringUtil.isNotNull(vo.getEscAryAttendance()[i][3])) {
				count++;
			}
		}
		if (count > 0) {
			isAttendance = true;
		}
		// ꌏłꎟFcĂꍇAꎟFD悳B
		if (is1stRemain) {
			if (is1stApproval) {
				vo.setMode(ApprovalListVo.MODE_1ST_APPROVAL);
			} else if (is2ndApproval) {
				vo.setMode(ApprovalListVo.MODE_2ND_APPROVAL);
			}
		} else if (is2ndApproval && isAttendance && is2ndRemain) {
			vo.setMode(ApprovalListVo.MODE_2ND_APPROVAL);
		} else {
			vo.setMode(ApprovalListVo.MODE_NOT_AUTH);
		}
	}
	
}
