/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.kintai.workflow.vo;

import javax.servlet.http.HttpServletRequest;

import jp.mosp.common.CommonConst;
import jp.mosp.common.MosPVo;

/**
 * @author yoshida
 *
 */
public class ApprovalListVo extends MosPVo {
	
	private static final long	serialVersionUID	= -2182387767518501669L;
	
	// 萔
	/**
	 * 
	 */
	public static final int		MODE_NOT_AUTH		= 0;
	/**
	 * 
	 */
	public static final int		MODE_1ST_APPROVAL	= 1;
	/**
	 * 
	 */
	public static final int		MODE_2ND_APPROVAL	= 2;
	
	// p[^
	/**
	 * 
	 */
	public static final String	PRM_PLT_YEAR		= "pltYear";
	/**
	 * 
	 */
	public static final String	PRM_PLT_MONTH		= "pltMonth";
	
	/**
	 * 
	 */
	public static final String	PRM_CKB_DATE		= "ckbSelectDate";
	
	// tB[hyѐ
	/**
	 * 
	 */
	public String				NAM_APPROVED;
	/**
	 * 
	 */
	public String				NAM_1ST_APPROVAL;
	/**
	 * 
	 */
	public String				NAM_2ND_APPROVAL;
	
	// tB[h
	private String				selectKCode;
	
	private String				workTimes;
	private String				breakTimes;
	private String				lateTimes;
	private String				leaveEarlyTimes;
	private String				overTimes;
	private String				workOnHoliday;
	private String				lateNightTimes;
	private String				presence;
	private String				paidHoliday;
	private String				particularHoliday;
	private String				absence;
	private String				sick;
	private String				compensationLeave;
	private String				transfer;
	private String				other;
	private String				leaveAndLate;
	private String				allowance;
	
	private String[][]			aryAttendance;
	private String[]			aryLabel;
	
	private String				pltYear;
	private String				pltMonth;
	
	// [h(1FꎟFA2F񎟏F)
	private int					mode;
	
	// v_EXg
	/**
	 * 
	 */
	public String[][]			aryPltYear;
	/**
	 * 
	 */
	public String[][]			aryPltMonth;
	
	private String				overTimeCssClass;
	

	/**
	 * RXgN^
	 */
	public ApprovalListVo() {
		super();
		setViewPath(getClassName());
		pltYear = "";
		pltMonth = "";
		aryAttendance = new String[0][0];
		aryLabel = new String[0];
		mode = MODE_NOT_AUTH;
		overTimeCssClass = "";
	}
	
	@Override
	protected void setSubTitle() {
		subTitle = CommonConst.TTL_APPROVAL_LIST;
		createAryMenu(CMD_MENU_MAMAGE, "K2112", CommonConst.TTL_EMPLOYEE_APPROVAL);
	}
	
	@Override
	protected void setFieldsName() {
		NAM_APPROVED = CommonConst.NAM_APPROVED;
		NAM_1ST_APPROVAL = CommonConst.NAM_1ST_APPROVED;
		NAM_2ND_APPROVAL = CommonConst.NAM_2ND_APPROVED;
	}
	
	@Override
	public void setParams(HttpServletRequest request) {
		pltYear = request.getParameter(PRM_PLT_YEAR);
		pltMonth = request.getParameter(PRM_PLT_MONTH);
	}
	
	/**
	 * tB[hݒ
	 * @param aryAttendance	Wvf[^Xg
	 * @param aryCompile	Wvf[^
	 * @param aryLabel		Wvx
	 */
	public void setFields(String[][] aryAttendance, String[] aryCompile, String[] aryLabel) {
		this.aryAttendance = escapeArray(aryAttendance.clone());
		this.aryLabel = escapeArray(aryLabel.clone());
		workTimes = aryCompile[0];
		breakTimes = aryCompile[1];
		lateTimes = aryCompile[2];
		leaveEarlyTimes = aryCompile[3];
		overTimes = aryCompile[4];
		workOnHoliday = aryCompile[5];
		lateNightTimes = aryCompile[6];
		presence = aryCompile[7];
		paidHoliday = aryCompile[8];
		particularHoliday = aryCompile[9];
		absence = aryCompile[10];
		sick = aryCompile[11];
		compensationLeave = aryCompile[12];
		transfer = aryCompile[13];
		other = aryCompile[14];
		leaveAndLate = aryCompile[15];
		allowance = aryCompile[16];
		overTimeCssClass = aryCompile[18];
	}
	
	@Override
	public String getDirectJs(Class<?> cls, Object obj) throws IllegalAccessException {
		StringBuffer sb = new StringBuffer();
		sb.append(super.getDirectJs(cls, obj));
		sb.append("var MODE = ");
		sb.append(mode);
		sb.append(";");
		return sb.toString();
	}
	
	// ANZT\bh
	public String[][] getEscAryAttendance() {
		return aryAttendance.clone();
	}
	
	public String[] getEscAryLabel() {
		return aryLabel.clone();
	}
	
	public String getEscWorkTimes() {
		return escapeHTML(workTimes);
	}
	
	public String getEscBreakTimes() {
		return escapeHTML(breakTimes);
	}
	
	public String getEscLateTimes() {
		return escapeHTML(lateTimes);
	}
	
	public String getEscLeaveEarlyTimes() {
		return escapeHTML(leaveEarlyTimes);
	}
	
	public String getEscOverTimes() {
		return escapeHTML(overTimes);
	}
	
	public String getEscWorkOnHoliday() {
		return escapeHTML(workOnHoliday);
	}
	
	public String getEscLateNightTimes() {
		return escapeHTML(lateNightTimes);
	}
	
	public String getEscPresence() {
		return escapeHTML(presence);
	}
	
	public String getEscPaidHoliday() {
		return escapeHTML(paidHoliday);
	}
	
	public String getEscParticularHoliday() {
		return escapeHTML(particularHoliday);
	}
	
	public String getEscAbsence() {
		return escapeHTML(absence);
	}
	
	public String getEscSick() {
		return escapeHTML(sick);
	}
	
	public String getEscCompensationLeave() {
		return escapeHTML(compensationLeave);
	}
	
	public String getEscTransfer() {
		return escapeHTML(transfer);
	}
	
	public String getEscOther() {
		return escapeHTML(other);
	}
	
	public String getEscLeaveAndLate() {
		return escapeHTML(leaveAndLate);
	}
	
	public String getEscAllowance() {
		return escapeHTML(allowance);
	}
	
	public String getSelectKCode() {
		return selectKCode;
	}
	
	public void setSelectKCode(String selectKCode) {
		this.selectKCode = selectKCode;
	}
	
	public String getPltYear() {
		return pltYear;
	}
	
	public String getPltMonth() {
		return pltMonth;
	}
	
	public String getEscPltYear() {
		return escapeHTML(pltYear);
	}
	
	public String getEscPltMonth() {
		return escapeHTML(pltMonth);
	}
	
	public void setPltYear(String pltYear) {
		this.pltYear = pltYear;
	}
	
	public void setPltMonth(String pltMonth) {
		this.pltMonth = pltMonth;
	}
	
	public void setMode(int mode) {
		this.mode = mode;
	}
	
	/**
	 * @return overTimeCssClass
	 */
	public String getOverTimeCssClass() {
		return overTimeCssClass;
	}
	
	/**
	 * @param overTimeCssClass Zbg overTimeCssClass
	 */
	public void setOverTimeCssClass(String overTimeCssClass) {
		this.overTimeCssClass = overTimeCssClass;
	}
	
}
