/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.mospcommon.system.action;

import java.sql.SQLException;
import java.util.Date;

import jp.mosp.common.CommonConst;
import jp.mosp.common.MosPAction;
import jp.mosp.common.common.BaseVo;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.common.MospUtility;
import jp.mosp.common.utils.DateUtil;
import jp.mosp.common.utils.StringUtil;
import jp.mosp.common.utils.VariousUtil;
import jp.mosp.mospcommon.system.LaborAgreementManager;
import jp.mosp.mospcommon.system.dao.CmAgreementOverTimeDao;
import jp.mosp.mospcommon.system.dto.CmAgreementOverTimeDto;
import jp.mosp.mospcommon.system.vo.OverTimeAgreementCardVo;

/**
 * @author koike
 *
 */
public class OverTimeAgreementCardAction extends MosPAction {
	
	// R}h
	private static final String	CMD_OVER_TIME_AGREEMENT_CARD_SHOW	= "S2525";	// \(ǉ)
	private static final String	CMD_OVER_TIME_AGREEMENT_CARD_SELECT	= "S2526";	// \(I)
	private static final String	CMD_OVER_TIME_AGREEMENT_CARD_INSERT	= "S2527";	// o^
	private static final String	CMD_OVER_TIME_AGREEMENT_CARD_UPDATE	= "S2528";	// XV
																				
	
	/**
	 * RXgN^
	 */
	public OverTimeAgreementCardAction() {
		super();
	}
	
	public void action() throws Exception {
		// VO̎擾		
		prepareVo(false);
		// 
		init();
		// R}h̏
		if (cmd.equals(CMD_OVER_TIME_AGREEMENT_CARD_SHOW)) {
			// \
			show();
		} else if (cmd.equals(CMD_OVER_TIME_AGREEMENT_CARD_SELECT)) {
			// \(L[ŏ)
			select();
		} else if (cmd.equals(CMD_OVER_TIME_AGREEMENT_CARD_INSERT)) {
			// VKo^
			insert();
		} else if (cmd.equals(CMD_OVER_TIME_AGREEMENT_CARD_UPDATE)) {
			// XV
			update();
		} else {
			throw new MospException(MospConst.EX_CMD_INVALID);
		}
	}
	
	@Override
	protected BaseVo getSpecificVo() {
		return new OverTimeAgreementCardVo();
	}
	
	@Override
	protected void init() throws Exception {
		// DBRlNV擾
		getConnection();
		// PAYROLLmF
		confirmSystemAuth();
		OverTimeAgreementCardVo vo = (OverTimeAgreementCardVo)getVo();
		// ރv_EXg쐬
		vo.aryPltAgreeType = part().mospcode().getAgreementTypeArray();
		// xv_EXg쐬
		vo.aryPltLimitCode = getLimitStandardArray();
		// N
		// JnNv_EXg쐬
		Date todayDate = DateUtil.getSystemDate();
		vo.aryPltYear = StringUtil.getYearArray(MospUtility.getYear(todayDate));
		vo.aryPltMonth = StringUtil.getMonthArray();
		vo.aryPltDay = StringUtil.getDayArray();
	}
	
	@Override
	protected void show() {
		OverTimeAgreementCardVo vo = (OverTimeAgreementCardVo)getVo();
		vo.setDefaultValues();
		// lݒ
		Date todayDate = DateUtil.getSystemDate();
		vo.setPltStartDateYear(String.valueOf(MospUtility.getYear(todayDate)));
		vo.setPltStartDateMonth(String.valueOf(MospUtility.getMonth(todayDate)));
		vo.setPltStartDateDay(String.valueOf(MospUtility.getDay(todayDate)));
		vo.setTxtOverTimeRate("125");
		vo.setTxtCautionMonthHour("60");
		vo.setTxtCautionMonthMin("0");
		vo.setTxtMonthlyOverTimeRate("150");
		vo.setTxtSubAcquireRate("125");
		vo.setTxtSubAcquireHolidayRate("125");
		vo.setTxtSubQuitRate("150");
		vo.setPltDeletFlag(String.valueOf(MospConst.DELETE_FLAG_OFF));
		vo.setMode(OverTimeAgreementCardVo.MODE_INSERT);
	}
	
	@Override
	protected void select() throws Exception {
		OverTimeAgreementCardVo vo = (OverTimeAgreementCardVo)getVo();
		CmAgreementOverTimeDao dao = new CmAgreementOverTimeDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		// f[^̎擾
		CmAgreementOverTimeDto dto = dao.findForKey(Integer.parseInt(key1));
		chkExist(dto);
		// VOɏZbg
		vo.setFields(dto);
		vo.setMode(OverTimeAgreementCardVo.MODE_UPDATE);
		// ZbVDTOZbg
		setSessionDto(dto);
	}
	
	@Override
	protected void insert() throws Exception {
		OverTimeAgreementCardVo vo = (OverTimeAgreementCardVo)getVo();
		vo.setParams(request);
		vo.setPltDeletFlag(String.valueOf(MospConst.DELETE_FLAG_OFF));
		// p[^̑ÓmF
		vo.validate();
		// DTȌ
		CmAgreementOverTimeDto dto = new CmAgreementOverTimeDto();
		// DAȌ
		CmAgreementOverTimeDao dao = new CmAgreementOverTimeDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		String max = dao.findForMax();
		if (StringUtil.isNull(max)) {
			max = "-1";
		}
		vo.setDtoFields(dto);
		dto.setOverTimeId(Integer.parseInt(max) + 1);
		// d`FbN
		chkDuplicate(dao.findForKey(dto.getOverTimeId()));
		chkDuplicate(dao.findForStartDate(dto.getOverTimeCode(), dto.getStartDate()));
		// xR[h̑Ó
		checkLimitStandard();
		// f[^̑}
		dao.insert(dto);
		// DTO̍Ď擾
		CmAgreementOverTimeDto retDto = dao.findForKey(dto.getOverTimeId());
		chkInsert(retDto);
		// R~bg1
		commit();
		// [hݒ
		vo.setMode(OverTimeAgreementCardVo.MODE_UPDATE);
		// bZ[Wݒ
		setMessage(getMessage(MospConst.MSG_INSERT, ""));
		// ZbVDTOZbg
		setSessionDto(retDto);
	}
	
	@Override
	protected void update() throws Exception {
		// DTO̎擾		
		CmAgreementOverTimeDto dto = (CmAgreementOverTimeDto)getSessionDto();
		OverTimeAgreementCardVo vo = (OverTimeAgreementCardVo)getVo();
		vo.setParams(request);
		vo.setTxtOverTimeCode(dto.getOverTimeCode());
		// p[^̑ÓmF
		vo.validate();
		// DTȌ
		vo.setDtoFields(dto);
		// xR[h̑Ó
		checkLimitStandard();
		// DAȌ
		CmAgreementOverTimeDao dao = new CmAgreementOverTimeDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		boolean comitFlag = true;
		// rmF
		chkExclusive(dto, dao.findForUpdate(dto.getOverTimeId()));
		// d`FbN
		if (MospConst.DELETE_FLAG_OFF == dto.getDeleteFlag()) {
			CmAgreementOverTimeDto overTimeDto = dao.findForStartDate(dto.getOverTimeCode(), dto.getStartDate());
			if (VariousUtil.isNotNull(overTimeDto) && (overTimeDto.getOverTimeId() != dto.getOverTimeId())) {
				addErrMessage(getMessage(MospConst.MSG_DUPLICATE, ""));
				comitFlag = false;
			}
		}
		if (comitFlag) {
			// f[^̍XV
			dao.update(dto);
			// DTO̍Ď擾
			CmAgreementOverTimeDto retDto = dao.findForKey(dto.getOverTimeId());
			chkUpdate(retDto);
			// R~bg
			commit();
			// bZ[Wݒ
			setMessage(getMessage(MospConst.MSG_UPDATE, ""));
			// ZbVDTOZbg
			setSessionDto(retDto);
		}
		// [hݒ
		vo.setMode(OverTimeAgreementCardVo.MODE_UPDATE);
	}
	
	/**
	 * xR[h擾
	 * @return xR[hXg
	 * @throws SQLException SQLOꍇ
	 * @throws NoSuchFieldException w肳ꂽÕtB[hNXɂ͂Ȃꍇ
	 * @throws IllegalAccessException {ƂȂ郁\bhOX[ꍇ
	 * @throws MospException  MosPOꍇ
	 */
	protected String[][] getLimitStandardArray() throws SQLException, NoSuchFieldException, IllegalAccessException,
			MospException {
		// ̎擾
		LaborAgreementManager laborAgreement = new LaborAgreementManager(cfg, cmd, aspUser, user, conn);
		// z̍쐬
		String[][] aryLimitStandard = laborAgreement.getLimitStandardArray();
		if (aryLimitStandard.length == 0) {
			addErrMessage(getMessage("WA1001", CommonConst.NAM_LIMIT_STANDARD));
		}
		return aryLimitStandard;
	}
	
	/**
	 * xR[h̑Ó`FbN
	 * @throws Exception Oꍇ
	 */
	private void checkLimitStandard() throws Exception {
		/*
				OverTimeAgreementCardVo vo = (OverTimeAgreementCardVo)getVo();
				// ̎擾
				LaborAgreement laborAgreement = new LaborAgreement(cfg, cmd, aspUser, user, conn);
				CmLimitStandardDto dto = laborAgreement.getLimitStandardInfo(vo.getPltLimitCode());
				// 玙͉Ƒ̂߂̎ԊOJ̐
				final int limitHour = 150;
				if (VariousUtil.isNotNull(dto)) {
					String[][] aryAgreeType = part().mospcode().getAgreementTypeArray();
					if (vo.getPltAgreeType().equals(aryAgreeType[2][0]) && dto.getLimitYear() > limitHour) {
						addErrMessage(getMessage("WC2010", CommonConst.NAM_LIMIT_STANDARD));
						throw new MospException(MospConst.EX_DUPLICATE);
					}
				}
		*/
	}
	
}
