/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.mospcommon.system.dao;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import com.google.appengine.api.datastore.Query;

import jp.getset.gae.bigtable.PreparedStatement;
import jp.getset.gae.bigtable.option.PreparedProperty;
import jp.getset.gae.bigtable.option.operation.OperationMax;
import jp.mosp.common.common.BaseDao;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.mospcommon.system.dto.CmAgreementWorkOnDto;

/**
 * CM_AGREEMENT_WORK_ON(xo}X^)DAONX B
 */
public class CmAgreementWorkOnDao extends BaseDao {
	
	// e[uyуL[
	/**
	 * CM_AGREEMENT_WORK_ON(xo}X^)B
	 */
	public static final String	TABLE						= "CM_AGREEMENT_WORK_ON";
	
	/**
	 * KEY_1 = WORK_ON_ID(xoID)B
	 */
	public static final String	KEY_1						= "WORK_ON_ID";
	
	// 
	/**
	 * WORK_ON_ID(xoID)B
	 */
	public static final String	COL_WORK_ON_ID				= "WORK_ON_ID";
	/**
	 * WORK_ON_CODE(xoR[h)B
	 */
	public static final String	COL_WORK_ON_CODE			= "WORK_ON_CODE";
	/**
	 * WORK_TYPE_NAME(Ɩ̎)B
	 */
	public static final String	COL_WORK_TYPE_NAME			= "WORK_TYPE_NAME";
	/**
	 * CAUSE(̓IR)B
	 */
	public static final String	COL_CAUSE					= "CAUSE";
	/**
	 * STANDARD_WEEK_HOLIDAY(x)B
	 */
	public static final String	COL_STANDARD_WEEK_HOLIDAY	= "STANDARD_WEEK_HOLIDAY";
	/**
	 * OFFICIAL_HOLIDAY(@x)B
	 */
	public static final String	COL_OFFICIAL_HOLIDAY		= "OFFICIAL_HOLIDAY";
	/**
	 * JAPANESE_HOLIDAY_FLAG(̏jtO)B
	 */
	public static final String	COL_JAPANESE_HOLIDAY_FLAG	= "JAPANESE_HOLIDAY_FLAG";
	/**
	 * HOLIDAY_MASTER_FLAG(jՓ}X^tO)B
	 */
	public static final String	COL_HOLIDAY_MASTER_FLAG		= "HOLIDAY_MASTER_FLAG";
	/**
	 * STANDARD_HOLIDAY_RATE(x)B
	 */
	public static final String	COL_STANDARD_HOLIDAY_RATE	= "STANDARD_HOLIDAY_RATE";
	/**
	 * OFFICIAL_HOLIDAY_RATE(@x)B
	 */
	public static final String	COL_OFFICIAL_HOLIDAY_RATE	= "OFFICIAL_HOLIDAY_RATE";
	/**
	 * NUMBER_OF_WORK_ON(xo)B
	 */
	public static final String	COL_NUMBER_OF_WORK_ON		= "NUMBER_OF_WORK_ON";
	/**
	 * START_TIME(Jn)B
	 */
	public static final String	COL_START_TIME				= "START_TIME";
	/**
	 * END_TIME(I)B
	 */
	public static final String	COL_END_TIME				= "END_TIME";
	/**
	 * START_DATE(JnN)B
	 */
	public static final String	COL_START_DATE				= "START_DATE";
	/**
	 * DELETE_FLAG(폜tO)B
	 */
	public static final String	COL_DELETE_FLAG				= "DELETE_FLAG";
	

	/**
	 * RXgN^B
	 */
	public CmAgreementWorkOnDao() {
		super();
		INSERT_DATE = "INSERT_DATE";
		INSERT_USER = "INSERT_USER";
		UPDATE_DATE = "UPDATE_DATE";
		UPDATE_USER = "UPDATE_USER";
	}
	
	/**
	 * ʎ擾(DTOList)B
	 * @return ʃXg
	 * @throws SQLException 	SQLOꍇ
	 */
	private List<CmAgreementWorkOnDto> mappingAll() throws SQLException {
		List<CmAgreementWorkOnDto> all = new ArrayList<CmAgreementWorkOnDto>();
		while (rs.next()) {
			all.add(mapping());
		}
		return all;
	}
	
	/**
	 * ʎ擾(DTO)B
	 * @return CM_AGREEMENT_WORK_ONR[h
	 * @throws SQLException 	SQLOꍇ
	 */
	private CmAgreementWorkOnDto mapping() throws SQLException {
		CmAgreementWorkOnDto dto = new CmAgreementWorkOnDto();
		dto.setWorkOnId(rs.getInt(COL_WORK_ON_ID));
		dto.setWorkOnCode(rs.getString(COL_WORK_ON_CODE));
		dto.setWorkTypeName(rs.getString(COL_WORK_TYPE_NAME));
		dto.setCause(rs.getString(COL_CAUSE));
		dto.setStandardWeekHoliday(rs.getString(COL_STANDARD_WEEK_HOLIDAY));
		dto.setOfficialHoliday(rs.getString(COL_OFFICIAL_HOLIDAY));
		dto.setJapaneseHolidayFlag(rs.getString(COL_JAPANESE_HOLIDAY_FLAG));
		dto.setHolidayMasterFlag(rs.getString(COL_HOLIDAY_MASTER_FLAG));
		dto.setStandardHolidayRate(rs.getInt(COL_STANDARD_HOLIDAY_RATE));
		dto.setOfficialHolidayRate(rs.getInt(COL_OFFICIAL_HOLIDAY_RATE));
		dto.setNumberOfWorkOn(rs.getInt(COL_NUMBER_OF_WORK_ON));
		dto.setStartTime(rs.getInt(COL_START_TIME));
		dto.setEndTime(rs.getInt(COL_END_TIME));
		dto.setStartDate(rs.getDate(COL_START_DATE));
		dto.setDeleteFlag(rs.getInt(COL_DELETE_FLAG));
		mappingCommonInfo(dto);
		return dto;
	}
	
	/**
	 * Sf[^擾B
	 * @return (DTOList)
	 * @throws SQLException 	SQLOꍇ
	 * @throws IllegalAccessException 	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException 	tB[hȂꍇ
	 */
	public List<CmAgreementWorkOnDto> findAll() throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			prepareStatement(getSelectQuery(getClass()) + getOrderForKey(getClass()));
			executeQuery();
			return mappingAll();
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * L[ɂf[^擾B
	 * @param workOnId xoID
	 * @return (DTO)
	 * @throws SQLException 	SQLOꍇ
	 * @throws IllegalAccessException 	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException 	tB[hȂꍇ
	 */
	public CmAgreementWorkOnDto findForKey(int workOnId) throws SQLException, IllegalAccessException,
			NoSuchFieldException {
		try {
			index = 1;
			prepareStatement(getSelectQuery(getClass()) + getConditionForKey(getClass()));
			setParam(index++, workOnId);
			executeQuery();
			CmAgreementWorkOnDto dto = null;
			if (rs.next()) {
				dto = mapping();
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * L[ɂsbN擾B
	 * @param workOnId xoID
	 * @return (DTO)
	 * @throws SQLException 	SQLOꍇ
	 * @throws IllegalAccessException 	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException 	tB[hȂꍇ
	 */
	public CmAgreementWorkOnDto findForUpdate(int workOnId) throws SQLException, IllegalAccessException,
			NoSuchFieldException {
		try {
			index = 1;
			prepareStatement(getSelectQuery(getClass()) + getConditionForKey(getClass()) + getForUpdate());
			setParam(index++, workOnId);
			executeQuery();
			CmAgreementWorkOnDto dto = null;
			if (rs.next()) {
				dto = mapping();
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * ɂf[^擾B
	 * @param workOnId xoID
	 * @return (DTOList)
	 * @throws SQLException 	SQLOꍇ
	 * @throws IllegalAccessException 	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException 	tB[hȂꍇ
	 */
	public List<CmAgreementWorkOnDto> findForCondition(int workOnId) throws SQLException, IllegalAccessException,
			NoSuchFieldException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append(" WHERE ");
		sb.append(COL_WORK_ON_ID);
		sb.append(" = ? ");
		this.pob.appendWhere(COL_WORK_ON_ID, Query.FilterOperator.EQUAL);
		try {
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForKey(getClass()));
			setParam(index++, workOnId);
			executeQuery();
			return mappingAll();
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * ɂf[^擾B
	 * @param workOnCode xoR[h
	 * @param workTypeName Ɩ̎
	 * @param deleteFlag 폜tO
	 * @return (DTOList)
	 * @throws SQLException 	SQLOꍇ
	 * @throws IllegalAccessException 	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException 	tB[hȂꍇ
	 */
	public List<CmAgreementWorkOnDto> findForCondition(String workOnCode, String workTypeName, String deleteFlag)
			throws SQLException, IllegalAccessException, NoSuchFieldException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append(" WHERE ");
		sb.append(COL_WORK_ON_CODE);
		sb.append(" LIKE ? AND ");
		sb.append(COL_WORK_TYPE_NAME);
		sb.append(" LIKE ? ");
		this.pob.appendLike(COL_WORK_ON_CODE);
		this.pob.appendLike(COL_WORK_TYPE_NAME);
		if (!deleteFlag.equals("")) {
			sb.append("AND ");
			sb.append(COL_DELETE_FLAG);
			sb.append(" = ? ");
			this.pob.appendWhere(COL_DELETE_FLAG, Query.FilterOperator.EQUAL);
		}
		try {
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForKey(getClass()));
			setParam(index++, workOnCode + "%");
			setParam(index++, "%" + workTypeName + "%");
			if (!deleteFlag.equals("")) {
				setParam(index++, Integer.parseInt(deleteFlag));
			}
			executeQuery();
			return mappingAll();
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * ɂf[^擾B
	 * @param workOnCode xoR[h
	 * @param targetDate Ώ۔N
	 * @return (DTO)
	 * @throws SQLException 	SQLOꍇ
	 * @throws IllegalAccessException 	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException 	tB[hȂꍇ
	 */
	public CmAgreementWorkOnDto findForAgreement(String workOnCode, Date targetDate) throws SQLException,
			IllegalAccessException, NoSuchFieldException {
		try {
			index = 1;
			StringBuffer sb = new StringBuffer();
			sb.append(" WHERE ");
			sb.append(COL_DELETE_FLAG);
			sb.append(" = " + MospConst.DELETE_FLAG_OFF);
			sb.append(" AND ");
			sb.append(COL_WORK_ON_CODE);
			sb.append(" = ?");
			sb.append(" AND ");
			sb.append(COL_START_DATE);
			sb.append(" <= ? ");
			sb.append(getOrderBy());
			sb.append(COL_START_DATE);
			sb.append(" ");
			sb.append(getDesc());
			sb.append(getLimit());
			sb.append("1");
			this.pob.appendWhere(COL_DELETE_FLAG, Query.FilterOperator.EQUAL, MospConst.DELETE_FLAG_OFF);
			this.pob.appendWhere(COL_WORK_ON_CODE, Query.FilterOperator.EQUAL);
			this.pob.appendWhere(COL_START_DATE, Query.FilterOperator.LESS_THAN_OR_EQUAL);
			this.pob.appendSort(COL_START_DATE, Query.SortDirection.DESCENDING);
			prepareStatement(getSelectQuery(getClass()) + sb.toString());
			this.ps.setMaxRows(1);
			setParam(index++, workOnCode);
			setParam(index++, targetDate);
			executeQuery();
			CmAgreementWorkOnDto dto = null;
			if (rs.next()) {
				dto = mapping();
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * ɂf[^擾B
	 * @param workOnCode xoR[h
	 * @param targetDate Ώ۔N
	 * @return (DTO)
	 * @throws SQLException 	SQLOꍇ
	 * @throws IllegalAccessException 	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException 	tB[hȂꍇ
	 */
	public CmAgreementWorkOnDto findForStartDate(String workOnCode, Date targetDate) throws SQLException,
			IllegalAccessException, NoSuchFieldException {
		try {
			index = 1;
			StringBuffer sb = new StringBuffer();
			sb.append(" WHERE ");
			sb.append(COL_DELETE_FLAG);
			sb.append(" = " + MospConst.DELETE_FLAG_OFF);
			sb.append(" AND ");
			sb.append(COL_WORK_ON_CODE);
			sb.append(" = ?");
			sb.append(" AND ");
			sb.append(COL_START_DATE);
			sb.append(" = ? ");
			this.pob.appendWhere(COL_DELETE_FLAG, Query.FilterOperator.EQUAL, MospConst.DELETE_FLAG_OFF);
			this.pob.appendWhere(COL_WORK_ON_CODE, Query.FilterOperator.EQUAL);
			this.pob.appendWhere(COL_START_DATE, Query.FilterOperator.EQUAL);
			prepareStatement(getSelectQuery(getClass()) + sb.toString());
			setParam(index++, workOnCode);
			setParam(index++, targetDate);
			executeQuery();
			CmAgreementWorkOnDto dto = null;
			if (rs.next()) {
				dto = mapping();
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * maxl擾
	 * @return String@őA
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException	tB[hȂꍇ
	 */
	public String findForMax() throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			String max = "";
			index = 1;
			StringBuffer sb = new StringBuffer();
			sb.append("SELECT MAX(");
			sb.append(COL_WORK_ON_ID);
			sb.append(") FROM ");
			sb.append(TABLE);
			// GAE
			this.setPreparedStatement(PreparedStatement.Mode.SELECT, getClass());
			PreparedProperty operation = new PreparedProperty(COL_WORK_ON_ID);
			operation.setOperation(new OperationMax());
			this.pob.appendFilledPreparable(operation);
			
			prepareStatement(sb.toString());
			executeQuery();
			if (rs.next()) {
				max = String.valueOf(rs.getLong(1));
			}
			return max;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * xoR[h擾
	 * @param targetDate Ώ۔N
	 * @return 
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException \bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException tB[hȂꍇ
	 */
	public List<String> findForWorkOnCode(Date targetDate) throws SQLException, IllegalAccessException,
			NoSuchFieldException {
		try {
			index = 1;
			StringBuffer sb = new StringBuffer();
			sb.append("SELECT DISTINCT ");
			sb.append(COL_WORK_ON_CODE);
			sb.append(" FROM ");
			sb.append(TABLE);
			sb.append(" WHERE ");
			sb.append(COL_DELETE_FLAG);
			sb.append(" = ");
			sb.append(MospConst.DELETE_FLAG_OFF);
			sb.append(" AND ");
			sb.append(COL_START_DATE);
			sb.append(" <= ?");
			// GAE
			this.setPreparedStatement(PreparedStatement.Mode.SELECT, getClass());
			this.pob.appendDistinct(COL_WORK_ON_CODE);
			this.pob.appendWhere(COL_DELETE_FLAG, Query.FilterOperator.EQUAL, MospConst.DELETE_FLAG_OFF);
			this.pob.appendWhere(COL_START_DATE, Query.FilterOperator.LESS_THAN_OR_EQUAL);
			prepareStatement(sb.toString());
			setParam(index++, targetDate);
			executeQuery();
			List<String> list = new ArrayList<String>();
			while (rs.next()) {
				list.add(rs.getString(COL_WORK_ON_CODE));
			}
			return list;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * f[^}B
	 * @param dto }ΏDTO
	 * @return int }()
	 * @throws SQLException 	SQLOꍇ
	 * @throws IllegalAccessException 	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException 	tB[hȂꍇ
	 * @throws MospException 	MosPOꍇ
	 */
	public int insert(CmAgreementWorkOnDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException,
			MospException {
		try {
			index = 1;
			prepareStatement(getInsertQuery(getClass()));
			setParams(dto, true);
			executeUpdate();
			chkInsert(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * f[^XVB
	 * @param dto XVΏDTO
	 * @return int XV()
	 * @throws SQLException 	SQLOꍇ
	 * @throws IllegalAccessException 	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException 	tB[hȂꍇ
	 * @throws MospException 	MosPOꍇ
	 */
	public int update(CmAgreementWorkOnDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException,
			MospException {
		try {
			index = 1;
			prepareStatement(getUpdateQuery(getClass()));
			setParams(dto, false);
			setParam(index++, dto.getWorkOnId());
			executeUpdate();
			chkUpdate(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * f[^폜B
	 * @param dto XVΏDTO
	 * @return int 폜()
	 * @throws SQLException 	SQLOꍇ
	 * @throws IllegalAccessException 	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException 	tB[hȂꍇ
	 * @throws MospException 	MosPOꍇ
	 */
	public int delete(CmAgreementWorkOnDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException,
			MospException {
		try {
			index = 1;
			prepareStatement(getDeleteQuery(getClass()));
			setParam(index++, dto.getWorkOnId());
			executeUpdate();
			chkDelete(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * p[^ݒB
	 * @param dto XVΏDTO
	 * @param isInsert }tO(trueF}AfalseF})
	 * @throws SQLException 	SQLOꍇ
	 */
	private void setParams(CmAgreementWorkOnDto dto, boolean isInsert) throws SQLException {
		setParam(index++, dto.getWorkOnId());
		setParam(index++, dto.getWorkOnCode());
		setParam(index++, dto.getWorkTypeName());
		setParam(index++, dto.getCause());
		setParam(index++, dto.getStandardWeekHoliday());
		setParam(index++, dto.getOfficialHoliday());
		setParam(index++, dto.getJapaneseHolidayFlag());
		setParam(index++, dto.getHolidayMasterFlag());
		setParam(index++, dto.getStandardHolidayRate());
		setParam(index++, dto.getOfficialHolidayRate());
		setParam(index++, dto.getNumberOfWorkOn());
		setParam(index++, dto.getStartTime());
		setParam(index++, dto.getEndTime());
		setParam(index++, dto.getStartDate());
		setParam(index++, dto.getDeleteFlag());
		setCommonParams(isInsert);
	}
	
}
