/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.mospcommon.system.dto;

import jp.mosp.common.common.BaseDto;

/**
 * CM_LIMIT_STANDARD(x}X^)DTONXB
 */
public class CmLimitStandardDto extends BaseDto {
	
	/**
	 * 
	 */
	private static final long	serialVersionUID	= -2068019072118421348L;
	// tB[h
	private String				limitcode			= "";
	private String				limitname			= "";
	private String				termtype			= "";
	private int					prescribedtime		= 0;
	private int					cautionday			= 0;
	private int					cautionterm			= 0;
	private int					cautionyear			= 0;
	private int					limitday			= 0;
	private int					limitterm			= 0;
	private int					limityear			= 0;
	private int					rateterm			= 0;
	private int					rateyear			= 0;
	private int					deleteflag			= 0;
	

	/**
	 * RXgN^B
	 */
	public CmLimitStandardDto() {
		super();
	}
	
	// ANZT\bh
	/**
	 * @return limitcode 	xR[hB
	 */
	public String getLimitCode() {
		return limitcode;
	}
	
	/**
	 * @return limitname 	x́B
	 */
	public String getLimitName() {
		return limitname;
	}
	
	/**
	 * @return termtype 	Ԃ̎ށB
	 */
	public String getTermType() {
		return termtype;
	}
	
	/**
	 * @return prescribedtime 	JԁB
	 */
	public int getPrescribedTime() {
		return prescribedtime;
	}
	
	/**
	 * @return cautionday 	1̌xԁB
	 */
	public int getCautionDay() {
		return cautionday;
	}
	
	/**
	 * @return cautionterm 	wԂ̌xԁB
	 */
	public int getCautionTerm() {
		return cautionterm;
	}
	
	/**
	 * @return cautionyear 	1ŇxԁB
	 */
	public int getCautionYear() {
		return cautionyear;
	}
	
	/**
	 * @return limitday 	̌xԁB
	 */
	public int getLimitDay() {
		return limitday;
	}
	
	/**
	 * @return limitterm 	wԂ̌xԁB
	 */
	public int getLimitTerm() {
		return limitterm;
	}
	
	/**
	 * @return limityear 	1ŇxԁB
	 */
	public int getLimitYear() {
		return limityear;
	}
	
	/**
	 * @return rateterm 	wԂ̊B
	 */
	public int getRateTerm() {
		return rateterm;
	}
	
	/**
	 * @return rateyear 	1N̊B
	 */
	public int getRateYear() {
		return rateyear;
	}
	
	/**
	 * @return deleteflag 	폜tOB
	 */
	public int getDeleteFlag() {
		return deleteflag;
	}
	
	/**
	 * @param limitcode 	ZbgxR[hB
	 */
	public void setLimitCode(String limitcode) {
		this.limitcode = limitcode;
	}
	
	/**
	 * @param limitname 	Zbgx́B
	 */
	public void setLimitName(String limitname) {
		this.limitname = limitname;
	}
	
	/**
	 * @param termtype 	ZbgԂ̎ށB
	 */
	public void setTermType(String termtype) {
		this.termtype = termtype;
	}
	
	/**
	 * @param prescribedtime 	Zbg鏊JԁB
	 */
	public void setPrescribedTime(int prescribedtime) {
		this.prescribedtime = prescribedtime;
	}
	
	/**
	 * @param cautionday 	Zbg1̌xԁB
	 */
	public void setCautionDay(int cautionday) {
		this.cautionday = cautionday;
	}
	
	/**
	 * @param cautionterm 	ZbgwԂ̌xԁB
	 */
	public void setCautionTerm(int cautionterm) {
		this.cautionterm = cautionterm;
	}
	
	/**
	 * @param cautionyear 	Zbg1ŇxԁB
	 */
	public void setCautionYear(int cautionyear) {
		this.cautionyear = cautionyear;
	}
	
	/**
	 * @param limitday 	ZbǧxԁB
	 */
	public void setLimitDay(int limitday) {
		this.limitday = limitday;
	}
	
	/**
	 * @param limitterm 	ZbgwԂ̌xԁB
	 */
	public void setLimitTerm(int limitterm) {
		this.limitterm = limitterm;
	}
	
	/**
	 * @param limityear 	Zbg1ŇxԁB
	 */
	public void setLimitYear(int limityear) {
		this.limityear = limityear;
	}
	
	/**
	 * @param rateterm 	ZbgwԂ̊B
	 */
	public void setRateTerm(int rateterm) {
		this.rateterm = rateterm;
	}
	
	/**
	 * @param rateyear 	Zbg1N̊B
	 */
	public void setRateYear(int rateyear) {
		this.rateyear = rateyear;
	}
	
	/**
	 * @param deleteflag 	Zbg폜tOB
	 */
	public void setDeleteFlag(int deleteflag) {
		this.deleteflag = deleteflag;
	}
	
}
