/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
/**
 * 
 */
package jp.mosp.mospcommon.system.vo;

import java.util.Iterator;
import java.util.List;

import javax.servlet.http.HttpServletRequest;

import jp.mosp.common.CommonConst;
import jp.mosp.common.MosPMenuConst;
import jp.mosp.common.MosPVo;
import jp.mosp.common.common.MospConst;
import jp.mosp.mospcommon.system.dto.CmLimitStandardDto;

/**
 * @author nakamura
 *
 */
public class LimitStandardMasterListVo extends MosPVo {
	
	private static final long	serialVersionUID	= -6494798631482617888L;
	
	// 萔
	/**
	 * 
	 */
	public static final int		SEARCH_OFF			= 0;
	
	/**
	 * 
	 */
	public static final int		SEARCH_ON			= 1;
	
	// p[^
	/**
	 * xR[h
	 */
	public static final String	PRM_TXT_LCODE		= "txtLCode";
	
	/**
	 * x
	 */
	public static final String	PRM_TXT_LNAME		= "txtLName";
	
	/**
	 * 폜tO
	 */
	public static final String	PRM_PLT_DELETE_FLAG	= "pltDeleteFlag";
	
	// tB[h
	private String[]			aryLCode;
	private String[]			aryLName;
	private String[]			aryDelete;
	private String				txtLCode;
	private String				txtLName;
	private String				pltDeleteFlag;
	
	// tB[hyѐ
	/**
	 * xR[h
	 */
	public String				NAM_LCODE;
	
	/**
	 * x
	 */
	public String				NAM_LNAME;
	
	/**
	 * 폜tO
	 */
	public String				NAM_DELETE_FLAG;
	
	/**
	 * xR[h
	 */
	public int					LEN_LCODE;
	
	/**
	 * x
	 */
	public int					LEN_LNAME;
	
	// \[gL[
	/**
	 * xR[h
	 */
	public final String			KEY_LCODE			= "keyLCode";
	
	/**
	 * x
	 */
	public final String			KEY_LNAME			= "keyLName";
	/**
	 * LE
	 */
	public final String			KEY_DELETE			= "keyDelete";
	
	// [h(0FȂA1F)
	private int					searchmode;
	

	/**
	 * RXgN^[
	 */
	public LimitStandardMasterListVo() {
		super();
		setViewPath(getClassName());
		aryLCode = new String[0];
		aryLName = new String[0];
		aryDelete = new String[0];
		txtLCode = "";
		txtLName = "";
		pltDeleteFlag = "";
		setFormerKey(KEY_LCODE);
	}
	
	@Override
	protected void setSubTitle() {
		subTitle = CommonConst.TTL_LIMIT_STANDARD;
		createAryMenu(CMD_MENU_SYSTEM2, MosPMenuConst.getMenuLaborAgreement());
	}
	
	@Override
	protected void setFieldsName() {
		NAM_LCODE = CommonConst.NAM_LIMIT_STANDARD + CommonConst.NAM_COMMON_CODE;
		NAM_LNAME = CommonConst.NAM_COMMON_MEISYO;
		NAM_DELETE_FLAG = CommonConst.NAM_DELETE_FLAG;
		LEN_LCODE = 10;
		LEN_LNAME = CommonConst.LEN_LIMIT_NAME;
	}
	
	@Override
	public void setParams(HttpServletRequest request) {
		txtLCode = request.getParameter(PRM_TXT_LCODE);
		txtLName = request.getParameter(PRM_TXT_LNAME);
		pltDeleteFlag = request.getParameter(PRM_PLT_DELETE_FLAG);
	}
	
	/**
	 * tB[hݒ
	 * @param listLimitStandard ƏXg
	 */
	@Override
	public void setFields(List<?> listLimitStandard) {
		// Xg̐ݒ
		list = listLimitStandard;
		// f[^̎擾
		count = listLimitStandard.size();
		// z̏
		aryLCode = new String[count];
		aryLName = new String[count];
		aryDelete = new String[count];
		// f[^̐ݒ
		int i = 0;
		Iterator<?> it = listLimitStandard.iterator();
		while (it.hasNext()) {
			CmLimitStandardDto dto = (CmLimitStandardDto)it.next();
			aryLCode[i] = escapeHTML(dto.getLimitCode());
			aryLName[i] = escapeHTML(dto.getLimitName());
			if (dto.getDeleteFlag() == MospConst.DELETE_FLAG_OFF) {
				aryDelete[i] = escapeHTML(MospConst.DELETE_FLAG_OFF_NAME);
			} else if (dto.getDeleteFlag() == MospConst.DELETE_FLAG_ON) {
				aryDelete[i] = escapeHTML(MospConst.DELETE_FLAG_ON_NAME);
			}
			i++;
		}
	}
	
	// ANZT\bh
	/**
	 * @return xR[h
	 */
	public String[] getEscAryLCode() {
		return aryLCode.clone();
	}
	
	/**
	 * @return x
	 */
	public String[] getEscAryLName() {
		return aryLName.clone();
	}
	
	/**
	 * @return xR[h
	 */
	public String getTxtLCode() {
		return txtLCode;
	}
	
	/**
	 * @return x
	 */
	public String getTxtLName() {
		return txtLName;
	}
	
	/**
	 * @return 폜tO
	 */
	public String getPltDeleteFlag() {
		return pltDeleteFlag;
	}
	
	/**
	 * @return xR[h
	 */
	public String getEscTxtLCode() {
		return escapeHTML(txtLCode);
	}
	
	/**
	 * @return x
	 */
	public String getEscTxtLName() {
		return escapeHTML(txtLName);
	}
	
	/**
	 * @return [h
	 */
	public int getSearchmode() {
		return searchmode;
	}
	
	/**
	 * @param searchmode [h
	 */
	public void setSearchmode(int searchmode) {
		this.searchmode = searchmode;
	}
	
	/** 
	 * @param pltDeleteFlag Zbg pltDeleteFlag 
	 */
	public void setPltDelete(String pltDeleteFlag) {
		this.pltDeleteFlag = pltDeleteFlag;
	}
	
	/**
	 * @return aryDelete
	 */
	public String[] getAryDelete() {
		return aryDelete.clone();
	}
}
