/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.payroll.bonus.dto;

import java.util.Date;

import jp.mosp.common.common.BaseDto;

public class PtSupportDto extends BaseDto {
	
	private static final long	serialVersionUID	= -343635125381145424L;
	
	// tB[h
	private String				kCode;										// ЈR[h
	private Date				startDate;									// xJn
	private Date				endDate;									// xI
	private String				stationCode;								// x揊R[h
																			
	private String				belongStation;								// ЈR[h
	private String				kName;										// Ј
																			
	
	/**
	 * RXgN^
	 */
	public PtSupportDto() {
		super();
	}
	
	// ANZT\bh
	public String getKCode() {
		return kCode;
	} // ЈR[h
	
	public Date getStartDate() {
		return (Date)startDate.clone();
	} // xJn
	
	public Date getEndDate() {
		return (Date)endDate.clone();
	} // xI
	
	public String getStationCode() {
		return stationCode;
	} // x揊R[h
	
	public void setKCode(String kCode) {
		this.kCode = kCode;
	} // ЈR[h
	
	public void setStartDate(Date startDate) {
		this.startDate = (Date)startDate.clone();
	} // xJn
	
	public void setEndDate(Date endDate) {
		this.endDate = (Date)endDate.clone();
	} // xI
	
	public void setStationCode(String stationCode) {
		this.stationCode = stationCode;
	} // x揊R[h
	
	public String getBelongStation() {
		return belongStation;
	} // ЈR[h
	
	public String getKName() {
		return kName;
	} // Ј
	
	public void setBelongStation(String belongStation) {
		this.belongStation = belongStation;
	} // ЈR[h
	
	public void setKName(String kName) {
		this.kName = kName;
	} // Ј
	
}
