/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.payroll.common.vo;

import java.util.Iterator;
import java.util.List;

import jp.mosp.common.CommonConst;
import jp.mosp.common.MosPVo;
import jp.mosp.common.common.FileUploadUtility;
import jp.mosp.common.utils.TimeUtil;
import jp.mosp.common.utils.VariousUtil;
import jp.mosp.kintai.dto.MSyukkinboDto;

import org.apache.commons.fileupload.FileItem;

public class SyukkinboImportCardVo extends MosPVo {
	
	private static final long	serialVersionUID	= 7515933469039599261L;
	
	// URLACSS
	private static final String	RETURN_URL			= "/jsp/payroll/common/syukkinboImportCard.jsp";
	private static final String	EXTRA_JS			= "/pub/payroll/common/js/syukkinboImportCard.js";
	private static final String	EXTRA_CSS			= "/pub/payroll/common/css/syukkinboImportCard.css";
	
	// p[^[
	public static final String	PRM_FIL_IMPORT_FILE	= "filImportFile";
	
	// tB[h
	private FileItem			filImportFile;
	private String[][]			aryImportData;
	
	private String				selectICode;
	private String				lblHeader;
	
	// Xg
	public String[][]			aryWorkType;
	public String[][]			aryHolidayReason;
	public String[][]			aryLateReason;
	public String[][]			aryLeaveEarlyReason;
	

	/**
	 * RXgN^
	 */
	public SyukkinboImportCardVo() {
		super();
		setRetUrl(RETURN_URL);
		addExtraJs(EXTRA_JS);
		setExtraCss(EXTRA_CSS);
		aryWorkType = new String[0][0];
		aryHolidayReason = new String[0][0];
		aryLateReason = new String[0][0];
		aryLeaveEarlyReason = new String[0][0];
		aryImportData = new String[0][0];
	}
	
	/**
	 * Tu^Cgݒ肷B
	 */
	@Override
	protected void setSubTitle() {
		super.setSubTitle();
		subTitle = getName("P_SYUKKINBO") + getName("P_IMPORT");
		aryMenu = new String[2][2];
		aryMenu[0][0] = "P1910";
		aryMenu[0][1] = getName("C_MENU") + getName("C_TO");
		aryMenu[1][0] = "P9022";
		aryMenu[1][1] = getName("C_LIST") + getName("C_TO");
	}
	
	/**
	 * p[^ݒ
	 * @param list NGXgXg
	 */
	public void setImportFile(List list) throws Exception {
		filImportFile = FileUploadUtility.getMultipartFile(list, PRM_FIL_IMPORT_FILE);
	}
	
	/**
	 * tB[hݒ
	 * @param importCsvList C|[gXg
	 */
	@Override
	public void setFields(List<?> importCsvList) {
		//Xg̐ݒ
		list = importCsvList;
		//f[^̎擾
		count = importCsvList.size();
		//z̏
		aryImportData = new String[count][14];
		//f[^̐ݒ
		int i = 0;
		Iterator it = importCsvList.iterator();
		while (it.hasNext()) {
			MSyukkinboDto dto = (MSyukkinboDto)it.next();
			aryImportData[i][0] = escapeHTML(dto.getKCode());
			aryImportData[i][1] = escapeHTML(dto.getHizuke());
			if (dto.getKinmu().equals(CommonConst.ATTENDANCE_TYPE_WEEK_HOLIDAY)) {
				aryImportData[i][2] = escapeHTML(CommonConst.ATTENDANCE_TYPE_WEEK_HOLIDAY);
			} else if (dto.getKinmu().equals(CommonConst.ATTENDANCE_TYPE_HOLIDAY)) {
				aryImportData[i][2] = escapeHTML(getCodeName(dto.getKKRiyuu(), aryHolidayReason));
			} else {
				aryImportData[i][2] = escapeHTML(getCodeName(dto.getKinmu(), aryWorkType));
			}
			aryImportData[i][3] = escapeHTML(dto.getSyJikoku());
			aryImportData[i][4] = escapeHTML(dto.getTaJikoku());
			aryImportData[i][5] = escapeHTML(VariousUtil.getHourString(TimeUtil.convIntegerTimeToDoubleTime(dto
				.getKinmuJi())));
			aryImportData[i][6] = escapeHTML(VariousUtil.getHourString(TimeUtil.convIntegerTimeToDoubleTime(dto
				.getKyukeiJi())));
			aryImportData[i][7] = escapeHTML(VariousUtil.getHourString(TimeUtil.convIntegerTimeToDoubleTime(dto
				.getTiJikan())));
			aryImportData[i][8] = escapeHTML(VariousUtil.getHourString(TimeUtil.convIntegerTimeToDoubleTime(dto
				.getSoJikan())));
			aryImportData[i][9] = escapeHTML(VariousUtil.getHourString(TimeUtil.convIntegerTimeToDoubleTime(dto
				.getZaJikan())));
			aryImportData[i][10] = escapeHTML(VariousUtil.getHourString(TimeUtil.convIntegerTimeToDoubleTime(dto
				.getKsJikan())));
			aryImportData[i][11] = escapeHTML(VariousUtil.getHourString(TimeUtil.convIntegerTimeToDoubleTime(dto
				.getSnJikan())));
			StringBuffer sb = new StringBuffer();
			sb.append(dto.getSyokuji());
			sb.append(CommonConst.SEPARATOR_DATE);
			sb.append(dto.getCyoku1());
			sb.append(dto.getCyoku2());
			sb.append(dto.getCyoku3());
			sb.append(CommonConst.SEPARATOR_DATE);
			sb.append(dto.getHoka1());
			sb.append(dto.getHoka2());
			sb.append(dto.getHoka3());
			sb.append(dto.getHoka4());
			sb.append(dto.getHoka5());
			aryImportData[i][12] = escapeHTML(sb.toString());
			aryImportData[i][13] = "";
			if (dto.getSHankyuKb().equals(CommonConst.NUM_START_HALF_HOLIDAY_FLAG_ON)
					|| dto.getTHankyuKb().equals(CommonConst.NUM_QUIT_HALF_HOLIDAY_FLAG_ON)) {
				aryImportData[i][13] += CommonConst.NAM_VACATION_LEAVE_HALF + CommonConst.NAM_COMMON_HALF_KANA_SPACE;
			}
			if (dto.getKyusyuKb().equals(CommonConst.NUM_WORK_ON_HOLIDAY_FLAG_ON)) {
				aryImportData[i][13] += CommonConst.NAM_WORK_ON_HOLIDAY + CommonConst.NAM_COMMON_HALF_KANA_SPACE;
			}
			i++;
		}
	}
	
	/**
	 * JavaScriptݒ
	 * @param cls 擾NX
	 * @throws IllegalAccessException
	 */
	@Override
	public String getDirectJs(Class cls) throws IllegalAccessException {
		StringBuffer sb = new StringBuffer();
		sb.append(super.getDirectJs(cls));
		return sb.toString();
	}
	
	// ANZT\bh
	public FileItem getFilImportFile() {
		return filImportFile;
	}
	
	public String[][] getEscAryImportData() {
		return aryImportData.clone();
	}
	
	public String getSelectICode() {
		return selectICode;
	}
	
	public String getLblHeader() {
		return lblHeader;
	}
	
	public String getEscLblHeader() {
		return escapeHTML(lblHeader);
	}
	
	public void setSelectICode(String selectICode) {
		this.selectICode = selectICode;
	}
	
	public void setLblHeader(String lblHeader) {
		this.lblHeader = lblHeader;
	}
	
}
