/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.payroll.payment.action;

import java.io.File;
import java.util.Date;
import java.util.List;

import jp.mosp.common.CommonConst;
import jp.mosp.common.common.BaseVo;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.common.PoiUtility;
import jp.mosp.common.utils.StringUtil;
import jp.mosp.payroll.base.PayrollAction;
import jp.mosp.payroll.base.PayrollConst;
import jp.mosp.payroll.dao.BankFrikomListDao;
import jp.mosp.payroll.dao.CashKindListDao;
import jp.mosp.payroll.dao.CmCompanyDao;
import jp.mosp.payroll.dto.BankFrikomListDto;
import jp.mosp.payroll.dto.CashKindListDto;
import jp.mosp.payroll.dto.CmCompanyDto;
import jp.mosp.payroll.payment.vo.PaymentReportVo;

import org.jopendocument.dom.spreadsheet.Sheet;
import org.jopendocument.dom.spreadsheet.SpreadSheet;

/**
 * ^[o(sUyыꗗ)ʂɂ鏈sB<br><br>
 * ȉ̃R}hB
 * <ul><li>
 * {@link #CMD_BANK_PERSON}
 * {@link #CMD_BANK_COMPANY}
 * {@link #CMD_CASH_KIND}
 * </li></ul>
 */
public class PaymentReportOutputAction extends PayrollAction {
	
	/**
	 * ʕ\R}hB<br><br>
	 * ^vZ̔N擾A\B<br>
	 * ^vZ̔NȂꍇ́AVXeN\B<br>
	 */
	public static final String	CMD_BANK_PERSON		= "P9014";
	/**
	 * 
	 */
	public static final String	CMD_BANK_COMPANY	= "P9015";
	/**
	 * 
	 */
	public static final String	CMD_CASH_KIND		= "P9012";
	

	/**
	 * Action̏sB<br><br>
	 * ȉ̏sB
	 * <ul><li>
	 * {@link PaymentReportOutputAction#PaymentReportOutputAction()}
	 * </li></ul>
	 */
	public PaymentReportOutputAction() {
		super();
		setNeedProcSeq(false);
	}
	
	/* (non-Javadoc)
	 * @see jp.mosp.common.common.BaseAction#getSpecificVo()
	 */
	@Override
	protected BaseVo getSpecificVo() {
		return new PaymentReportVo();
	}
	
	/**
	 * ANVB<br>
	 * ڍׂ́ANXQƁB<br>
	 */
	public void action() throws Exception {
		//VO擾yѐݒ
		prepareVo();
		if (cmd.equals(CMD_CASH_KIND)) {
			// ꗗ\o
			cashKind();
		} else if (cmd.equals(CMD_BANK_PERSON)) {
			//sUꗗ\(l)o
			bankParson();
		} else if (cmd.equals(CMD_BANK_COMPANY)) {
			//sUꗗ\(Ћs)o
			bankCompany();
		} else {
			throw new MospException(MospConst.EX_CMD_INVALID);
		}
	}
	
	/**
	 * ^ꗗ\o͏sB<br><br>
	 * @throws Exception 
	 */
	private void cashKind() throws Exception {
		//RlNV擾
		getConnection();
		// VO擾
		PaymentReportVo vo = (PaymentReportVo)getVo();
		//p[^擾
		vo.setParams(request);
		//Ώ۔N擾
		Date date = vo.getDate(String.valueOf(vo.getPltOutYear()), String.valueOf(vo.getPltOutMonth()), String
			.valueOf(PayrollConst.TIME_DEFAULT_DAY));
		//f[^̎擾
		CashKindListDao cashKindList = new CashKindListDao();
		cashKindList.initDao(cfg, cmd, aspUser, user, conn);
		List<CashKindListDto> list = cashKindList.findForCondition(date);
		//DAO
		CmCompanyDao dao = new CmCompanyDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		// DTO
		CmCompanyDto dto;
		dto = dao.findAll();
		if (StringUtil.isNotNull(cfg.getProperty(CommonConst.PPT_KINTAI_USE_ODF))) {
			//ODS
			makeSpreadSheet(list, vo, date, dto);
		} else {
			//XLS
			makeCashKindBook(list, vo, date, dto);
		}
	}
	
	/**
	 * sUꗗ\(l)o͏sB<br><br>
	 * @throws Exception 
	 */
	private void bankParson() throws Exception {
		
		//RlNV擾
		getConnection();
		// VO擾
		PaymentReportVo vo = (PaymentReportVo)getVo();
		//p[^擾
		vo.setParams(request);
		//Ώ۔N擾
		Date date = vo.getDate(String.valueOf(vo.getPltOutYear()), String.valueOf(vo.getPltOutMonth()), String
			.valueOf(PayrollConst.TIME_DEFAULT_DAY));
		//f[^̎擾
		//Uf[^擾
		BankFrikomListDao bankFrikomListDao = new BankFrikomListDao();
		bankFrikomListDao.initDao(cfg, cmd, aspUser, user, conn);
		List<BankFrikomListDto> list = bankFrikomListDao.findForCondition(date);
		//DAO
		CmCompanyDao dao = new CmCompanyDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		// DTO
		CmCompanyDto dto;
		dto = dao.findAll();
		
		if (StringUtil.isNotNull(cfg.getProperty(CommonConst.PPT_KINTAI_USE_ODF))) {
			//ODS
			makeBankSpreadSheet(list, vo, date, dto);
		} else {
			//XLS
			makeAttendanceBook(list, vo, date, dto);
		}
		
	}
	
	/**
	 * sUꗗ\(Е)o͏sB<br><br>
	 * @throws Exception 
	 */
	private void bankCompany() throws Exception {
		//RlNV擾
		getConnection();
		// VO擾
		PaymentReportVo vo = (PaymentReportVo)getVo();
		//p[^擾
		vo.setParams(request);
		//Ώ۔N擾
		Date date = vo.getDate(String.valueOf(vo.getPltOutYear()), String.valueOf(vo.getPltOutMonth()), String
			.valueOf(PayrollConst.TIME_DEFAULT_DAY));
		//f[^̎擾
		//Uf[^擾
		BankFrikomListDao bankFrikomListDao = new BankFrikomListDao();
		bankFrikomListDao.initDao(cfg, cmd, aspUser, user, conn);
		List<BankFrikomListDto> list = bankFrikomListDao.findForCondition(date);
		//DAO
		CmCompanyDao dao = new CmCompanyDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		// DTO
		CmCompanyDto dto;
		dto = dao.findAll();
		if (StringUtil.isNotNull(cfg.getProperty(CommonConst.PPT_KINTAI_USE_ODF))) {
			//ODS
			makeCoBankSpreadSheet(list, vo, date, dto);
		} else {
			//XLS
			makeCompanyBankBook(list, vo, date, dto);
		}
		
	}
	
	/**
	 * sUꗗ\쐬(lʋ^)XLS
	 * @param dtolist 
	 * @param vo ΏVO
	 * @param date 
	 * @param companyDto 
	 * @throws Exception 
	 */
	private void makeAttendanceBook(List<BankFrikomListDto> dtolist, PaymentReportVo vo, Date date,
			CmCompanyDto companyDto) throws Exception {
		int printDataRow = 7;
		int sumAmount = 0;
		int subTotalCnt = 0;
		int totalAmount = 0;
		int totalCnt = 0;
		String coBankCdNew = "";
		String coBankCdOld = "";
		//[쐬
		PoiUtility poi = new PoiUtility();
		poi.crtNewDocR(0, cfg.getProperty(MospConst.PPT_APP_DOCBASE) + PayrollConst.TEMPLATE_BANK_FRKOM_LIST);
		//tHgݒׂ̈̏
		poi.createCellStyleAndFont();
		setStyle(poi, true, false);
		//wb_[ݒ
		poi.prtItem(1, 0, jpnYM(date, vo) + PayrollConst.NAM_PAYMENT_TARGET);
		poi.prtItem(3, 1, companyDto.getCompanyName());
		Date sysDate = getSystemDate();
		poi.prtItem(3, 13, jpnYMD(sysDate, vo));
		for (int i = 0; i < dtolist.size(); i++) {
			
			BankFrikomListDto dto = dtolist.get(i);
			coBankCdNew = dto.getCoBankCode();
			if (!coBankCdNew.equals(coBankCdOld)) {
				if (i != 0) {
					printDataRow++;
					poi.prtItem(printDataRow, 3, PayrollConst.BRACKET_LEFT + PayrollConst.NMA_SUBTOTAL + "  "
							+ subTotalCnt + PayrollConst.NMA_SHARE + PayrollConst.BRACKET_RIGHT);
					setStyle(poi, false, true);
					totalCnt = totalCnt + subTotalCnt;
					printDataRow++;
				}
				
				poi.prtItem(printDataRow, 5, dto.getCoBankKana());
				setStyle(poi, false, true);
				
				poi.prtItem(printDataRow, 7, dto.getCoBranchKana());
				setStyle(poi, false, true);
				
				printDataRow++;
				
				poi.prtItem(printDataRow, 3, PayrollConst.BRACKET_LEFT + PayrollConst.NAM_CO_BANK_CODE
						+ dto.getCoBankCode() + PayrollConst.BRACKET_RIGHT);
				setStyle(poi, false, true);
				
				poi
					.prtItem(printDataRow, 4, dto.getBankCode() + PayrollConst.FILE_NAME_SEPARATOR
							+ dto.getBranchCode());
				setStyle(poi, false, true);
				
				poi.prtItem(printDataRow, 5, dto.getCoBankName());
				setStyle(poi, false, true);
				
				poi.prtItem(printDataRow, 7, dto.getCoBranchName());
				setStyle(poi, false, true);
				
				poi.prtItem(printDataRow, 9, dto.getCoAccountName().replace(PayrollConst.NMA_YOKIN, ""));
				setStyle(poi, false, true);
				
				poi.prtItem(printDataRow, 11, dto.getCoAccountNo());
				setStyle(poi, false, true);
				
				printDataRow++;
				subTotalCnt = 0;
			}
			
			poi.prtItem(printDataRow, 1, dto.getKCode());
			setStyle(poi, false, true);
			
			poi.prtItem(printDataRow, 3, dto.getHolderKana());
			setStyle(poi, false, true);
			
			poi.prtItem(printDataRow, 5, dto.getPaidBankKana());
			setStyle(poi, false, true);
			
			poi.prtItem(printDataRow, 7, dto.getPaidBranchKana());
			setStyle(poi, false, true);
			
			printDataRow++;
			poi.createCellStyle();
			poi.prtItem(printDataRow, 3, dto.getHolderName());
			setStyle(poi, false, true);
			
			poi.prtItem(printDataRow, 4, dto.getPaidBankCode() + PayrollConst.FILE_NAME_SEPARATOR
					+ dto.getPaidBranchCode());
			setStyle(poi, false, true);
			
			poi.prtItem(printDataRow, 5, dto.getPaidBankName());
			setStyle(poi, false, true);
			
			poi.prtItem(printDataRow, 7, dto.getPaidBranchName());
			setStyle(poi, false, true);
			
			poi.prtItem(printDataRow, 9, dto.getAccountName().replace(PayrollConst.NMA_YOKIN, ""));
			setStyle(poi, false, true);
			
			poi.prtItem(printDataRow, 11, dto.getAccountNo());
			setStyle(poi, false, true);
			
			printDataRow++;
			subTotalCnt++;
			coBankCdOld = coBankCdNew;
			
		}
		if (dtolist.size() != 0) {
			totalCnt = totalCnt + subTotalCnt;
			printDataRow++;
			poi.prtItem(printDataRow, 3, PayrollConst.BRACKET_LEFT + PayrollConst.NMA_SUBTOTAL + "  " + subTotalCnt
					+ PayrollConst.NMA_SHARE + PayrollConst.BRACKET_RIGHT);
			setStyle(poi, false, true);
			printDataRow = printDataRow + 2;
			poi.prtItem(printDataRow, 3, PayrollConst.BRACKET_LEFT + PayrollConst.NAM_COMMON_SUM + "  " + totalCnt
					+ PayrollConst.NMA_SHARE + PayrollConst.BRACKET_RIGHT);
			setStyle(poi, false, true);
			
		}
		
		//z̐ݒ
		setStyle(poi, true, false);
		printDataRow = 10;
		for (int i = 0; i < dtolist.size(); i++) {
			BankFrikomListDto dto = dtolist.get(i);
			coBankCdNew = dto.getCoBankCode();
			if (!coBankCdNew.equals(coBankCdOld)) {
				if (i != 0) {
					//s̍vz
					poi.prtBorderTop(printDataRow, 13);
					poi.prtItem(printDataRow, 13, insertComma(String.valueOf(sumAmount)));
					setStyle(poi, false, false);
					printDataRow = printDataRow + 4;
					setStyle(poi, true, false);
					totalAmount = totalAmount + sumAmount;
					sumAmount = 0;
				}
			}
			poi.prtItem(printDataRow, 13, insertComma(String.valueOf(dto.getBankPayAmount())));
			setStyle(poi, false, false);
			sumAmount = sumAmount + dto.getBankPayAmount();
			printDataRow = printDataRow + 2;
			coBankCdOld = coBankCdNew;
			
		}
		if (dtolist.size() != 0) {
			poi.prtBorderTop(printDataRow, 13);
			poi.prtItem(printDataRow, 13, insertComma(String.valueOf(sumAmount)));
			setStyle(poi, false, false);
			totalAmount = totalAmount + sumAmount;
			//v
			printDataRow = printDataRow + 2;
			poi.prtBorderTop(printDataRow, 13);
			poi.prtItem(printDataRow, 13, insertComma(String.valueOf(totalAmount)));
			setStyle(poi, false, false);
		}
		
		//XLS
		String fileName = vo.getPltOutYear() + PayrollConst.FILE_NAME_SEPARATOR + vo.getPltOutMonth()
				+ PayrollConst.FILE_NAME_SEPARATOR + PayrollConst.FILE_BANK_FRKOM_LIST;
		request.setAttribute(MospConst.ATT_FILE_NAME, fileName);
		request.setAttribute(MospConst.ATT_FILE_OBJECT, poi.getWorkbook());
	}
	
	/**
	 * sUꗗ\쐬(lʋ^)ODS
	 * @param dtolist 
	 * @param vo ΏVO
	 * @param date 
	 * @param companyDto 
	 * @throws Exception 
	 */
	private void makeBankSpreadSheet(List<BankFrikomListDto> dtolist, PaymentReportVo vo, Date date,
			CmCompanyDto companyDto) throws Exception {
		int printDataRow = 7;
		int sumAmount = 0;
		int subTotalCnt = 0;
		int totalAmount = 0;
		int totalCnt = 0;
		String coBankCdNew = "";
		String coBankCdOld = "";
		
		//ev[gt@C
		StringBuffer sb = new StringBuffer();
		sb.append(cfg.getProperty(MospConst.PPT_APP_DOCBASE));
		sb.append(PayrollConst.TEMPLATE_BANK_FRKOM_LIST_ODS);
		//[쐬
		SpreadSheet ss = SpreadSheet.createFromFile(new File(sb.toString()));
		//V[g
		Sheet sheet = ss.getSheet(0);
		//wb_[ݒ
		sheet.getCellAt(0, 1).setValue(jpnYM(date, vo) + PayrollConst.NAM_PAYMENT_TARGET);
		sheet.getCellAt(1, 3).setValue(companyDto.getCompanyName());
		Date sysDate = getSystemDate();
		sheet.getCellAt(12, 3).setValue(jpnYMD(sysDate, vo));
		//rX^CR[h̎擾
		String styleCodeBorderBotom = sheet.getCellAt(4, 3).getStyleName();
		//׃f[^̐ݒ
		sheet.insertDuplicatedRows(sheet.getRowCount() - 1, 6000);
		for (int i = 0; i < dtolist.size(); i++) {
			BankFrikomListDto dto = dtolist.get(i);
			//zȊO̕ʂ̈
			coBankCdNew = dto.getCoBankCode();
			if (!coBankCdNew.equals(coBankCdOld)) {
				//ЋsR[hς
				if (i != 0) {
					//vڂ\
					printDataRow = printDataRow + 2;
					sheet.getCellAt(3, printDataRow).setValue(
							PayrollConst.BRACKET_LEFT + PayrollConst.NMA_SUBTOTAL + "  " + subTotalCnt
									+ PayrollConst.NMA_SHARE + PayrollConst.BRACKET_RIGHT);
					totalCnt = totalCnt + subTotalCnt;
					printDataRow++;
				}
				//VЋs󎚂
				sheet.getCellAt(5, printDataRow).setValue(dto.getCoBankKana());
				sheet.getCellAt(7, printDataRow).setValue(dto.getCoBranchKana());
				printDataRow++;
				sheet.getCellAt(3, printDataRow).setValue(
						PayrollConst.BRACKET_LEFT + PayrollConst.NAM_CO_BANK_CODE + dto.getCoBankCode()
								+ PayrollConst.BRACKET_RIGHT);
				sheet.getCellAt(4, printDataRow).setValue(
						dto.getBankCode() + PayrollConst.FILE_NAME_SEPARATOR + dto.getBranchCode());
				sheet.getCellAt(5, printDataRow).setValue(dto.getCoBankName());
				sheet.getCellAt(7, printDataRow).setValue(dto.getCoBranchName());
				sheet.getCellAt(9, printDataRow).setValue(dto.getCoAccountName().replace(PayrollConst.NMA_YOKIN, ""));
				sheet.getCellAt(11, printDataRow).setValue(dto.getCoAccountNo());
				printDataRow++;
				subTotalCnt = 0;
			}
			//ו̈
			sheet.getCellAt(1, printDataRow).setValue(dto.getKCode());
			sheet.getCellAt(3, printDataRow).setValue(dto.getHolderKana());
			sheet.getCellAt(5, printDataRow).setValue(dto.getPaidBankKana());
			sheet.getCellAt(7, printDataRow).setValue(dto.getPaidBranchKana());
			printDataRow++;
			sheet.getCellAt(3, printDataRow).setValue(dto.getHolderName());
			sheet.getCellAt(4, printDataRow).setValue(
					dto.getPaidBankCode() + PayrollConst.FILE_NAME_SEPARATOR + dto.getPaidBranchCode());
			sheet.getCellAt(5, printDataRow).setValue(dto.getPaidBankName());
			sheet.getCellAt(7, printDataRow).setValue(dto.getPaidBranchName());
			sheet.getCellAt(9, printDataRow).setValue(dto.getAccountName().replace(PayrollConst.NMA_YOKIN, ""));
			sheet.getCellAt(11, printDataRow).setValue(dto.getAccountNo());
			printDataRow++;
			subTotalCnt++;
			coBankCdOld = coBankCdNew;
		}
		
		if (dtolist.size() != 0) {
			
			//Ō̃f[^
			totalCnt = totalCnt + subTotalCnt;
			printDataRow = printDataRow + 2;
			sheet.getCellAt(3, printDataRow).setValue(
					PayrollConst.BRACKET_LEFT + PayrollConst.NMA_SUBTOTAL + "  " + subTotalCnt + PayrollConst.NMA_SHARE
							+ PayrollConst.BRACKET_RIGHT);
			printDataRow = printDataRow + 2;
			sheet.getCellAt(3, printDataRow).setValue(
					PayrollConst.BRACKET_LEFT + PayrollConst.NAM_COMMON_SUM + "  " + totalCnt + PayrollConst.NMA_SHARE
							+ PayrollConst.BRACKET_RIGHT);
		}
		
		//z̐ݒ	
		printDataRow = 10;
		
		for (int i = 0; i < dtolist.size(); i++) {
			BankFrikomListDto dto = dtolist.get(i);
			coBankCdNew = dto.getCoBankCode();
			if (!coBankCdNew.equals(coBankCdOld)) {
				//ЋsR[hς
				if (i != 0) {
					//s̍vz
					sheet.getCellAt(13, printDataRow).setStyleName(styleCodeBorderBotom);
					printDataRow++;
					sheet.getCellAt(13, printDataRow).setValue(insertComma(String.valueOf(sumAmount)));
					printDataRow = printDataRow + 4;
					totalAmount = totalAmount + sumAmount;
					sumAmount = 0;
				}
			}
			sheet.getCellAt(13, printDataRow).setValue(insertComma(String.valueOf(dto.getBankPayAmount())));
			sumAmount = sumAmount + dto.getBankPayAmount();
			printDataRow = printDataRow + 2;
			coBankCdOld = coBankCdNew;
		}
		
		if (dtolist.size() != 0) {
			//vlrX^C̐ݒ
			sheet.getCellAt(13, printDataRow).setStyleName(styleCodeBorderBotom);
			printDataRow++;
			sheet.getCellAt(13, printDataRow).setValue(insertComma(String.valueOf(sumAmount)));
			totalAmount = totalAmount + sumAmount;
			//v
			printDataRow++;
			sheet.getCellAt(13, printDataRow).setStyleName(styleCodeBorderBotom);
			printDataRow++;
			sheet.getCellAt(13, printDataRow).setValue(insertComma(String.valueOf(totalAmount)));
		}
		
		String fileName = vo.getPltOutYear() + PayrollConst.FILE_NAME_SEPARATOR + vo.getPltOutMonth()
				+ PayrollConst.FILE_NAME_SEPARATOR + PayrollConst.FILE_BANK_FRKOM_LIST_ODS;
		request.setAttribute(MospConst.ATT_FILE_NAME, fileName);
		request.setAttribute(MospConst.ATT_FILE_OBJECT, ss);
	}
	
	/**
	 * sUꗗ\(Ћs)쐬(^)XLS
	 * @param vo ΏVO
	 * @throws Exception 
	 */
	private void makeCompanyBankBook(List<BankFrikomListDto> dtolist, PaymentReportVo vo, Date date,
			CmCompanyDto companyDto) throws Exception {
		int printDataRow = 7;
		int sumAmount = 0;
		int totalAmount = 0;
		int subTotalCnt = 0;
		int totalCnt = 0;
		String coBankCdNew = "";
		String coBankCdOld = "";
		//[쐬
		PoiUtility poi = new PoiUtility();
		poi.crtNewDocR(0, cfg.getProperty(MospConst.PPT_APP_DOCBASE) + PayrollConst.TEMPLATE_COMPANY_BANK_FRKOM_LIST);
		//tHgݒׂ̈̏
		poi.createCellStyleAndFont();
		setStyle(poi, true, false);
		//wb_[ݒ
		poi.prtItem(1, 0, jpnYM(date, vo) + PayrollConst.NAM_PAYMENT_TARGET);
		poi.prtItem(3, 1, companyDto.getCompanyName());
		Date sysDate = getSystemDate();
		poi.prtItem(3, 13, jpnYMD(sysDate, vo));
		for (int i = 0; i < dtolist.size(); i++) {
			BankFrikomListDto dto = dtolist.get(i);
			coBankCdNew = dto.getCoBankCode();
			if (!coBankCdNew.equals(coBankCdOld)) {
				if (i != 0) {
					printDataRow++;
					poi.prtItem(printDataRow, 3, PayrollConst.BRACKET_LEFT + PayrollConst.NMA_SUBTOTAL + "  "
							+ subTotalCnt + PayrollConst.NMA_SHARE + PayrollConst.BRACKET_RIGHT);
					setStyle(poi, false, true);
					printDataRow++;
					//v̌vZ()
					totalCnt = totalCnt + subTotalCnt;
				}
				poi.prtItem(printDataRow, 5, dto.getCoBankKana());
				setStyle(poi, false, true);
				
				poi.prtItem(printDataRow, 7, dto.getCoBranchKana());
				setStyle(poi, false, true);
				
				printDataRow++;
				
				poi.prtItem(printDataRow, 3, PayrollConst.BRACKET_LEFT + PayrollConst.NAM_CO_BANK_CODE
						+ dto.getCoBankCode() + PayrollConst.BRACKET_RIGHT);
				setStyle(poi, false, true);
				
				poi
					.prtItem(printDataRow, 4, dto.getBankCode() + PayrollConst.FILE_NAME_SEPARATOR
							+ dto.getBranchCode());
				setStyle(poi, false, true);
				
				poi.prtItem(printDataRow, 5, dto.getCoBankName());
				setStyle(poi, false, true);
				
				poi.prtItem(printDataRow, 7, dto.getCoBranchName());
				setStyle(poi, false, true);
				
				poi.prtItem(printDataRow, 9, dto.getCoAccountName().replace(PayrollConst.NMA_YOKIN, ""));
				setStyle(poi, false, true);
				
				poi.prtItem(printDataRow, 11, dto.getCoAccountNo());
				setStyle(poi, false, true);
				
				printDataRow++;
				subTotalCnt = 0;
			}
			subTotalCnt++;
			coBankCdOld = coBankCdNew;
			
		}
		if (dtolist.size() != 0) {
			printDataRow++;
			poi.prtItem(printDataRow, 3, PayrollConst.BRACKET_LEFT + PayrollConst.NMA_SUBTOTAL + "  " + subTotalCnt
					+ PayrollConst.NMA_SHARE + PayrollConst.BRACKET_RIGHT);
			setStyle(poi, false, true);
			
			printDataRow++;
			
			//v̌vZ()
			totalCnt = totalCnt + subTotalCnt;
			
			//ŌɑvvgB
			printDataRow++;
			
			poi.prtItem(printDataRow, 3, PayrollConst.BRACKET_LEFT + PayrollConst.NAM_COMMON_SUM + "  " + totalCnt
					+ PayrollConst.NMA_SHARE + PayrollConst.BRACKET_RIGHT);
			setStyle(poi, false, true);
			
		}
		//z̐ݒ
		setStyle(poi, true, false);
		printDataRow = 10;
		for (int i = 0; i < dtolist.size(); i++) {
			BankFrikomListDto dto = dtolist.get(i);
			coBankCdNew = dto.getCoBankCode();
			if (!coBankCdNew.equals(coBankCdOld)) {
				if (i != 0) {
					poi.prtItem(printDataRow, 13, insertComma(String.valueOf(sumAmount)));
					setStyle(poi, false, false);
					printDataRow = printDataRow + 4;
					//v̌vZ(z)
					totalAmount = totalAmount + sumAmount;
				}
				sumAmount = 0;
				coBankCdOld = coBankCdNew;
			}
			
			//v̌vZ
			sumAmount = sumAmount + dto.getBankPayAmount();
			
		}
		if (dtolist.size() != 0) {
			poi.prtItem(printDataRow, 13, insertComma(String.valueOf(sumAmount)));
			setStyle(poi, false, false);
			//v̌vZ(z)
			totalAmount = totalAmount + sumAmount;
			//ŌɑvvgB
			printDataRow = printDataRow + 2;
			poi.prtBorderTop(printDataRow, 13);
			poi.prtItem(printDataRow, 13, insertComma(String.valueOf(totalAmount)));
			setStyle(poi, false, false);
			
		}
		
		//XLS
		String fileName = vo.getPltOutYear() + PayrollConst.FILE_NAME_SEPARATOR + vo.getPltOutMonth()
				+ PayrollConst.FILE_NAME_SEPARATOR + PayrollConst.FILE_COMPANY_BANK_FRKOM_LIST;
		request.setAttribute(MospConst.ATT_FILE_NAME, fileName);
		request.setAttribute(MospConst.ATT_FILE_OBJECT, poi.getWorkbook());
	}
	
	/**
	 * sUꗗ\쐬(Еʋ^)ODS
	 * @param dtolist 
	 * @param vo ΏVO
	 * @param date 
	 * @param companyDto 
	 * @throws Exception 
	 */
	private void makeCoBankSpreadSheet(List<BankFrikomListDto> dtolist, PaymentReportVo vo, Date date,
			CmCompanyDto companyDto) throws Exception {
		int printDataRow = 7;
		int sumAmount = 0;
		int subTotalCnt = 0;
		int totalAmount = 0;
		int totalCnt = 0;
		String coBankCdNew = "";
		String coBankCdOld = "";
		
		//ev[gt@C
		StringBuffer sb = new StringBuffer();
		sb.append(cfg.getProperty(MospConst.PPT_APP_DOCBASE));
		sb.append(PayrollConst.TEMPLATE_COMPANY_BANK_FRKOM_LIST_ODS);
		//[쐬
		SpreadSheet ss = SpreadSheet.createFromFile(new File(sb.toString()));
		//V[g
		Sheet sheet = ss.getSheet(0);
		//wb_[ݒ
		sheet.getCellAt(0, 1).setValue(jpnYM(date, vo) + PayrollConst.NAM_PAYMENT_TARGET);
		sheet.getCellAt(1, 3).setValue(companyDto.getCompanyName());
		Date sysDate = getSystemDate();
		sheet.getCellAt(12, 3).setValue(jpnYMD(sysDate, vo));
		//rX^CR[h̎擾
		String styleCodeBorderBotom = sheet.getCellAt(4, 3).getStyleName();
		//׃f[^̐ݒ
		sheet.insertDuplicatedRows(sheet.getRowCount() - 1, 6000);
		for (int i = 0; i < dtolist.size(); i++) {
			BankFrikomListDto dto = dtolist.get(i);
			//zȊO̕ʂ̈
			coBankCdNew = dto.getCoBankCode();
			if (!coBankCdNew.equals(coBankCdOld)) {
				//ЋsR[hς
				if (i != 0) {
					//vڂ\
					printDataRow = printDataRow + 2;
					sheet.getCellAt(3, printDataRow).setValue(
							PayrollConst.BRACKET_LEFT + PayrollConst.NMA_SUBTOTAL + "  " + subTotalCnt
									+ PayrollConst.NMA_SHARE + PayrollConst.BRACKET_RIGHT);
					totalCnt = totalCnt + subTotalCnt;
					printDataRow++;
				}
				//VЋs󎚂
				sheet.getCellAt(5, printDataRow).setValue(dto.getCoBankKana());
				sheet.getCellAt(7, printDataRow).setValue(dto.getCoBranchKana());
				printDataRow++;
				sheet.getCellAt(3, printDataRow).setValue(
						PayrollConst.BRACKET_LEFT + PayrollConst.NAM_CO_BANK_CODE + dto.getCoBankCode()
								+ PayrollConst.BRACKET_RIGHT);
				sheet.getCellAt(4, printDataRow).setValue(
						dto.getBankCode() + PayrollConst.FILE_NAME_SEPARATOR + dto.getBranchCode());
				sheet.getCellAt(5, printDataRow).setValue(dto.getCoBankName());
				sheet.getCellAt(7, printDataRow).setValue(dto.getCoBranchName());
				sheet.getCellAt(9, printDataRow).setValue(dto.getCoAccountName().replace(PayrollConst.NMA_YOKIN, ""));
				sheet.getCellAt(11, printDataRow).setValue(dto.getCoAccountNo());
				printDataRow++;
				subTotalCnt = 0;
			}
			//וo͕ҏW
			subTotalCnt++;
			coBankCdOld = coBankCdNew;
		}
		if (dtolist.size() != 0) {
			//Ō̃f[^
			totalCnt = totalCnt + subTotalCnt;
			printDataRow = printDataRow + 2;
			sheet.getCellAt(3, printDataRow).setValue(
					PayrollConst.BRACKET_LEFT + PayrollConst.NMA_SUBTOTAL + "  " + subTotalCnt + PayrollConst.NMA_SHARE
							+ PayrollConst.BRACKET_RIGHT);
			printDataRow = printDataRow + 2;
			sheet.getCellAt(3, printDataRow).setValue(
					PayrollConst.BRACKET_LEFT + PayrollConst.NAM_COMMON_SUM + "  " + totalCnt + PayrollConst.NMA_SHARE
							+ PayrollConst.BRACKET_RIGHT);
		}
		
		//z̐ݒ	
		printDataRow = 10;
		for (int i = 0; i < dtolist.size(); i++) {
			BankFrikomListDto dto = dtolist.get(i);
			coBankCdNew = dto.getCoBankCode();
			if (!coBankCdNew.equals(coBankCdOld)) {
				//ЋsR[hς
				if (i != 0) {
					//s̍vz
					sheet.getCellAt(13, printDataRow).setStyleName(styleCodeBorderBotom);
					printDataRow++;
					sheet.getCellAt(13, printDataRow).setValue(insertComma(String.valueOf(sumAmount)));
					printDataRow = printDataRow + 4;
					totalAmount = totalAmount + sumAmount;
				}
				sumAmount = 0;
				coBankCdOld = coBankCdNew;
			}
			//v̌vZ
			sumAmount = sumAmount + dto.getBankPayAmount();
		}
		if (dtolist.size() != 0) {
			//vlrX^C̐ݒ
			sheet.getCellAt(13, printDataRow).setStyleName(styleCodeBorderBotom);
			printDataRow++;
			sheet.getCellAt(13, printDataRow).setValue(insertComma(String.valueOf(sumAmount)));
			totalAmount = totalAmount + sumAmount;
			//v
			printDataRow++;
			sheet.getCellAt(13, printDataRow).setStyleName(styleCodeBorderBotom);
			printDataRow++;
			sheet.getCellAt(13, printDataRow).setValue(insertComma(String.valueOf(totalAmount)));
		}
		
		String fileName = vo.getPltOutYear() + PayrollConst.FILE_NAME_SEPARATOR + vo.getPltOutMonth()
				+ PayrollConst.FILE_NAME_SEPARATOR + PayrollConst.FILE_COMPANY_BANK_FRKOM_LIST_ODS;
		request.setAttribute(MospConst.ATT_FILE_NAME, fileName);
		request.setAttribute(MospConst.ATT_FILE_OBJECT, ss);
	}
	
	/**
	 * xꗗ\쐬(^)XLS
	 * @param dtolist 
	 * @param vo ΏVO
	 * @param date 
	 * @param companyDto 
	 * @throws Exception 
	 */
	private void makeCashKindBook(List<CashKindListDto> dtolist, PaymentReportVo vo, Date date, CmCompanyDto companyDto)
			throws Exception {
		int printDataRow = 7;
		int[] cashKind;
		int totalAmount = 0;
		int totalCnt = 0;
		int totalCollect = 0;
		int totalCollectAmount = 0;
		int totalMan = 0;
		int total5Sen = 0;
		int totalSen = 0;
		int total5Hnd = 0;
		int totalHnd = 0;
		int total5Jyu = 0;
		int totalJyu = 0;
		int total5En = 0;
		int total1En = 0;
		
		//[쐬
		PoiUtility poi = new PoiUtility();
		poi.crtNewDocR(0, cfg.getProperty(MospConst.PPT_APP_DOCBASE) + PayrollConst.TEMPLATE_CASH_KIND_LIST);
		//tHgݒׂ̈̏
		poi.createCellStyleAndFont();
		setStyle(poi, true, false);
		//wb_[ݒ
		poi.prtItem(1, 0, jpnYM(date, vo) + PayrollConst.NAM_PAYMENT_TARGET);
		poi.prtItem(3, 1, companyDto.getCompanyName());
		Date sysDate = getSystemDate();
		poi.prtItem(3, 22, jpnYMD(sysDate, vo));
		for (int i = 0; i < dtolist.size(); i++) {
			
			CashKindListDto dto = dtolist.get(i);
			//EЈԍ̈
			poi.prtItem(printDataRow, 1, dto.getKCode());
			setStyle(poi, false, true);
			poi.prtItem(printDataRow, 3, dto.getKName());
			setStyle(poi, false, true);
			if (dto.getCashAmount() > 0) {
				//xzvX
				totalCnt++;
			} else {
				//xz}CiX
				totalCollect++;
			}
			printDataRow++;
			
		}
		if (dtolist.size() != 0) {
			
			printDataRow++;
			poi.prtItem(printDataRow, 3, PayrollConst.BRACKET_LEFT + PayrollConst.NAM_COMMON_SUM + "  " + totalCnt
					+ PayrollConst.NAM_COMMON_NAME + PayrollConst.BRACKET_RIGHT);
			setStyle(poi, false, true);
			if (totalCollect != 0) {
				printDataRow++;
				poi.prtItem(printDataRow, 3, PayrollConst.BRACKET_LEFT + PayrollConst.NMA_COMMON_COLLECT + "  "
						+ totalCollect + PayrollConst.NAM_COMMON_NAME + PayrollConst.BRACKET_RIGHT);
				setStyle(poi, false, true);
			}
			
		}
		
		setStyle(poi, true, false);
		printDataRow = 7;
		for (int i = 0; i < dtolist.size(); i++) {
			CashKindListDto dto = dtolist.get(i);
			//픻
			if (dto.getCashAmount() > 0) {
				cashKind = cashKind(dto.getCashAmount());
				
				//햇ݒ(ꖜ~)
				poi.prtItem(printDataRow, 4, cashKind[0]);
				setStyle(poi, false, false);
				//햇vl(ꖜ~)
				totalMan = totalMan + cashKind[0];
				
				//햇ݒ(ܐ~)
				poi.prtItem(printDataRow, 6, cashKind[1]);
				setStyle(poi, false, false);
				//햇vl(ܐ~)
				total5Sen = total5Sen + cashKind[1];
				
				//햇ݒ(~)
				poi.prtItem(printDataRow, 8, cashKind[2]);
				setStyle(poi, false, false);
				//햇vl(~)
				totalSen = totalSen + cashKind[2];
				
				//햇ݒ(ܕS~)
				poi.prtItem(printDataRow, 10, cashKind[3]);
				setStyle(poi, false, false);
				//햇vl(ܕS~)
				total5Hnd = total5Hnd + cashKind[3];
				
				//햇ݒ(S~)
				poi.prtItem(printDataRow, 12, cashKind[4]);
				setStyle(poi, false, false);
				//햇vl(S~)
				totalHnd = totalHnd + cashKind[4];
				
				//햇ݒ(܏\~)
				poi.prtItem(printDataRow, 14, cashKind[5]);
				setStyle(poi, false, false);
				//햇vl(܏\~)
				total5Jyu = total5Jyu + cashKind[5];
				
				//햇ݒ(\~)
				poi.prtItem(printDataRow, 16, cashKind[6]);
				setStyle(poi, false, false);
				//햇vl(\~)
				totalJyu = totalJyu + cashKind[6];
				
				//햇ݒ(܉~)
				poi.prtItem(printDataRow, 18, cashKind[7]);
				setStyle(poi, false, false);
				//햇vl(܉~)
				total5En = total5En + cashKind[7];
				
				//햇ݒ(~)
				poi.prtItem(printDataRow, 20, cashKind[8]);
				setStyle(poi, false, false);
				//햇vl(~)
				total1En = total1En + cashKind[8];
				//zvZ
				totalAmount = totalAmount + dto.getCashAmount();
			} else {
				//z}CiX̍Z
				totalCollectAmount = totalCollectAmount + dto.getCashAmount();
			}
			//햇ݒ(z)
			poi.prtItem(printDataRow, 22, insertComma(String.valueOf(dto.getCashAmount())));
			setStyle(poi, false, false);
			printDataRow++;
			
		}
		if (dtolist.size() != 0) {
			printDataRow++;
			poi.prtBorderTop(printDataRow, 4);
			poi.prtBorderTop(printDataRow, 5);
			poi.prtBorderTop(printDataRow, 6);
			poi.prtBorderTop(printDataRow, 7);
			poi.prtBorderTop(printDataRow, 8);
			poi.prtBorderTop(printDataRow, 9);
			poi.prtBorderTop(printDataRow, 10);
			poi.prtBorderTop(printDataRow, 11);
			poi.prtBorderTop(printDataRow, 12);
			poi.prtBorderTop(printDataRow, 13);
			poi.prtBorderTop(printDataRow, 14);
			poi.prtBorderTop(printDataRow, 15);
			poi.prtBorderTop(printDataRow, 16);
			poi.prtBorderTop(printDataRow, 17);
			poi.prtBorderTop(printDataRow, 18);
			poi.prtBorderTop(printDataRow, 19);
			poi.prtBorderTop(printDataRow, 20);
			poi.prtBorderTop(printDataRow, 21);
			poi.prtBorderTop(printDataRow, 22);
			poi.prtBorderTop(printDataRow, 23);
			
			//퍇v(ꖜ~)
			poi.prtItem(printDataRow, 4, totalMan);
			setStyle(poi, false, false);
			//퍇v(ܐ~)
			poi.prtItem(printDataRow, 6, total5Sen);
			setStyle(poi, false, false);
			//퍇v(~)
			poi.prtItem(printDataRow, 8, totalSen);
			setStyle(poi, false, false);
			//퍇v(ܕS~)
			poi.prtItem(printDataRow, 10, total5Hnd);
			setStyle(poi, false, false);
			//퍇v(S~)
			poi.prtItem(printDataRow, 12, totalHnd);
			setStyle(poi, false, false);
			//퍇v(܏\~)
			poi.prtItem(printDataRow, 14, total5Jyu);
			setStyle(poi, false, false);
			//퍇v(\~)
			poi.prtItem(printDataRow, 16, totalJyu);
			setStyle(poi, false, false);
			//퍇v(܉~)
			poi.prtItem(printDataRow, 18, total5En);
			setStyle(poi, false, false);
			//퍇v(~)
			poi.prtItem(printDataRow, 20, total1En);
			setStyle(poi, false, false);
			//zv
			poi.prtItem(printDataRow, 22, insertComma(String.valueOf(totalAmount)));
			setStyle(poi, false, false);
			if (totalCollect != 0) {
				printDataRow++;
				poi.prtBorderTop(printDataRow, 4);
				poi.prtBorderTop(printDataRow, 5);
				poi.prtBorderTop(printDataRow, 6);
				poi.prtBorderTop(printDataRow, 7);
				poi.prtBorderTop(printDataRow, 8);
				poi.prtBorderTop(printDataRow, 9);
				poi.prtBorderTop(printDataRow, 10);
				poi.prtBorderTop(printDataRow, 11);
				poi.prtBorderTop(printDataRow, 12);
				poi.prtBorderTop(printDataRow, 13);
				poi.prtBorderTop(printDataRow, 14);
				poi.prtBorderTop(printDataRow, 15);
				poi.prtBorderTop(printDataRow, 16);
				poi.prtBorderTop(printDataRow, 17);
				poi.prtBorderTop(printDataRow, 18);
				poi.prtBorderTop(printDataRow, 19);
				poi.prtBorderTop(printDataRow, 20);
				poi.prtBorderTop(printDataRow, 21);
				poi.prtBorderTop(printDataRow, 22);
				poi.prtBorderTop(printDataRow, 23);
				//zv(}CiXvXɕϊ)
				totalCollectAmount = totalCollectAmount * -1;
				poi.prtItem(printDataRow, 22, insertComma(String.valueOf(totalCollectAmount)));
				setStyle(poi, false, false);
			}
		}
		
		//XLS
		String fileName = vo.getPltOutYear() + PayrollConst.FILE_NAME_SEPARATOR + vo.getPltOutMonth()
				+ PayrollConst.FILE_NAME_SEPARATOR + PayrollConst.FILE_CASH_KIND_LIST;
		request.setAttribute(MospConst.ATT_FILE_NAME, fileName);
		request.setAttribute(MospConst.ATT_FILE_OBJECT, poi.getWorkbook());
		
	}
	
	/**
	 * xꗗ\쐬(^)ODS
	 * @param dtolist 
	 * @param vo ΏVO
	 * @param date 
	 * @param companyDto 
	 * @throws Exception 
	 */
	private void makeSpreadSheet(List<CashKindListDto> dtolist, PaymentReportVo vo, Date date, CmCompanyDto companyDto)
			throws Exception {
		int printDataRow = 7;
		int totalCnt = 0;
		int totalCollect = 0;
		int[] cashKind;
		int totalAmount = 0;
		int totalCollectAmount = 0;
		int totalMan = 0;
		int total5Sen = 0;
		int totalSen = 0;
		int total5Hnd = 0;
		int totalHnd = 0;
		int total5Jyu = 0;
		int totalJyu = 0;
		int total5En = 0;
		int total1En = 0;
		
		//ev[gt@C
		StringBuffer sb = new StringBuffer();
		sb.append(cfg.getProperty(MospConst.PPT_APP_DOCBASE));
		sb.append(PayrollConst.TEMPLATE_CASH_KIND_LIST_ODS);
		//[쐬
		SpreadSheet ss = SpreadSheet.createFromFile(new File(sb.toString()));
		//V[g
		Sheet sheet = ss.getSheet(0);
		//wb_[ݒ
		sheet.getCellAt(0, 1).setValue(jpnYM(date, vo) + PayrollConst.NAM_PAYMENT_TARGET);
		sheet.getCellAt(1, 3).setValue(companyDto.getCompanyName());
		Date sysDate = getSystemDate();
		sheet.getCellAt(22, 3).setValue(jpnYMD(sysDate, vo));
		//׃f[^̐ݒ
		sheet.insertDuplicatedRows(sheet.getRowCount() - 1, 6000);
		for (int i = 0; i < dtolist.size(); i++) {
			CashKindListDto dto = dtolist.get(i);
			//EЈԍ̈
			sheet.getCellAt(1, printDataRow).setValue(dto.getKCode());
			sheet.getCellAt(3, printDataRow).setValue(dto.getKName());
			if (dto.getCashAmount() > 0) {
				//xzvX
				totalCnt++;
			} else {
				//xz}CiX
				totalCollect++;
			}
			printDataRow++;
			
		}
		if (dtolist.size() != 0) {
			//Ō̃f[^
			printDataRow = printDataRow + 2;
			sheet.getCellAt(3, printDataRow).setValue(
					PayrollConst.BRACKET_LEFT + PayrollConst.NAM_COMMON_SUM + "  " + totalCnt
							+ PayrollConst.NAM_COMMON_NAME + PayrollConst.BRACKET_RIGHT);
			if (totalCollect != 0) {
				printDataRow = printDataRow + 2;
				sheet.getCellAt(3, printDataRow).setValue(
						PayrollConst.BRACKET_LEFT + PayrollConst.NMA_COMMON_COLLECT + "  " + totalCollect
								+ PayrollConst.NAM_COMMON_NAME + PayrollConst.BRACKET_RIGHT);
			}
			
		}
		
		printDataRow = 7;
		for (int i = 0; i < dtolist.size(); i++) {
			CashKindListDto dto = dtolist.get(i);
			//픻
			if (dto.getCashAmount() > 0) {
				cashKind = cashKind(dto.getCashAmount());
				//햇ݒ(ꖜ~)
				sheet.getCellAt(4, printDataRow).setValue(cashKind[0]);
				//햇vl(ꖜ~)
				totalMan = totalMan + cashKind[0];
				
				//햇ݒ(ܐ~)
				sheet.getCellAt(6, printDataRow).setValue(cashKind[1]);
				//햇vl(ܐ~)
				total5Sen = total5Sen + cashKind[1];
				
				//햇ݒ(~)
				sheet.getCellAt(8, printDataRow).setValue(cashKind[2]);
				//햇vl(~)
				totalSen = totalSen + cashKind[2];
				
				//햇ݒ(ܕS~)
				sheet.getCellAt(10, printDataRow).setValue(cashKind[3]);
				//햇vl(ܕS~)
				total5Hnd = total5Hnd + cashKind[3];
				
				//햇ݒ(S~)
				sheet.getCellAt(12, printDataRow).setValue(cashKind[4]);
				//햇vl(S~)
				totalHnd = totalHnd + cashKind[4];
				
				//햇ݒ(܏\~)
				sheet.getCellAt(14, printDataRow).setValue(cashKind[5]);
				//햇vl(܏\~)
				total5Jyu = total5Jyu + cashKind[5];
				
				//햇ݒ(\~)
				sheet.getCellAt(16, printDataRow).setValue(cashKind[6]);
				//햇vl(\~)
				totalJyu = totalJyu + cashKind[6];
				
				//햇ݒ(܉~)
				sheet.getCellAt(18, printDataRow).setValue(cashKind[7]);
				//햇vl(܉~)
				total5En = total5En + cashKind[7];
				
				//햇ݒ(~)
				sheet.getCellAt(20, printDataRow).setValue(cashKind[8]);
				//햇vl(~)
				total1En = total1En + cashKind[8];
				//zvZ
				totalAmount = totalAmount + dto.getCashAmount();
			} else {
				//z}CiX̍Z
				totalCollectAmount = totalCollectAmount + dto.getCashAmount();
			}
			//햇ݒ(z)
			sheet.getCellAt(22, printDataRow).setValue(insertComma(String.valueOf(dto.getCashAmount())));
			printDataRow++;
			
		}
		
		if (dtolist.size() != 0) {
			printDataRow++;
			String styleCodeBorderBotom = sheet.getCellAt(0, 3).getStyleName();
			sheet.getCellAt(4, printDataRow).setStyleName(styleCodeBorderBotom);
			sheet.getCellAt(5, printDataRow).setStyleName(styleCodeBorderBotom);
			sheet.getCellAt(6, printDataRow).setStyleName(styleCodeBorderBotom);
			sheet.getCellAt(7, printDataRow).setStyleName(styleCodeBorderBotom);
			sheet.getCellAt(8, printDataRow).setStyleName(styleCodeBorderBotom);
			sheet.getCellAt(9, printDataRow).setStyleName(styleCodeBorderBotom);
			sheet.getCellAt(10, printDataRow).setStyleName(styleCodeBorderBotom);
			sheet.getCellAt(11, printDataRow).setStyleName(styleCodeBorderBotom);
			sheet.getCellAt(12, printDataRow).setStyleName(styleCodeBorderBotom);
			sheet.getCellAt(13, printDataRow).setStyleName(styleCodeBorderBotom);
			sheet.getCellAt(14, printDataRow).setStyleName(styleCodeBorderBotom);
			sheet.getCellAt(15, printDataRow).setStyleName(styleCodeBorderBotom);
			sheet.getCellAt(16, printDataRow).setStyleName(styleCodeBorderBotom);
			sheet.getCellAt(17, printDataRow).setStyleName(styleCodeBorderBotom);
			sheet.getCellAt(18, printDataRow).setStyleName(styleCodeBorderBotom);
			sheet.getCellAt(19, printDataRow).setStyleName(styleCodeBorderBotom);
			sheet.getCellAt(20, printDataRow).setStyleName(styleCodeBorderBotom);
			sheet.getCellAt(21, printDataRow).setStyleName(styleCodeBorderBotom);
			sheet.getCellAt(22, printDataRow).setStyleName(styleCodeBorderBotom);
			sheet.getCellAt(23, printDataRow).setStyleName(styleCodeBorderBotom);
			printDataRow++;
			//퍇v(ꖜ~)
			sheet.getCellAt(4, printDataRow).setValue(totalMan);
			//퍇v(ܐ~)
			sheet.getCellAt(6, printDataRow).setValue(total5Sen);
			//퍇v(~)
			sheet.getCellAt(8, printDataRow).setValue(totalSen);
			//퍇v(ܕS~)
			sheet.getCellAt(10, printDataRow).setValue(total5Hnd);
			//퍇v(S~)
			sheet.getCellAt(12, printDataRow).setValue(totalHnd);
			//퍇v(܏\~)
			sheet.getCellAt(14, printDataRow).setValue(total5Jyu);
			//퍇v(\~)
			sheet.getCellAt(16, printDataRow).setValue(totalJyu);
			//퍇v(܉~)
			sheet.getCellAt(18, printDataRow).setValue(total5En);
			//퍇v(~)
			sheet.getCellAt(20, printDataRow).setValue(total1En);
			//zv
			sheet.getCellAt(22, printDataRow).setValue(insertComma(String.valueOf(totalAmount)));
			if (totalCollect != 0) {
				printDataRow++;
				sheet.getCellAt(4, printDataRow).setStyleName(styleCodeBorderBotom);
				sheet.getCellAt(5, printDataRow).setStyleName(styleCodeBorderBotom);
				sheet.getCellAt(6, printDataRow).setStyleName(styleCodeBorderBotom);
				sheet.getCellAt(7, printDataRow).setStyleName(styleCodeBorderBotom);
				sheet.getCellAt(8, printDataRow).setStyleName(styleCodeBorderBotom);
				sheet.getCellAt(9, printDataRow).setStyleName(styleCodeBorderBotom);
				sheet.getCellAt(10, printDataRow).setStyleName(styleCodeBorderBotom);
				sheet.getCellAt(11, printDataRow).setStyleName(styleCodeBorderBotom);
				sheet.getCellAt(12, printDataRow).setStyleName(styleCodeBorderBotom);
				sheet.getCellAt(13, printDataRow).setStyleName(styleCodeBorderBotom);
				sheet.getCellAt(14, printDataRow).setStyleName(styleCodeBorderBotom);
				sheet.getCellAt(15, printDataRow).setStyleName(styleCodeBorderBotom);
				sheet.getCellAt(16, printDataRow).setStyleName(styleCodeBorderBotom);
				sheet.getCellAt(17, printDataRow).setStyleName(styleCodeBorderBotom);
				sheet.getCellAt(18, printDataRow).setStyleName(styleCodeBorderBotom);
				sheet.getCellAt(19, printDataRow).setStyleName(styleCodeBorderBotom);
				sheet.getCellAt(20, printDataRow).setStyleName(styleCodeBorderBotom);
				sheet.getCellAt(21, printDataRow).setStyleName(styleCodeBorderBotom);
				sheet.getCellAt(22, printDataRow).setStyleName(styleCodeBorderBotom);
				sheet.getCellAt(23, printDataRow).setStyleName(styleCodeBorderBotom);
				//zv(}CiXvXɕϊ)
				totalCollectAmount = totalCollectAmount * -1;
				printDataRow++;
				sheet.getCellAt(22, printDataRow).setValue(insertComma(String.valueOf(totalCollectAmount)));
			}
		}
		String fileName = vo.getPltOutYear() + PayrollConst.FILE_NAME_SEPARATOR + vo.getPltOutMonth()
				+ PayrollConst.FILE_NAME_SEPARATOR + PayrollConst.FILE_CASH_KIND_LIST_ODS;
		request.setAttribute(MospConst.ATT_FILE_NAME, fileName);
		request.setAttribute(MospConst.ATT_FILE_OBJECT, ss);
	}
	
	/**
	 * x픻
	 * @param cashAmount z
	 * @return cashKind 픻茋 
	 */
	private int[] cashKind(int cashAmount) {
		int[] cashKind = new int[9];
		int remainder = 0;
		remainder = cashAmount;
		//~̈ʂvZ
		cashKind[0] = remainder / 10000;
		remainder = remainder % 10000;
		//ܐ~̈ʂvZ
		cashKind[1] = remainder / 5000;
		remainder = remainder % 5000;
		//~̈ʂvZ
		cashKind[2] = remainder / 1000;
		remainder = remainder % 1000;
		//ܕS~̈ʂvZ
		cashKind[3] = remainder / 500;
		remainder = remainder % 500;
		//S~̈ʂvZ
		cashKind[4] = remainder / 100;
		remainder = remainder % 100;
		//܏\~̈ʂvZ
		cashKind[5] = remainder / 50;
		remainder = remainder % 50;
		//\~̈ʂvZ
		cashKind[6] = remainder / 10;
		remainder = remainder % 10;
		//܉~̈ʂvZ
		cashKind[7] = remainder / 5;
		remainder = remainder % 5;
		//~̈ʂvZ
		cashKind[8] = remainder / 1;
		remainder = remainder % 1;
		
		return cashKind;
	}
	
	/**
	 * ZtHgEX^Cݒ 
	 * @param poi PoiUtility
	 * @param styleFlg X^CtO
	 * @param halignFlg EtO
	 */
	private void setStyle(PoiUtility poi, boolean styleFlg, boolean halignFlg) {
		int fontSize = 13;
		//tHgݒׂ̈̏
		if (styleFlg == true) {
			poi.createCellStyle();
		} else {
			poi.setFontType(PoiUtility.MS_MINTYO);
			poi.setFontSize(fontSize);
			if (halignFlg == true) {
				poi.setFontHAlignLeft();
			} else {
				poi.setFontHAlignRight();
			}
			poi.reflectCellStyle();
		}
		
	}
}
