/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.payroll.payment.vo;

import javax.servlet.http.HttpServletRequest;

import jp.mosp.common.common.MospException;
import jp.mosp.payroll.base.PayrollConst;
import jp.mosp.payroll.base.PayrollVo;
import jp.mosp.payroll.dto.CmCompanyDto;

public class CompanyCardVo extends PayrollVo {
	
	private static final long	serialVersionUID					= 3281945937471826907L;
	
	// 萔
	public static final int		MODE_INSERT							= 0;
	public static final int		MODE_UPDATE							= 1;
	// p[^
	public static final String	PRM_TXT_COMPANY_CODE				= "txtCompanyCode";
	public static final String	PRM_TXT_COMPANY_NAME				= "txtCompanyName";
	public static final String	PRM_TXT_COMPANY_KANA				= "txtCompanyKana";
	public static final String	PRM_TXT_ENTERPRENEUR				= "txtEnterpreneur";
	public static final String	PRM_TXT_COMPANY_POSTAL				= "txtCompanyPostal";
	public static final String	PRM_TXT_COMPANY_ADDRESS				= "txtCompanyAddress";
	public static final String	PRM_TXT_COMPANY_PHONE				= "txtCompanyPhone";
	public static final String	PRM_TXT_COM_HEALTH_PREMIUM_RATE		= "txtComHealthPremiumRate";
	public static final String	PRM_TXT_COM_NURSING_PREMIUM_RATE	= "txtComNursingPremiumRate";
	public static final String	PRM_TXT_COM_PENSION_PREMIUM_RATE	= "txtComPensionPremiumRate";
	public static final String	PRM_TXT_COM_FUND_PREMIUM_RATE		= "txtComFundPremiumRate";
	public static final String	PRM_TXT_COM_UNEMPLOY_PREMIUM_RATE	= "txtComUnemployPremiumRate";
	public static final String	PRM_TXT_HEALTH_PREMIUM_RATE			= "txtHealthPremiumRate";
	public static final String	PRM_TXT_NURSING_PREMIUM_RATE		= "txtNursingPremiumRate";
	public static final String	PRM_TXT_PENSION_PREMIUM_RATE		= "txtPensionPremiumRate";
	public static final String	PRM_TXT_FUND_PREMIUM_RATE			= "txtFundPremiumRate";
	public static final String	PRM_TXT_UNEMPLOY_PREMIUM_RATE		= "txtUnemployPremiumRate";
	public static final String	PRM_PLT_FUND_PARTICIPATION			= "pltFundParticipation";
	public static final String	PRM_TXT_STATION_NO					= "txtStationNo";
	public static final String	PRM_TXT_DISPOSE_NO					= "txtDisposeNo";
	
	// tB[h
	private String				txtCompanyCode;
	private String				txtCompanyName;
	private String				txtCompanyKana;
	private String				txtEnterpreneur;
	private String				txtCompanyPostal;
	private String				txtCompanyAddress;
	private String				txtCompanyPhone;
	private String				txtComHealthPremiumRate;
	private String				txtComNursingPremiumRate;
	private String				txtComPensionPremiumRate;
	private String				txtComFundPremiumRate;
	private String				txtComUnemployPremiumRate;
	private String				txtHealthPremiumRate;
	private String				txtNursingPremiumRate;
	private String				txtPensionPremiumRate;
	private String				txtFundPremiumRate;
	private String				txtUnemployPremiumRate;
	private String				pltFundParticipation;
	private String				txtStationNo;
	private String				txtDisposeNo;
	
	// tB[hyѐ
	public static final String	NAM_COMPANY_CODE					= "ЃR[h";
	public static final String	NAM_COMPANY_NAME					= "Ж";
	public static final String	NAM_COMPANY_KANA					= "ض";
	public static final String	NAM_ENTERPRENEUR					= "Ǝ喼";
	public static final String	NAM_COMPANY_POSTAL					= "ЗX֔ԍ";
	public static final String	NAM_COMPANY_ADDRESS					= "ЏZ";
	public static final String	NAM_COMPANY_PHONE					= "Гdbԍ";
	public static final String	NAM_COM_HEALTH_PREMIUM_RATE			= "Nیv";
	public static final String	NAM_COM_NURSING_PREMIUM_RATE		= "یv";
	public static final String	NAM_COM_PENSION_PREMIUM_RATE		= "Nv";
	public static final String	NAM_COM_FUND_PREMIUM_RATE			= "Nv";
	public static final String	NAM_COM_UNEMPLOY_PREMIUM_RATE		= "ٗpیv";
	public static final String	NAM_HEALTH_PREMIUM_RATE				= "Nی(l)";
	public static final String	NAM_NURSING_PREMIUM_RATE			= "ی(l)";
	public static final String	NAM_PENSION_PREMIUM_RATE			= "N(l)";
	public static final String	NAM_FUND_PREMIUM_RATE				= "N(l)";
	public static final String	NAM_UNEMPLOY_PREMIUM_RATE			= "ٗpی(l)";
	public static final String	NAM_FUND_PARTICIPATION				= "N";
	public static final String	NAM_STATION_NO						= "ԍ";
	public static final String	NAM_DISPOSE_NO						= "ԍ";
	
	public static final int		LEN_COMPANY_CODE					= 4;
	public static final int		LEN_COMPANY_NAME					= 32;
	public static final int		LEN_COMPANY_KANA					= 32;
	public static final int		LEN_ENTERPRENEUR					= 16;
	public static final int		LEN_STATION_NO						= 8;
	public static final int		LEN_DISPOSE_NO						= 8;
	public static final int		LEN_COMPANY_POSTAL					= PayrollConst.LEN_POSTAL_CODE;
	public static final int		LEN_COMPANY_ADDRESS					= PayrollConst.LEN_ADDRESS;
	public static final int		LEN_COMPANY_PHONE					= PayrollConst.LEN_PHONE_NUMBER;
	public static final int		LEN_INS_RATIO_INT					= PayrollConst.LEN_INS_RATIO_INT;
	public static final int		LEN_INS_RATIO_DEC					= PayrollConst.LEN_INS_RATIO_DEC;
	
	// [h(0FVKo^A1FXV)
	private int					mode;
	//@v_EXg
	public String[][]			aryPltFundParticipation;
	

	/**
	 * RXgN^
	 */
	public CompanyCardVo() {
		super();
		txtCompanyCode = "";
		txtCompanyName = "";
		txtCompanyKana = "";
		txtEnterpreneur = "";
		txtCompanyPostal = "";
		txtCompanyAddress = "";
		txtCompanyPhone = "";
		txtComHealthPremiumRate = "";
		txtComNursingPremiumRate = "";
		txtComPensionPremiumRate = "";
		txtComFundPremiumRate = "";
		txtComUnemployPremiumRate = "";
		txtHealthPremiumRate = "";
		txtNursingPremiumRate = "";
		txtPensionPremiumRate = "";
		txtFundPremiumRate = "";
		txtUnemployPremiumRate = "";
		pltFundParticipation = "";
		txtStationNo = "";
		txtDisposeNo = "";
		
	}
	
	/* (non-Javadoc)
	 * @see jp.mosp.payroll.base.PayrollVo#setSubTitle()
	 */
	@Override
	protected void setSubTitle() {
		super.setSubTitle();
		subTitle = getName("P_COMPANY") + getName("P_INFORMATION") + getName("P_MAINTENANCE");
		addAryMenu("P1002", getName("P_PAYROLL") + getName("C_MASTER") + getName("C_MENU") + getName("C_TO"));
	}
	
	/**
	 * p[^ݒ
	 */
	public void setParams(HttpServletRequest request) {
		txtCompanyCode = request.getParameter(PRM_TXT_COMPANY_CODE);
		txtCompanyName = request.getParameter(PRM_TXT_COMPANY_NAME);
		txtCompanyKana = request.getParameter(PRM_TXT_COMPANY_KANA);
		txtEnterpreneur = request.getParameter(PRM_TXT_ENTERPRENEUR);
		txtCompanyPostal = request.getParameter(PRM_TXT_COMPANY_POSTAL);
		txtCompanyAddress = request.getParameter(PRM_TXT_COMPANY_ADDRESS);
		txtCompanyPhone = request.getParameter(PRM_TXT_COMPANY_PHONE);
		txtComHealthPremiumRate = request.getParameter(PRM_TXT_COM_HEALTH_PREMIUM_RATE);
		txtComNursingPremiumRate = request.getParameter(PRM_TXT_COM_NURSING_PREMIUM_RATE);
		txtComPensionPremiumRate = request.getParameter(PRM_TXT_COM_PENSION_PREMIUM_RATE);
		txtComFundPremiumRate = request.getParameter(PRM_TXT_COM_FUND_PREMIUM_RATE);
		txtComUnemployPremiumRate = request.getParameter(PRM_TXT_COM_UNEMPLOY_PREMIUM_RATE);
		txtHealthPremiumRate = request.getParameter(PRM_TXT_HEALTH_PREMIUM_RATE);
		txtNursingPremiumRate = request.getParameter(PRM_TXT_NURSING_PREMIUM_RATE);
		txtPensionPremiumRate = request.getParameter(PRM_TXT_PENSION_PREMIUM_RATE);
		txtFundPremiumRate = request.getParameter(PRM_TXT_FUND_PREMIUM_RATE);
		txtUnemployPremiumRate = request.getParameter(PRM_TXT_UNEMPLOY_PREMIUM_RATE);
		pltFundParticipation = request.getParameter(PRM_PLT_FUND_PARTICIPATION);
		txtStationNo = request.getParameter(PRM_TXT_STATION_NO);
		txtDisposeNo = request.getParameter(PRM_TXT_DISPOSE_NO);
		
	}
	
	/**
	 * tB[hݒ
	 * @param dto ЃXg
	 */
	public void setFields(CmCompanyDto dto) {
		// f[^̐ݒ
		txtCompanyCode = dto.getCompanyCode();
		txtCompanyName = dto.getCompanyName();
		txtCompanyKana = dto.getCompanyKana();
		txtEnterpreneur = dto.getEnterpreneur();
		txtCompanyPostal = dto.getCompanyPostal();
		txtCompanyAddress = dto.getCompanyAddress();
		txtCompanyPhone = dto.getCompanyPhone();
		txtComHealthPremiumRate = Float.toString(dto.getComHealthPremiumRate());
		txtComNursingPremiumRate = Float.toString(dto.getComNursingPremiumRate());
		txtComPensionPremiumRate = Float.toString(dto.getComPensionPremiumRate());
		txtComFundPremiumRate = Float.toString(dto.getComFundPremiumRate());
		txtComUnemployPremiumRate = Float.toString(dto.getComUnemployPremiumRate());
		txtHealthPremiumRate = Float.toString(dto.getHealthPremiumRate());
		txtNursingPremiumRate = Float.toString(dto.getNursingPremiumRate());
		txtPensionPremiumRate = Float.toString(dto.getPensionPremiumRate());
		txtFundPremiumRate = Float.toString(dto.getFundPremiumRate());
		txtUnemployPremiumRate = Float.toString(dto.getUnemployPremiumRate());
		pltFundParticipation = dto.getFundParticipation();
		txtStationNo = dto.getStationNo();
		txtDisposeNo = dto.getDisposeNo();
		
	}
	
	/**
	 * tB[h̑ÓmF
	 * @return 
	 * @throws MospException
	 */
	public boolean validate() throws MospException {
		// ÓmFJn
		startValidation();
		// K{mF
		checkRequired(txtCompanyCode, NAM_COMPANY_CODE, PRM_TXT_COMPANY_CODE);
		// R[hmF
		checkCode(txtCompanyCode, NAM_COMPANY_CODE, PRM_TXT_COMPANY_CODE);
		checkPhone(txtCompanyPhone, NAM_COMPANY_PHONE, PRM_TXT_COMPANY_PHONE);
		// mF
		checkLength(txtCompanyCode, LEN_COMPANY_CODE, NAM_COMPANY_CODE, PRM_TXT_COMPANY_CODE);
		checkLength(txtCompanyName, LEN_COMPANY_NAME, NAM_COMPANY_NAME, PRM_TXT_COMPANY_NAME);
		checkLength(txtCompanyKana, LEN_COMPANY_KANA, NAM_COMPANY_KANA, PRM_TXT_COMPANY_KANA);
		checkLength(txtEnterpreneur, LEN_ENTERPRENEUR, NAM_ENTERPRENEUR, PRM_TXT_ENTERPRENEUR);
		checkLength(txtCompanyPostal, LEN_COMPANY_POSTAL, NAM_COMPANY_POSTAL, PRM_TXT_COMPANY_POSTAL);
		checkLength(txtCompanyAddress, LEN_COMPANY_ADDRESS, NAM_COMPANY_ADDRESS, PRM_TXT_COMPANY_ADDRESS);
		checkLength(txtCompanyPhone, LEN_COMPANY_PHONE, NAM_COMPANY_PHONE, PRM_TXT_COMPANY_PHONE);
		checkLength(txtStationNo, LEN_STATION_NO, NAM_STATION_NO, PRM_TXT_STATION_NO);
		checkLength(txtDisposeNo, LEN_DISPOSE_NO, NAM_DISPOSE_NO, PRM_TXT_DISPOSE_NO);
		/*
		checkLength(txtComHealthPremiumRate  , LEN_RATE, NAM_COM_HEALTH_PREMIUM_RATE  , PRM_TXT_COM_HEALTH_PREMIUM_RATE  );
		checkLength(txtComNursingPremiumRate , LEN_RATE, NAM_COM_NURSING_PREMIUM_RATE , PRM_TXT_COM_NURSING_PREMIUM_RATE );
		checkLength(txtComPensionPremiumRate , LEN_RATE, NAM_COM_PENSION_PREMIUM_RATE , PRM_TXT_COM_PENSION_PREMIUM_RATE );
		checkLength(txtComFundPremiumRate    , LEN_RATE, NAM_COM_FUND_PREMIUM_RATE    , PRM_TXT_COM_FUND_PREMIUM_RATE    );
		checkLength(txtComUnemployPremiumRate, LEN_RATE, NAM_COM_UNEMPLOY_PREMIUM_RATE, PRM_TXT_COM_UNEMPLOY_PREMIUM_RATE);
		checkLength(txtHealthPremiumRate  , LEN_RATE, NAM_HEALTH_PREMIUM_RATE  , PRM_TXT_HEALTH_PREMIUM_RATE  );
		checkLength(txtNursingPremiumRate , LEN_RATE, NAM_NURSING_PREMIUM_RATE , PRM_TXT_NURSING_PREMIUM_RATE );
		checkLength(txtPensionPremiumRate , LEN_RATE, NAM_PENSION_PREMIUM_RATE , PRM_TXT_PENSION_PREMIUM_RATE );
		checkLength(txtFundPremiumRate    , LEN_RATE, NAM_FUND_PREMIUM_RATE    , PRM_TXT_FUND_PREMIUM_RATE    );
		checkLength(txtUnemployPremiumRate, LEN_RATE, NAM_UNEMPLOY_PREMIUM_RATE, PRM_TXT_UNEMPLOY_PREMIUM_RATE);
		*/

		checkNumeric(txtComHealthPremiumRate, NAM_COM_HEALTH_PREMIUM_RATE, PRM_TXT_COM_HEALTH_PREMIUM_RATE);
		checkNumeric(txtComNursingPremiumRate, NAM_COM_NURSING_PREMIUM_RATE, PRM_TXT_COM_NURSING_PREMIUM_RATE);
		checkNumeric(txtComPensionPremiumRate, NAM_COM_PENSION_PREMIUM_RATE, PRM_TXT_COM_PENSION_PREMIUM_RATE);
		checkNumeric(txtComFundPremiumRate, NAM_COM_FUND_PREMIUM_RATE, PRM_TXT_COM_FUND_PREMIUM_RATE);
		checkNumeric(txtComUnemployPremiumRate, NAM_COM_UNEMPLOY_PREMIUM_RATE, PRM_TXT_COM_UNEMPLOY_PREMIUM_RATE);
		checkNumeric(txtHealthPremiumRate, NAM_HEALTH_PREMIUM_RATE, PRM_TXT_HEALTH_PREMIUM_RATE);
		checkNumeric(txtNursingPremiumRate, NAM_NURSING_PREMIUM_RATE, PRM_TXT_NURSING_PREMIUM_RATE);
		checkNumeric(txtPensionPremiumRate, NAM_PENSION_PREMIUM_RATE, PRM_TXT_PENSION_PREMIUM_RATE);
		checkNumeric(txtFundPremiumRate, NAM_FUND_PREMIUM_RATE, PRM_TXT_FUND_PREMIUM_RATE);
		checkNumeric(txtUnemployPremiumRate, NAM_UNEMPLOY_PREMIUM_RATE, PRM_TXT_UNEMPLOY_PREMIUM_RATE);
		
		// ÓmFI
		endValidation();
		return isValid;
	}
	
	/**
	 * tB[hݒ(DTOɑ΂VÕZbg)
	 * @param dto ݒΏDTO
	 */
	public void setDtoFields(CmCompanyDto dto) {
		dto.setCompanyCode(txtCompanyCode);
		dto.setCompanyName(txtCompanyName);
		dto.setCompanyKana(txtCompanyKana);
		dto.setEnterpreneur(txtEnterpreneur);
		dto.setCompanyPostal(txtCompanyPostal);
		dto.setCompanyAddress(txtCompanyAddress);
		dto.setCompanyPhone(txtCompanyPhone);
		dto.setComHealthPremiumRate(Float.parseFloat(txtComHealthPremiumRate));
		dto.setComNursingPremiumRate(Float.parseFloat(txtComNursingPremiumRate));
		dto.setComPensionPremiumRate(Float.parseFloat(txtComPensionPremiumRate));
		dto.setComFundPremiumRate(Float.parseFloat(txtComFundPremiumRate));
		dto.setComUnemployPremiumRate(Float.parseFloat(txtComUnemployPremiumRate));
		dto.setHealthPremiumRate(Float.parseFloat(txtHealthPremiumRate));
		dto.setNursingPremiumRate(Float.parseFloat(txtNursingPremiumRate));
		dto.setPensionPremiumRate(Float.parseFloat(txtPensionPremiumRate));
		dto.setFundPremiumRate(Float.parseFloat(txtFundPremiumRate));
		dto.setUnemployPremiumRate(Float.parseFloat(txtUnemployPremiumRate));
		dto.setFundParticipation(pltFundParticipation);
		dto.setStationNo(txtStationNo);
		dto.setDisposeNo(txtDisposeNo);
		
	}
	
	/**
	 * JavaScriptݒ
	 * @param cls 擾NX
	 * @throws IllegalAccessException
	 */
	@Override
	public String getDirectJs(Class<?> cls) throws IllegalAccessException {
		StringBuffer sb = new StringBuffer();
		sb.append(super.getDirectJs(cls));
		sb.append("var MODE = ");
		sb.append(mode);
		sb.append(";");
		return sb.toString();
	}
	
	// ANZT\bh
	public void setTxtCompanyCode(String txtCompanyCode) {
		this.txtCompanyCode = txtCompanyCode;
	}
	
	public void setTxtCompanyName(String txtCompanyName) {
		this.txtCompanyName = txtCompanyName;
	}
	
	public void setTxtCompanyKana(String txtCompanyKana) {
		this.txtCompanyKana = txtCompanyKana;
	}
	
	public void setTxtEnterpreneur(String txtEnterpreneur) {
		this.txtEnterpreneur = txtEnterpreneur;
	}
	
	public void setTxtCompanyPostal(String txtCompanyPostal) {
		this.txtCompanyPostal = txtCompanyPostal;
	}
	
	public void setTxtCompanyAddress(String txtCompanyAddress) {
		this.txtCompanyAddress = txtCompanyAddress;
	}
	
	public void setTxtCompanyPhone(String txtCompanyPhone) {
		this.txtCompanyPhone = txtCompanyPhone;
	}
	
	public void setTxtComHealthPremiumRate(String txtComHealthPremiumRate) {
		this.txtComHealthPremiumRate = txtComHealthPremiumRate;
	}
	
	public void setTxtComNursingPremiumRate(String txtComNursingPremiumRate) {
		this.txtComNursingPremiumRate = txtComNursingPremiumRate;
	}
	
	public void setTxtComPensionPremiumRate(String txtComPensionPremiumRate) {
		this.txtComPensionPremiumRate = txtComPensionPremiumRate;
	}
	
	public void setTxtComFundPremiumRate(String txtComFundPremiumRate) {
		this.txtComFundPremiumRate = txtComFundPremiumRate;
	}
	
	public void setTxtComUnemployPremiumRate(String txtComUnemployPremiumRate) {
		this.txtComUnemployPremiumRate = txtComUnemployPremiumRate;
	}
	
	public void setTxtStationNo(String txtStationNo) {
		this.txtStationNo = txtStationNo;
	}
	
	public void setTxtDisposeNo(String txtDisposeNo) {
		this.txtDisposeNo = txtDisposeNo;
	}
	
	public void setTxtHealthPremiumRate(String txtHealthPremiumRate) {
		this.txtHealthPremiumRate = txtHealthPremiumRate;
	}
	
	public void setTxtNursingPremiumRate(String txtNursingPremiumRate) {
		this.txtNursingPremiumRate = txtNursingPremiumRate;
	}
	
	public void setTxtPensionPremiumRate(String txtPensionPremiumRate) {
		this.txtPensionPremiumRate = txtPensionPremiumRate;
	}
	
	public void setTxtFundPremiumRate(String txtFundPremiumRate) {
		this.txtFundPremiumRate = txtFundPremiumRate;
	}
	
	public void setTxtUnemployPremiumRate(String txtUnemployPremiumRate) {
		this.txtUnemployPremiumRate = txtUnemployPremiumRate;
	}
	
	public void setPltFundParticipation(String pltFundParticipation) {
		this.pltFundParticipation = pltFundParticipation;
	}
	
	public String getTxtCompanyCode() {
		return escapeHTML(txtCompanyCode);
	}
	
	public String getTxtCompanyName() {
		return escapeHTML(txtCompanyName);
	}
	
	public String getTxtCompanyKana() {
		return escapeHTML(txtCompanyKana);
	}
	
	public String getTxtEnterpreneur() {
		return escapeHTML(txtEnterpreneur);
	}
	
	public String getTxtCompanyPostal() {
		return escapeHTML(txtCompanyPostal);
	}
	
	public String getTxtCompanyAddress() {
		return escapeHTML(txtCompanyAddress);
	}
	
	public String getTxtCompanyPhone() {
		return escapeHTML(txtCompanyPhone);
	}
	
	public String getTxtComHealthPremiumRate() {
		return escapeHTML(txtComHealthPremiumRate);
	}
	
	public String getTxtComNursingPremiumRate() {
		return escapeHTML(txtComNursingPremiumRate);
	}
	
	public String getTxtComPensionPremiumRate() {
		return escapeHTML(txtComPensionPremiumRate);
	}
	
	public String getTxtComFundPremiumRate() {
		return escapeHTML(txtComFundPremiumRate);
	}
	
	public String getTxtComUnemployPremiumRate() {
		return escapeHTML(txtComUnemployPremiumRate);
	}
	
	public String getTxtHealthPremiumRate() {
		return escapeHTML(txtHealthPremiumRate);
	}
	
	public String getTxtNursingPremiumRate() {
		return escapeHTML(txtNursingPremiumRate);
	}
	
	public String getTxtPensionPremiumRate() {
		return escapeHTML(txtPensionPremiumRate);
	}
	
	public String getTxtFundPremiumRate() {
		return escapeHTML(txtFundPremiumRate);
	}
	
	public String getTxtUnemployPremiumRate() {
		return escapeHTML(txtUnemployPremiumRate);
	}
	
	public String getTxtStationNo() {
		return escapeHTML(txtStationNo);
	}
	
	public String getTxtDisposeNo() {
		return escapeHTML(txtDisposeNo);
	}
	
	public String getPltFundParticipation() {
		return escapeHTML(pltFundParticipation);
	}
	
	public void setMode(int mode) {
		this.mode = mode;
	}
	
	public int getMode() {
		return mode;
	}
	
}
