/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.payroll.vo;

import java.util.Date;

import javax.servlet.http.HttpServletRequest;

import jp.mosp.common.CommonConst;
import jp.mosp.common.MosPMenuConst;
import jp.mosp.common.MosPVo;
import jp.mosp.common.common.MospException;
import jp.mosp.common.common.MospUtility;
import jp.mosp.payroll.dto.MKintaiKeisanDto;

/**
 * @author yoshida
 *
 */
public class AttendanceCalculateStartCardVo extends MosPVo {
	
	private static final long	serialVersionUID	= 930283603344677026L;
	
	// p[^
	/**
	 * 
	 */
	public static final String	PRM_PLT_KTNEN		= "pltKTnen";
	/**
	 * 
	 */
	public static final String	PRM_PLT_KTTUKI		= "pltKTtuki";
	
	// tB[h
	private String				pltKTnen;
	private String				pltKTtuki;
	
	// v_EXg
	/**
	 * 
	 */
	public String[][]			aryPltKTnen;
	/**
	 * 
	 */
	public String[][]			aryPltKTtuki;
	
	// tB[hyѐ
	/**
	 * 
	 */
	public String				NAM_KT_YYMM_NAME;
	/**
	 * 
	 */
	public String				NAM_KT_YEAR;
	/**
	 * 
	 */
	public String				NAM_KT_MONTH;
	

	/**
	 * RXgN^
	 */
	public AttendanceCalculateStartCardVo() {
		super();
		setViewPath(getClassName());
	}
	
	@Override
	protected void setSubTitle() {
		subTitle = CommonConst.TTL_ATT_CALCULATE_START;
		createAryMenu(CMD_MENU_PAYROLL, MosPMenuConst.getMenuAttendanceCalculate());
	}
	
	@Override
	protected void setFieldsName() {
		NAM_KT_YYMM_NAME = CommonConst.NAM_CONFIRM_ATTENDANCE + CommonConst.NAM_CALCULATE_TARGET + CommonConst.NAM_YEAR
				+ CommonConst.NAM_MONTH;
		NAM_KT_YEAR = CommonConst.NAM_CONFIRM_ATTENDANCE + CommonConst.NAM_CALCULATE_TARGET + CommonConst.NAM_YEAR;
		NAM_KT_MONTH = CommonConst.NAM_CONFIRM_ATTENDANCE + CommonConst.NAM_CALCULATE_TARGET + CommonConst.NAM_MONTH;
	}
	
	/**
	 * lݒ
	 */
	public void setDefaultValues() {
		setPltKTnen("");
		setPltKTtuki("");
	}
	
	@Override
	public void setParams(HttpServletRequest request) {
		pltKTnen = request.getParameter(PRM_PLT_KTNEN);
		pltKTtuki = request.getParameter(PRM_PLT_KTTUKI);
	}
	
	/**
	 * tB[hݒ
	 * @param dto [U[Xg
	 */
	public void setFields(MKintaiKeisanDto dto) {
		pltKTnen = String.valueOf(dto.getKTNen());
		pltKTtuki = String.valueOf(dto.getKTTuki());
	}
	
	/**
	 * tB[hݒ(DTOɑ΂VÕZbg)
	 * @param dto ݒΏDTO
	 */
	public void setDtoFields(MKintaiKeisanDto dto) {
		dto.setKTNen(Integer.parseInt(pltKTnen));
		dto.setKTTuki(Integer.parseInt(pltKTtuki));
		dto.setKKanryou(CommonConst.NUM_ATTENDANCE_CALCULATE_FLAG_OFF);
	}
	
	/**
	 * tB[h̑ÓmF
	 * @param dto ΏDTO
	 * @param current WvN
	 * @param change ͔N
	 * @throws MospException	MosPOꍇ
	 */
	public void validate(MKintaiKeisanDto dto, Date current, Date change) throws MospException {
		// ÓmFJn
		startValidation();
		// bZ[WpvZN
		String msgdate = MospUtility.getYear(current) + CommonConst.STR_UNDER_SEPARATOR + MospUtility.getMonth(current);
		// XVw`FbN
		if (CommonConst.NUM_ATTENDANCE_CALCULATE_FLAG_OFF.equals(dto.getKKanryou())) {
			// jdto 200807 < vo 200808
			// wŇvZIĂȂ̂ɗȍ~̌vZJn悤Ƃ
			if (current.compareTo(change) < 0) {
				addErrMessage(MospUtility.getMessage(msg, CommonConst.MSG_CANNOT_FUTURE_MONTH, msgdate));
				isValid = false;
			}
		} else {
			// vZ`FbN
			if (current.compareTo(change) == 0) {
				addErrMessage(MospUtility.getMessage(msg, CommonConst.MSG_ALREADY_CALCULATE, msgdate));
				isValid = false;
			}
		}
		// ߋւ̖߂`FbN
		if (current.compareTo(change) > 0) {
			String errMsg = MospUtility.getMessage(msg, CommonConst.MSG_CANNOT_PAST_MONTH, msgdate);
			addErrMessage(errMsg);
			isValid = false;
		}
		// ÓmFI
		endValidation();
	}
	
	// ANZT\bh	
	/**
	 * @return pltKTnen
	 */
	public String getPltKTnen() {
		return pltKTnen;
	}
	
	/**
	 * @return pltKTtuki
	 */
	public String getPltKTtuki() {
		return pltKTtuki;
	}
	
	/**
	 * @param pltKTnen Zbg pltKTnen
	 */
	public void setPltKTnen(String pltKTnen) {
		this.pltKTnen = pltKTnen;
	}
	
	/**
	 * @param pltKTtuki Zbg pltKTtuki
	 */
	public void setPltKTtuki(String pltKTtuki) {
		this.pltKTtuki = pltKTtuki;
	}
	
}
