/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.system.action;

import jp.mosp.common.CommonConst;
import jp.mosp.common.common.BaseVo;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.utils.StringUtil;
import jp.mosp.kintai.common.action.KintaiCommonAction;
import jp.mosp.kintai.common.dao.MKaisyaDao;
import jp.mosp.kintai.common.dto.MKaisyaDto;
import jp.mosp.system.vo.KaisyaMasterCardVo;

/**
 * @author yoshida
 *
 */
public class KaisyaMasterCardAction extends KintaiCommonAction {
	
	// R}h
	private static final String	CMD_KAISYA_MASTER_CARD_SHOW		= "S2015";	// \(ǉ)
	private static final String	CMD_KAISYA_MASTER_CARD_SELECT	= "S2016";	// \(I)
	private static final String	CMD_KAISYA_MASTER_CARD_INSERT	= "S2017";	// o^
	private static final String	CMD_KAISYA_MASTER_CARD_UPDATE	= "S2018";	// XV
	private static final String	CMD_KAISYA_MASTER_CARD_DELETE	= "S2019";	// 폜
																			
	
	/**
	 * RXgN^
	 */
	public KaisyaMasterCardAction() {
		super();
	}
	
	public void action() throws Exception {
		// VO̎擾		
		prepareVo(false);
		// 
		init();
		// R}h̏
		if (cmd.equals(CMD_KAISYA_MASTER_CARD_SHOW)) {
			// \
			show();
		} else if (cmd.equals(CMD_KAISYA_MASTER_CARD_SELECT)) {
			// \(L[ŏ)
			select();
		} else if (cmd.equals(CMD_KAISYA_MASTER_CARD_INSERT)) {
			// VKo^
			insert();
		} else if (cmd.equals(CMD_KAISYA_MASTER_CARD_UPDATE)) {
			// XV
			update();
		} else if (cmd.equals(CMD_KAISYA_MASTER_CARD_DELETE)) {
			// 폜
			delete();
		} else {
			throw new MospException(MospConst.EX_CMD_INVALID);
		}
	}
	
	@Override
	protected BaseVo getSpecificVo() {
		return new KaisyaMasterCardVo();
	}
	
	@Override
	protected void init() throws Exception {
		// DBRlNV擾
		getConnection();
		// PAYROLLmF
		confirmSystemAuth();
		KaisyaMasterCardVo vo = (KaisyaMasterCardVo)getVo();
		// N\@v_EXg쐬
		vo.aryPltKikinKbn = StringUtil.getFlagArray(CommonConst.NAM_FUND_NOT_PARTICIPATION,
				CommonConst.NAM_FUND_PARTICIPATION);
	}
	
	@Override
	protected void show() {
		KaisyaMasterCardVo vo = (KaisyaMasterCardVo)getVo();
		vo.setDefaultValues();
		vo.setMode(KaisyaMasterCardVo.MODE_INSERT);
	}
	
	@Override
	protected void select() throws Exception {
		KaisyaMasterCardVo vo = (KaisyaMasterCardVo)getVo();
		// f[^̎擾
		MKaisyaDto dto = part().office().getMKaisyaDao().findForKey(key1);
		chkExist(dto);
		// VOɏZbg
		vo.setFields(dto);
		setMode();
		// ZbVDTOZbg
		setSessionDto(dto);
	}
	
	@Override
	protected void insert() throws Exception {
		KaisyaMasterCardVo vo = (KaisyaMasterCardVo)getVo();
		vo.setParams(request);
		// p[^̑ÓmF
		vo.validate();
		// DTȌ
		MKaisyaDto dto = new MKaisyaDto();
		vo.setDtoFields(dto);
		// DAȌ
		MKaisyaDao dao = part().office().getMKaisyaDao();
		// ݃`FbN
		chkDuplicate(dao.findForKey(dto.getId()));
		// f[^̑}
		dao.insert(dto);
		// DTO̍Ď擾
		dto = dao.findForKey(dto.getId());
		chkInsert(dto);
		// R~bg
		commit();
		// [hݒ
		setMode();
		// bZ[Wݒ
		vo.setMessage(getMessage(MospConst.MSG_INSERT, ""));
		// ZbVDTOZbg
		setSessionDto(dto);
	}
	
	@Override
	protected void update() throws Exception {
		// DTO̎擾		
		MKaisyaDto dto = (MKaisyaDto)getSessionDto();
		KaisyaMasterCardVo vo = (KaisyaMasterCardVo)getVo();
		vo.setParams(request);
		// p[^̑ÓmF
		vo.validate();
		// DTȌ
		vo.setDtoFields(dto);
		// DAȌ
		MKaisyaDao dao = part().office().getMKaisyaDao();
		// rmF
		chkExclusive(dto, dao.findForUpdate(dto.getId()));
		// f[^̍XV
		dao.update(dto);
		// DTO̍Ď擾
		MKaisyaDto retDto = dao.findForKey(dto.getId());
		chkUpdate(retDto);
		// R~bg
		commit();
		// [hݒ
		setMode();
		// bZ[Wݒ
		vo.setMessage(getMessage(MospConst.MSG_UPDATE, ""));
		// ZbVDTOZbg
		setSessionDto(retDto);
	}
	
	/**
	 * f[^폜
	 * @throws Exception 	Oꍇ
	 */
	private void delete() throws Exception {
		// DTO̎擾		
		MKaisyaDto dto = (MKaisyaDto)getSessionDto();
		KaisyaMasterCardVo vo = (KaisyaMasterCardVo)getVo();
		// f[^̍XV
		part().office().getMKaisyaDao().delete(dto);
		// R~bg
		commit();
		// bZ[Wݒ
		vo.setMessage(getMessage(MospConst.MSG_DELETE, ""));
	}
	
	/**
	 * [hݒ
	 * @throws Exception 	Oꍇ
	 */
	private void setMode() throws Exception {
		KaisyaMasterCardVo vo = (KaisyaMasterCardVo)getVo();
		// [hݒ
		if (hasSystemAuth()) {
			vo.setMode(KaisyaMasterCardVo.MODE_SYSTEM);
		} else {
			vo.setMode(KaisyaMasterCardVo.MODE_UPDATE);
		}
	}
	
}
