/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.system.action;

import jp.mosp.common.CommonConst;
import jp.mosp.common.MosPAction;
import jp.mosp.common.common.BaseVo;
import jp.mosp.system.vo.OptionFunctionMenuVo;

/**
 * @author yoshida
 *
 */
public class OptionFunctionMenuAction extends MosPAction {
	
	/**
	 * RXgN^
	 */
	public OptionFunctionMenuAction() {
		super();
	}
	
	public void action() throws Exception {
		// VȌ
		prepareVo(false);
		// 
		init();
		// \
		show();
	}
	
	@Override
	protected BaseVo getSpecificVo() {
		return new OptionFunctionMenuVo();
	}
	
	@Override
	protected void init() throws Exception {
		// ZbVێ̏
		initStoredData();
		// SYSTEMmF
		confirmSystemAuth();
	}
	
	@Override
	protected void show() throws Exception {
		OptionFunctionMenuVo vo = (OptionFunctionMenuVo)getVo();
		vo.setAryOptionFunctionMenu(getMosPCodeArray(CommonConst.TID_OPTION_FUNCTION));
	}
	
}
