/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.system.vo;

import javax.servlet.http.HttpServletRequest;

import jp.mosp.common.CommonConst;
import jp.mosp.common.MosPVo;
import jp.mosp.common.common.MospException;
import jp.mosp.common.common.MospUtility;
import jp.mosp.common.dto.MCodeDto;
import jp.mosp.common.utils.DateUtil;
import jp.mosp.common.utils.StringUtil;

/**
 * @author yoshida
 *
 */
public class HolidayMasterCardVo extends MosPVo {
	
	private static final long	serialVersionUID		= -1523597184920140308L;
	
	// 萔
	public static final int		MODE_INSERT				= 0;
	public static final int		MODE_UPDATE				= 1;
	public static final int		MODE_SYSTEM				= 2;
	
	// p[^	
	public static final String	PRM_TXT_HOLIDAY_YEAR	= "txtHolidayYear";
	public static final String	PRM_PLT_HOLIDAY_MONTH	= "pltHolidayMonth";
	public static final String	PRM_PLT_HOLIDAY_DAY		= "pltHolidayDay";
	public static final String	PRM_TXT_HOLIDAY_NAME	= "txtHolidayName";
	
	// tB[h
	private String				txtHolidayYear;
	private String				pltHolidayMonth;
	private String				pltHolidayDay;
	private String				txtHolidayName;
	
	// [h(0FVKo^A1FXVA2F폜)
	private int					mode;
	
	// tB[hyѐ	
	public String				NAM_HOLIDAY_DATE;
	public String				NAM_HOLIDAY_YEAR;
	public String				NAM_HOLIDAY_MONTH;
	public String				NAM_HOLIDAY_DAY;
	public String				NAM_HOLIDAY_NAME;
	public int					LEN_YEAR;
	public int					LEN_NAME;
	
	// v_E
	public String[][]			aryPltMonth;
	public String[][]			aryPltDay;
	

	/**
	 * RXgN^
	 */
	public HolidayMasterCardVo() {
		super();
		mode = 0;
		setViewPath(getClassName());
	}
	
	@Override
	protected void setSubTitle() {
		subTitle = CommonConst.TTL_HOLIDAY_MASTER;
		aryMenu = new String[][]{ { CMD_MENU_SYSTEM2, CommonConst.NAM_TO_MENU } };
	}
	
	@Override
	protected void setFieldsName() {
		NAM_HOLIDAY_DATE = CommonConst.NAM_DATE;
		NAM_HOLIDAY_YEAR = CommonConst.NAM_YEAR;
		NAM_HOLIDAY_MONTH = CommonConst.NAM_MONTH;
		NAM_HOLIDAY_DAY = CommonConst.NAM_DAY;
		NAM_HOLIDAY_NAME = CommonConst.NAM_COMMON_MEISYO;
		LEN_YEAR = CommonConst.LEN_YEAR;
		LEN_NAME = 50;
	}
	
	/**
	 * lݒ
	 */
	public void setDefaultValues() {
		setTxtHolidayYear("");
		setTxtHolidayName("");
	}
	
	@Override
	public void setParams(HttpServletRequest request) {
		txtHolidayYear = request.getParameter(PRM_TXT_HOLIDAY_YEAR);
		pltHolidayMonth = request.getParameter(PRM_PLT_HOLIDAY_MONTH);
		pltHolidayDay = request.getParameter(PRM_PLT_HOLIDAY_DAY);
		txtHolidayName = request.getParameter(PRM_TXT_HOLIDAY_NAME);
	}
	
	/**
	 * tB[hݒ
	 * @param dto [U[Xg
	 */
	public void setFields(MCodeDto dto) {
		// f[^̐ݒ
		String holiday = dto.getTCode();
		if (holiday.startsWith("0") || holiday.startsWith("1")) {
			txtHolidayYear = "";
			pltHolidayMonth = StringUtil.removeZero(holiday.split(CommonConst.SEPARATOR_DATE)[0]);
			pltHolidayDay = StringUtil.removeZero(holiday.split(CommonConst.SEPARATOR_DATE)[1]);
		} else {
			txtHolidayYear = String.valueOf(MospUtility.getYear(DateUtil.convStringDateToDate(holiday)));
			pltHolidayMonth = String.valueOf(MospUtility.getMonth(DateUtil.convStringDateToDate(holiday)));
			pltHolidayDay = String.valueOf(MospUtility.getDay(DateUtil.convStringDateToDate(holiday)));
		}
		txtHolidayName = dto.getTName();
	}
	
	/**
	 * tB[h̑ÓmF
	 * @throws MospException
	 */
	public void validate() throws MospException {
		// ÓmFJn
		startValidation();
		// K{mF
		checkRequired(txtHolidayName, NAM_HOLIDAY_NAME, PRM_TXT_HOLIDAY_NAME);
		// 񒷊mF
		checkLength(txtHolidayYear, LEN_YEAR, NAM_HOLIDAY_YEAR, PRM_TXT_HOLIDAY_YEAR);
		checkLength(txtHolidayName, LEN_NAME, NAM_HOLIDAY_NAME, PRM_TXT_HOLIDAY_NAME);
		// tmF
		if (StringUtil.isNotNull(txtHolidayYear)) {
			checkDate(Integer.parseInt(txtHolidayYear), Integer.parseInt(pltHolidayMonth), Integer
				.parseInt(pltHolidayDay), NAM_HOLIDAY_DATE, PRM_TXT_HOLIDAY_YEAR);
		} else {
			checkDate(MospUtility.getYear(DateUtil.getSystemDate()), Integer.parseInt(pltHolidayMonth), Integer
				.parseInt(pltHolidayDay), NAM_HOLIDAY_DATE, PRM_TXT_HOLIDAY_YEAR);
		}
		// ÓmFI
		endValidation();
	}
	
	/**
	 * tB[hݒ(DTOɑ΂VÕZbg)
	 * @param dto ݒΏDTO
	 */
	public void setDtoFields(MCodeDto dto) {
		dto.setTId(CommonConst.NAM_HOLIDAY);
		if (StringUtil.isNotNull(txtHolidayYear)) {
			dto.setTCode(DateUtil.convStringDateFormatted(txtHolidayYear, pltHolidayMonth, pltHolidayDay));
		} else {
			dto.setTCode(StringUtil.addZero(pltHolidayMonth) + CommonConst.SEPARATOR_DATE
					+ StringUtil.addZero(pltHolidayDay));
		}
		dto.setTName(txtHolidayName);
		dto.setTChange(CommonConst.NAM_COMMON_STRING_INITIAL_VALUE);
	}
	
	@Override
	public String getDirectJs(Class<?> cls, Object obj) throws IllegalAccessException {
		StringBuffer sb = new StringBuffer();
		sb.append(super.getDirectJs(cls, obj));
		sb.append("var MODE = ");
		sb.append(mode);
		sb.append(";");
		return sb.toString();
	}
	
	// ANZT\bh
	public void setTxtHolidayYear(String txtHolidayYear) {
		this.txtHolidayYear = txtHolidayYear;
	}
	
	public void setPltHolidayMonth(String pltHolidayMonth) {
		this.pltHolidayMonth = pltHolidayMonth;
	}
	
	public void setPltHolidayDay(String pltHolidayDay) {
		this.pltHolidayDay = pltHolidayDay;
	}
	
	public void setTxtHolidayName(String txtHolidayName) {
		this.txtHolidayName = txtHolidayName;
	}
	
	public String getTxtHolidayYear() {
		return txtHolidayYear;
	}
	
	public String getPltHolidayMonth() {
		return pltHolidayMonth;
	}
	
	public String getPltHolidayDay() {
		return pltHolidayDay;
	}
	
	public String getTxtHolidayName() {
		return txtHolidayName;
	}
	
	public String getEscTxtHolidayYear() {
		return escapeHTML(txtHolidayYear);
	}
	
	public String getEscTxtHolidayName() {
		return escapeHTML(txtHolidayName);
	}
	
	public void setMode(int mode) {
		this.mode = mode;
	}
	
}
