/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.system.vo;

import javax.servlet.http.HttpServletRequest;

import jp.mosp.common.CommonConst;
import jp.mosp.common.MosPVo;
import jp.mosp.common.common.MospException;
import jp.mosp.common.utils.TimeUtil;
import jp.mosp.kintai.common.dto.CmWorkTypeDto;

/**
 * @author yoshida
 *
 */
public class WorkTypeMasterCardVo extends MosPVo {
	
	private static final long	serialVersionUID	= 4784515918527934322L;
	
	// 萔
	/**
	 * 
	 */
	public static final int		MODE_INSERT			= 0;
	/**
	 * 
	 */
	public static final int		MODE_UPDATE			= 1;
	
	// p[^
	/**
	 * 
	 */
	public static final String	PRM_TXT_SHIFT_CODE	= "txtShiftCode";
	/**
	 * 
	 */
	public static final String	PRM_TXT_SHIFT_NAME	= "txtShiftName";
	/**
	 * 
	 */
	public static final String	PRM_TXT_START_HOUR	= "txtStartHour";
	/**
	 * 
	 */
	public static final String	PRM_TXT_START_MIN	= "txtStartMin";
	/**
	 * 
	 */
	public static final String	PRM_TXT_QUIT_HOUR	= "txtQuitHour";
	/**
	 * 
	 */
	public static final String	PRM_TXT_QUIT_MIN	= "txtQuitMin";
	/**
	 * 
	 */
	public static final String	PRM_TXT_WORK_HOUR	= "txtWorkHour";
	/**
	 * 
	 */
	public static final String	PRM_TXT_WORK_MIN	= "txtWorkMin";
	/**
	 * 
	 */
	public static final String	PRM_TXT_BREAK_HOUR	= "txtBreakHour";
	/**
	 * 
	 */
	public static final String	PRM_TXT_BREAK_MIN	= "txtBreakMin";
	/*						
	 *  	2009/10/07	m.yoshida	@cƑΉ
	 */
	/*
	public static final String PRM_TXT_OVER_START_HOUR 	= "txtOverStartHour";
	public static final String PRM_TXT_OVER_START_MIN 		= "txtOverStartMin";
	public static final String PRM_TXT_OVER_BREAK_HOUR 	= "txtOverBreakHour";
	public static final String PRM_TXT_OVER_BREAK_MIN 		= "txtOverBreakMin";
	 */
	/**
	 * 
	 */
	public static final String	PRM_TXT_OPTION1		= "txtOption1";
	/**
	 * 
	 */
	public static final String	PRM_TXT_OPTION2		= "txtOption2";
	/**
	 * 
	 */
	public static final String	PRM_TXT_OPTION3		= "txtOption3";
	/**
	 * 
	 */
	public static final String	PRM_TXT_OPTION4		= "txtOption4";
	/**
	 * 
	 */
	public static final String	PRM_TXT_OPTION5		= "txtOption5";
	/**
	 * 
	 */
	public static final String	PRM_PLT_DELETE		= "pltDelete";
	
	// tB[h
	private String				txtShiftCode;
	private String				txtShiftName;
	private String				txtStartHour;
	private String				txtStartMin;
	private String				txtQuitHour;
	private String				txtQuitMin;
	private String				txtWorkHour;
	private String				txtWorkMin;
	private String				txtBreakHour;
	private String				txtBreakMin;
	/*						
	 *  	2009/10/07	m.yoshida	@cƑΉ
	 */
	/*
	private String txtOverStartHour;
	private String txtOverStartMin;
	private String txtOverBreakHour;
	private String txtOverBreakMin;
	 */
	private String				txtOption1;
	private String				txtOption2;
	private String				txtOption3;
	private String				txtOption4;
	private String				txtOption5;
	private String				pltDelete;
	
	// [h(0FVKo^A1FXV)
	private int					mode;
	
	// tB[hyѐ
	/**
	 * 
	 */
	public String				NAM_SHIFT_CODE;
	/**
	 * 
	 */
	public String				NAM_SHIFT_NAME;
	/**
	 * 
	 */
	public String				NAM_START_TIME;
	/**
	 * 
	 */
	public String				NAM_START_TIME_HOUR;
	/**
	 * 
	 */
	public String				NAM_START_TIME_MIN;
	/**
	 * 
	 */
	public String				NAM_QUIT_TIME;
	/**
	 * 
	 */
	public String				NAM_QUIT_TIME_HOUR;
	/**
	 * 
	 */
	public String				NAM_QUIT_TIME_MIN;
	/**
	 * 
	 */
	public String				NAM_WORKING_HOURS;
	/**
	 * 
	 */
	public String				NAM_WORKING_HOURS_HOUR;
	/**
	 * 
	 */
	public String				NAM_WORKING_HOURS_MIN;
	/**
	 * 
	 */
	public String				NAM_BREAK_TIME;
	/**
	 * 
	 */
	public String				NAM_BREAK_TIME_HOUR;
	/**
	 * 
	 */
	public String				NAM_BREAK_TIME_MIN;
	/*						
	 *  	2009/10/07	m.yoshida	@cƑΉ
	 */
	/*
	public String NAM_OVERTIME_START;
	public String NAM_OVERTIME_START_HOUR;
	public String NAM_OVERTIME_START_MIN;
	public String NAM_OVERTIME_BREAK;
	public String NAM_OVERTIME_BREAK_HOUR;
	public String NAM_OVERTIME_BREAK_MIN;
	 */
	/**
	 * 
	 */
	public String				NAM_OPTION;
	/**
	 * 
	 */
	public String				NAM_LIMIT;
	/**
	 * 
	 */
	public String				NAM_DELETE;
	/**
	 * 
	 */
	public String				MSG_QUIT_TIME_NEXT_DAY;
	/**
	 * 
	 */
	public int					LEN_TIME;
	/**
	 * 
	 */
	public int					LEN_SHIFT_CODE;
	/**
	 * 
	 */
	public int					LEN_SHIFT_NAME;
	/**
	 * 
	 */
	public String				REG_DELETE;
	
	// J
	private double				limitPerDay;
	

	/**
	 * RXgN^
	 */
	public WorkTypeMasterCardVo() {
		super();
		mode = 0;
		limitPerDay = 0;
		setViewPath(getClassName());
	}
	
	@Override
	protected void setSubTitle() {
		subTitle = CommonConst.TTL_WORK_TYPE_MASTER;
		createAryMenu(CMD_MENU_SYSTEM2);
	}
	
	@Override
	protected void setFieldsName() {
		NAM_SHIFT_CODE = CommonConst.NAM_WORKING_TYPE + CommonConst.NAM_COMMON_CODE;
		NAM_SHIFT_NAME = CommonConst.NAM_WORKING_TYPE + CommonConst.NAM_COMMON_MEISYO;
		NAM_START_TIME = CommonConst.NAM_PRESENCE + CommonConst.NAM_TIME;
		NAM_START_TIME_HOUR = NAM_START_TIME + CommonConst.MSG_HOUR;
		NAM_START_TIME_MIN = NAM_START_TIME + CommonConst.MSG_MINUTES;
		NAM_QUIT_TIME = CommonConst.NAM_QUIT_TIME + CommonConst.NAM_TIME;
		NAM_QUIT_TIME_HOUR = NAM_QUIT_TIME + CommonConst.MSG_HOUR;
		NAM_QUIT_TIME_MIN = NAM_QUIT_TIME + CommonConst.MSG_MINUTES;
		NAM_WORKING_HOURS = CommonConst.NAM_WORKING + CommonConst.NAM_COMMON_TIME;
		NAM_WORKING_HOURS_HOUR = NAM_WORKING_HOURS + CommonConst.MSG_HOUR;
		NAM_WORKING_HOURS_MIN = NAM_WORKING_HOURS + CommonConst.MSG_MINUTES;
		NAM_BREAK_TIME = CommonConst.NAM_INTERVAL_TIME + CommonConst.NAM_COMMON_TIME;
		NAM_BREAK_TIME_HOUR = NAM_BREAK_TIME + CommonConst.MSG_HOUR;
		NAM_BREAK_TIME_MIN = NAM_BREAK_TIME + CommonConst.MSG_MINUTES;
		/*						
		 *  	2009/10/07	m.yoshida	@cƑΉ
		 */
		/*
		NAM_OVERTIME_START 			= CommonConst.NAM_OVERTIME + CommonConst.NAM_START + CommonConst.NAM_COMMON_TIME;
		NAM_OVERTIME_START_HOUR 	= NAM_OVERTIME_START + CommonConst.MSG_HOUR;
		NAM_OVERTIME_START_MIN 		= NAM_OVERTIME_START + CommonConst.MSG_MINUTES;
		NAM_OVERTIME_BREAK 			= CommonConst.NAM_OVERTIME + CommonConst.NAM_INTERVAL_TIME + CommonConst.NAM_COMMON_TIME;
		NAM_OVERTIME_BREAK_HOUR 	= NAM_OVERTIME_BREAK + CommonConst.MSG_HOUR;
		NAM_OVERTIME_BREAK_MIN 		= NAM_OVERTIME_BREAK + CommonConst.MSG_MINUTES;
		 */
		NAM_OPTION = CommonConst.NAM_OPTION;
		NAM_LIMIT = CommonConst.NAM_STATUTORY_HOUR;
		NAM_DELETE = CommonConst.NAM_DELETE_FLAG;
		MSG_QUIT_TIME_NEXT_DAY = CommonConst.MSG_QUIT_TIME_NEXT_DAY;
		LEN_TIME = CommonConst.LEN_TIME_MIN;
		LEN_SHIFT_CODE = 10;
		LEN_SHIFT_NAME = 6;
		REG_DELETE = CommonConst.REG_DELETE;
	}
	
	/**
	 * lݒ
	 */
	public void setDefaultValues() {
		setTxtShiftCode("");
		setTxtShiftName("");
		setTxtStartHour("0");
		setTxtStartMin("0");
		setTxtQuitHour("0");
		setTxtQuitMin("0");
		setTxtWorkHour("0");
		setTxtWorkMin("0");
		setTxtBreakHour("0");
		setTxtBreakMin("0");
		/*						
		 *  	2009/10/07	m.yoshida	@cƑΉ
		 */
		/*
		setTxtOverStartHour("0");
		setTxtOverStartMin("0");
		setTxtOverBreakHour("0");
		setTxtOverBreakMin("0");
		 */
		setTxtOption1("");
		setTxtOption2("");
		setTxtOption3("");
		setTxtOption4("");
		setTxtOption5("");
		setPltDelete("0");
	}
	
	/**
	 * p[^ݒ
	 */
	@Override
	public void setParams(HttpServletRequest request) {
		txtShiftCode = request.getParameter(PRM_TXT_SHIFT_CODE);
		txtShiftName = request.getParameter(PRM_TXT_SHIFT_NAME);
		txtStartHour = request.getParameter(PRM_TXT_START_HOUR);
		txtStartMin = request.getParameter(PRM_TXT_START_MIN);
		txtQuitHour = request.getParameter(PRM_TXT_QUIT_HOUR);
		txtQuitMin = request.getParameter(PRM_TXT_QUIT_MIN);
		txtWorkHour = request.getParameter(PRM_TXT_WORK_HOUR);
		txtWorkMin = request.getParameter(PRM_TXT_WORK_MIN);
		txtBreakHour = request.getParameter(PRM_TXT_BREAK_HOUR);
		txtBreakMin = request.getParameter(PRM_TXT_BREAK_MIN);
		/*						
		 *  	2009/10/07	m.yoshida	@cƑΉ
		 */
		/*
		txtOverStartHour 	= request.getParameter(PRM_TXT_OVER_START_HOUR);
		txtOverStartMin 	= request.getParameter(PRM_TXT_OVER_START_MIN);
		txtOverBreakHour 	= request.getParameter(PRM_TXT_OVER_BREAK_HOUR);
		txtOverBreakMin 	= request.getParameter(PRM_TXT_OVER_BREAK_MIN);
		 */
		txtOption1 = request.getParameter(PRM_TXT_OPTION1);
		txtOption2 = request.getParameter(PRM_TXT_OPTION2);
		txtOption3 = request.getParameter(PRM_TXT_OPTION3);
		txtOption4 = request.getParameter(PRM_TXT_OPTION4);
		txtOption5 = request.getParameter(PRM_TXT_OPTION5);
		pltDelete = request.getParameter(PRM_PLT_DELETE);
	}
	
	/**
	 * tB[hݒ
	 * @param dto ΏDTO
	 */
	public void setFields(CmWorkTypeDto dto) {
		txtShiftCode = dto.getShiftCode();
		txtShiftName = dto.getShiftName();
		txtStartHour = TimeUtil.convIntegerTimeToStringHour(dto.getStartTime());
		txtStartMin = TimeUtil.convIntegerTimeToStringMinutes(dto.getStartTime());
		txtQuitHour = TimeUtil.convIntegerTimeToStringHour(dto.getQuitTime());
		txtQuitMin = TimeUtil.convIntegerTimeToStringMinutes(dto.getQuitTime());
		txtWorkHour = TimeUtil.convIntegerTimeToStringHour(dto.getWorkTime());
		txtWorkMin = TimeUtil.convIntegerTimeToStringMinutes(dto.getWorkTime());
		txtBreakHour = TimeUtil.convIntegerTimeToStringHour(dto.getBreakTime());
		txtBreakMin = TimeUtil.convIntegerTimeToStringMinutes(dto.getBreakTime());
		/*						
		 *  	2009/10/07	m.yoshida	@cƑΉ
		 */
		/*
		txtOverStartHour 	= TimePart.convIntegerTimeToStringHour(dto.getOverStart());
		txtOverStartMin 	= TimePart.convIntegerTimeToStringMinutes(dto.getOverStart());
		txtOverBreakHour 	= TimePart.convIntegerTimeToStringHour(dto.getOverBreak());
		txtOverBreakMin 	= TimePart.convIntegerTimeToStringMinutes(dto.getOverBreak());
		 */
		txtOption1 = dto.getOption1();
		txtOption2 = dto.getOption2();
		txtOption3 = dto.getOption3();
		txtOption4 = dto.getOption4();
		txtOption5 = dto.getOption5();
		pltDelete = String.valueOf(dto.getDeleteFlag());
	}
	
	/**
	 * tB[hݒ(DTOɑ΂VÕZbg)
	 * @param dto ݒΏDTO
	 */
	public void setDtoFields(CmWorkTypeDto dto) {
		dto.setShiftCode(txtShiftCode);
		dto.setShiftName(txtShiftName);
		dto.setStartTime(TimeUtil.convStringTimeToIntegerTime(txtStartHour, txtStartMin));
		dto.setQuitTime(TimeUtil.convStringTimeToIntegerTime(txtQuitHour, txtQuitMin));
		dto.setWorkTime(TimeUtil.convStringTimeToIntegerTime(txtWorkHour, txtWorkMin));
		dto.setBreakTime(TimeUtil.convStringTimeToIntegerTime(txtBreakHour, txtBreakMin));
		/*						
		 *  	2009/10/07	m.yoshida	@cƑΉ
		 */
		/*		
		dto.setOverStart(TimePart.convStringTimeToIntegerTime(txtOverStartHour, txtOverStartMin));
		dto.setOverBreak(TimePart.convStringTimeToIntegerTime(txtOverBreakHour, txtOverBreakMin));
		 */
		dto.setOption1(txtOption1);
		dto.setOption2(txtOption2);
		dto.setOption3(txtOption3);
		dto.setOption4(txtOption4);
		dto.setOption5(txtOption5);
		dto.setDeleteFlag(Integer.parseInt(pltDelete));
	}
	
	/**
	 * tB[h̑ÓmF
	 * @throws MospException MosPOꍇ
	 */
	public void validate() throws MospException {
		// ÓmFJn
		startValidation();
		// K{mF
		checkRequired(txtShiftCode, NAM_SHIFT_CODE, PRM_TXT_SHIFT_CODE);
		checkRequired(txtShiftName, NAM_SHIFT_NAME, PRM_TXT_SHIFT_NAME);
		checkRequired(txtStartHour, NAM_START_TIME_HOUR, PRM_TXT_START_HOUR);
		checkRequired(txtStartMin, NAM_START_TIME_MIN, PRM_TXT_START_MIN);
		checkRequired(txtQuitHour, NAM_QUIT_TIME_HOUR, PRM_TXT_QUIT_HOUR);
		checkRequired(txtQuitMin, NAM_QUIT_TIME_MIN, PRM_TXT_QUIT_MIN);
		checkRequired(txtWorkHour, NAM_WORKING_HOURS_HOUR, PRM_TXT_WORK_HOUR);
		checkRequired(txtWorkMin, NAM_WORKING_HOURS_MIN, PRM_TXT_WORK_MIN);
		checkRequired(txtBreakHour, NAM_BREAK_TIME_HOUR, PRM_TXT_BREAK_HOUR);
		checkRequired(txtBreakMin, NAM_BREAK_TIME_MIN, PRM_TXT_BREAK_MIN);
		/*						
		 *  	2009/10/07	m.yoshida	@cƑΉ
		 */
		/*
		checkRequired(txtOverStartHour	, NAM_OVERTIME_START_HOUR	, PRM_TXT_OVER_START_HOUR);
		checkRequired(txtOverStartMin	, NAM_OVERTIME_START_MIN	, PRM_TXT_OVER_START_MIN);
		checkRequired(txtOverBreakHour	, NAM_OVERTIME_BREAK_HOUR	, PRM_TXT_OVER_BREAK_HOUR);
		checkRequired(txtOverBreakMin	, NAM_OVERTIME_BREAK_MIN	, PRM_TXT_OVER_BREAK_MIN);
		 */
		// 񒷊mF
		checkLength(txtShiftCode, LEN_SHIFT_CODE, NAM_SHIFT_CODE, PRM_TXT_SHIFT_CODE);
		checkLength(txtShiftName, LEN_SHIFT_NAME, NAM_SHIFT_NAME, PRM_TXT_SHIFT_NAME);
		checkLength(txtStartHour, LEN_TIME, NAM_START_TIME_HOUR, PRM_TXT_START_HOUR);
		checkLength(txtStartMin, LEN_TIME, NAM_START_TIME_MIN, PRM_TXT_START_MIN);
		checkLength(txtQuitHour, LEN_TIME, NAM_QUIT_TIME_HOUR, PRM_TXT_QUIT_HOUR);
		checkLength(txtQuitMin, LEN_TIME, NAM_QUIT_TIME_MIN, PRM_TXT_QUIT_MIN);
		checkLength(txtWorkHour, LEN_TIME, NAM_WORKING_HOURS_HOUR, PRM_TXT_WORK_HOUR);
		checkLength(txtWorkMin, LEN_TIME, NAM_WORKING_HOURS_MIN, PRM_TXT_WORK_MIN);
		checkLength(txtBreakHour, LEN_TIME, NAM_BREAK_TIME_HOUR, PRM_TXT_BREAK_HOUR);
		checkLength(txtBreakMin, LEN_TIME, NAM_BREAK_TIME_MIN, PRM_TXT_BREAK_MIN);
		/*						
		 *  	2009/10/07	m.yoshida	@cƑΉ
		 */
		/*
		checkLength(txtOverStartHour, LEN_TIME			, NAM_OVERTIME_START_HOUR	, PRM_TXT_OVER_START_HOUR);
		checkLength(txtOverStartMin	, LEN_TIME			, NAM_OVERTIME_START_MIN	, PRM_TXT_OVER_START_MIN);
		checkLength(txtOverBreakHour, LEN_TIME			, NAM_OVERTIME_BREAK_HOUR	, PRM_TXT_OVER_BREAK_HOUR);
		checkLength(txtOverBreakMin	, LEN_TIME			, NAM_OVERTIME_BREAK_MIN	, PRM_TXT_OVER_BREAK_MIN);
		 */
		// mF
		checkNumber(txtStartHour, NAM_START_TIME_HOUR, PRM_TXT_START_HOUR);
		checkNumber(txtStartMin, NAM_START_TIME_MIN, PRM_TXT_START_MIN);
		checkNumber(txtQuitHour, NAM_QUIT_TIME_HOUR, PRM_TXT_QUIT_HOUR);
		checkNumber(txtQuitMin, NAM_QUIT_TIME_MIN, PRM_TXT_QUIT_MIN);
		checkNumber(txtWorkHour, NAM_WORKING_HOURS_HOUR, PRM_TXT_WORK_HOUR);
		checkNumber(txtWorkMin, NAM_WORKING_HOURS_MIN, PRM_TXT_WORK_MIN);
		checkNumber(txtBreakHour, NAM_BREAK_TIME_HOUR, PRM_TXT_BREAK_HOUR);
		checkNumber(txtBreakMin, NAM_BREAK_TIME_MIN, PRM_TXT_BREAK_MIN);
		/*						
		 *  	2009/10/07	m.yoshida	@cƑΉ
		 */
		/*
		checkNumber(txtOverStartHour, NAM_OVERTIME_START_HOUR	, PRM_TXT_OVER_START_HOUR);
		checkNumber(txtOverStartMin	, NAM_OVERTIME_START_MIN	, PRM_TXT_OVER_START_MIN);
		checkNumber(txtOverBreakHour, NAM_OVERTIME_BREAK_HOUR	, PRM_TXT_OVER_BREAK_HOUR);
		checkNumber(txtOverBreakMin	, NAM_OVERTIME_BREAK_MIN	, PRM_TXT_OVER_BREAK_MIN);
		 */
		// ÓmFI
		endValidation();
	}
	
	@Override
	public String getDirectJs(Class<?> cls, Object obj) throws IllegalAccessException {
		StringBuffer sb = new StringBuffer();
		sb.append(super.getDirectJs(cls, obj));
		sb.append("var MODE = ");
		sb.append(mode);
		sb.append(";");
		sb.append("var LIMIT = ");
		sb.append(limitPerDay);
		sb.append(";");
		return sb.toString();
	}
	
	// ANZT\bh
	public void setTxtShiftCode(String txtShiftCode) {
		this.txtShiftCode = txtShiftCode;
	}
	
	public void setTxtShiftName(String txtShiftName) {
		this.txtShiftName = txtShiftName;
	}
	
	public void setTxtStartHour(String txtStartHour) {
		this.txtStartHour = txtStartHour;
	}
	
	public void setTxtStartMin(String txtStartMin) {
		this.txtStartMin = txtStartMin;
	}
	
	public void setTxtQuitHour(String txtQuitHour) {
		this.txtQuitHour = txtQuitHour;
	}
	
	public void setTxtQuitMin(String txtQuitMin) {
		this.txtQuitMin = txtQuitMin;
	}
	
	public void setTxtWorkHour(String txtWorkHour) {
		this.txtWorkHour = txtWorkHour;
	}
	
	public void setTxtWorkMin(String txtWorkMin) {
		this.txtWorkMin = txtWorkMin;
	}
	
	public void setTxtBreakHour(String txtBreakHour) {
		this.txtBreakHour = txtBreakHour;
	}
	
	public void setTxtBreakMin(String txtBreakMin) {
		this.txtBreakMin = txtBreakMin;
	}
	
	/*						
	 *  	2009/10/07	m.yoshida	@cƑΉ
	 */
	/*
	public void setTxtOverStartHour	(String txtOverStartHour) { this.txtOverStartHour	= txtOverStartHour 	; }
	public void setTxtOverStartMin 	(String txtOverStartMin	) { this.txtOverStartMin	= txtOverStartMin 	; }
	public void setTxtOverBreakHour	(String txtOverBreakHour) { this.txtOverBreakHour	= txtOverBreakHour 	; }
	public void setTxtOverBreakMin 	(String txtOverBreakMin	) { this.txtOverBreakMin 	= txtOverBreakMin 	; }
	 */
	public void setTxtOption1(String txtOption1) {
		this.txtOption1 = txtOption1;
	}
	
	public void setTxtOption2(String txtOption2) {
		this.txtOption2 = txtOption2;
	}
	
	public void setTxtOption3(String txtOption3) {
		this.txtOption3 = txtOption3;
	}
	
	public void setTxtOption4(String txtOption4) {
		this.txtOption4 = txtOption4;
	}
	
	public void setTxtOption5(String txtOption5) {
		this.txtOption5 = txtOption5;
	}
	
	public void setPltDelete(String pltDelete) {
		this.pltDelete = pltDelete;
	}
	
	public String getEscTxtShiftCode() {
		return escapeHTML(txtShiftCode);
	}
	
	public String getEscTxtShiftName() {
		return escapeHTML(txtShiftName);
	}
	
	public String getEscTxtStartHour() {
		return escapeHTML(txtStartHour);
	}
	
	public String getEscTxtStartMin() {
		return escapeHTML(txtStartMin);
	}
	
	public String getEscTxtQuitHour() {
		return escapeHTML(txtQuitHour);
	}
	
	public String getEscTxtQuitMin() {
		return escapeHTML(txtQuitMin);
	}
	
	public String getEscTxtWorkHour() {
		return escapeHTML(txtWorkHour);
	}
	
	public String getEscTxtWorkMin() {
		return escapeHTML(txtWorkMin);
	}
	
	public String getEscTxtBreakHour() {
		return escapeHTML(txtBreakHour);
	}
	
	public String getEscTxtBreakMin() {
		return escapeHTML(txtBreakMin);
	}
	
	/*						
	 *  	2009/10/07	m.yoshida	@cƑΉ
	 */
	/*
	public String getEscTxtOverStartHour ()	{ return escapeHTML(txtOverStartHour) 	; }
	public String getEscTxtOverStartMin ()	{ return escapeHTML(txtOverStartMin) 	; }
	public String getEscTxtOverBreakHour ()	{ return escapeHTML(txtOverBreakHour) 	; }
	public String getEscTxtOverBreakMin () 	{ return escapeHTML(txtOverBreakMin) 	; }
	 */
	public String getEscTxtOption1() {
		return escapeHTML(txtOption1);
	}
	
	public String getEscTxtOption2() {
		return escapeHTML(txtOption2);
	}
	
	public String getEscTxtOption3() {
		return escapeHTML(txtOption3);
	}
	
	public String getEscTxtOption4() {
		return escapeHTML(txtOption4);
	}
	
	public String getEscTxtOption5() {
		return escapeHTML(txtOption5);
	}
	
	public String getTxtShiftCode() {
		return txtShiftCode;
	}
	
	public String getTxtShiftName() {
		return txtShiftName;
	}
	
	public String getTxtStartHour() {
		return txtStartHour;
	}
	
	public String getTxtStartMin() {
		return txtStartMin;
	}
	
	public String getTxtQuitHour() {
		return txtQuitHour;
	}
	
	public String getTxtQuitMin() {
		return txtQuitMin;
	}
	
	public String getTxtWorkHour() {
		return txtWorkHour;
	}
	
	public String getTxtWorkMin() {
		return txtWorkMin;
	}
	
	public String getTxtBreakHour() {
		return txtBreakHour;
	}
	
	public String getTxtBreakMin() {
		return txtBreakMin;
	}
	
	/*						
	 *  	2009/10/07	m.yoshida	@cƑΉ
	 */
	/*
	public String getTxtOverStartHour()	{ return txtOverStartHour 	; }
	public String getTxtOverStartMin ()	{ return txtOverStartMin 	; }
	public String getTxtOverBreakHour()	{ return txtOverBreakHour 	; }
	public String getTxtOverBreakMin ()	{ return txtOverBreakMin 	; }
	 */
	public String getTxtOption1() {
		return txtOption1;
	}
	
	public String getTxtOption2() {
		return txtOption2;
	}
	
	public String getTxtOption3() {
		return txtOption3;
	}
	
	public String getTxtOption4() {
		return txtOption4;
	}
	
	public String getTxtOption5() {
		return txtOption5;
	}
	
	public String getPltDelete() {
		return pltDelete;
	}
	
	public void setMode(int mode) {
		this.mode = mode;
	}
	
	public int getMode() {
		return mode;
	}
	
	public double getLimitPerDay() {
		return limitPerDay;
	}
	
	public void setLimitPerDay(double limitPerDay) {
		this.limitPerDay = limitPerDay;
	}
	
}
