/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.system.vo;

import java.util.Iterator;
import java.util.List;

import javax.servlet.http.HttpServletRequest;

import jp.mosp.common.CommonConst;
import jp.mosp.common.MosPVo;
import jp.mosp.kintai.common.dto.MYakusyokuDto;

/**
 * @author yoshida
 *
 */
public class YakusyokuMasterListVo extends MosPVo {
	
	private static final long	serialVersionUID	= -751062849161954119L;
	
	// 萔
	/**
	 * 
	 */
	public static final int		SEARCH_OFF			= 0;
	/**
	 * 
	 */
	public static final int		SEARCH_ON			= 1;
	
	// p[^
	/**
	 * 
	 */
	public static final String	PRM_TXT_YCODE		= "txtYCode";
	/**
	 * 
	 */
	public static final String	PRM_TXT_YNAME		= "txtYName";
	/**
	 * 
	 */
	public static final String	PRM_PLT_TOKYU		= "pltTokyu";
	
	// tB[h	
	private String[]			aryYCode;
	private String[]			aryTokyu;
	private String[]			aryTokyuName;
	private String[]			aryYName;
	private String				txtYCode;
	private String				txtYName;
	private String				pltTokyu;
	
	// tB[hyѐ
	/**
	 * 
	 */
	public String				NAM_YCODE;
	/**
	 * 
	 */
	public String				NAM_TOKYU;
	/**
	 * 
	 */
	public String				NAM_YNAME;
	/**
	 * 
	 */
	public int					LEN_YCODE;
	/**
	 * 
	 */
	public int					LEN_YNAME;
	
	// v_EXg
	/**
	 * 
	 */
	public String[][]			aryPltTokyu;
	
	// \[gL[
	/**
	 * 
	 */
	public final String			KEY_YCODE			= "keyYCode";
	/**
	 * 
	 */
	public final String			KEY_TOKYU			= "keyTokyu";
	/**
	 * 
	 */
	public final String			KEY_YNAME			= "keyYName";
	
	// [h(0FȂA1F)
	private int					searchmode;
	

	/**
	 * RXgN^
	 */
	public YakusyokuMasterListVo() {
		super();
		setViewPath(getClassName());
		aryYCode = new String[0];
		aryTokyu = new String[0];
		aryTokyuName = new String[0];
		aryYName = new String[0];
		txtYCode = "";
		txtYName = "";
		pltTokyu = "";
		setFormerKey(KEY_YCODE);
	}
	
	@Override
	protected void setSubTitle() {
		subTitle = CommonConst.TTL_POSITION_MASTER;
		aryMenu = new String[][]{ { CMD_MENU_SYSTEM2, CommonConst.NAM_TO_MENU } };
	}
	
	@Override
	protected void setFieldsName() {
		NAM_YCODE = CommonConst.NAM_POSITION1 + CommonConst.NAM_COMMON_CODE;
		NAM_TOKYU = CommonConst.NAM_GRADE;
		NAM_YNAME = CommonConst.NAM_COMMON_MEISYO;
		LEN_YCODE = 5;
		LEN_YNAME = 20;
	}
	
	@Override
	public void setParams(HttpServletRequest request) {
		txtYCode = request.getParameter(PRM_TXT_YCODE);
		txtYName = request.getParameter(PRM_TXT_YNAME);
		pltTokyu = request.getParameter(PRM_PLT_TOKYU);
	}
	
	/**
	 * tB[hݒ
	 * @param listPosition		EXg
	 */
	@Override
	public void setFields(List<?> listPosition) {
		// Xg̐ݒ
		list = listPosition;
		// f[^̎擾
		count = listPosition.size();
		// z̏
		aryYCode = new String[count];
		aryYName = new String[count];
		aryTokyu = new String[count];
		aryTokyuName = new String[count];
		// f[^̐ݒ
		int i = 0;
		Iterator<?> it = listPosition.iterator();
		while (it.hasNext()) {
			MYakusyokuDto dto = (MYakusyokuDto)it.next();
			aryYCode[i] = escapeHTML(dto.getYcode());
			aryYName[i] = escapeHTML(dto.getYname());
			aryTokyu[i] = escapeHTML(dto.getTokyu());
			aryTokyuName[i] = escapeHTML(getCodeName(dto.getTokyu(), aryPltTokyu));
			i++;
		}
	}
	
	// ANZT\bh	
	/**
	 * @return txtYCode
	 */
	public String getEscTxtYCode() {
		return escapeHTML(txtYCode);
	}
	
	/**
	 * @return txtYName
	 */
	public String getEscTxtYName() {
		return escapeHTML(txtYName);
	}
	
	/**
	 * @return pltTokyu
	 */
	public String getEscPltTokyu() {
		return escapeHTML(pltTokyu);
	}
	
	/**
	 * @return aryYCode
	 */
	public String[] getAryYCode() {
		return aryYCode.clone();
	}
	
	/**
	 * @return aryTokyu
	 */
	public String[] getAryTokyu() {
		return aryTokyu.clone();
	}
	
	/**
	 * @return aryTokyuName
	 */
	public String[] getAryTokyuName() {
		return aryTokyuName.clone();
	}
	
	/**
	 * @return aryYName
	 */
	public String[] getAryYName() {
		return aryYName.clone();
	}
	
	/**
	 * @return txtYCode
	 */
	public String getTxtYCode() {
		return txtYCode;
	}
	
	/**
	 * @return txtYName
	 */
	public String getTxtYName() {
		return txtYName;
	}
	
	/**
	 * @return pltTokyu
	 */
	public String getPltTokyu() {
		return pltTokyu;
	}
	
	/**
	 * @return searchmode
	 */
	public int getSearchmode() {
		return searchmode;
	}
	
	/**
	 * @param txtYCode Zbg txtYCode
	 */
	public void setTxtYCode(String txtYCode) {
		this.txtYCode = txtYCode;
	}
	
	/**
	 * @param txtYName Zbg txtYName
	 */
	public void setTxtYName(String txtYName) {
		this.txtYName = txtYName;
	}
	
	/**
	 * @param pltTokyu Zbg pltTokyu
	 */
	public void setPltTokyu(String pltTokyu) {
		this.pltTokyu = pltTokyu;
	}
	
	/**
	 * @param searchmode Zbg searchmode
	 */
	public void setSearchmode(int searchmode) {
		this.searchmode = searchmode;
	}
	
}
