/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.workflow.action;

import jp.mosp.common.CommonConst;
import jp.mosp.common.MosPAction;
import jp.mosp.common.MosPMenuConst;
import jp.mosp.common.common.BaseVo;
import jp.mosp.common.utils.StringUtil;
import jp.mosp.workflow.vo.ManagerApprovalMenuVo;

/**
 * @author yoshida
 *
 */
public class ManagerApprovalMenuAction extends MosPAction {
	
	/**
	 * RXgN^
	 */
	public ManagerApprovalMenuAction() {
		super();
	}
	
	public void action() throws Exception {
		// VȌ
		prepareVo(false);
		// 
		init();
		// \
		show();
	}
	
	@Override
	protected BaseVo getSpecificVo() {
		return new ManagerApprovalMenuVo();
	}
	
	@Override
	protected void init() throws Exception {
		// ZbVێ̏
		initStoredData();
	}
	
	@Override
	protected void show() throws Exception {
		ManagerApprovalMenuVo vo = (ManagerApprovalMenuVo)getVo();
		String[][] aryApplication = new String[0][0];
		if (isAttendanceApprovalFunction()) {
			aryApplication = StringUtil.combineArray(MosPMenuConst.getApprovalCmdArray(),
					getMosPCodeArray(CommonConst.TID_APPROVAL_MENU));
		} else {
			// ΑӏF@\ꍇ̃bZ[Wݒ
			addErrMessage(CommonConst.MSG_ATTENDANCE_APPROVAL_FUNCTION3);
		}
		// j[{^ꗗ
		vo.setFields(aryApplication);
	}
	
}
