/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.workflow.action;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;

import jp.mosp.common.common.BaseVo;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.common.MospUtility;
import jp.mosp.common.utils.DateUtil;
import jp.mosp.common.utils.StringUtil;
import jp.mosp.common.utils.TimeUtil;
import jp.mosp.kintai.common.action.MosPWorkflowAction;
import jp.mosp.kintai.common.part.KintaiApprovalPart;
import jp.mosp.workflow.dto.CtOvertimeRequestDto;
import jp.mosp.workflow.dto.OverTimeRequestDto;
import jp.mosp.workflow.vo.OverTimeRequestListVo;

/**
 * @author yoshida
 *
 */
public class OverTimeRequestListAction extends MosPWorkflowAction {
	
	// R}h
	private static final String	CMD_LIST_SHOW		= "K1410";
	private static final String	CMD_LIST_SEARCH		= "K1411";
	/**
	 * 
	 */
	public static final String	CMD_LIST_RE_SEARCH	= "K1412";
	private static final String	CMD_LIST_SORT		= "K1413";
	

	/**
	 * RXgN^
	 */
	public OverTimeRequestListAction() {
		super();
	}
	
	public void action() throws Exception {
		// VȌ
		prepareVo();
		// 
		init();
		// R}h̏
		if (cmd.equals(CMD_LIST_SHOW)) {
			// 
			show();
		} else if (cmd.equals(CMD_LIST_SEARCH)) {
			// 
			search();
		} else if (cmd.equals(CMD_LIST_RE_SEARCH)) {
			// Č
			research();
		} else if (cmd.equals(CMD_LIST_SORT)) {
			// \[g
			sortList(key1);
		} else {
			throw new MospException(MospConst.EX_CMD_INVALID);
		}
	}
	
	@Override
	protected BaseVo getSpecificVo() {
		return new OverTimeRequestListVo();
	}
	
	@Override
	protected void init() throws Exception {
		// v_E̐ݒ
		OverTimeRequestListVo vo = (OverTimeRequestListVo)getVo();
		vo.aryPltYear = StringUtil.getYearArray(MospUtility.getYear(DateUtil.getSystemDate()));
		vo.aryPltMonth = StringUtil.getMonthArray();
		// [U̐ݒ
		getInfo(user.getUserId());
		setLabelBasisInfo(userBasis);
	}
	
	@Override
	protected void show() throws Exception {
		OverTimeRequestListVo vo = (OverTimeRequestListVo)getVo();
		Date todayDate = DateUtil.getSystemDate();
		vo.setPltYear(String.valueOf(MospUtility.getYear(todayDate)));
		vo.setPltMonth(String.valueOf(MospUtility.getMonth(todayDate)));
		searchList();
	}
	
	@Override
	protected void search() throws Exception {
		OverTimeRequestListVo vo = (OverTimeRequestListVo)getVo();
		vo.setParams(request);
		searchList();
	}
	
	@Override
	protected void research() throws Exception {
		OverTimeRequestListVo vo = (OverTimeRequestListVo)getVo();
		removeSessionDto();
		searchRequestList();
		vo.setPageButton();
		sortList();
	}
	
	/**
	 * ꗗ
	 * @throws Exception 	Oꍇ
	 */
	private void searchList() throws Exception {
		OverTimeRequestListVo vo = (OverTimeRequestListVo)getVo();
		// ɂꗗ擾
		searchRequestList();
		vo.setFormerKey(vo.KEY_WORK_DATE);
		vo.setIsAscending(true);
		vo.initListInfo();
	}
	
	/**
	 * ɂꗗݒ
	 * @throws Exception 	Oꍇ
	 */
	private void searchRequestList() throws Exception {
		OverTimeRequestListVo vo = (OverTimeRequestListVo)getVo();
		// JnN
		Date startDate = null;
		// IN
		Date endDate = null;
		if (StringUtil.isNotNull(vo.getPltMonth())) {
			startDate = DateUtil.getFirstDateOfMonth(vo.getPltYear(), vo.getPltMonth());
			endDate = DateUtil.getLastDateOfMonth(vo.getPltYear(), vo.getPltMonth());
		} else {
			startDate = DateUtil.getFirstDateOfYear(vo.getPltYear());
			endDate = DateUtil.getLastDateOfYear(vo.getPltYear());
		}
		// \ꗗ
		List<CtOvertimeRequestDto> overList = overTimeDao().findForCondition(userBasis.getKCode(), startDate, endDate);
		// \ꗗ
		List<OverTimeRequestDto> listRequest = new ArrayList<OverTimeRequestDto>();
		for (CtOvertimeRequestDto requestDto : overList) {
			OverTimeRequestDto dto = new OverTimeRequestDto(requestDto);
			// F
			dto.setApprovalStatus(getApprovalName(toKintaiApprovalStatus(dto.getWorkflow())));
			// FҖ
			String approverName = "";
			if (KintaiApprovalPart.is1stApproved(toKintaiApprovalStatus(dto.getWorkflow()))
					|| KintaiApprovalPart.is2ndApproved(toKintaiApprovalStatus(dto.getWorkflow()))) {
				approverName = getKName(getWorkflowDto(dto.getWorkflow()).getUpdateUser());
			}
			dto.setApproverName(approverName);
			listRequest.add(dto);
		}
		// VOɃZbg
		vo.setFields(listRequest);
		// IԎԊO
		vo.setLblOverTime(TimeUtil.convIntegerTimeToJPHours(part().kintai().getOverTimeForPeriod(userBasis.getKCode(),
				startDate, endDate)));
		// Ώۂꍇ̃bZ[Wݒ
		if (vo.getEscAryOverTime().length == 0) {
			vo.addErrMessage(getMessage(MospConst.MSG_NO_DATA, ""));
		}
	}
	
	@Override
	protected void sortList(String key) throws MospException {
		OverTimeRequestListVo vo = (OverTimeRequestListVo)getVo();
		vo.sortList(key, getComparator(key));
		vo.setFields(vo.getList());
	}
	
	@Override
	protected void sortList() throws MospException {
		OverTimeRequestListVo vo = (OverTimeRequestListVo)getVo();
		vo.sortList(getComparator(vo.getFormerKey()));
		vo.setFields(vo.getList());
	}
	
	@Override
	protected Comparator<Object> getComparator(String key) throws MospException {
		OverTimeRequestListVo vo = (OverTimeRequestListVo)getVo();
		Comparator<Object> comp = null;
		if (key.equals(vo.KEY_WORK_DATE)) {
			comp = new CompWorkDate();
		} else if (key.equals(vo.KEY_REQUEST_DATE)) {
			comp = new CompRequestDate();
		} else if (key.equals(vo.KEY_STATUS)) {
			comp = new CompStatus();
		} else if (key.equals(vo.KEY_APPROVER)) {
			comp = new CompApprover();
		} else {
			throw new MospException(MospConst.EX_SORTKEY_INVALID);
		}
		return comp;
	}
	

	/**
	 * ΖɂrNX
	 */
	protected static class CompWorkDate implements Comparator<Object>, Serializable {
		
		private static final long	serialVersionUID	= 9136870178985992803L;
		

		public int compare(Object obj1, Object obj2) {
			OverTimeRequestDto dto1 = (OverTimeRequestDto)obj1;
			OverTimeRequestDto dto2 = (OverTimeRequestDto)obj2;
			return dto1.getWorkDate().compareTo(dto2.getWorkDate());
		}
	}
	
	/**
	 * \ɂrNX
	 */
	protected static class CompRequestDate implements Comparator<Object>, Serializable {
		
		private static final long	serialVersionUID	= 818289320529127227L;
		

		public int compare(Object obj1, Object obj2) {
			OverTimeRequestDto dto1 = (OverTimeRequestDto)obj1;
			OverTimeRequestDto dto2 = (OverTimeRequestDto)obj2;
			return dto1.getRequestDate().compareTo(dto2.getRequestDate());
		}
	}
	
	/**
	 * F󋵂ɂrNX
	 */
	protected static class CompStatus implements Comparator<Object>, Serializable {
		
		private static final long	serialVersionUID	= 7143311063774870712L;
		

		public int compare(Object obj1, Object obj2) {
			OverTimeRequestDto dto1 = (OverTimeRequestDto)obj1;
			OverTimeRequestDto dto2 = (OverTimeRequestDto)obj2;
			return dto1.getApprovalStatus().compareTo(dto2.getApprovalStatus());
		}
	}
	
	/**
	 * F󋵂ɂrNX
	 */
	protected static class CompApprover implements Comparator<Object>, Serializable {
		
		private static final long	serialVersionUID	= 1923632050645529241L;
		

		public int compare(Object obj1, Object obj2) {
			OverTimeRequestDto dto1 = (OverTimeRequestDto)obj1;
			OverTimeRequestDto dto2 = (OverTimeRequestDto)obj2;
			return dto1.getApproverName().compareTo(dto2.getApproverName());
		}
	}
	
}
