<%--
MosP - Mind Open Source Project    http://www.mosp.jp/
Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
--%>
<%@ page
language     = "java"
pageEncoding = "Windows-31J"
buffer       = "16kb"
autoFlush    = "false"
errorPage    = "/jsp/common/error.jsp"
%><%@ page
import = "jp.mosp.common.common.MospConst"
import = "jp.mosp.common.common.HtmlUtility"
import = "jp.mosp.common.CommonConst"
import = "jp.mosp.common.common.BaseVo"
import = "jp.mosp.kintai.payroll.vo.SubHolidayCardVo"
%><%
SubHolidayCardVo vo = (SubHolidayCardVo)request.getAttribute(MospConst.ATT_VO);
%>
<%= HtmlUtility.getHeader(vo) %>
<%= HtmlUtility.getSubTitle(vo) %>
<div class="Body" id="subHolidayCard">
	<%= HtmlUtility.getMessages(vo) %>
	<div class="Card">
		<table>
			<tr>
				<td class="TitleTd"><%= vo.NAM_K_CODE %><%= CommonConst.STR_TITLE_SEPARATOR %></td>
				<td class="ViewTd" >
					<%= vo.getEscLblKCode() %>
				</td>
			</tr>
			<tr>
				<td class="TitleTd"><%= vo.NAM_K_NAME %><%= CommonConst.STR_TITLE_SEPARATOR %></td>
				<td class="ViewTd" >
					<%= vo.getEscLblKName() %>
				</td>
			</tr>
			<tr>
				<td class="TitleTd"><%= vo.NAM_OCCUR_YEARMONTH %><%= CommonConst.STR_TITLE_SEPARATOR %></td>
				<td class="ViewTd" >
					<%= BaseVo.escapeHTML(vo.getLblOccurYear()) %><%= CommonConst.NAM_YEAR %>
					<%= BaseVo.escapeHTML(vo.getLblOccurMonth()) %><%= CommonConst.NAM_MONTH %>
				</td>
			</tr>
			<tr>
				<td class="TitleTd"><%= vo.NAM_CLOSE_DATE %><%= CommonConst.STR_TITLE_SEPARATOR %></td>
				<td class="ViewTd" >
					<%= BaseVo.escapeHTML(vo.getLblCloseDate()) %>
				</td>
			</tr>
			<tr>
				<td class="TitleTd"><%= vo.NAM_LIMIT_START_DATE %><%= CommonConst.STR_TITLE_SEPARATOR %></td>
				<td class="ViewTd" >
					<%= BaseVo.escapeHTML(vo.getLblLimitStartDate()) %>
				</td>
			</tr>
			<tr>
				<td class="TitleTd"><%= vo.NAM_LIMIT_END_DATE %><%= CommonConst.STR_TITLE_SEPARATOR %></td>
				<td class="ViewTd" >
					<%= BaseVo.escapeHTML(vo.getLblLimitEndDate()) %>
				</td>
			</tr>
			<tr>
				<td class="TitleTd"><%= vo.NAM_ATTITUDE_STATUS %><%= CommonConst.STR_TITLE_SEPARATOR %></td>
				<td class="ViewTd" >
					<%= BaseVo.escapeHTML(vo.getLblAttitudeStatus()) %>
				</td>
			</tr>
			<tr>
				<td class="TitleTd"><%= vo.NAM_PAYMENT_ACQUIRE_TIME %><%= CommonConst.STR_TITLE_SEPARATOR %></td>
				<td class="ViewTd" >
					<%= BaseVo.escapeHTML(vo.getLblPaymentAcquireTime()) %>
				</td>
			</tr>
			<tr>
				<td class="TitleTd"><%= vo.NAM_PAYMENT_ACQUIRE_HOLIDAY %><%= CommonConst.STR_TITLE_SEPARATOR %></td>
				<td class="ViewTd" >
					<%= BaseVo.escapeHTML(vo.getLblPaymentAcquireHoliday()) %>
				</td>
			</tr>
			<tr>
				<td class="TitleTd"><%= vo.NAM_PAYMENT_QUIT_TIME %><%= CommonConst.STR_TITLE_SEPARATOR %></td>
				<td class="ViewTd" >
					<%= BaseVo.escapeHTML(vo.getLblPaymentQuitTime()) %>
				</td>
			</tr>
			<tr>
				<td class="TitleTd"><%= vo.NAM_USE_HOLICAY %><%= CommonConst.STR_TITLE_SEPARATOR %></td>
				<td class="ViewTd" >
					<%= BaseVo.escapeHTML(vo.getLblUseHoliday()) %>
				</td>
			</tr>
			<tr>
				<td class="TitleTd"><%= vo.NAM_ACQUISITION_STATUS %><%= CommonConst.STR_TITLE_SEPARATOR %></td>
				<td class="ViewTd" >
					<%= BaseVo.escapeHTML(vo.getLblAcquisitionStatus()) %>
				</td>
			</tr>
			<tr>
				<td class="TitleTd"><%= vo.NAM_LIQUIDATION_OVER_TIME %><%= CommonConst.STR_TITLE_SEPARATOR %></td>
				<td class="ViewTd" >
					<%= BaseVo.escapeHTML(vo.getLblLiquidationOverTime()) %>
				</td>
			</tr>
			<tr>
				<td class="TitleTd"><%= vo.NAM_LIQUIDATION_WEEK_HOLIDAY %><%= CommonConst.STR_TITLE_SEPARATOR %></td>
				<td class="ViewTd" >
					<%= BaseVo.escapeHTML(vo.getLblLiquidationWeekHoliday()) %>
				</td>
			</tr>
			<tr>
				<td class="TitleTd"><%= vo.NAM_DECISION_STATUS %><%= CommonConst.STR_TITLE_SEPARATOR %></td>
				<td class="ViewTd" >
					<%= BaseVo.escapeHTML(vo.getLblDecisionStatus()) %>
				</td>
			</tr>
			<tr>
				<td class="TitleTd"><%= vo.NAM_DELETE_FLAG %><%= CommonConst.STR_TITLE_SEPARATOR %></td>
				<td>
					<select class="DeleteFlagSelect" id="<%= SubHolidayCardVo.PRM_PLT_DELETE %>" name="<%= SubHolidayCardVo.PRM_PLT_DELETE %>">
						<%= HtmlUtility.getDeleteFlagSelectOption(vo.getPltDelete()) %>
					</select>
				</td>
			</tr>
		</table>
	</div>
</div>
<div class="Footer">
	<button type="button" class="ExecuteButton" id="btnRegist" onclick="doSubmit(document.form, 'P1312')"><%= CommonConst.NAM_TO_LIST %></button>
</div>
<%= HtmlUtility.getFooter(vo) %>
