<%@ page
language     = "java"
pageEncoding = "Windows-31J"
buffer       = "256kb"
autoFlush    = "false"
errorPage    = "/jsp/common/error.jsp"
%><%@ page
import = "jp.mosp.common.common.MospConst"
import = "jp.mosp.common.common.HtmlUtility"
import = "jp.mosp.payroll.payment.vo.PaymentListVo"
%><%
PaymentListVo vo  = (PaymentListVo)request.getAttribute(MospConst.ATT_VO);
%>
<%= HtmlUtility.getHeader(vo) %>
<%= HtmlUtility.getSubTitle(vo) %>
<div class="Body">
	<%= HtmlUtility.getMessages(vo) %>
	<div class="Search">
		<table id="tabCondition">
			<tr>
				<td>
					<span class="TitleLabel"><%= vo.getName("P_OFFICE") + vo.getName("C_SEPARATOR") %></span>
					<select id="<%= PaymentListVo.PRM_PLT_OFFICE %>" name="<%= PaymentListVo.PRM_PLT_OFFICE %>">
						<option value=""></option>
						<%= HtmlUtility.getSelectOption(vo.getPitOffice(), vo.getPltOffice()) %>
					</select>
				</td>
				<td>
					<span class="TitleLabel"><%= vo.getName("P_SECTION") + vo.getName("C_SEPARATOR") %></span>
					<select id="<%= PaymentListVo.PRM_PLT_SECTION %>" name="<%= PaymentListVo.PRM_PLT_SECTION %>">
						<option value=""></option>
						<%= HtmlUtility.getSelectOption(vo.getPitSection(), vo.getPltSection()) %>
					</select>
				</td>
				<td>
					<span class="TitleLabel"><%= vo.getName("P_POSITION") + vo.getName("C_SEPARATOR") %></span>
					<select id="<%= PaymentListVo.PRM_PLT_POSITION %>" name="<%= PaymentListVo.PRM_PLT_POSITION %>">
						<option value=""></option>
						<%= HtmlUtility.getSelectOption(vo.getPitPosition(), vo.getPltPosition()) %>
					</select>
				</td>
				<td class="ButtonTd" rowspan="2">
					<button type="button" onclick="submitForm(document.form, 'P1241')"><%= vo.getName("C_SEARCH") %></button>
				</td>
			</tr>
			<tr>
				<td>
					<span class="TitleLabel"><%= vo.getName("P_EMPLOYEE") + vo.getName("C_CODE") + vo.getName("C_SEPARATOR") %></span>
					<input type="text" class="UserIdText" id="<%= PaymentListVo.PRM_TXT_K_CODE %>" name="<%= PaymentListVo.PRM_TXT_K_CODE %>" value="<%= vo.getEscTxtKCode() %>" />
				</td>
				<td colspan="2">
					<span class="TitleLabel"><%= vo.getName("C_KANA") + vo.getName("C_SEPARATOR") %></span>
					<input type="text" class="TextBox" id="<%= PaymentListVo.PRM_TXT_K_KANA %>" name="<%= PaymentListVo.PRM_TXT_K_KANA %>" value="<%= vo.getEscTxtKKana() %>" />
				</td>
			</tr>
		</table>
		<table id="tabTargetMonth">
			<tr>
				<td>
					<span class="TitleLabel"><%= vo.getName("P_TARGET_MONTH") + vo.getName("C_SEPARATOR") %></span>
					<select id="<%= PaymentListVo.PRM_PLT_YEAR %>" name="<%= PaymentListVo.PRM_PLT_YEAR %>">
						<%= HtmlUtility.getSelectOption(vo.getPitYear(), String.valueOf(vo.getPltYear())) %>
					</select><%= vo.getName("C_YEAR") %>
					<select id="<%= PaymentListVo.PRM_PLT_MONTH %>" name="<%= PaymentListVo.PRM_PLT_MONTH %>">
						<%= HtmlUtility.getSelectOption(vo.getPitMonth(), String.valueOf(vo.getPltMonth())) %>
					</select><%= vo.getName("C_MONTH") %>
				</td>
			</tr>
		</table>
	</div>
	<%= HtmlUtility.getListInfoFlex(vo) %>
	<div class="List">
		<table id="tabList">
			<thead>
				<tr>
					<th class="ButtonTh"></th>
					<th class="ButtonTh"></th>
					<th id="thKCode"    onclick="doSubmitKey(document.form, 'P1243', '1', '')">&nbsp;<%= vo.getName("P_EMPLOYEE" ) + vo.getName("C_CODE") %>&nbsp;<%= vo.getSortMark("1") %></th>
					<th id="thKName"    onclick="doSubmitKey(document.form, 'P1243', '2', '')">&nbsp;<%= vo.getName("P_EMPLOYEE" ) + vo.getName("C_NAME") %>&nbsp;<%= vo.getSortMark("2") %></th>
					<th id="thOffice"   onclick="doSubmitKey(document.form, 'P1243', '3', '')">&nbsp;<%= vo.getName("P_OFFICE"   )                        %>&nbsp;<%= vo.getSortMark("3") %></th>
					<th id="thSection"  onclick="doSubmitKey(document.form, 'P1243', '4', '')">&nbsp;<%= vo.getName("P_SECTION"  )                        %>&nbsp;<%= vo.getSortMark("4") %></th>
					<th id="thPosition" onclick="doSubmitKey(document.form, 'P1243', '5', '')">&nbsp;<%= vo.getName("P_POSITION" )                        %>&nbsp;<%= vo.getSortMark("5") %></th>
					<th id="thPayTotal" onclick="doSubmitKey(document.form, 'P1243', '6', '')">&nbsp;<%= vo.getName("P_PAY_TOTAL")                        %>&nbsp;<%= vo.getSortMark("6") %></th>
				</tr>
			</thead>
			<tbody>
<%
for (int i = 0; i < vo.getCount(); i++) {
%>
				<tr>
					<td class="ButtonTd">
						<button type="button" onclick="doSubmitKey(document.form, 'P1250', '<%= vo.getAryKCode(i) %>', '<%= vo.getLblTargetMonth() %>')">
							<%= vo.getName("C_SELECT") %>
						</button>
					</td>
					<td class="ButtonTd">
						<button type="button" onclick="doSubmitFileKey(document.form, 'P1245', '<%= vo.getAryKCode(i) %>', '<%= vo.getLblTargetMonth() %>')">
							<%= vo.getName("C_EXPORT") %>
						</button>
					</td>
					<td                ><%= vo.getAryKCode   (i) %></td>
					<td                ><%= vo.getAryKName   (i) %></td>
					<td                ><%= vo.getAryOffice  (i) %></td>
					<td                ><%= vo.getArySection (i) %></td>
					<td                ><%= vo.getAryPosition(i) %></td>
					<td class="RightTd"><%= vo.getAryPayTotal(i) %></td>
				</tr>
<%
}
%>
			</tbody>
		</table>
	</div>
</div>
<%= HtmlUtility.getFooter(vo) %>
