/*
 * Decompiled with CFR 0.152.
 */
package galatea;

import galatea.document.DocError;
import galatea.document.DocLoader;
import galatea.main.Debug;
import galatea.main.IC;
import galatea.util.Getopt;
import galatea.util.Util;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.Properties;
import org.xml.sax.SAXParseException;

public class DialogManager {
    public static final String COPYRIGHT = "(c)2003-2005 Takuya NISHIMOTO (nishi@hil.t.u-tokyo.ac.jp)\nUses Mozilla Rhino from mozilla.org.\nSee http://www.mozilla.org/rhino/.\n";

    public static void showVersion() {
        System.err.println("Galatea Dialog Manager 2.0.3 (051215)");
        System.err.print(COPYRIGHT);
        System.err.println();
    }

    public static void showUsage() {
        System.err.println("Usage:\tgalatea [options] document.vxml");
        System.err.println("\t -c file : config file");
        System.err.println("\t -v      : show version");
        System.err.println("\t -p      : print translation results");
        System.err.println();
    }

    private static String _getDefaultFile() {
        String file = System.getProperty("DefaultFile", "../lib/default.vxml");
        return Util.resolveAdrs(String.valueOf(Util.getPropertyStr("user.dir", "/")) + "/", file);
    }

    public static void main(String[] argv) {
        int c;
        String conf = "gdm.conf";
        boolean isPrintOnly = false;
        Getopt g = new Getopt("", argv, "c:vp");
        g.setOpterr(false);
        while ((c = g.getopt()) != -1) {
            switch (c) {
                case 99: {
                    conf = g.getOptarg();
                    break;
                }
                case 118: {
                    DialogManager.showVersion();
                    DialogManager.showUsage();
                    System.exit(1);
                    break;
                }
                case 112: {
                    isPrintOnly = true;
                }
            }
        }
        File conffile = new File(conf);
        if (conffile.canRead()) {
            try {
                Properties props = new Properties(System.getProperties());
                props.load(new FileInputStream(conffile));
                System.setProperties(props);
            }
            catch (Exception e) {
                e.printStackTrace();
                System.exit(0);
            }
        }
        if (isPrintOnly) {
            System.out.print(DocLoader.convert(argv[g.getOptind()]));
            System.exit(0);
        }
        if (Util.getPropertyInt("ShowVersion", 1) != 0) {
            DialogManager.showVersion();
        }
        Debug dbg = new Debug("DM");
        dbg.print("DM: using " + conffile);
        String filename = argv.length - g.getOptind() != 1 ? DialogManager._getDefaultFile() : argv[g.getOptind()];
        IC ic = new IC();
        int errorCount = 0;
        while (filename.length() > 0 && errorCount < 5) {
            try {
                dbg.print("DM: filename:" + filename);
                ic.loadDocument(filename);
                ic.mainLoop();
                String nf = ic.getNextDocFile();
                if (nf.length() > 0) {
                    dbg.print("DM: resolve from:" + filename);
                    dbg.print("DM: nextDocFile:" + nf);
                    filename = nf;
                    dbg.print("DM: " + filename);
                    continue;
                }
                filename = DialogManager._getDefaultFile();
            }
            catch (DocError e) {
                System.err.println();
                System.err.println(e);
                System.err.println("Document error.");
                ++errorCount;
            }
            catch (SAXParseException e) {
                e.printStackTrace();
                ++errorCount;
            }
            catch (FileNotFoundException e) {
                System.err.println();
                System.err.println("File not found.");
                ++errorCount;
            }
            catch (Exception e) {
                e.printStackTrace();
                ++errorCount;
            }
        }
        Util.halt("Galatea Dialog Manager terminated.");
    }
}

