/*
 * Decompiled with CFR 0.152.
 */
package galatea;

import galatea.document.DocLoader;
import galatea.main.ICEventListener;
import galatea.util.Util;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class DialogManagerWindow {
    private JEditorPane applogPane_ = null;
    private StringBuffer applogContent_ = null;
    private JEditorPane recogPane_ = null;
    private StringBuffer recogContent_ = null;
    private JEditorPane statePane_ = null;
    private StringBuffer stateContent_ = null;
    private JEditorPane debugPane_ = null;
    private StringBuffer debugContent_ = null;
    private boolean windowEnabled_ = false;
    private ICEventListener eventListener_ = null;
    private JLabel labelPauseMode_ = null;
    private JTextField textFieldLocation_ = null;
    private JTextArea textFieldSpeaking_ = null;
    private String currDirPath_ = "";
    private JFrame viewSrcFrame_ = null;
    private JEditorPane viewSrcPane_ = null;
    private String srcFile_ = "";
    private JFrame viewTranslatedFrame_ = null;
    private JEditorPane viewTranslatedPane_ = null;
    private String translatedFile_ = "";
    private String test1Label_;
    private String test1Command_;
    private String test2Label_;
    private String test2Command_;
    private String test3Label_;
    private String test3Command_;
    private String demo1Label_;
    private String demo1File_;
    private String demo2Label_;
    private String demo2File_;
    private String demo3Label_;
    private String demo3File_;
    private String demo4Label_;
    private String demo4File_;
    private static DialogManagerWindow instance_ = null;

    private void _send(String str) {
        System.out.println(str);
        System.out.flush();
    }

    private void _makeDialogManagerWindow() throws Exception {
        JFrame frame = new JFrame("Galatea Dialog Manager 2.0.3 (051215)");
        frame.setDefaultCloseOperation(3);
        JMenuBar menuBar = new JMenuBar();
        JMenu menuFile = new JMenu("File");
        menuBar.add(menuFile);
        JMenuItem itemOpen = new JMenuItem("Open Local File...");
        menuFile.add(itemOpen);
        itemOpen.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JFileChooser chooser = new JFileChooser(DialogManagerWindow.this.currDirPath_);
                chooser.showOpenDialog(null);
                File file = chooser.getSelectedFile();
                if (file == null) {
                    return;
                }
                String uri = file.getAbsolutePath();
                uri = "file:" + uri;
                if (DialogManagerWindow.this.eventListener_ != null) {
                    DialogManagerWindow.this.labelPauseMode_.setText("Mode: Run");
                    DialogManagerWindow.this.eventListener_.setPauseModeICEvent(false);
                    DialogManagerWindow.this.eventListener_.setNextDocumentICEvent(uri);
                    DialogManagerWindow.this.eventListener_.terminateDialogICEvent();
                } else {
                    System.out.println(e);
                    System.out.println(uri);
                }
            }
        });
        JMenuItem itemViewSrc = new JMenuItem("View Source");
        menuFile.add(itemViewSrc);
        itemViewSrc.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (DialogManagerWindow.this.viewSrcFrame_ == null) {
                    DialogManagerWindow.this.viewSrcFrame_ = new JFrame("View Source");
                    DialogManagerWindow.this.viewSrcPane_ = new JEditorPane("text/plain", "");
                    DialogManagerWindow.this.viewSrcPane_.setEditable(false);
                    DialogManagerWindow.this.viewSrcPane_.setText(DialogManagerWindow.this.srcFile_);
                    DialogManagerWindow.this.viewSrcFrame_.getContentPane().add(new JScrollPane(DialogManagerWindow.this.viewSrcPane_, 22, 32));
                    DialogManagerWindow.this.viewSrcFrame_.setSize(600, 400);
                    DialogManagerWindow.this.viewSrcFrame_.setVisible(true);
                }
            }
        });
        JMenuItem itemViewTranslated = new JMenuItem("View Translated");
        menuFile.add(itemViewTranslated);
        itemViewTranslated.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (DialogManagerWindow.this.viewTranslatedFrame_ == null) {
                    DialogManagerWindow.this.viewTranslatedFrame_ = new JFrame("View Translated");
                    DialogManagerWindow.this.viewTranslatedPane_ = new JEditorPane("text/plain", "");
                    DialogManagerWindow.this.viewTranslatedPane_.setEditable(false);
                    DialogManagerWindow.this.viewTranslatedPane_.setText(DialogManagerWindow.this.translatedFile_);
                    DialogManagerWindow.this.viewTranslatedFrame_.getContentPane().add(new JScrollPane(DialogManagerWindow.this.viewTranslatedPane_, 22, 32));
                    DialogManagerWindow.this.viewTranslatedFrame_.setSize(600, 400);
                    DialogManagerWindow.this.viewTranslatedFrame_.setVisible(true);
                }
            }
        });
        JMenuItem itemQuit = new JMenuItem("Quit Current Dialog");
        menuFile.add(itemQuit);
        itemQuit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (DialogManagerWindow.this.eventListener_ != null) {
                    DialogManagerWindow.this.eventListener_.quitICEvent();
                } else {
                    System.out.println(e);
                }
            }
        });
        JMenu menuFace = new JMenu("Face");
        menuBar.add(menuFace);
        JMenuItem itemAgentEnable = new JMenuItem("AgentEnable");
        menuFace.add(itemAgentEnable);
        itemAgentEnable.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DialogManagerWindow.this._send("to @FSM set AgentEnable = ENABLE");
            }
        });
        JMenuItem itemAgentDisable = new JMenuItem("AgentDisable");
        menuFace.add(itemAgentDisable);
        itemAgentDisable.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DialogManagerWindow.this._send("to @FSM set AgentEnable = DISABLE");
            }
        });
        JMenuItem itemAgentAlpha10 = new JMenuItem("Alpha 1.0");
        menuFace.add(itemAgentAlpha10);
        itemAgentAlpha10.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DialogManagerWindow.this._send("to @FSM set AgentAlpha = 1.0");
            }
        });
        JMenuItem itemAgentAlpha08 = new JMenuItem("Alpha 0.8");
        menuFace.add(itemAgentAlpha08);
        itemAgentAlpha08.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DialogManagerWindow.this._send("to @FSM set AgentAlpha = 0.8");
            }
        });
        JMenuItem itemAgentAlpha05 = new JMenuItem("Alpha 0.5");
        menuFace.add(itemAgentAlpha05);
        itemAgentAlpha05.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DialogManagerWindow.this._send("to @FSM set AgentAlpha = 0.5");
            }
        });
        JMenuItem itemAgentAlpha03 = new JMenuItem("Alpha 0.3");
        menuFace.add(itemAgentAlpha03);
        itemAgentAlpha03.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DialogManagerWindow.this._send("to @FSM set AgentAlpha = 0.3");
            }
        });
        JMenuItem itemViewMode1 = new JMenuItem("Texture");
        menuFace.add(itemViewMode1);
        itemViewMode1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DialogManagerWindow.this._send("to @FSM set ViewMode = TEXTURE");
            }
        });
        JMenuItem itemViewMode2 = new JMenuItem("Texture with Wireframe");
        menuFace.add(itemViewMode2);
        itemViewMode2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DialogManagerWindow.this._send("to @FSM set ViewMode = TEXTURE_WITH_WIREFRAME");
            }
        });
        JMenuItem itemViewMode3 = new JMenuItem("Wireframe");
        menuFace.add(itemViewMode3);
        itemViewMode3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DialogManagerWindow.this._send("to @FSM set ViewMode = WIREFRAME");
            }
        });
        JMenu menuMask = new JMenu("Mask");
        menuBar.add(menuMask);
        JMenuItem itemMask1 = new JMenuItem("man01");
        menuMask.add(itemMask1);
        itemMask1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DialogManagerWindow.this._send("to @AM-MCL set Mask = man01");
            }
        });
        JMenuItem itemMask2 = new JMenuItem("man02");
        menuMask.add(itemMask2);
        itemMask2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DialogManagerWindow.this._send("to @AM-MCL set Mask = man02");
            }
        });
        JMenuItem itemMask3 = new JMenuItem("woman01");
        menuMask.add(itemMask3);
        itemMask3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DialogManagerWindow.this._send("to @AM-MCL set Mask = woman01");
            }
        });
        JMenu menuAuto = new JMenu("Auto");
        menuBar.add(menuAuto);
        JMenuItem itemAutoMoveOn = new JMenuItem("AutoMove ON");
        menuAuto.add(itemAutoMoveOn);
        itemAutoMoveOn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DialogManagerWindow.this._send("to @AM-MCL set AutoMove = 1");
            }
        });
        JMenuItem itemAutoMoveOff = new JMenuItem("AutoMove OFF");
        menuAuto.add(itemAutoMoveOff);
        itemAutoMoveOff.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DialogManagerWindow.this._send("to @AM-MCL set AutoMove = 0");
            }
        });
        JMenuItem itemAutoGazeOn = new JMenuItem("AutoGaze ON");
        menuAuto.add(itemAutoGazeOn);
        itemAutoGazeOn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DialogManagerWindow.this._send("to @AM-MCL set AutoGaze = 1");
            }
        });
        JMenuItem itemAutoGazeOff = new JMenuItem("AutoGaze OFF");
        menuAuto.add(itemAutoGazeOff);
        itemAutoGazeOff.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DialogManagerWindow.this._send("to @AM-MCL set AutoGaze = 0");
            }
        });
        JMenuItem itemEmotionSpeakOn = new JMenuItem("EmotionSpeak ON");
        menuAuto.add(itemEmotionSpeakOn);
        itemEmotionSpeakOn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DialogManagerWindow.this._send("to @AM-MCL set AutoEmotionSpeak = 1");
            }
        });
        JMenuItem itemEmotionSpeakOff = new JMenuItem("EmotionSpeak OFF");
        menuAuto.add(itemEmotionSpeakOff);
        itemEmotionSpeakOff.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DialogManagerWindow.this._send("to @AM-MCL set AutoEmotionSpeak = 0");
            }
        });
        JMenu menuExp = new JMenu("Expression");
        menuBar.add(menuExp);
        JMenuItem itemEmo1 = new JMenuItem("Neutral");
        menuExp.add(itemEmo1);
        itemEmo1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DialogManagerWindow.this._send("to @FS-MCL set Emotion = NEUTRAL");
            }
        });
        JMenuItem itemEmo2 = new JMenuItem("Happy");
        menuExp.add(itemEmo2);
        itemEmo2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DialogManagerWindow.this._send("to @FS-MCL set Emotion = HAPPY 90");
            }
        });
        JMenuItem itemEmo3 = new JMenuItem("Disgusted");
        menuExp.add(itemEmo3);
        itemEmo3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DialogManagerWindow.this._send("to @FS-MCL set Emotion = DISGUSTED 90");
            }
        });
        JMenuItem itemEmo4 = new JMenuItem("Sad");
        menuExp.add(itemEmo4);
        itemEmo4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DialogManagerWindow.this._send("to @FS-MCL set Emotion = SAD 90");
            }
        });
        JMenuItem itemEmo5 = new JMenuItem("Angry");
        menuExp.add(itemEmo5);
        itemEmo5.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DialogManagerWindow.this._send("to @FS-MCL set Emotion = ANGRY 90");
            }
        });
        JMenuItem itemEmo6 = new JMenuItem("Surprised");
        menuExp.add(itemEmo6);
        itemEmo6.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DialogManagerWindow.this._send("to @FS-MCL set Emotion = SURPRISED 30");
            }
        });
        JMenuItem itemEmo7 = new JMenuItem("Feared");
        menuExp.add(itemEmo7);
        itemEmo7.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DialogManagerWindow.this._send("to @FS-MCL set Emotion = FEARED 90");
            }
        });
        JMenu menuDemo = new JMenu("Demo");
        menuBar.add(menuDemo);
        this.test1Label_ = Util.getPropertyStr("DM.Window.Test.1.Label", null);
        this.test1Command_ = Util.getPropertyStr("DM.Window.Test.1.Command", null);
        if (this.test1Label_ != null && this.test1Command_ != null) {
            JMenuItem itemTest1 = new JMenuItem(this.test1Label_);
            menuDemo.add(itemTest1);
            itemTest1.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    DialogManagerWindow.this._send(DialogManagerWindow.this.test1Command_);
                }
            });
        }
        this.test2Label_ = Util.getPropertyStr("DM.Window.Test.2.Label", null);
        this.test2Command_ = Util.getPropertyStr("DM.Window.Test.2.Command", null);
        if (this.test2Label_ != null && this.test2Command_ != null) {
            JMenuItem itemTest2 = new JMenuItem(this.test2Label_);
            menuDemo.add(itemTest2);
            itemTest2.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    DialogManagerWindow.this._send(DialogManagerWindow.this.test2Command_);
                }
            });
        }
        this.test3Label_ = Util.getPropertyStr("DM.Window.Test.3.Label", null);
        this.test3Command_ = Util.getPropertyStr("DM.Window.Test.3.Command", null);
        if (this.test3Label_ != null && this.test3Command_ != null) {
            JMenuItem itemTest3 = new JMenuItem(this.test3Label_);
            menuDemo.add(itemTest3);
            itemTest3.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    DialogManagerWindow.this._send(DialogManagerWindow.this.test3Command_);
                }
            });
        }
        this.demo1Label_ = Util.getPropertyStr("DM.Window.Demo.1.Label", null);
        this.demo1File_ = Util.getPropertyStr("DM.Window.Demo.1.File", null);
        if (this.demo1Label_ != null && this.demo1File_ != null) {
            JMenuItem itemDemo1 = new JMenuItem(this.demo1Label_);
            menuDemo.add(itemDemo1);
            itemDemo1.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    String adrs = Util.resolveAdrs(DialogManagerWindow.this.currDirPath_, DialogManagerWindow.this.demo1File_);
                    if (DialogManagerWindow.this.eventListener_ != null) {
                        DialogManagerWindow.this.labelPauseMode_.setText("Mode: Run");
                        DialogManagerWindow.this.eventListener_.setPauseModeICEvent(false);
                        DialogManagerWindow.this.eventListener_.setNextDocumentICEvent(adrs);
                        DialogManagerWindow.this.eventListener_.terminateDialogICEvent();
                    } else {
                        System.err.println("adrs:" + adrs);
                    }
                }
            });
        }
        this.demo2Label_ = Util.getPropertyStr("DM.Window.Demo.2.Label", null);
        this.demo2File_ = Util.getPropertyStr("DM.Window.Demo.2.File", null);
        if (this.demo2Label_ != null && this.demo2File_ != null) {
            JMenuItem itemDemo2 = new JMenuItem(this.demo2Label_);
            menuDemo.add(itemDemo2);
            itemDemo2.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    String adrs = Util.resolveAdrs(DialogManagerWindow.this.currDirPath_, DialogManagerWindow.this.demo2File_);
                    if (DialogManagerWindow.this.eventListener_ != null) {
                        DialogManagerWindow.this.labelPauseMode_.setText("Mode: Run");
                        DialogManagerWindow.this.eventListener_.setPauseModeICEvent(false);
                        DialogManagerWindow.this.eventListener_.setNextDocumentICEvent(adrs);
                        DialogManagerWindow.this.eventListener_.terminateDialogICEvent();
                    } else {
                        System.err.println("adrs:" + adrs);
                    }
                }
            });
        }
        this.demo3Label_ = Util.getPropertyStr("DM.Window.Demo.3.Label", null);
        this.demo3File_ = Util.getPropertyStr("DM.Window.Demo.3.File", null);
        if (this.demo3Label_ != null && this.demo3File_ != null) {
            JMenuItem itemDemo3 = new JMenuItem(this.demo3Label_);
            menuDemo.add(itemDemo3);
            itemDemo3.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    String adrs = Util.resolveAdrs(DialogManagerWindow.this.currDirPath_, DialogManagerWindow.this.demo3File_);
                    if (DialogManagerWindow.this.eventListener_ != null) {
                        DialogManagerWindow.this.labelPauseMode_.setText("Mode: Run");
                        DialogManagerWindow.this.eventListener_.setPauseModeICEvent(false);
                        DialogManagerWindow.this.eventListener_.setNextDocumentICEvent(adrs);
                        DialogManagerWindow.this.eventListener_.terminateDialogICEvent();
                    } else {
                        System.err.println("adrs:" + adrs);
                    }
                }
            });
        }
        this.demo4Label_ = Util.getPropertyStr("DM.Window.Demo.4.Label", null);
        this.demo4File_ = Util.getPropertyStr("DM.Window.Demo.4.File", null);
        if (this.demo4Label_ != null && this.demo4File_ != null) {
            JMenuItem itemDemo4 = new JMenuItem(this.demo4Label_);
            menuDemo.add(itemDemo4);
            itemDemo4.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    String adrs = Util.resolveAdrs(DialogManagerWindow.this.currDirPath_, DialogManagerWindow.this.demo4File_);
                    if (DialogManagerWindow.this.eventListener_ != null) {
                        DialogManagerWindow.this.labelPauseMode_.setText("Mode: Run");
                        DialogManagerWindow.this.eventListener_.setPauseModeICEvent(false);
                        DialogManagerWindow.this.eventListener_.setNextDocumentICEvent(adrs);
                        DialogManagerWindow.this.eventListener_.terminateDialogICEvent();
                    } else {
                        System.err.println("adrs:" + adrs);
                    }
                }
            });
        }
        frame.setJMenuBar(menuBar);
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 11;
        constraints.fill = 1;
        constraints.insets = new Insets(3, 5, 3, 5);
        constraints.weightx = 1.0;
        constraints.gridy = 0;
        constraints.gridwidth = 2;
        constraints.gridx = 0;
        constraints.weightx = 1.0;
        this.textFieldLocation_ = new JTextField();
        panel.add((Component)this.textFieldLocation_, constraints);
        constraints.gridwidth = 1;
        constraints.gridx = 2;
        constraints.weightx = 0.0;
        JButton buttonGo = new JButton("Go");
        panel.add((Component)buttonGo, constraints);
        buttonGo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String uri = DialogManagerWindow.this.textFieldLocation_.getText();
                if (DialogManagerWindow.this.eventListener_ != null) {
                    DialogManagerWindow.this.labelPauseMode_.setText("Mode: Run");
                    DialogManagerWindow.this.eventListener_.setPauseModeICEvent(false);
                    DialogManagerWindow.this.eventListener_.setNextDocumentICEvent(uri);
                    DialogManagerWindow.this.eventListener_.terminateDialogICEvent();
                } else {
                    System.out.println(e);
                    System.out.println(uri);
                }
            }
        });
        constraints.gridwidth = 1;
        constraints.gridx = 3;
        constraints.weightx = 0.0;
        JButton buttonValidate = new JButton("Validate");
        panel.add((Component)buttonValidate, constraints);
        buttonValidate.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String uri = DialogManagerWindow.this.textFieldLocation_.getText();
                if (uri != null && uri.length() > 0) {
                    String doc = DocLoader.convert(uri);
                    if (doc != "") {
                        System.err.println("[DM Validate OK] " + uri);
                    } else {
                        System.err.println("[DM Validate ERROR] " + uri);
                    }
                }
            }
        });
        ++constraints.gridy;
        constraints.weighty = 0.0;
        constraints.gridwidth = 1;
        constraints.gridx = 0;
        constraints.weightx = 1.0;
        JButton buttonStart = new JButton("Run");
        panel.add((Component)buttonStart, constraints);
        buttonStart.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DialogManagerWindow.this.labelPauseMode_.setText("Mode: Run");
                if (DialogManagerWindow.this.eventListener_ != null) {
                    DialogManagerWindow.this.eventListener_.setPauseModeICEvent(false);
                } else {
                    System.out.println(e);
                }
            }
        });
        constraints.gridx = 1;
        constraints.weightx = 1.0;
        JButton buttonStop = new JButton("Pause");
        panel.add((Component)buttonStop, constraints);
        buttonStop.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DialogManagerWindow.this.labelPauseMode_.setText("Mode: Pause");
                if (DialogManagerWindow.this.eventListener_ != null) {
                    DialogManagerWindow.this.eventListener_.setPauseModeICEvent(true);
                } else {
                    System.out.println(e);
                }
            }
        });
        constraints.gridx = 2;
        constraints.weightx = 0.0;
        constraints.gridwidth = 2;
        this.labelPauseMode_ = new JLabel("Mode: Run");
        panel.add((Component)this.labelPauseMode_, constraints);
        ++constraints.gridy;
        constraints.gridx = 0;
        constraints.gridwidth = 4;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        this.textFieldSpeaking_ = new JTextArea();
        this.textFieldSpeaking_.setRows(3);
        this.textFieldSpeaking_.setLineWrap(true);
        panel.add((Component)new JScrollPane(this.textFieldSpeaking_, 22, 31), constraints);
        ++constraints.gridy;
        constraints.gridx = 0;
        constraints.gridwidth = 4;
        constraints.weighty = 0.0;
        constraints.insets = new Insets(0, 5, 0, 5);
        panel.add((Component)new JLabel("Log"), constraints);
        ++constraints.gridy;
        constraints.weighty = 1.0;
        this.applogPane_ = new JEditorPane("text/plain", "");
        this.applogPane_.setEditable(false);
        panel.add((Component)new JScrollPane(this.applogPane_, 22, 31), constraints);
        ++constraints.gridy;
        constraints.weighty = 0.0;
        panel.add((Component)new JLabel("Input"), constraints);
        ++constraints.gridy;
        constraints.weighty = 1.0;
        this.recogPane_ = new JEditorPane("text/plain", "");
        this.recogPane_.setEditable(false);
        panel.add((Component)new JScrollPane(this.recogPane_, 22, 31), constraints);
        ++constraints.gridy;
        constraints.weighty = 0.0;
        panel.add((Component)new JLabel("State"), constraints);
        ++constraints.gridy;
        constraints.weighty = 1.0;
        this.statePane_ = new JEditorPane("text/plain", "");
        this.statePane_.setEditable(false);
        panel.add((Component)new JScrollPane(this.statePane_, 22, 31), constraints);
        frame.getContentPane().add(panel);
        frame.setSize(600, 400);
        frame.setVisible(true);
    }

    private void _setupContent() {
        this.applogContent_ = new StringBuffer();
        this.recogContent_ = new StringBuffer();
        this.stateContent_ = new StringBuffer();
    }

    private DialogManagerWindow() {
        if (Util.getPropertyInt("ShowWindow", 1) != 0) {
            this.windowEnabled_ = true;
            this.currDirPath_ = String.valueOf(Util.getPropertyStr("user.dir", "/")) + "/../";
            try {
                this._makeDialogManagerWindow();
            }
            catch (Exception e) {
                System.out.println(e);
            }
            this._setupContent();
        }
    }

    private void dispLocation(String text) {
        if (this.textFieldLocation_ != null) {
            this.textFieldLocation_.setText(text);
        }
    }

    private void dispSpeaking(String text) {
        if (this.textFieldSpeaking_ != null) {
            this.textFieldSpeaking_.setText(Util.removeTags(text));
        }
    }

    private void dispApplog(String text) {
        if (this.applogContent_ != null) {
            this.applogContent_.insert(0, String.valueOf(text) + "\n");
        }
        if (this.applogPane_ != null) {
            this.applogPane_.setText(this.applogContent_.toString());
        }
    }

    private void dispRecog(String text) {
        if (this.recogContent_ != null) {
            this.recogContent_.insert(0, String.valueOf(text) + "\n");
        }
        if (this.recogPane_ != null) {
            this.recogPane_.setText(this.recogContent_.toString());
        }
    }

    private void dispState(String text) {
        if (this.stateContent_ != null) {
            this.stateContent_.insert(0, String.valueOf(text) + "\n");
        }
        if (this.statePane_ != null) {
            this.statePane_.setText(this.stateContent_.toString());
        }
    }

    private void setICEventListener(ICEventListener listener) {
        this.eventListener_ = listener;
    }

    private void setSrcFile(String text) {
        this.srcFile_ = text;
    }

    private void setTranslatedFile(String text) {
        this.translatedFile_ = text;
    }

    private static DialogManagerWindow _getInstance() {
        if (instance_ == null) {
            instance_ = new DialogManagerWindow();
        }
        return instance_;
    }

    public static void doSetSrcFile(String str) {
        DialogManagerWindow._getInstance().setSrcFile(str);
    }

    public static void doSetTranslatedFile(String str) {
        DialogManagerWindow._getInstance().setTranslatedFile(str);
    }

    public static void doDispLocation(String text) {
        DialogManagerWindow._getInstance().dispLocation(text);
    }

    public static void doDispSpeaking(String text) {
        DialogManagerWindow._getInstance().dispSpeaking(text);
    }

    public static void doDispApplog(String text) {
        DialogManagerWindow._getInstance().dispApplog(text);
    }

    public static void doDispRecog(String text) {
        DialogManagerWindow._getInstance().dispRecog(text);
    }

    public static void doDispState(String text) {
        DialogManagerWindow._getInstance().dispState(text);
    }

    public static void doSetICEventListener(ICEventListener listener) {
        DialogManagerWindow._getInstance().setICEventListener(listener);
    }

    public static void main(String[] args) throws Exception {
        DialogManagerWindow.doDispApplog("abc\u65e5\u672c\u8a9e\u3067\u3059\u3002");
        DialogManagerWindow.doDispApplog("java.io.tmpdir=" + System.getProperty("java.io.tmpdir"));
        DialogManagerWindow.doDispApplog("os.arch=" + System.getProperty("os.arch"));
        DialogManagerWindow.doDispApplog("os.name=" + System.getProperty("os.name"));
        DialogManagerWindow.doDispApplog("user.dir=" + System.getProperty("user.dir"));
        int i = 0;
        while (true) {
            String s = "test" + i;
            DialogManagerWindow.doDispApplog(s);
            try {
                Thread.sleep(3000L);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++i;
        }
    }
}

