/*
 * Decompiled with CFR 0.152.
 */
package galatea;

import galatea.util.AMBuffer;
import galatea.util.StringHashArray;
import java.text.DecimalFormat;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GalateaBase {
    protected String modulename_ = "GalateaBase";
    protected boolean debug_ = false;
    protected StringHashArray myslot_;
    protected StringHashArray myprop_;
    private AMBuffer ambuf_;
    private DecimalFormat intFormatter_ = new DecimalFormat("0");
    private DecimalFormat doubleFormatter_ = new DecimalFormat("0.000");

    public GalateaBase() {
        this.ambuf_ = new AMBuffer();
        this.myslot_ = new StringHashArray();
        this.myslot_.set("Run", "DEAD");
        this.myslot_.set("ProtocolVersion", "ProtocolVersion 1.0");
        this.myslot_.set("ModuleVersion", "ModuleVersion 1.0");
        this.myprop_ = new StringHashArray();
    }

    private String _format(int i) {
        return this.intFormatter_.format(i);
    }

    private String _format(double d) {
        return this.doubleFormatter_.format(d);
    }

    public void sendSet(String mod, String slot, String str) {
        String s = "to @" + mod + " set " + slot + " = " + str;
        this.ambuf_.send(s);
    }

    public void sendSet(String mod, String slot, int num) {
        String s = "to @" + mod + " set " + slot + " = " + this._format(num);
        this.ambuf_.send(s);
    }

    public void printOut(String str) {
        this.ambuf_.send(str);
    }

    public void printDebug(String str) {
        if (this.debug_) {
            System.err.println(str);
            System.err.flush();
        }
    }

    public void printTell(String str) {
        this.ambuf_.send("tell " + str);
    }

    public void printRep(String str) {
        this.ambuf_.send("rep " + str);
    }

    public void doSet(String slot, String arg) {
    }

    public void doProp(String prop, String arg) {
    }

    public void acceptFrom(String mod, String str) {
    }

    public void acceptTo(String mod, String str) {
    }

    public void run() {
        Pattern p1 = Pattern.compile("^\\s*set\\s+([^\\s=]*)\\s*=\\s*(.*)$");
        Pattern p2 = Pattern.compile("^\\s*prop\\s+([^\\s=]*)\\s*=\\s*(.*)$");
        Pattern p3 = Pattern.compile("^\\s*inq\\s+(.*)$");
        Pattern p4 = Pattern.compile("^\\s*From\\s+\\@(\\S+)\\s(.*)$");
        Pattern p5 = Pattern.compile("^\\s*to\\s+\\@(\\S+)\\s(.*)$");
        while (true) {
            String s;
            if ((s = this.ambuf_.receive()).length() > 0) {
                Matcher m = p1.matcher(s);
                if (m.matches()) {
                    this.myslot_.set(m.group(1), m.group(2));
                    this.doSet(m.group(1), m.group(2));
                    if (!m.group(1).equals("Run")) continue;
                    if (m.group(2).equals("INIT")) {
                        this.myslot_.set("Run", "LIVE");
                        continue;
                    }
                    if (!m.group(2).equals("EXIT")) continue;
                    this.myslot_.set("Run", "DEAD");
                    continue;
                }
                m = p2.matcher(s);
                if (m.matches()) {
                    this.myprop_.set(m.group(1), m.group(2));
                    this.doProp(m.group(1), m.group(2));
                    continue;
                }
                m = p3.matcher(s);
                if (m.matches()) {
                    this.printRep(String.valueOf(m.group(1)) + " = " + this.myslot_.get(m.group(1)));
                    continue;
                }
                m = p4.matcher(s);
                if (m.matches()) {
                    this.acceptFrom(m.group(1), m.group(2));
                    continue;
                }
                m = p5.matcher(s);
                if (!m.matches()) continue;
                this.acceptTo(m.group(1), m.group(2));
                continue;
            }
            try {
                Thread.sleep(0L, 1);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    public static void main(String[] argv) {
        GalateaBase gb = new GalateaBase();
        gb.run();
    }
}

