/*
 * Decompiled with CFR 0.152.
 */
package galatea;

import galatea.util.AMBuffer;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.util.Iterator;

public class JuliusClient {
    private String ENCODING = "EUC-JP";
    private String ADDRESS = "localhost";
    private int PORT = 5530;
    private SocketChannel channel;
    private Selector selector;
    private ByteBuffer byteBuffer = ByteBuffer.allocateDirect(2048);
    private String inputBuffer = "";
    private Charset charset;
    private CharsetDecoder decoder;
    private CharsetEncoder encoder;

    public JuliusClient(String addr, int port, String enc) {
        this.ENCODING = enc;
        this.ADDRESS = addr;
        this.PORT = port;
    }

    private void send(String str) {
        try {
            this.byteBuffer.clear();
            this.encoder.reset();
            this.encoder.encode(CharBuffer.wrap(str), this.byteBuffer, true);
            this.byteBuffer.flip();
            this.channel.write(this.byteBuffer);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private String chomp(String src) {
        if (src == null || src.length() < 2) {
            return "";
        }
        return src.substring(0, src.length() - 1);
    }

    public String getMessage() {
        String ret = "";
        int pos = this.inputBuffer.indexOf(">.");
        if (pos > 0) {
            ret = this.inputBuffer.substring(0, pos + 1);
            this.inputBuffer = this.inputBuffer.substring(pos + 2);
        }
        return ret;
    }

    public void open() {
        this.charset = Charset.forName(this.ENCODING);
        this.decoder = this.charset.newDecoder();
        this.encoder = this.charset.newEncoder();
        try {
            this.channel = SocketChannel.open();
            this.selector = Selector.open();
            InetSocketAddress address = new InetSocketAddress(this.ADDRESS, this.PORT);
            this.channel.connect(address);
            this.channel.configureBlocking(false);
            this.channel.register(this.selector, 1);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void receive() {
        try {
            if (this.selector.selectNow() > 0) {
                Iterator<SelectionKey> it = this.selector.selectedKeys().iterator();
                while (it.hasNext()) {
                    SelectionKey key = it.next();
                    it.remove();
                    if (!key.isReadable()) continue;
                    this.byteBuffer.clear();
                    this.channel.read(this.byteBuffer);
                    this.byteBuffer.flip();
                    this.decoder.reset();
                    String str = this.decoder.decode(this.byteBuffer).toString();
                    str = str.replaceAll("\\s+<", "<");
                    str = str.replaceAll("\n", "");
                    this.inputBuffer = String.valueOf(this.inputBuffer) + str;
                }
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void close() {
        try {
            this.channel.close();
            this.selector.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public static void main(String[] args) {
        AMBuffer ambuf = new AMBuffer();
        JuliusClient client = new JuliusClient("localhost", 5530, "EUC-JP");
        client.open();
        ambuf.send("open");
        while (true) {
            String msg;
            client.receive();
            while ((msg = client.getMessage()).length() > 0) {
                ambuf.send("tell " + msg);
            }
            String in = ambuf.receive();
            if (in.length() > 0) {
                if (in.equals(".")) break;
                String cmd = String.valueOf(in) + "\n";
                client.send(cmd);
            }
            try {
                Thread.sleep(1L);
            }
            catch (Exception exception) {}
        }
        client.close();
    }
}

