/*
 * Decompiled with CFR 0.152.
 */
package galatea;

import galatea.RecogInterpreter;
import galatea.RecogListener;
import galatea.util.AMBuffer;
import galatea.util.Util;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RecogManager
implements RecogListener {
    private AMBuffer ambuf_;
    private RecogInterpreter recogInterpreter_;
    static String xmlContent_ = "";

    private void _debugPrint(String str) {
    }

    public void run() {
        this.recogInterpreter_ = new RecogInterpreter();
        this.recogInterpreter_.setListener(this);
        this.ambuf_ = new AMBuffer();
        Pattern pattern1 = Pattern.compile("^From @SRM tell [1-9][0-9][0-9] (<.*)$");
        while (true) {
            String str;
            if ((str = this.ambuf_.receive()).length() > 0) {
                Matcher matcher1 = pattern1.matcher(str);
                if (matcher1.matches()) {
                    this._fromSRMtell(matcher1.group(1));
                }
                this._debugPrint(str);
                String s = Util.getFirstGroup("set DialogName = (.*)$", str);
                if (s != null) {
                    this.recogInterpreter_.setDialogName(s);
                } else {
                    s = Util.getFirstGroup("set SlotAlias = (.*)$", str);
                    if (s != null) {
                        if (s.equals("RESET")) {
                            this.recogInterpreter_.resetSlotAlias();
                        } else {
                            this.recogInterpreter_.setSlotAlias(s);
                        }
                    } else {
                        s = Util.getFirstGroup("set Script = (.*)$", str);
                        if (s != null) {
                            this.recogInterpreter_.setScript(s);
                        } else {
                            s = Util.getFirstGroup("set EventHandler = (.*)$", str);
                            if (s != null) {
                                this.recogInterpreter_.setEventHandler(s);
                            }
                        }
                    }
                }
            }
            try {
                Thread.sleep(1L);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    private void _send(String str) {
        this.ambuf_.send(str);
    }

    private void _sendRecogState(int s) {
        this._send("to @DIM set RecogState = " + s);
    }

    private void _sendUserSpeakState(int s) {
        this._send("to @DIM set UserSpeakState = " + s);
    }

    public void recogListenStarted() {
        this._sendUserSpeakState(0);
    }

    public void recogRecordStarted() {
        this._sendUserSpeakState(1);
    }

    public void recogRecordFinished() {
        this._sendUserSpeakState(0);
    }

    public void recogPass1Finished() {
    }

    public void recogPass2Finished() {
        String sc = this.recogInterpreter_.getScript();
        String text = this.recogInterpreter_.getText();
        this._speechRecognized(text, sc);
    }

    public void recogFailed() {
    }

    public void recogException(Exception e, String str) {
        this._debugPrint("[SIM] recogException(" + str + ")");
        e.printStackTrace();
    }

    private void _fromSRMtell(String s) {
        this._debugPrint("[SIM] [" + xmlContent_ + "] [" + s + "]");
        if ((xmlContent_.length() > 0 || s.startsWith("<")) && ((xmlContent_ = String.valueOf(xmlContent_) + s).endsWith("/>") || xmlContent_.endsWith("</RECOGOUT>") || xmlContent_.endsWith("</GRAMINFO>"))) {
            this.recogInterpreter_.receiveRecogMessage(xmlContent_);
            xmlContent_ = "";
        }
    }

    private void _speechRecognized(String text, String script) {
        this._send("to @DM From @SIM tell 300 <ev src=\"SRM\" type=\"INPUT\"><interpreted><text>" + text + "</text>" + "<script>" + script + "</script></interpreted></ev>");
    }

    public static void main(String[] argv) {
        RecogManager recogManager = new RecogManager();
        recogManager.run();
    }
}

