/*
 * Decompiled with CFR 0.152.
 */
package galatea.command;

import galatea.main.AbstractIC;
import galatea.main.Debug;
import galatea.scripting.ECMAScript;
import galatea.util.Util;

public abstract class Command {
    protected Debug dbg = new Debug("Command");
    protected AbstractIC interpreterContext_ = null;
    protected ECMAScript ecmascript_ = null;
    private String condition_ = "true";
    private String with_ = "";

    public void setContext(AbstractIC ic, ECMAScript sc) {
        this.interpreterContext_ = ic;
        this.ecmascript_ = sc;
    }

    public void setCondition(String s) {
        if (s == null) {
            this.condition_ = "true";
        }
        this.condition_ = s;
    }

    public String getConditionAsEncodedString() {
        return Util.encodeXmlChars(this.condition_);
    }

    public boolean hasCondition() {
        if (this.condition_ == null) {
            return false;
        }
        return !this.condition_.equals("true");
    }

    public void setWith(String s) {
        this.with_ = s;
    }

    public String getWith() {
        return this.with_;
    }

    public boolean evaluateCondition() {
        if (this.condition_ == null) {
            return true;
        }
        if (this.with_.length() > 0) {
            this.condition_ = "with(" + this.with_ + "){" + this.condition_ + "}";
        }
        String r = this.ecmascript_.evaluate(this.condition_);
        boolean b = false;
        if (r.equals("true")) {
            b = true;
        }
        return b;
    }

    public String toString() {
        String s = "<command/>";
        return s;
    }

    public void execute() {
        System.err.println("Empty Command execute()");
    }
}

