/*
 * Decompiled with CFR 0.152.
 */
package galatea.document;

import galatea.DialogManagerWindow;
import galatea.document.AbstractDoc;
import galatea.document.DocError;
import galatea.document.PDoc;
import galatea.document.StateMap;
import galatea.document.VXMLDoc;
import galatea.util.NetUtil;
import galatea.util.Util;
import java.io.FileNotFoundException;
import org.w3c.dom.Element;
import org.xml.sax.SAXParseException;

public class DocLoader {
    private Element element_;
    private AbstractDoc doc_;
    private StateMap stateMap_;

    public DocLoader(String filename, String path, String dialog) throws Exception {
        block4: {
            this.doc_ = null;
            try {
                this.element_ = NetUtil.loadXMLFile(filename);
                String topName = NetUtil.getTopName(this.element_);
                if (topName.equals("vxml")) {
                    this.doc_ = new VXMLDoc(this.element_, path, dialog);
                    break block4;
                }
                if (topName.equals("pdoc")) {
                    this.doc_ = new PDoc(this.element_, path);
                    break block4;
                }
                throw new DocError("Not a valid document:" + filename);
            }
            catch (Exception e) {
                throw new DocError("Not a valid document:" + filename + "\n" + e.toString());
            }
        }
        this.stateMap_ = this.doc_.getStateMap();
    }

    public StateMap getStateMap() {
        return this.stateMap_;
    }

    public void sendSrcToWindow() {
        DialogManagerWindow.doSetSrcFile(this.element_.toString());
        DialogManagerWindow.doSetTranslatedFile(this.stateMap_.toString());
    }

    public static String convert(String uri) {
        String ret = "";
        try {
            String path = Util.getUriWithoutFragment(uri);
            String dialog = Util.getUriFragment(uri);
            DocLoader loader = new DocLoader(uri, path, dialog);
            StateMap stateMap = loader.getStateMap();
            if (stateMap == null) {
                System.err.println("DocLoader stopped: stateMap null.");
                return ret;
            }
            ret = stateMap.toString();
        }
        catch (DocError e) {
            System.err.println();
            System.err.println(e);
            System.err.println("DocLoader stopped.");
        }
        catch (FileNotFoundException e) {
            System.err.println();
            System.err.println(e);
            System.err.println("DocLoader stopped.");
        }
        catch (SAXParseException e) {
            System.err.println();
            System.err.println(e);
            System.err.println("Source:" + uri);
            System.err.println("Line:" + e.getLineNumber() + " Column:" + e.getColumnNumber());
            System.err.println("DocLoader stopped.");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }
}

