/*
 * Decompiled with CFR 0.152.
 */
package galatea.document;

import galatea.command.AddOutItemCommand;
import galatea.command.Command;
import galatea.command.CompositeCommand;
import galatea.command.EndCommand;
import galatea.command.EvaluateCommand;
import galatea.command.GotoCommand;
import galatea.command.SetNextCommand;
import galatea.command.StopOutputCommand;
import galatea.document.AbstractDoc;
import galatea.document.DocError;
import galatea.document.StateMap;
import galatea.main.Debug;
import galatea.outitem.AudioOutItem;
import galatea.outitem.BreakOutItem;
import galatea.outitem.GrammarOutItem;
import galatea.outitem.LogOutItem;
import galatea.outitem.NativeOutItem;
import galatea.outitem.OutItem;
import galatea.outitem.VoiceOutItem;
import galatea.relaxer.pdoc.IPdocAddChoice;
import galatea.relaxer.pdoc.IPdocCmdContentsChoice;
import galatea.relaxer.pdoc.PdocAdd;
import galatea.relaxer.pdoc.PdocAudio;
import galatea.relaxer.pdoc.PdocBody;
import galatea.relaxer.pdoc.PdocBreak;
import galatea.relaxer.pdoc.PdocCatch;
import galatea.relaxer.pdoc.PdocCmd;
import galatea.relaxer.pdoc.PdocEnd;
import galatea.relaxer.pdoc.PdocGoto;
import galatea.relaxer.pdoc.PdocGrammarout;
import galatea.relaxer.pdoc.PdocLog;
import galatea.relaxer.pdoc.PdocNative;
import galatea.relaxer.pdoc.PdocNext;
import galatea.relaxer.pdoc.PdocPdoc;
import galatea.relaxer.pdoc.PdocScript;
import galatea.relaxer.pdoc.PdocState;
import galatea.relaxer.pdoc.PdocStopoutput;
import galatea.relaxer.pdoc.PdocVoice;
import java.util.ArrayList;
import org.w3c.dom.Element;

public class PDoc
implements AbstractDoc {
    private Debug dbg = new Debug("PDoc");
    private String docAddress_;
    private Element element_;
    private StateMap stateMap_;

    public StateMap getStateMap() {
        return this.stateMap_;
    }

    public String getDocAddress() {
        return this.docAddress_;
    }

    public void setDocAddress(String adrs) {
        this.docAddress_ = adrs;
    }

    private Command getCompositeCommand(PdocCmd composite) throws Exception {
        ArrayList<Command> vec = new ArrayList<Command>();
        int j = 0;
        while (j < composite.sizeCmdContents()) {
            Command c;
            Command c2;
            String cond;
            String next;
            String cond2;
            IPdocCmdContentsChoice cc = composite.getCmdContents(j);
            if (cc instanceof PdocAdd) {
                PdocAdd add = (PdocAdd)cc;
                cond2 = ((PdocAdd)cc).getCond();
                ArrayList<OutItem> items = new ArrayList<OutItem>();
                IPdocAddChoice[] aclist = add.getContent();
                int k = 0;
                while (k < aclist.length) {
                    OutItem o;
                    String text;
                    String with;
                    IPdocAddChoice ac = aclist[k];
                    if (ac instanceof PdocAudio) {
                        String src = ((PdocAudio)ac).getContent();
                        AudioOutItem o2 = new AudioOutItem(src);
                        items.add(o2);
                    } else if (ac instanceof PdocBreak) {
                        BreakOutItem o3 = new BreakOutItem((PdocBreak)ac);
                        items.add(o3);
                    } else if (ac instanceof PdocLog) {
                        with = ((PdocLog)ac).getWith();
                        text = ((PdocLog)ac).getContent();
                        o = new LogOutItem(text, with);
                        items.add(o);
                    } else if (ac instanceof PdocNative) {
                        with = ((PdocNative)ac).getWith();
                        text = ((PdocNative)ac).getContent();
                        o = new NativeOutItem(text, with);
                        items.add(o);
                    } else if (ac instanceof PdocVoice) {
                        with = ((PdocVoice)ac).getWith();
                        text = ((PdocVoice)ac).getContent();
                        o = new VoiceOutItem(text, with);
                        items.add(o);
                    } else if (ac instanceof PdocGrammarout) {
                        String gramstr = ((PdocGrammarout)ac).getContent();
                        String name = ((PdocGrammarout)ac).getName();
                        String dir = ((PdocGrammarout)ac).getDir();
                        GrammarOutItem o4 = new GrammarOutItem(gramstr, name, dir);
                        items.add(o4);
                    }
                    ++k;
                }
                AddOutItemCommand c3 = new AddOutItemCommand(items, cond2);
                vec.add(c3);
            } else if (cc instanceof PdocCmd) {
                Command c4 = this.getCompositeCommand((PdocCmd)cc);
                vec.add(c4);
            } else if (cc instanceof PdocEnd) {
                next = ((PdocEnd)cc).getContent();
                boolean now = ((PdocEnd)cc).getNow();
                cond = ((PdocEnd)cc).getCond();
                c2 = new EndCommand(next, cond, now);
                vec.add(c2);
            } else if (cc instanceof PdocGoto) {
                next = ((PdocGoto)cc).getContent();
                cond2 = ((PdocGoto)cc).getCond();
                c = new GotoCommand(next, cond2);
                vec.add(c);
            } else if (cc instanceof PdocNext) {
                next = ((PdocNext)cc).getContent();
                cond2 = ((PdocNext)cc).getCond();
                c = new SetNextCommand(next, cond2);
                vec.add(c);
            } else if (cc instanceof PdocScript) {
                String content = ((PdocScript)cc).getContent();
                String with = ((PdocScript)cc).getWith();
                cond = ((PdocScript)cc).getCond();
                c2 = new EvaluateCommand(content, with, cond);
                vec.add(c2);
            } else if (cc instanceof PdocStopoutput) {
                String cond3 = ((PdocStopoutput)cc).getCond();
                StopOutputCommand c5 = new StopOutputCommand(cond3);
                vec.add(c5);
            }
            ++j;
        }
        String cmdcond = composite.getCond();
        return new CompositeCommand(vec, cmdcond);
    }

    public PDoc(Element e, String path) throws Exception {
        this.element_ = e;
        this.docAddress_ = path;
        if (!PdocPdoc.isMatch(e)) {
            throw new DocError("Not a valid <pdoc> document: " + path);
        }
        PdocPdoc pdoc = new PdocPdoc(e);
        this.stateMap_ = new StateMap();
        this.stateMap_.setPdocVersion(pdoc.getVersion());
        PdocBody body = pdoc.getBody();
        String start = body.getStart();
        this.stateMap_.setFirstStateName(start);
        int i = 0;
        while (i < body.sizeState()) {
            PdocState state = body.getState(i);
            this.dbg.print(String.valueOf(i) + ">" + state.toString());
            String stateId = state.getId();
            this.stateMap_.newState(stateId);
            PdocCmd cmd = state.getCmd();
            Command c = this.getCompositeCommand(cmd);
            this.stateMap_.addCommand(stateId, c);
            int j = 0;
            while (j < state.sizeCatch()) {
                String next;
                PdocCatch pcatch = state.getCatch(j);
                String event = pcatch.getEvent();
                if (event == null) {
                    event = ".*";
                }
                if ((next = pcatch.getNext()) != null) {
                    this.stateMap_.addTrans(stateId, next, event);
                }
                ++j;
            }
            ++i;
        }
    }
}

