/*
 * Decompiled with CFR 0.152.
 */
package galatea.grammar;

import galatea.grammar.GrammarMaker;
import galatea.main.Debug;
import galatea.relaxer.vxml20.IVxmlGrammarChoice;
import galatea.relaxer.vxml20.VxmlGrammar;
import galatea.relaxer.vxml20.VxmlItem;
import galatea.relaxer.vxml20.VxmlOneOf;
import galatea.relaxer.vxml20.VxmlRule;
import galatea.relaxer.vxml20.VxmlRuleref;
import galatea.relaxer.vxml20.VxmlToken;
import galatea.util.HashArray;
import galatea.util.Util;

public class IpaRuleSet {
    private Debug dbg = new Debug("IpaRuleSet");
    private HashArray rules_ = new HashArray();
    private int unique_ = 0;

    public String toString() {
        return this.getAsString();
    }

    public void setupTemplateGrammar() {
        VxmlGrammar templateGrammar = new VxmlGrammar();
        String gfile = System.getProperty("GrammarTemplateFile", "../lib/grammar.xml");
        try {
            templateGrammar.setup(gfile);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        int i = 0;
        while (i < templateGrammar.sizeContent()) {
            IVxmlGrammarChoice c = templateGrammar.getContent(i);
            if (c instanceof VxmlRule) {
                String key = this._getUniqueId();
                this.rules_.put(key, c);
            }
            ++i;
        }
    }

    public void addRulesFromGrammar(VxmlGrammar gramXml, String gramAdrs) {
        if (gramXml == null) {
            return;
        }
        if (gramAdrs == null) {
            gramAdrs = "";
        }
        if (gramXml.getRoot() != null) {
            this._addRulesWithRoot(gramXml, gramAdrs);
        } else {
            this._addRulesWithoutRoot(gramXml, gramAdrs);
        }
    }

    public String getGrammarChangeCommand() {
        String gramStr = "";
        VxmlGrammar gramset = new VxmlGrammar();
        gramset.setVersion("IPA-XML-1.0");
        int i = 0;
        while (i < this.rules_.size()) {
            VxmlRule rule = (VxmlRule)this.rules_.get(i);
            gramset.addContent(rule);
            String string = rule.getId();
            ++i;
        }
        gramStr = Util.removeNewLines(gramset.makeTextDocument());
        gramStr = gramStr.replaceAll(" xmlns=\"[^\"]*\"", "");
        gramStr = gramStr.replaceAll("> <", "><");
        gramStr = gramStr.replaceAll("></ruleref>", "/>");
        return "to @SIM set SRM_XML_String = " + gramStr;
    }

    public String getAsString() {
        String gramStr = "";
        VxmlGrammar gramset = new VxmlGrammar();
        gramset.setVersion("IPA-XML-1.0");
        int i = 0;
        while (i < this.rules_.size()) {
            VxmlRule rule = (VxmlRule)this.rules_.get(i);
            gramset.addContent(rule);
            ++i;
        }
        gramStr = Util.removeNewLines(gramset.makeTextDocument());
        gramStr = gramStr.replaceFirst(" xmlns=\"[^\"]*\"", "");
        gramStr = gramStr.replaceAll("<rule ", "\n<rule ");
        gramStr = gramStr.replaceAll("</grammar>", "\n</grammar>");
        gramStr = gramStr.replaceAll("> <", "><");
        gramStr = gramStr.replaceAll("></ruleref>", "/>");
        return gramStr;
    }

    private String _getUniqueId() {
        ++this.unique_;
        String id = "ipa" + this.unique_;
        return id;
    }

    private String _getTokenContent(VxmlRule rule) {
        return Util.removeNewLines(rule.makeTextDocument());
    }

    private boolean _sameRuleExists(VxmlRule rule) {
        String curr = this._getTokenContent(rule);
        return this._sameRuleExists(curr);
    }

    private boolean _isSingleTokenRule(VxmlRule rule) {
        int nToken = 0;
        int nOther = 0;
        int i = 0;
        while (i < rule.sizeContent()) {
            if (rule.getContent(i) instanceof VxmlToken) {
                ++nToken;
            } else if (rule.getContent(i) instanceof VxmlItem) {
                ++nOther;
            } else if (rule.getContent(i) instanceof VxmlOneOf) {
                ++nOther;
            } else if (rule.getContent(i) instanceof VxmlRuleref) {
                ++nOther;
            }
            ++i;
        }
        return nToken == 1 && nOther == 0;
    }

    private void _addRuleref(VxmlRule rule, String uri) {
        VxmlRuleref ref = new VxmlRuleref();
        ref.setUri(uri);
        rule.addContent(ref);
        rule.setId("root");
    }

    private boolean _sameRuleExists(String curr) {
        int i = 0;
        while (i < this.rules_.size()) {
            String r = this._getTokenContent((VxmlRule)this.rules_.get(i));
            if (curr.equals(r)) {
                return true;
            }
            ++i;
        }
        this.dbg.print("new rule found:" + curr);
        return false;
    }

    private void _addRootRule(VxmlRule rule, String key) {
        if (!this._sameRuleExists(rule)) {
            this.rules_.put(key, rule);
        }
    }

    private void _addNonRootRule(VxmlRule rule, String key) {
        if (!this._sameRuleExists(rule)) {
            this.rules_.put(key, rule);
        }
    }

    private void _addRulesWithoutRoot(VxmlGrammar gramXml, String gramAdrs) {
        int nContent = gramXml.sizeContent();
        int i = 0;
        while (i < nContent) {
            IVxmlGrammarChoice choice = gramXml.getContent(i);
            if (choice instanceof VxmlRule) {
                VxmlRule rule = (VxmlRule)choice;
                boolean isRootGrammar = true;
                boolean isAnonymousRule = false;
                String id = rule.getId();
                if (id == null) {
                    id = this._getUniqueId();
                    rule.setId(id);
                    isAnonymousRule = true;
                } else {
                    rule.setId(id.replaceAll("#", ""));
                }
                if (id.matches("[A-Z_]+")) {
                    isRootGrammar = false;
                }
                String key = String.valueOf(gramAdrs) + ":" + id + ":" + this._getUniqueId();
                if (isRootGrammar) {
                    if (this._isSingleTokenRule(rule)) {
                        this.dbg.print("(root) addRootRule " + key);
                        this._addRootRule(rule, key);
                    }
                } else {
                    this.dbg.print("(not root) addNonRootRule " + key);
                    this._addNonRootRule(rule, key);
                }
                if (isAnonymousRule) {
                    VxmlRule rootRule = new VxmlRule();
                    this._addRuleref(rootRule, id);
                    this._addRootRule(rootRule, String.valueOf(key) + ":root");
                }
            }
            ++i;
        }
    }

    private void _addRulesWithRoot(VxmlGrammar gramXml, String gramAdrs) {
        GrammarMaker maker = new GrammarMaker();
        try {
            gramXml = maker.makeIpaXml(gramXml, gramAdrs);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String myroot = gramXml.getRoot().replaceAll("#", "");
        if (!myroot.equals("root")) {
            VxmlRule rootRule = new VxmlRule();
            this._addRuleref(rootRule, myroot);
            this._addRootRule(rootRule, this._getUniqueId());
        }
        int nContent = gramXml.sizeContent();
        int i = 0;
        while (i < nContent) {
            IVxmlGrammarChoice choice = gramXml.getContent(i);
            if (choice instanceof VxmlRule) {
                VxmlRule rule = (VxmlRule)choice;
                String key = this._getUniqueId();
                this.rules_.put(key, rule);
            }
            ++i;
        }
    }
}

