/*
 * Decompiled with CFR 0.152.
 */
package galatea.io;

import galatea.DialogManagerWindow;
import galatea.io.DeviceEvent;
import galatea.io.DeviceListener;
import galatea.io.InputDevice;
import galatea.io.OutputDevice;
import galatea.main.Debug;
import galatea.outitem.AudioOutItem;
import galatea.outitem.GrammarOutItem;
import galatea.outitem.NativeOutItem;
import galatea.outitem.OutItem;
import galatea.outitem.VoiceOutItem;
import galatea.relaxer.vxml20.IVxmlBlockMixed;
import galatea.relaxer.vxml20.RString;
import galatea.relaxer.vxml20.VxmlBlock;
import galatea.relaxer.vxml20.VxmlForm;
import galatea.relaxer.vxml20.VxmlNative;
import galatea.relaxer.vxml20.VxmlVxml;
import galatea.util.AMBuffer;
import galatea.util.Util;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AMThread
extends Thread
implements OutputDevice,
InputDevice {
    private int runLevel_ = 0;
    private Debug dbg = new Debug("AMThread", 0);
    private DeviceListener inputListener_;
    private DeviceListener outputListener_;
    private AMBuffer ambuf_;
    private VxmlBlock initOutputCmd_ = null;
    private VxmlBlock initRecogCmd_ = null;
    private String speakLen_ = "";
    private String speakUtt_ = "";

    private void _loadSubmoduleConfigFile(String scfile) {
        try {
            VxmlVxml vxml = new VxmlVxml(scfile);
            int i = 0;
            while (i < vxml.sizeContent()) {
                if (vxml.getContent(i) instanceof VxmlForm) {
                    VxmlForm form = (VxmlForm)vxml.getContent(i);
                    if (form.getId().equals("initOutput")) {
                        this.dbg.print("AMT: loadSubmoduleConfig: initOutput");
                        this.initOutputCmd_ = (VxmlBlock)form.getContent(0);
                    } else if (form.getId().equals("initRecog")) {
                        this.dbg.print("AMT: loadSubmoduleConfig: initRecog");
                        this.initRecogCmd_ = (VxmlBlock)form.getContent(0);
                    }
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public AMThread() {
        this.setName("AMThread");
        this.ambuf_ = new AMBuffer();
        this.outputNative("rep Run = POWEROFF");
        String scfile = System.getProperty("SubmoduleConfigFile");
        if (scfile != null) {
            this._loadSubmoduleConfigFile(scfile);
        }
    }

    public boolean isReady() {
        return this.runLevel_ == 2;
    }

    private String _getNativeAsString(IVxmlBlockMixed bm) {
        String ret = "";
        if (bm instanceof VxmlNative) {
            VxmlNative nt = (VxmlNative)bm;
            int i = 0;
            while (i < nt.sizeContent()) {
                if (nt.getContent(i) instanceof RString) {
                    ret = String.valueOf(ret) + ((RString)nt.getContent(i)).getText();
                }
                ++i;
            }
        }
        return ret;
    }

    private void _outputNative(VxmlBlock block) {
        if (block == null) {
            return;
        }
        int i = 0;
        while (i < block.sizeContent()) {
            String str = this._getNativeAsString(block.getContent(i));
            if (str.length() > 0) {
                this.outputNative(str);
            }
            ++i;
        }
    }

    private void _initAgent() {
        this._outputNative(this.initOutputCmd_);
    }

    private void _initRecog() {
        this._outputNative(this.initRecogCmd_);
        this.runLevel_ = 1;
        this.dbg.print("runLevel: " + this.runLevel_);
    }

    public void setInputListener(DeviceListener l) {
        this.inputListener_ = l;
    }

    public void setOutputListener(DeviceListener l) {
        this.outputListener_ = l;
    }

    public void outputDeviceStart(OutItem obj) {
        if (obj instanceof VoiceOutItem) {
            VoiceOutItem o = (VoiceOutItem)obj;
            this.outputSpeak(o.getArg());
        } else if (obj instanceof AudioOutItem) {
            AudioOutItem o = (AudioOutItem)obj;
            this.outputAudio(o.getArg());
        } else if (obj instanceof NativeOutItem) {
            NativeOutItem o = (NativeOutItem)obj;
            this.outputNative(o.getArg());
        } else if (obj instanceof GrammarOutItem) {
            GrammarOutItem o = (GrammarOutItem)obj;
            this.outputGrammar(o);
        }
    }

    public void outputNative(String str) {
        this.ambuf_.send(str);
    }

    public void outputSpeak(String str) {
        this.outputNative("to @AM-MCL set Speak = " + str);
        DialogManagerWindow.doDispSpeaking(str);
    }

    public void outputAudio(String str) {
        this.outputNative("to @SND set Play = " + str);
    }

    public void outputDeviceStop(OutItem item) {
        this.outputNative("to @AM-MCL set Speak = STOP");
    }

    public synchronized boolean outputGrammar(GrammarOutItem g) {
        String doc = "<?xml version=\"1.0\" encoding=\"EUC-JP\"?>" + g.getDocument();
        String location = g.getLocation();
        try {
            Util.writeToFile(String.valueOf(location) + ".xml", doc);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        String cmd = "to @GRM set ConvertGrammar = " + location;
        this.dbg.print("AMT: outputGrammar: " + cmd);
        this.outputNative(cmd);
        this.outputListener_.enqueueOutputEvent(new DeviceEvent(this, DeviceEvent.Type.OUTPUT, DeviceEvent.State.BUSY, "grammar", null));
        return true;
    }

    private boolean checkFromSIM(String str) {
        Pattern pSIMResult = Pattern.compile("From @SIM tell 300 (.*)$");
        Matcher mSIMResult = pSIMResult.matcher(str);
        if (mSIMResult.matches()) {
            String xmlevent = mSIMResult.group(1);
            this.dbg.print("AMT: SIM tell 300 " + xmlevent);
            this.inputListener_.enqueueInputEvent(new DeviceEvent(this, DeviceEvent.Type.INPUT, DeviceEvent.State.READY, "input", xmlevent));
            this.notify();
            this.dbg.print("AMT: SIM tell result done.");
            return true;
        }
        if (str.startsWith("From @SIM tell 201")) {
            DialogManagerWindow.doDispRecog(str.replaceAll("From @", ""));
            if (this.runLevel_ == 1) {
                this.runLevel_ = 2;
                DialogManagerWindow.doDispRecog("RunLevel:2");
            }
            return true;
        }
        if (str.startsWith("From @SIM ")) {
            DialogManagerWindow.doDispRecog(str.replaceAll("From @", ""));
            return true;
        }
        return false;
    }

    private boolean checkFromGRM(String str) {
        if (str.startsWith("From @GRM tell 200")) {
            DialogManagerWindow.doDispRecog(str.replaceAll("From @", ""));
            this.outputListener_.enqueueOutputEvent(new DeviceEvent(this, DeviceEvent.Type.OUTPUT, DeviceEvent.State.READY, "grammar", null));
            return true;
        }
        if (str.startsWith("From @GRM tell 4")) {
            DialogManagerWindow.doDispRecog(str.replaceAll("From @", ""));
            return true;
        }
        return false;
    }

    private boolean checkFromSRM(String str) {
        if (str.startsWith("From @SRM tell 201")) {
            DialogManagerWindow.doDispRecog(str.replaceAll("From @", ""));
            if (this.runLevel_ == 1) {
                this.runLevel_ = 2;
                DialogManagerWindow.doDispRecog("RunLevel:2");
            }
            return true;
        }
        if (str.startsWith("From @SRM tell 4")) {
            DialogManagerWindow.doDispRecog(str.replaceAll("From @", ""));
            return true;
        }
        return false;
    }

    private boolean checkFromSSM(String str) {
        Pattern pSSMSpeakLen = Pattern.compile("From @SSM rep Speak.len = (.*)$");
        Matcher mSSMSpeakLen = pSSMSpeakLen.matcher(str);
        if (mSSMSpeakLen.matches()) {
            this.speakLen_ = mSSMSpeakLen.group(1);
            return true;
        }
        Pattern pSSMSpeakUtt = Pattern.compile("From @SSM rep Speak.utt = (.*)$");
        Matcher mSSMSpeakUtt = pSSMSpeakUtt.matcher(str);
        if (mSSMSpeakUtt.matches()) {
            this.speakUtt_ = mSSMSpeakUtt.group(1);
            return true;
        }
        Pattern pSSMSpeakStat = Pattern.compile("From @SSM rep Speak.stat = (.*)$");
        Matcher mSSMSpeakStat = pSSMSpeakStat.matcher(str);
        if (mSSMSpeakStat.matches()) {
            String g1 = mSSMSpeakStat.group(1);
            if (g1.equals("IDLE")) {
                this.outputListener_.enqueueOutputEvent(new DeviceEvent(this, DeviceEvent.Type.OUTPUT, DeviceEvent.State.READY, "voice", String.valueOf(this.speakLen_) + " " + this.speakUtt_));
                return true;
            }
            if (g1.equals("ERROR")) {
                this.outputListener_.enqueueOutputEvent(new DeviceEvent(this, DeviceEvent.Type.OUTPUT, DeviceEvent.State.READY, "voice", null));
                return true;
            }
            if (g1.equals("SPEAKING")) {
                this.outputListener_.enqueueOutputEvent(new DeviceEvent(this, DeviceEvent.Type.OUTPUT, DeviceEvent.State.BUSY, "voice", null));
                return true;
            }
        }
        return false;
    }

    private boolean checkFromSND(String str) {
        Pattern pSNDTell = Pattern.compile("From @SND tell (\\S+) (.*)$");
        Matcher mSNDTell = pSNDTell.matcher(str);
        if (mSNDTell.matches()) {
            String g1 = mSNDTell.group(1);
            String g2 = mSNDTell.group(2);
            if (g1.equals("start")) {
                this.outputListener_.enqueueOutputEvent(new DeviceEvent(this, DeviceEvent.Type.OUTPUT, DeviceEvent.State.BUSY, "audio", g2));
                return true;
            }
            if (g1.equals("end")) {
                this.outputListener_.enqueueOutputEvent(new DeviceEvent(this, DeviceEvent.Type.OUTPUT, DeviceEvent.State.READY, "audio", g2));
                return true;
            }
        }
        return false;
    }

    private synchronized boolean _iteration() {
        String str = this.ambuf_.receive();
        this.dbg.ASSERT(str != null, "AMT: str != null");
        if (str.length() == 0) {
            return true;
        }
        this.dbg.print("AMT: " + str);
        if (this.checkFromGRM(str)) {
            return true;
        }
        if (this.checkFromSIM(str)) {
            return true;
        }
        if (this.checkFromSND(str)) {
            return true;
        }
        if (this.checkFromSRM(str)) {
            return true;
        }
        if (this.checkFromSSM(str)) {
            return true;
        }
        return true;
    }

    public void run() {
        String s = System.getProperty("AMThread.StartupWait", "0");
        this.dbg.print("AMThread.StartupWait:" + s);
        int waitms = (int)(Double.parseDouble(s) * 1000.0);
        try {
            Thread.sleep(waitms);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this._initAgent();
        this._initRecog();
        DialogManagerWindow.doDispRecog("RunLevel:1");
        this.outputNative("rep Run = DEAD");
        while (this.inputListener_ == null || this.outputListener_ == null) {
            try {
                Thread.sleep(0L, 1);
                this.dbg.print("AMT: event listeners not ready.");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        while (this._iteration()) {
            try {
                Thread.sleep(0L, 1);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void terminate() {
    }
}

